function id(x)
{
    return x;
}



function map(list,fun)
{
    local result = [];
    foreach( x in list )
        result.append(fun(x));
    return result;
}


function mapKeys(table,fun)
{                                              
    local result = {};
    foreach( key,value in table )
    {
        result[fun(key)] <- value;
    }
    return result;
}

function mapValues(table,fun)
{                                              
    local result = {};
    foreach( key,value in table )
    {
        result[key] <- fun(value);
    }
    return result;
}


function filter(list, fun)
{
    local result = [];
    foreach( value in list )
    {
        if (fun(value))
	    result.append(value);
    }
    return result;
}




function filterKeys(table, pred)
{
    local result = {};
    foreach( key,value in table )
    {
        if (pred(key))
            result[key] <- value;
    }
    return result;
}


function filterValues(table, pred)
{
    local result = {};
    foreach( key,value in table )
    {
        if (pred(value))
            result[key] <- value;
    }
    return result;
}


function tableKeys(table)
{
    local result = [];
    foreach( key,value in table)
        result.append(key);
    return result;
}

function tableValues(table)
{
    foreach( key,value in table)
        yield value;
}    

// Build the table key <- fun(key) for each key in keys
function makeTable(keys, fun)
{
    local result = {};
    foreach( k in keys )
    {
        result[k] <- fun(key);
    }
    return result;
}


function findKey(key, keys, values)
{
    for(local i=0; i<keys.len(); ++i)
    {
        if (keys[i] == key)
        {
            return values[i];
        }
    }
}

// make a sorted list of a given table, using cmp( [key,value], [key,value] )
// as comparator
function sortTable(table, cmp)
{
    local result = [];
    foreach(key,value in table)
    {
        result.append([key,value]);
    }
    result.sort(cmp);
    return result;
}

function defaultCmp(x,y)
{
    return x - y;
}

function sortTableByValues(table,cmp=defaultCmp)
{
    local compare = function(x,y):(cmp){ return cmp(x[1],y[1]); }
    local result = [];
    foreach(key,value in table)
    {
        result.append([key,value]);
    }
    result.sort(compare);
    return result;
}
    


// return the or of the given functions: 
// or(f,g,h)(x) = f(x) || g(x) || h(x)
function or(...)
{
    local args = [];
    for (local i = 0; i<vargc; i++)
        args.append(vargv[i]);

    local result = function(x):(args)
    {
        foreach(f in args)
        {
            local y = f(x);
            if ( y )
                return y;
        }
        return null;
    }
    return result;
}


// return the and of the given functions: 
// and(f,g,h)(x) = f(x) && g(x) && h(x)
function and(...)
{
    local args = [];
    for (local i = 0; i<vargc; i++)
        args.append(vargv[i]);

    local result = function(x):(args)
    {
        // AILog.Info("input is " + x);
        local last = true;
        foreach(f in args)
        {
            last = f(x);
            // AILog.Info("last is " +f + "=" +f(x));
            if (!last)
                return null;
        }
        return last;
    }
    return result;
}


function tableKeys(table)
{
    local result = [];
    foreach(k,v in table)
	result.append(k);
    return result;
}

/**
   For each x in the list do
   initialValue = fun(initialValue,x)
   and return the list of resulting values
   For example fun is "+"
   the result of scanl([1,2,3,4,5],fun,0) is equal to
   [1,3,6,10,15]

*/
function scanl(list,fun,initialValue)
{
    local result = []
    foreach(x in list)
    {
        initialValue = fun(initialValue,x);
        result.append(initialValue);
        
    }
    return result;
}


/**
   For each x in the list do
   initialValue = fun(initialValue,x)
   and resulting value
   For example fun is "+"
   the result of scanl([1,2,3,4,5],fun,0) is equal to
   1+2+3+4+5

*/
function foldl(list,fun,initialValue)
{
    foreach(x in list)
    {
        initialValue = fun(initialValue,x);
    }
    return initialValue;
}


function sum(seq)
{
    local result = 0;
    foreach(x in seq)
	result += x;
    return result;
}

function buildOpTable()
{
    local result = {}
    result["+"] <- function(x,y) { return x+y; };
    result["-"] <- function(x,y) { return x-y; };
    return result;
}


_ops <- buildOpTable();


function range(min, max)
{
    while (min <max)
    {
        yield min++;
    }
}
       

/**
 *  Return a function representing an operator such as <,+,/ etc.
 */
function op(x)
{
    return _ops[x];
}


function zip(x,y)
{
    local i=0;
    
    while( i < x.len() && i < y.len() )
    {
        yield [x[i],y[i]];
    }
}


function concat(lists)
{
    local result = [];
    foreach(l in lists)
    {
        foreach(x in l)
        {
            yield x;
        }
    }
}

// return an iterator to all the pairs (x,y)
// such that 'x in list1' and 'y in list2'
function crossProd(list1, list2)
{
    foreach(x in list1)
    {
        foreach(y in list2)
        {
            yield (x,y);
        }
    }
}


function tableValues(table)
{
    local result = [];
    foreach(key,value in table)
    {
	result.push(value);
    }
    return result;
}


function makeArray(seq)
{
    local result = [];
    foreach(x in seq)
    {
	result.push(x);
    }
    return result;
}
