ERROR <- "ERROR";
INFO <- "INFO";
CACHE <- "CACHE";

enum LogLevel {
    trace,
    debug,
    info,
    warning,
    error,
    max
};

LOG_LEVELS <- ["TRACE", "DEBUG", "INFO", "WARNING", "ERROR"];


function makeLogFunction(level, label) 
{
    return function(...):(level, label)
    {
	if (vargc == 0)
	{
	    return;
	}
	local msg = vargv[0];
	for (local i=1; i< vargc; ++i) 
	{
	    msg = msg + " " + vargv[i];
	}
	log(LOG_LEVELS[level], label, msg);
    };
}

function makeNullFunction(level)
{
    return function(...) {} ;
}



_loggers <- {};


class Log 
{
	    
    trace = null;
    debug = null;
    info = null;
    warning = null;
    error = null;

    _key = null;
    _currentLevel = null;


    constructor(key)
    {
	_key = key;
	trace = makeNullFunction(LogLevel.trace);
	debug = makeNullFunction(LogLevel.debug);
	info = makeNullFunction(LogLevel.info);
	warning = makeNullFunction(LogLevel.warning);
	error = makeNullFunction(LogLevel.error);
	SetLogLevel(LogLevel.info);
    }

    static function GetLogger(key)
    {
	if (!(key in _loggers)) 
	{
	    _loggers[key] <- Log(key);
	}
	return _loggers[key];
    }

    function SetLogLevel(level) 
    {
	if (_currentLevel == level) 
	{
	    return;
	}
	this.info("Changing log level to", LOG_LEVELS[level]);
	_currentLevel = level;
	this.trace = makeNullFunction(LogLevel.trace);
	debug = makeNullFunction(LogLevel.debug);
	info = makeNullFunction(LogLevel.info);
	warning = makeNullFunction(LogLevel.warning);
	error = makeNullFunction(LogLevel.error);
	switch(level)
	{
	case LogLevel.trace:
	    trace = makeLogFunction(LogLevel.trace, _key);
	case LogLevel.debug:
	    debug = makeLogFunction(LogLevel.debug, _key);
	case LogLevel.info:
	    info = makeLogFunction(LogLevel.info, _key);
	case LogLevel.warning:
	    warning = makeLogFunction(LogLevel.warning, _key);
	case LogLevel.error:
	    error = makeLogFunction(LogLevel.error, _key);
	    break;
	default:
	    throw "Invalid value for setLogLevel: " + level;
	}
    }	    
}

function dumpArray(array)
{
    local result = "[";
    foreach(x in array)
    {
        result += x;
        result += ", ";
    }
    result += "]";
    return result;
}


function dumpList(array)
{
    local result = "List(";
    foreach(item,dummy in array)
    {
	result += (" " + item + "=" + item + ",");
    }
    result += ")";
    return result;
}


function dumpTable(table)
{
    local result = "";
    local lineCount = 1;
    result +="{";
    
    foreach (i,j in table)
    {
	result += (" " + i + "=" + j + ",");
        if (result.len() > 100*lineCount )
        {
            result += "\n";
            lineCount+=1;
        }
    }
    result +="}";
    print(result);
    return result;

}

function log(tag,level,text)
{
    local date = AIDate.GetCurrentDate();
    local year = AIDate.GetYear(date);
    local month = AIDate.GetMonth(date);
    local day = AIDate.GetDayOfMonth(date);
    AILog.Info("" + year + "-" + month + "-" + day +  " - " + tag + " - " + level + " - " + text );
}

