
class Route
{
    from = null;
    to = null;
    depot = null;
    industryFrom = null;
    industryTo = null;
    fromTown = null;
    toTown = null;

    cargo = null;
    fromSize = null;
    expandable = null;
    brokenCount = null;

    _transport = null;
    _vehicles = null;
    _logger = null;
    constructor(from, to, depot, industryFrom, industryTo, fromTown, toTown,
	transport,
	cargo=null)
    {
	_logger = Log.GetLogger("Route");
	this.from =from ;
	this.to =to ;
	this.depot =depot ;
	this.industryFrom =industryFrom ;
	this.industryTo =industryTo ;
        this.fromTown = fromTown;
        this.toTown =toTown ;
	this._vehicles = [];
	_transport = transport;
	this.cargo = cargo;
	this.fromSize = 1;
        this.expandable = true;
        routeList.push(this.weakref());
        this.brokenCount = 0;
    }

    function ScheduleRoute(truck, stationFrom,stationT);
    function Save();
    static function Load(table)
    {
	local industryTo = table.toTown ? Town.Get(table.industryTo) : Industry.Get(table.industryTo);
	local industryFrom = table.fromTown ? Town.Get(table.industryFrom) : Industry.Get(table.industryFrom);
	local to = Station.Load(table.to);
	local from = Station.Load(table.from);
        local transportId = table.transportId;
	local transport = ALL_TRANSPORTS[ transportId ];
	return Route(from, to, table.depot, industryFrom, industryTo, table.toTown,
	    table.vehicles, transport, table.cargo );
    }
};


routeList <- [];


function Route::Vehicles()
{
    return _vehicles;
}


function Route::Contains(vehicleId)
{
    return vehicleId in Vehicles();
}


function townOrFactoryName(toTown,x)
{
}


function Route::_tostring()
{
    
    local tag = toTown ? "T" : "I";
    return "[" + tag + "| " + industryFrom + " -> " + industryTo + " ]";
}


function Route::VehicleLimit()
{
    local dst = distance(this.from, this.to);
}


function Route::Save() 
{
    local route = this;
    return {
	from =route.from.Save() ,
	to =route.to.Save() ,
	depot =route.depot ,
	industryFrom = route.industryFrom.Id(),
	industryTo =route.industryTo.Id(),
	toTown =route.toTown ,
	fromTown =route.fromTown ,
	vehicles = route._vehicles,
	cargo = route.cargo,
	transportId = route._transport.Id()
    };
}

function routeToTable(route)
{
    return route.Save();
}

function tableToRoute(route)
{
    return Route.Load(route);
}

function Route::FullCapacity()
{
    // return the maximum number of vehicles that the stations may handle 
    local days = _transport.EstimateDays(from.Location(), to.Location(), cargo);
    if (!days)
        return 0;
    local vehiclesPerDay = minf( from.VehiclesPerDay(), to.VehiclesPerDay() );
    // FIXME: we should handle this "fromSize" better ...
    return (days*fromSize * vehiclesPerDay).tointeger(); 
}


function Route::ExpandStations()
{
    if (!expandable)
        return;
    log("INFO",5,"Expanding station at " + location(from.Location()));
    if ( _transport.ExpandStation(from))
	fromSize += 1;
    else
        expandable = false;
}


function productionAt(productionMap,tile)
{
    if (tile in productionMap)
        return productionMap[tile];
    return 0;
}


function Route::NeededVehicles()
{
    // Similar to estimateNVehicles, but takes into account what the other stations
    // transport
    local engine = _transport.GetEngineFor(cargo, from, to);
    if(!engine)
        return 0;
    local days = _transport.EstimateDays(from.Location(), to.Location(), cargo);
    if (!days )
        return 0;
    // double time, we have to return :)
    days = days*2;

    local production;
    if (fromTown)
        production = min(productionAt(industryFrom.Production(cargo),from),
                         productionAt(industryTo.Production(cargo),to));
    else
        production = industryFrom.Production(cargo);

//    local transported = AIIndustry.GetLastMonthTransported(industryFrom, cargo );

    local capacity = engine.GetCapacity(cargo);
    if (!capacity)
	return 0;
//    local myTransported = nVehicles * capacity * 30 / days;
//    local transportedByOthers = transported - myTransported;
    local available = production; 

    local loadsPerMonth = 0.66 * 0.7* available / capacity; // we hardly go above 70%. btw value is still wrong
    local vehicles = 1 + loadsPerMonth * days / 30; // Yes, because february also has 30 days :P
    return vehicles;
}



function Route::RetireVehicle(vehicle)
{
    sendToDepot(vehicle);
    foreach(i,t in _vehicles)
    {
	if ( t == vehicle )
        {
            _vehicles.remove(i);
            return;
        }
    }
}


function Route::AddVehicle()
{
    local route = this;
    local vehicle = _transport.BuildVehicleFor(route.depot,route.cargo, this.from, this.to);
    if (!vehicle)
    {
	_logger.debug("Cannot build vehicle for route ", this );
        return;
    }
    local ok;
    if (fromTown && route._vehicles.len() % 2 == 0 )
        ok = ScheduleRoute(vehicle, route.to, route.from);
    else
        ok = ScheduleRoute(vehicle,route.from,route.to);
    if (ok)
    {
	AIVehicle.StartStopVehicle(vehicle);
	_logger.info("Adding new vehicle",vehicle,  AIEngine.GetName(AIVehicle.GetEngineType(vehicle)), "to route", route);
	_vehicles.append(vehicle);
	return vehicle;
    }
    else
    {
	AIVehicle.SellVehicle(vehicle);
	_logger.error("Unable to schedule route for ", route );
	return;
    }
}


function Route::ScheduleRoute(truck, stationFrom,stationTo)
{
    local vehicle = truck;
    local flags = _transport.GetDefaultFlags(vehicle);
    local fromFlags = AIOrder.OF_FULL_LOAD_ANY;
    local toFlags = AIOrder.OF_NONE;
    foreach( f in flags )
    {
	fromFlags = fromFlags | f;
	toFlags = toFlags | f;
    }

    check("Invalid truck passed to ScheduleRoute", AIVehicle.IsValidVehicle, truck);
    if (!AIOrder.AppendOrder(truck, stationFrom.Location(), fromFlags))
    {
	AILog.Error("Unable to schedule order to " + location(stationFrom) + ":" + AIError.GetLastErrorString());
	return false;
    }
    if (!AIOrder.AppendOrder(truck, stationTo.Location(), toFlags ))
    {
   	AILog.Error("Unable to schedule order to " + location(stationTo) +" :" + AIError.GetLastErrorString());
	return false;
    }
    return true;
}



function everyRoute(fun)
{
    foreach( route in routeList )
    {
        if (route)
	{	
            fun(route);
	}
    }
}
    
function handleVehicleCrash(vehicleId)
{
    foreach( route in routeList )
    {
        if ( route && route.Contains(vehicleId) )
        {
	    _logger.info("Removing vehicle from route " + route);
            route._vehicles.remove(vehicleId);
            return;
        }
    }
    _logger.error("Cannot find vehicle in any route!");
}



function Route::IntegrityCheck()
{
    // Check that every vehicle belongs to a route
    

}
