require("log.nut");

class Scheduler
{
    _interval = null;
    _actions = null;
    _last = null;
    _logger = null;
    
    constructor( interval )
    {
	_interval = interval;
	_actions = [];
	_last = -interval;
	_logger = Log.GetLogger("Scheduler");
    }
}



function Scheduler::SetActions(actionList)
{
    _actions = actionList;
}


function Scheduler::_tostring()
{
    return "Scheduler: every " + _interval + " days";
}


function Scheduler::Update()
{
    local now = AIDate.GetCurrentDate();
    if ( now > _last + _interval )
    {
        _last = now;
        foreach( action in _actions )
        {
            action();
        }
    }
}




class MonthlyScheduler
{
    _interval = null;
    _actions = null;
    _lastMonth = null;
    _lastYear = null;
    _logger = null;

    constructor()
    {
	_actions = [];
	_lastMonth = 0;
	_lastYear = 0;
	_logger = Log.GetLogger("MonthlyScheduler");
    }
}



function MonthlyScheduler::_tostring()
{
    return "MonthlyScheduler";
}



function MonthlyScheduler::SetActions(actionList)
{
    _actions = actionList;
}


function MonthlyScheduler::Update()
{
    local now = AIDate.GetCurrentDate();
    local month = AIDate.GetMonth(now);
    local year = AIDate.GetYear(now);
    if ( year > _lastYear || month > _lastMonth )
    {
        _logger.debug("Performing monthly update");
        _lastMonth = month;
	_lastYear = year;
        foreach( action in _actions )
        {
            action();
        }
    }
}
