
function testRouletteWheel()
{
    local probs = [1];
    local res = rouletteWheel(probs);
    assert( res == 0 );
}



function testOr()
{
    local f = function(x){ return x < 5; }
    local g = function(x){ return x > 10; }

    assert( or(f,g)(1) == true );
    assert( or(f,g)(7) == null );
    assert( or()(1) == null );
    assert( or()(1) == null );
    
}


function testAnd()
{
    local f = function(x){ return x < 10; }
    local g = function(x){ return x > 5; }

    assert( !and(f,g)(1) );
    assert( and(f,g)(7) );
    assert( and()(1) );
    assert( and()(2) );
}



function testScanl()
{
    local x = [1,2,3,4,5];
    local fun = function(x,y){return x+y;}
    
    local result = scanl(x,fun,0);
    assert(x.len() == result.len());
    assert(result[0] == 1 );
    assert(result[1] == 3 );
    assert(result[2] == 6 );
    assert(result[3] == 10 );
    assert(result[4] == 15 );
}




TESTS <- [testOr,testAnd,testScanl,testRouletteWheel];


function runTests()
{
    AILog.Info("Running tests...");
    foreach (test in TESTS)
    {
        test();
    }
}


