/* -*- Mode: C++; tab-width: 6 -*- */ 

/*
 *
 * This file is part of Script Communication Protocol (shorten to SCP), which are libraries for OpenTTD NoAI and NoGO
 * Copyright (C) 2012 Krinn <krinn@chez.com> & Zuu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

class	_SCPLib_CommandSet
{
static	base		= {};
		Name		= null;
		CommandList	= null;

static	function Load(_Name)
		{
			return _Name in _SCPLib_CommandSet.base ? _SCPLib_CommandSet.base[_Name] : null;
		}

	constructor()
	{
		Name		= "unknown command set";
		CommandList	= [];
	}
}

function _SCPLib_CommandSet::AddCommandToSet(_CommandName, _SetName)
{
local cmdSet = _SCPLib_CommandSet.Load(_SetName);
if (cmdSet == null)
	{
	cmdSet = _SCPLib_CommandSet();
	cmdSet.Name = _SetName;
	cmdSet.CommandList.push(_CommandName);
	_SCPLib_CommandSet.base[_SetName] <- cmdSet;
	_SCPLib_Message.SCPLogInfo("Adding a new command set : "+_SetName);
	return;
	}
cmdSet.CommandList.push(_CommandName);
}

