/* -*- Mode: C++; tab-width: 6 -*- */ 

/*
 *
 * This file is part of Script Communication Protocol (shorten to SCP), which are libraries for OpenTTD NoAI and NoGO
 * Copyright (C) 2012 Krinn <krinn@chez.com> & Zuu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

class	_SCPLib_Message
// the Message class is use to create a new message
{
		PoolID	= null;	// the ID in the pool
		MessageID	= null;	// the ID for that message
		Command	= null;	// the command
		CommandSet	= null;	// the command set
		CommandID	= null;	// the server commandID
		SenderID	= null;	// the sender
		ReceiverID	= null;	// the receiver
		Type		= null;	// the type: true a query, false an answer, null a query that don't expect answer
		Data		= null;	// it's encoded data, if message is delay it's original data

	constructor()
		{
		this.PoolID = -1;
		this.MessageID = -1;
		this.Command = -1;
		this.CommandSet = -1;
		this.SenderID = -1;
		this.ReceiverID = -1;
		this.Type	= -1;
		this.Data = null;
		}
}

function _SCPLib_Message::GetData(index)
// Get data at the index position in Data. If Data doesn't exist or the index is invalid, null is returned.
// @param index position in the Data array to grab
// @return Data[index] if it exist, otherwise null
{
	if (this.Data != null && this.Data.len() > index)
		return this.Data[index];

	return null;
}

function _SCPLib_Message::GetIntData(index)
// Get integer data at the index position in Data. If Data doesn't exist or the 
// index is invalid, null is returned. If data exist, but is not of the type 
// integer, null will be returned.
// @param index position in the Data array to grab
// @return Data[index] if it exist and is of the type integer, otherwise null
{
	if (this.Data != null && 
			this.Data.len() > index && 
			typeof(this.Data[index]) == "integer")
	{
		return this.Data[index];
	}

	return null;
}

function _SCPLib_Message::GetStringData(index)
// Get string data at the index position in Data. If Data doesn't exist or the 
// index is invalid, null is returned. If data exist, but is not of the type 
// string, null will be returned.
// @param index position in the Data array to grab
// @return Data[index] if it exist and is of the type integer, otherwise null
{
	if (this.Data != null && 
			this.Data.len() > index && 
			typeof(this.Data[index]) == "string")
	{
		return this.Data[index];
	}

	return null;
}

function _SCPLib_Message::GetBoolData(index)
// Get bool data at the index position in Data. If Data doesn't exist or the 
// index is invalid, null is returned. If data exist, but is not of the type 
// integer, null will be returned. Yes, it is not a typo. Bools are transmitted
// as integers, however this function does check that the received integer is
// 0 or 1, otherwise null is returned as well.
// @param index position in the Data array to grab
// @return Data[index] if it exist and is of the type integer and is 0 or 1, otherwise null
{
	if (this.Data != null && 
			this.Data.len() > index && 
			typeof(this.Data[index]) == "integer" &&
			(this.Data[index] == 0 || this.Data[index] == 1))
	{
		return this.Data[index] == 1;
	}

	return null;
}


// private functions:

function _SCPLib_Message::SCPLogError(...)
{
	if (_SCPLib_Client.Configuration[3] != 1) return;
	local args = "SCP: "; // force args to be a string
	for (local i=0; i < vargc; i++)	args+=vargv[i];
	SCPLog.Error(args);
}

function _SCPLib_Message::SCPLogInfo(...)
{
	if (_SCPLib_Client.Configuration[4] != 1) return;
	local args = "SCP: ";
	for (local i=0; i < vargc; i++)	args+=vargv[i];
	SCPLog.Info(args);
}

