/*
	MogulAI - an artificial intelligence for OpenTTD
	Copyright (C) 2009 - 2010 Kazantsev Lev (Dezmond_snz)

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

require ("Util.nut");

class DummyRoadPathFinder
{
	_start = null;
	_end = null;
	
	_visitedStucks = {};
	
	constructor(startTile, endTile)
	{
		_start = startTile;
		_end = endTile;
		_visitedStucks = {};
	}
	
	function TryFindPath()
	{
		local foo = AITestMode();
		
		_visitedStucks = {};
		local dx = AIMap.GetTileX(_end) - AIMap.GetTileX(_start);
		local dy = AIMap.GetTileY(_end) - AIMap.GetTileY(_start);
		if (dx == 0 && dy == 0) return null;
		
		local pnStart = PathNode(_start, null, ReachableType.Normal, 1, 0);
		
		if (dx == 0 || dy == 0)
		{
			if (tryGo(_start, _end) == _end)
			{
				local path = [];
				path.append(pnStart);
				local pnEnd = PathNode(_end, null, ReachableType.Normal, 2, 0);
				path.append(pnEnd);
				return path;
			}
			return null;
		}
		else
		{
			{ // by X, then by Y
				local tileHalf = AIMap.GetTileIndex(AIMap.GetTileX(_end), AIMap.GetTileY(_start));
				local steps = tryGoTwoSteps(_start, _end, tileHalf);
				if (steps != null)
				{
					local path = [];
					path.append(pnStart);
					
					foreach(p in steps)
						path.append(PathNode(p, null, ReachableType.Normal, 0, 0));
					
					path.append(PathNode(_end, null, ReachableType.Normal, 0, 0));
					return path;
				}
			}
			
			{ // by Y, then by X
				local tileHalf = AIMap.GetTileIndex(AIMap.GetTileX(_start), AIMap.GetTileY(_end));
				local steps = tryGoTwoSteps(_start, _end, tileHalf);
				if (steps != null)
				{
					local path = [];
					path.append(pnStart);
					
					foreach(p in steps)
						path.append(PathNode(p, null, ReachableType.Normal, 0, 0));
					
					path.append(PathNode(_end, null, ReachableType.Normal, 0, 0));
					return path;
				}
				return null;
			}
		}
		
		return null;
	}
	
	function tryGoTwoSteps(from, to, tileHalf)
	{
		if (_visitedStucks.rawin(from) && _visitedStucks.rawget(from) == tileHalf) return null;
		if (_visitedStucks.rawin(tileHalf)) return null;
		
		//{ local a = AIExecMode(); AISign.BuildSign(tileHalf, "o"); }
		
		local dirToEnd = Util.GetDirection(tileHalf, to);
		local dirFromStart = Util.GetDirection(from, tileHalf);
		
		local try1 = tryGo(from, tileHalf);
		if (try1 == tileHalf)
		{
			if (Util.CanPass(tileHalf, tileHalf+dirToEnd, tileHalf - dirFromStart))
			{
				local try2 = tryGo(tileHalf, to); 
				if (try2 == to)
					return [ tileHalf ];
				else
				{
					if (!_visitedStucks.rawin(try2) || _visitedStucks[try2] != -1)
					{
						for (local newHalf = tileHalf - dirFromStart; newHalf != from; newHalf -=dirFromStart)
						{
							if (Util.CanPass(newHalf, newHalf+dirToEnd, newHalf - dirFromStart))
							{
								//{ local a = AIExecMode(); AISign.BuildSign(newHalf, "x"); }
								local res;
								if (AIMap.GetTileX(_end) == AIMap.GetTileX(tileHalf))
									res = combineHalfWithNextTwoSteps( newHalf, to, AIMap.GetTileIndex(AIMap.GetTileX(newHalf), AIMap.GetTileY(to)));
								else
									res = combineHalfWithNextTwoSteps( newHalf, to, AIMap.GetTileIndex(AIMap.GetTileX(to), AIMap.GetTileY(newHalf)));
								
								if (res != null)
									return res;
							}
						}
						_visitedStucks.rawset(try2, -1);
					}
					_visitedStucks.rawset(from, tileHalf);
					_visitedStucks.rawset(tileHalf, -2);
					return null;
				}
			}
			else
			{
				for (local newHalf = tileHalf - dirFromStart; newHalf != from; newHalf -=dirFromStart)
				{
					if (Util.CanPass(newHalf, newHalf+dirToEnd, newHalf - dirFromStart))
					{
						//{ local a = AIExecMode(); AISign.BuildSign(newHalf, "x"); }
						local res;
						if (AIMap.GetTileX(_end) == AIMap.GetTileX(tileHalf))
							res = combineHalfWithNextTwoSteps( newHalf, to, AIMap.GetTileIndex(AIMap.GetTileX(newHalf), AIMap.GetTileY(to)));
						else
							res = combineHalfWithNextTwoSteps( newHalf, to, AIMap.GetTileIndex(AIMap.GetTileX(to), AIMap.GetTileY(newHalf)));
						
						if (res != null)
							return res;
					}
				}
				_visitedStucks.rawset(from, tileHalf);
				return null;
			}
		}
		else
		{
			for (local newHalf = try1; newHalf != from; newHalf -=dirFromStart)
			{
				if (Util.CanPass(newHalf, newHalf+dirToEnd, newHalf - dirFromStart))
				{
					//{ local a = AIExecMode(); AISign.BuildSign(newHalf, "x"); }
					local res;
					if (AIMap.GetTileX(_end) == AIMap.GetTileX(tileHalf))
						res = combineHalfWithNextTwoSteps( newHalf, to, AIMap.GetTileIndex(AIMap.GetTileX(newHalf), AIMap.GetTileY(to)));
					else
						res = combineHalfWithNextTwoSteps( newHalf, to, AIMap.GetTileIndex(AIMap.GetTileX(to), AIMap.GetTileY(newHalf)));
					
					if (res != null)
						return res;
				}
			}
			_visitedStucks.rawset(from, tileHalf);
			_visitedStucks.rawset(tileHalf, -2);
			return null;
		}
		return null;
	}
	
	function combineHalfWithNextTwoSteps(from, to, tileHalf)
	{
		local steps = tryGoTwoSteps(from, to, tileHalf);
		if (steps == null)
			return null;
		local path = [];
		path.append(from);
		foreach(p in steps)
			path.append(p);
		return path;
	}
	
	function tryGo(from, to)
	{
		if (AIMap.GetTileX(from) - AIMap.GetTileX(to) != 0 && AIMap.GetTileY(from) - AIMap.GetTileY(to) != 0)
			local i = 1/0;
		
		local dir = Util.GetDirection(from, to);
		
		local curr = from+dir;
		while (curr != to)
		{
			if (!Util.CanPass(curr, curr+dir, curr-dir))
				return curr;
			
			curr = curr + dir;
		}
		return curr;
	}
}