/*
	MogulAI - an artificial intelligence for OpenTTD
	Copyright (C) 2009 - 2010 Kazantsev Lev (Dezmond_snz)

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

class FundsManager
{
	constructor(){}
}

function FundsManager::CheckMoneyLoanInterval(waitForMoney)
{
	return FundsManager.CheckMoneyConstruction(1, waitForMoney);
}

function FundsManager::CheckMoneyForEngine(engine, count, waitForMoney)
{
	local enginePrice = AIEngine.GetPrice(engine);
	local refitCost = 0; // TODO
	
	return FundsManager.CheckMoneyConstruction((enginePrice + refitCost) * count, waitForMoney);
}

function FundsManager::CheckMoneyConstruction(money, waitForMoney)
{
	local loan = AICompany.GetLoanAmount();
	local loanInterval = AICompany.GetLoanInterval();
	local balance = AICompany.GetBankBalance(AICompany.COMPANY_SELF);
	
	if (balance - loanInterval >= money)
		return true;
	
	if (balance + AICompany.GetMaxLoanAmount() - loan - loanInterval >= money)
	{
		local mult = ((money - balance) / loanInterval).tointeger() + 1;
		AICompany.SetLoanAmount(loan + loanInterval*mult);
		return true;
	}
	
	if (waitForMoney)
	{
		AICompany.SetLoanAmount(AICompany.GetMaxLoanAmount());
		WaitForMoney(money + loanInterval);
		return true;
	}
	return false;
}

function FundsManager::CheckMoneyGeneral()
{
	local loan = AICompany.GetLoanAmount();
	local loanInterval = AICompany.GetLoanInterval();
	local balance = AICompany.GetBankBalance(AICompany.COMPANY_SELF);
	if (balance < loanInterval)
	{
		if (loan < AICompany.GetMaxLoanAmount())
			AICompany.SetLoanAmount(loan + loanInterval);
	}
	if (loan > 0 && balance > loanInterval*2)
	{
		local mult = (balance / loanInterval).tointeger()-1;
		if (loan - loanInterval*mult < 0)
			AICompany.SetLoanAmount(0);
		else
			AICompany.SetLoanAmount(loan - loanInterval*mult);
	}
}

function WaitForMoney(moneyNeeded)
{
	AILog.Info("Waiting for money... Need "+moneyNeeded+".");
	while(AICompany.GetBankBalance(AICompany.COMPANY_SELF) < moneyNeeded)
		AIController.Sleep(10);
}