//SmallTownAI V7

require("management.nut");
require("network.nut");
require("road.nut");


import("pathfinder.road", "RoadPathFinder", 4);


class SmallTownAI extends AIController {
	
    function Start();
    
}

function SmallTownAI::Start() {
	
	//our AI's current project.
	local project = null;
	
	//the station we are ordering buses to
	local current_station = 0;
	
	//a list of all of our serviced towns
	local total_towns = AITownList();
	total_towns.RemoveList(total_towns);
	
	local town_directory = AITownList();

	//set the name of our ai
	if (!AICompany.SetName("The Company")) {
		if (!AICompany.SetName("The 2nd Company")) {
			if(!AICompany.SetName("The 3rd Company")) {
				local i = 4;
				local named = false;
				while(named = false); {
					if(AICompany.SetName("The " +  i.tostring() + "th Company")) {
						named = true;
					}
					i ++;
				}      
			}
		}
	}

   //create a loop so that our ai doesn't stop
   while (true) {
	   
	    //make sure we have not expanded to every town
		if(total_towns.Count() < town_directory.Count()) {
			
			//check to see if we have the money to expand
			if(check_funding() > 40000) {
				AILog.Info("Money is present, attempting construction");
				if(project != null && project.stations.Count() < 12) {
					AILog.Info("Planning expansion to current project");
					local town_list = AITownList();	//create a list of towns
					town_list.RemoveList(project.serviced_towns);	//remove towns we have already serviced
					town_list.RemoveList(total_towns);
					town_list.Valuate(AITown.GetDistanceManhattanToTile, AITown.GetLocation(project.network_center));
					town_list.KeepBelowValue(250);
					AILog.Info("Potential expansions " + town_list.Count());
					if(town_list.Count() > 0) {
						town_list.Valuate(valuate_route, project.network_center);	//valuate the potential of each town
						town_list.KeepTop(1);
						AILog.Info("potential rating: " + town_list.GetValue(town_list.Begin()));
						AILog.Info("Town to expand to: " + AITown.GetName(town_list.Begin()));
						project.serviced_towns.AddItem(town_list.Begin(), 0);
						local road = build_path(AIBaseStation.GetLocation(project.core_station), AITown.GetLocation(town_list.Begin()));	//build a path to the town
						if (road == true) {
							current_station = build_station(AITown.GetLocation(town_list.Begin()));	//build a station
							if(current_station >= 0) {
								AILog.Info("Station is at tile " + current_station);
								project.stations.AddItem(AIStation.GetStationID(current_station), 0);
								local bus = build_bus(project.depot);	//build a bus
								project.buses.AddItem(bus, 0);	//add the bus to the network's list of buses
								order_bus(bus, project.core_station);	//order the bus to go to the first station
								order_bus_to_location(bus, current_station);	//order the bus to go to the new station
								AIVehicle.StartStopVehicle(bus);	//start the bus
								AILog.Info("bus " + bus + " Started!");
							}
						}
					} else {
						total_towns.AddList(project.serviced_towns);
						project.reset();
						project = null;
					}
				} else {
					
					//sleep so that two of this ai don't always choose the same town to start a network
					AIController.Sleep(AIBase.RandRange(1000));
					
					//start a new network
					AILog.Info("Starting new project");
					if(project != null) {
						total_towns.AddList(project.serviced_towns);
					}	
					project = null;
					project = Network();	//create a new network object
					project.reset();
					project.find_first_town();	//find a town to work in
					project.depot = build_depot(AITown.GetLocation(project.network_center));	//build a depot and associate it with the new network
					AILog.Info(project.depot);
					local station_1 = build_station(AITown.GetLocation(project.network_center));	//build a station
					if(station_1 >= 0) {
						project.stations.AddItem(AIStation.GetStationID(station_1),0);
						project.core_station = project.stations.Begin();
						local station_2 = build_station(AITown.GetLocation(project.network_center));	//build another station
						if(station_2 >= 0) {
							project.stations.AddItem(AIStation.GetStationID(station_2),1);
							local bus = build_bus(project.depot);	//build a bus
							project.buses.AddItem(bus, 0);	//add the bus to the network's list of buses
							order_bus(bus, project.stations.Begin());	//order the bus to go to the first station
							order_bus(bus, project.stations.Next());	//order the bus to go to the next station
							AIVehicle.StartStopVehicle(bus);	//start the bus
							AILog.Info("bus" + bus + " Started!");
						} else {
							total_towns.AddItem(project.network_center,1);
							project.reset();
							project = null;
						}
					} else {
						total_towns.AddItem(project.network_center,1);
						project.reset();
						project = null;
					}
				}
			} else {
				AILog.Info("Money is lacking, taking out loan");
				take_loan(20000);
			}
			
			if(check_funding() >= 60000 && project != null) {
				take_loan(-20000);
			}
			
			this.Sleep(500);
		} else {
			AILog.Info("We have run out of towns to expand to!");
		}
	}
}
