//This file contains functions related to managing money and deciding what to do

//check how much money we can spend
function check_funding () {
	return AICompany.GetBankBalance(AICompany.COMPANY_SELF);
}

//take out a loan
function take_loan (amount) {
	AICompany.SetLoanAmount(AICompany.GetLoanAmount() + amount);
}

//valuate the potential profit of a route(not actual expected profit yet)
function valuate_route(town1, town2) {
	local tile1 = AITown.GetLocation(town1);
	local tile2 = AITown.GetLocation(town2);
	local distance = AIMap.DistanceManhattan(tile1, tile2);
	local town1size = AITown.GetPopulation(town1);
	local town2size = AITown.GetPopulation(town2);
	local profit = (town1size + town2size) - (25*distance); 
	return profit;
}



