//This file contains the network class, the class that stores information about each network


class Network {
	
	depot = null;	//the depot built for this network
	serviced_towns = null;	//the towns serviced by this network
	network_center = null;	//thw town at the center of this network
	stations = null;	//the stations in this network
	buses = null;	//the vehicles in this network
	core_station = null;
	
	constructor () {
		serviced_towns = AITownList();
		serviced_towns.Clear();
		stations = AIStationList(AIStation.STATION_BUS_STOP);
		buses = AIVehicleList();
	}
	
	function reset() {
		serviced_towns = AITownList();
		serviced_towns.Clear();
		stations = AIStationList(AIStation.STATION_BUS_STOP);
		stations.RemoveList(stations);
		buses = AIVehicleList();
		depot = null;
		core_station = null;
	}
	
	function find_first_town () {
		AILog.Info("Finding a town..");
	
		//create a list of all the unserviced towns between 250 and 1100 population.
		AILog.Info("Searching for a small town...");
		local town_list = AITownList();
		town_list.Valuate(AITown.GetPopulation);
		town_list.KeepAboveValue(250);
		town_list.KeepBelowValue(1100);
		AILog.Info("Number of potential towns: " + town_list.Count());
		
		
		//choose the largest town in this list
		town_list.KeepTop(1);
		local town = town_list.Begin();
		AILog.Info("Town Found: " + AITown.GetName(town));
		
		//set the town to be the network's center
		network_center = town;
		serviced_towns.AddItem(town,0);
		AILog.Info("serviced_towns: " + serviced_towns.Count());
	}
}
