//this file contains road related functions

/*finds a path from one tile to the next using the road pathfinder library
Mostly copied from a pathfinding ai on the wiki */
function build_path(tile1, tile2) {

   AILog.Info("building path between " + tile1 + " and " + tile2);

	//create an instance of the pathfinder
	local pathfinder = RoadPathFinder();

	//tell openttd that we want to build roads
	AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_ROAD);

	//tell the pathfinder where we want to start and end
	pathfinder.InitializePath([tile1], [tile2]);

	AILog.Info("Finding Path")
   //find a path between the tiles
	local path = false;
   local i = 1
   while (path == false && i < 151) {
		AILog.Info("Try number " + i);
   	path = pathfinder.FindPath(150);
      i ++;
   	this.Sleep(1);
		if(i == 150) {return(false);}
  }

  //build the path we found
  while (path != null) {
    local par = path.GetParent();
    if (par != null) {
      local last_node = path.GetTile();
      if (AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) == 1 ) {
        if (!AIRoad.BuildRoad(path.GetTile(), par.GetTile())) {
          /* An error occured while building a piece of road. TODO: handle it. 
           * Note that is can also be the case that the road was already build. */
        }
      } else {
        /* Build a bridge or tunnel. */
        if (!AIBridge.IsBridgeTile(path.GetTile()) && !AITunnel.IsTunnelTile(path.GetTile())) {
          /* If it was a road tile, demolish it first. Do this to work around expended roadbits. */
          if (AIRoad.IsRoadTile(path.GetTile())) AITile.DemolishTile(path.GetTile());
          if (AITunnel.GetOtherTunnelEnd(path.GetTile()) == par.GetTile()) {
            if (!AITunnel.BuildTunnel(AIVehicle.VT_ROAD, path.GetTile())) {
              /* An error occured while building a tunnel. TODO: handle it. */
            }
          } else {
            local bridge_list = AIBridgeList_Length(AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) + 1);
            bridge_list.Valuate(AIBridge.GetMaxSpeed);
            bridge_list.Sort(AIList.SORT_BY_VALUE, false);
            if (!AIBridge.BuildBridge(AIVehicle.VT_ROAD, bridge_list.Begin(), path.GetTile(), par.GetTile())) {
              /* An error occured while building a bridge. TODO: handle it. */
            }
          }
        }
      }
    }
    path = par;
   }
	AILog.Info("Path Built!")
   return(true);
}


//builds a depot near and connected to the inputted tile
function build_depot(tile) {

   local depot_built = false;
   local depot_x = -1;
   local depot_y = -1;
   local depot_front = -1;
	local town = AITile.GetTownAuthority(tile);
	AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_ROAD);

   // Create a 14x14 grid around the town that will be used to find a location for a bus depot.
   local depot_location = AITileList();
   depot_location.AddRectangle(tile - AIMap.GetTileIndex(7, 7), tile + AIMap.GetTileIndex(7, 7));

   //cut the list down to buildable tiles next to roads
   depot_location.Valuate(AITile.IsWithinTownInfluence, town);
   depot_location.RemoveValue(0);
   AILog.Info("number of potential tiles: " + depot_location.Count());
   depot_location.Valuate(AITile.IsBuildable);
   depot_location.RemoveValue(0);
   AILog.Info("number of potential tiles: " + depot_location.Count());
   depot_location.Valuate(AIRoad.GetNeighbourRoadCount);
   depot_location.RemoveValue(0);
   AILog.Info("number of potential tiles: " + depot_location.Count());

   //Create a while loop to find a spot to build a depot.
   local depot = depot_location.Begin();
   while(!depot_built) {
	   wait(1);

      depot = depot_location.Next();
      depot_x = AIMap.GetTileX(depot);
      depot_y = AIMap.GetTileY(depot);

      //set the front of the depot to a road tile adjacent to the depot
      if(AIRoad.IsRoadTile(AIMap.GetTileIndex(depot_x, depot_y + 1))) {
         depot_front = AIMap.GetTileIndex(depot_x, depot_y + 1);
      } else if(AIRoad.IsRoadTile(AIMap.GetTileIndex(depot_x, depot_y - 1))) {
         depot_front = AIMap.GetTileIndex(depot_x, depot_y - 1);
      }else if(AIRoad.IsRoadTile(AIMap.GetTileIndex(depot_x + 1, depot_y))) {
         depot_front = AIMap.GetTileIndex(depot_x + 1, depot_y);
      }else{
         depot_front = AIMap.GetTileIndex(depot_x - 1, depot_y);
      }
      AILog.Info("Building Road between " + depot + " and " + depot_front);
      if(AIRoad.BuildRoad(depot_front, depot)) {
         AILog.Info("Built Road between " + depot + " and " + depot_front);
         if(AIRoad.BuildRoadDepot(depot, depot_front)) {
				//depots.AddTile(depot);
            depot_built = true;
            AILog.Info("Built Depot!");
			return depot;
         }

          
      }else{
         depot_location.RemoveValue(depot);
      }
   }
}

//This function builds a bus station in the optimal location in a 14x14 area
function build_station(town_center) {
	AILog.Info("Building Station near " + AITown.GetName(AITile.GetTownAuthority(town_center)));
	
	//variables for building our stations
	local stations_built = 0; //the number of statons we have built
	local station1_x = -1; //the x location of our station
	local station1_y = -1; //the y location of our station
	local station1_front = -1; // the tile our station is facing
	local station1_tileindex = -1; // the tile our station is on
    local town = AITile.GetTownAuthority(town_center);

	// Create a grid around the town that will be used to find a location for a bus station.
	local station1_location = AITileList();
      
	//create a 16x16 grid for smaller towns
	station1_location.AddRectangle(town_center - AIMap.GetTileIndex(8, 8), town_center + AIMap.GetTileIndex(8, 8));
	AILog.Info("number of potential tiles: " + station1_location.Count());
		
		
	
	//cut the list down to buildable tiles next to roads with reasonable passenger availability
	station1_location.Valuate(AITile.IsBuildable);
	station1_location.RemoveValue(0);
	station1_location.Valuate(AITile.IsWithinTownInfluence, town);
	station1_location.RemoveValue(0);
	AILog.Info("number of potential tiles: " + station1_location.Count());
	station1_location.Valuate(AIRoad.GetNeighbourRoadCount);
	station1_location.RemoveValue(0);
	AILog.Info("number of potential tiles: " + station1_location.Count());
	station1_location.Valuate(AITile.GetCargoAcceptance, 2, 1, 1, 6);
	station1_location.KeepTop(10);
	AILog.Info("number of potential tiles: " + station1_location.Count());
	station1_location.RemoveBelowValue(5);
	AILog.Info("number of potential tiles: " + station1_location.Count());

	//remove tiles near other stations
	for(local test_tile = station1_location.Begin(); !station1_location.IsEnd(); test_tile = station1_location.Next()) {

		//create a list of tiles near the tile being tested
		local neighbors = AITileList();
		neighbors.AddRectangle(test_tile - AIMap.GetTileIndex(2, 2), test_tile + AIMap.GetTileIndex(2, 2));

		//remove non-station tiles
		neighbors.Valuate(AITile.IsStationTile);
		neighbors.RemoveValue(0);

		// if there are still tiles, remove the tile being tested from the list of potential station locations
		if(neighbors.Count() != 0) {
			station1_location.RemoveTile(test_tile);
			AILog.Info("Removing tile: " + test_tile + " from the list of possible station tiles");
		}
		neighbors.Clear();

		//if there are no more potential tiles, return an error
		if(station1_location.Count == 0) {
			AILog.Error("Error 12: No suitable station tile found");
			return(-12);
		}
	}
	
	//sort the potential station tiles based on the number of passengers they will be serving
	station1_location.Valuate(AITile.GetCargoAcceptance, 2, 1, 1, 6)
	station1_location.Sort(AIList.SORT_BY_VALUE, false);
	
	if(station1_location.Count() > 0) {
		   //Create a while loop to find a spot to build a station.
		   local station1 = station1_location.Begin();
		   local loops = 0;
		   while(stations_built < 1 && loops <= 10) {
				loops++;
		      station1_x = AIMap.GetTileX(station1);
		      station1_y = AIMap.GetTileY(station1);

		      //set the front of the station to a road tile adjacent to the station
		      if(AIRoad.IsRoadTile(AIMap.GetTileIndex(station1_x, station1_y + 1))) {
		         station1_front = AIMap.GetTileIndex(station1_x, station1_y + 1);
		      } else if(AIRoad.IsRoadTile(AIMap.GetTileIndex(station1_x, station1_y - 1))) {
		         station1_front = AIMap.GetTileIndex(station1_x, station1_y - 1);
		      }else if(AIRoad.IsRoadTile(AIMap.GetTileIndex(station1_x + 1, station1_y))) {
		         station1_front = AIMap.GetTileIndex(station1_x + 1, station1_y);
		      }else if(AIRoad.IsRoadTile(AIMap.GetTileIndex(station1_x - 1, station1_y))) {
		         station1_front = AIMap.GetTileIndex(station1_x - 1, station1_y);
		      }

			  //build the road that will connect the station to a main road
		      AILog.Info("Building Road between " + station1 + " and " + station1_front);
		      if(AIRoad.BuildRoad(station1_front, station1)) {
		         AILog.Info("Built Road between " + station1 + " and " + station1_front);
		         
		         //build a station at the chosen location
		         if(AIRoad.BuildRoadStation(station1, station1_front, AIRoad.ROADVEHTYPE_BUS,AIStation.STATION_NEW)) {
		            stations_built ++;
		            AILog.Info("Built Station!");

		            //Mark the location of the stations to order busses to them.
		            if(stations_built == 1) {
		                station1_tileindex = AIMap.GetTileIndex(station1_x, station1_y);
						return(station1_tileindex);
		            }
		         }else{
						AILog.Info("Error 13: no station could be built");
						return(-13);
					}
		         
		         
		         
		      }else{
					station1_location.RemoveValue(station1);
					if(station1_location.Count() == 0) {
						//all locations were tried but no station could be built
						AILog.Error("Error: No bus station could be built!");
						return(-10);
					}
		      }

		      
		      this.Sleep(5);
		      station1 = station1_location.Next();
		   }
		
	} else {
		AILog.Error("Error: No bus station could be built!");
		return(-10);
	}
}

function build_bus(depot) {

  //chose the newest bus
   local engines = AIEngineList(AIVehicle.VT_ROAD);
   engines.Valuate(AIEngine.IsBuildable);
   engines.RemoveValue(0);
   engines.Valuate(AIEngine.GetCargoType);
  	engines.KeepValue(0);
	engines.Valuate(AIEngine.GetDesignDate);
	engines.KeepTop(1);
   AILog.Info("Number of potential busses: " + engines.Count());
   while(engines.Count() > 1) {
      engines.RemoveBottom(1);
      this.Sleep(5);
   }

   local bus = null;
   //build the vehicle
   local bus_type = engines.Begin();
   if(AIEngine.IsBuildable(bus_type)) {
      AILog.Info("Bus found: " + AIEngine.GetName(bus_type) + "  Building at" + depot);
      bus = AIVehicle.BuildVehicle(depot, bus_type);
      AILog.Info("Built Bus!");
		return bus;
   }
}

function order_bus_to_location (bus, location) {
	if(AIOrder.InsertOrder(bus, 0, location, AIOrder.OF_NONE)) {
		AILog.Info("Bus order set");
		return true;
	}
	return false;
}
function order_bus (bus, station) {
	AILog.Info("ordering bus " + bus + " to go to: " + AIBaseStation.GetName(station));
	if(AIOrder.InsertOrder(bus, 0, AIBaseStation.GetLocation(station), AIOrder.OF_NONE)) {
		AILog.Info("Bus order set");
		return true;
	}
	return false;
}

function wait (time) {
	AIController.Sleep(time);
}

