require("BuildManager.nut");

class RouteManager {
    MAX_STATION_COUNT = 2;

    m_townRouteArray = null;
    m_airportTowns = null;

    constructor() {
        m_townRouteArray = [];
        m_airportTowns = AIList();
    }

    function buildRoute(buildManager, cityFrom, cityTo, cargoClass) {
        local route = buildManager.buildRoute(cityFrom, cityTo, cargoClass);
        if (route != null) {
            m_townRouteArray.append(route);
            buildManager.setRouteFinish();
            return 1;
        }

        return null;
    }


    function getRoadVehicleCount() {
        //local list = AIVehicleList();
        //list.Valuate(AIVehicle.GetVehicleType);
        //list.KeepValue(AIVehicle.VT_ROAD);
        //return list.Count();

        local count = 0;

        for(local i = 0; i < m_townRouteArray.len(); ++i) {
            count += AIVehicleList_Depot(m_townRouteArray[i].m_depotTile).Count();
        }

        return count;
    }

    function townRouteExists(cityFrom, cityTo) {
        for(local i = 0; i < m_townRouteArray.len(); ++i) {
            if(TownPair(cityFrom, cityTo).isEqual(m_townRouteArray[i].m_cityFrom, m_townRouteArray[i].m_cityTo)) {
                return 1;
            }
        }

        return 0;
    }

    function airRouteExists(cityFrom, cityTo) {
        for(local i = 0; i < m_townRouteArray.len(); ++i) {
            if(TownPair(cityFrom, cityTo).isEqual(m_airRouteArray[i].m_cityFrom, m_airRouteArray[i].m_cityTo)) {
                return 1;
            }
        }

        return 0;
    }

    //the highest last years profit out of all vehicles
    function highestProfitLastYear() {
        local maxAllRoutesProfit = 0;

        for(local i = 0; i < m_townRouteArray.len(); ++i) {
            local maxRouteProfit = AIVehicleList_Depot(m_townRouteArray[i].m_depotTile);
            maxRouteProfit.Valuate(AIVehicle.GetProfitLastYear);
            maxRouteProfit.Sort(AIList.SORT_BY_VALUE, false);
            maxRouteProfit = maxRouteProfit.GetValue(maxRouteProfit.Begin());

            if(maxRouteProfit > maxAllRoutesProfit) {
                maxAllRoutesProfit = maxRouteProfit;
            }
        }

        return maxAllRoutesProfit;
    }

    //wont build any new stations if 1
    function hasMaxStationCount(cityFrom, cityTo) {
        local maxTownStationFrom = (1 + AITown.GetPopulation(cityFrom) / 1000).tointeger();
        local maxTownStationTo = (1 + AITown.GetPopulation(cityTo) / 1000).tointeger();

        local cityFromCount = 0;
        local cityToCount = 0;

        for(local i = 0; i < m_townRouteArray.len(); ++i) {
            if(m_townRouteArray[i].m_cityFrom == cityFrom || m_townRouteArray[i].m_cityFrom == cityTo) {
                ++cityFromCount;
            }

            if(m_townRouteArray[i].m_cityTo == cityTo || m_townRouteArray[i].m_cityTo == cityFrom) {
                ++cityToCount;
            }
        }

        if((cityFromCount >= maxTownStationFrom) || (cityToCount >= maxTownStationTo)) {
            return 1;
        }

        return 0;
    }

    function saveRouteManager() {
        local table = {};

        for(local i = 0; i < m_townRouteArray.len(); ++i) {
            table.rawset(i, m_townRouteArray[i].saveRoute());
        }

        return table;
    }

    function loadRouteManager(data) {
        if(m_townRouteArray == null) {
            m_townRouteArray = [];
        }

        local i = 0;
        while(data.rawin(i)) {
            local route = Route.loadRoute(data.rawget(i));
            m_townRouteArray.append(route);

            ++i;
        }

        AILog.Info("Loaded " + m_townRouteArray.len() + " routes.");
    }
    
}