class TownPair {
    m_cityFrom = null;
    m_cityTo = null;

    constructor(cityFrom, cityTo) {
        m_cityFrom = cityFrom;
        m_cityTo = cityTo;
    }

    function isEqual(cityFrom, cityTo) {
        if((m_cityFrom == cityFrom) && (m_cityTo == cityTo)) {
            return 1;
        }

        if((m_cityFrom == cityTo) && (m_cityTo == cityFrom)) {
            return 1;
        }

        return 0;
    }

    function toString() {
        return "Pair: [" + AITown.GetName(m_cityFrom) + "] [" + AITown.GetName(m_cityTo) + "]";
    }

    function saveTownPair() {
        local pair = [];

        pair.append(m_cityFrom);
        pair.append(m_cityTo);

        return pair;
    }

    function loadPair(data) {
        local cityFrom = data[0];
        local cityTo = data[1];

        return TownPair(cityFrom, cityTo);
    }
}

class TownManager {
    m_townList = null;

    m_nearCityPairArray = null;
    m_usedCities = null;

    constructor() {

        m_townList = AITownList();
        if(AIController.GetSetting("cities_only")) {
            m_townList = AITownList();
            m_townList.Valuate(AITown.IsCity);
            m_townList.KeepValue(1);
        }

        m_nearCityPairArray = [];
        m_usedCities = AIList();
    }

    function getUnusedCity(bestRoutesBuilt);
    function findNearCities(fromCity, minDistance, maxDistance, bestRoutesBuilt);

    function getUnusedCity(bestRoutesBuilt) {
        if(m_townList.Count() == m_usedCities.Count()) {
            return null;
        }

        local localList = AIList();
        localList.AddList(m_townList);
        localList.RemoveList(m_usedCities);

        local unusedTown = null;
        if(AIController.GetSetting("pick_random")) {
            local randomLocalListItemIndex = AIBase.RandRange(localList.Count() - 1);
            unusedTown = Utils.getNthItem(localList, randomLocalListItemIndex);
            m_usedCities.AddItem(unusedTown, 0);
        }
        else {
            localList.Valuate(AITown.GetPopulation);
            localList.Sort(AIList.SORT_BY_VALUE, false);

            if(!bestRoutesBuilt) {
                localList.KeepAboveValue(700);
            }

            if(localList.Count()) {
                unusedTown = localList.Begin();
                m_usedCities.AddItem(unusedTown, 0);
            }
        }

        return unusedTown;
    }

    function findNearCities(fromCity, minDistance, maxDistance, bestRoutesBuilt) {
        local localCityList = AIList();
        localCityList.AddList(m_townList);
        localCityList.RemoveList(m_usedCities);
        localCityList.RemoveItem(fromCity); //remove self

        local localPairList = AIList();

        for(local toCity = localCityList.Begin(); localCityList.HasNext(); toCity = localCityList.Next()) {

            local distance = AITown.GetDistanceManhattanToTile(fromCity, AITown.GetLocation(toCity));
            if((distance > maxDistance) || (distance < minDistance)) {
                //AILog.Warning("findNearCity:: Distance too long between " + AITown.GetName(fromCity) + " and " + AITown.GetName(toCity)) ;
            }
            else {
                localPairList.AddItem(toCity, 0);
            }
        }

        if(!localPairList.Count()) {
            return;
        }

        if(AIController.GetSetting("pick_random")) {
            local randomLocalListItemIndex = AIBase.RandRange(localPairList.Count() - 1);
            local toCity = Utils.getNthItem(localPairList, randomLocalListItemIndex);

            m_nearCityPairArray.append(TownPair(fromCity, toCity));
        }
        else {
            localPairList.Valuate(AITown.GetPopulation);
            localPairList.Sort(AIList.SORT_BY_VALUE, false);

            if (!bestRoutesBuilt) {
                local exists = false;
                for(local i = 0; i < m_nearCityPairArray.len(); ++i) {
                    if(m_nearCityPairArray[i].isEqual(fromCity, localPairList.Begin())) {
                        exists = true;
                        break;
                    }
                }

                if(!exists) {
                    m_nearCityPairArray.append(TownPair(fromCity, localPairList.Begin()));
                    return;
                }
            } else {
                for (local toCity = localPairList.Begin(); localPairList.HasNext(); toCity = localPairList.Next()) {
                    local exists = false;
                    for(local i = 0; i < m_nearCityPairArray.len(); ++i) {
                        if(m_nearCityPairArray[i].isEqual(fromCity, toCity)) {
                            exists = true;
                            break;
                        }
                    }

                    if(!exists) {
                        m_nearCityPairArray.append(TownPair(fromCity, toCity));
                    }
                }
            }
        }

        return;
    }
    
    function saveTownManager() {
        local pairTable = {};
        for(local i = 0; i < m_nearCityPairArray.len(); ++i) {
            pairTable.rawset(i, m_nearCityPairArray[i].saveTownPair());
        }

        local usedTownsTable = {};
        for(local town = m_usedCities.Begin(), i = 0; m_usedCities.HasNext(); town = m_usedCities.Next(), ++i) {
            usedTownsTable.rawset(i, town);
        }

        return [pairTable, usedTownsTable];
    }

    function loadTownManager(data) {
        if(m_nearCityPairArray == null) {
            m_nearCityPairArray = [];
        }

        if(m_usedCities == null) {
            m_usedCities = AIList();
        }

        local pairTable = data[0];

        local i = 0;
        while(pairTable.rawin(i)) {
            local pair = TownPair.loadPair(pairTable.rawget(i));
            m_nearCityPairArray.append(pair);

            ++i;
        }


        local usedTownsTable = data[1];

        i = 0;
        while(usedTownsTable.rawin(i)) {
            local town = usedTownsTable.rawget(i);
            m_usedCities.AddItem(town, 0);

            ++i;
        }

    }

}