/*
 *
 * Copyright (c) 2009, Dustin Andrews
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions in binary form must reproduce the above copyright notice, this
 * list of conditions and the following disclaimer in the documentation and/or 
 *  other materials provided with the distribution.
 * 
 * The names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

class Headquarters
{
    constructor()
    {
    }
}

function Headquarters::Place()
{
    local randTown = GetRandomTown();
    local townName = AITown.GetName(randTown);
    AILog.Info("Moving company headquaters to " + townName);
    local randTownManager = TownManager(randTown);
    local townTiles = randTownManager.GetInfluencedZone();
    townTiles.Valuate(AIMap.DistanceManhattan, randTownManager.Location);
    local result = FindLocationAndBuildHQ(townTiles);
    if(result == false)
    {
        AILog.Info(townName + " was a stupid place anyway. Move someplace else.")
    }
    return result;
}

function Headquarters::GetRandomTown()
{
    local cities = AITownList();
    local count = cities.Count();
    local random = AIBase.RandRange(count - 1);
    cities.Begin();
    for(local i = 0; i < random; i++)
    {
        cities.Next();
    }
    
    
    return cities.Next();
}

function Headquarters::FindLocationAndBuildHQ(townTiles)
{
    townTiles.Sort(AIAbstractList.SORT_BY_VALUE, true);
    foreach(tile, v in townTiles)
    {
        local square = AITileList();
        square.AddRectangle(tile, tile + AIMap.GetTileIndex(1,1));
        square.Valuate(AITile.IsBuildable);
        square.KeepValue(1);
        if(square.Count() == 4)
        {
            local result = PlaceHeadQuarters(tile, square);
            if(result) {return true;}
        }
    }
    return false;
}

function Headquarters::PlaceHeadQuarters(tile, square)
{
    //AITile.LevelTiles(tile, tile + AIMap.GetTileIndex(1,1));
    local alt = AITile.GetMaxHeight(tile);
    foreach(ptile, v in square)
    {
        if(AITile.GetSlope(ptile) != AITile.SLOPE_FLAT) {return false;}
        if(AITile.GetMaxHeight(ptile) != alt) {return false;}
    }

    local result = AICompany.BuildCompanyHQ(tile);
    return result;
    
}