/*
 *
 * Copyright (c) 2009, Dustin Andrews
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 
 * Redistributions in binary form must reproduce the above copyright notice, this
 * list of conditions and the following disclaimer in the documentation and/or 
 *  other materials provided with the distribution.
 * 
 * The names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

class TownManager
{  
  Index = null;
  Location = null;
  Name = null;
  
  startRadius = 5;
  constructor(townIndex)
  {
    this.Index = townIndex;
    Location = AITown.GetLocation(townIndex);
    Name = AITown.GetName(townIndex);
  }
}


function TownManager::GetInfluencedZone()
{
  local tiles = GetBoundingRectRadius(20);
  
  
  tiles.Valuate(AITile.GetClosestTown);
  foreach(tile, v in tiles)
  {
    local name = AITown.GetName(v);
    //AISign.BuildSign(tile, name);
  }
  tiles.KeepValue(Index);
 //print(Name + "influences " + tiles.Count() + " tiles.");
  return tiles;
}

function TownManager::GetRating()
{
  return AITown.GetRating(Index, AICompany.COMPANY_SELF );
}

function TownManager::GetBoundingRect()
{
  return this.GetBoundingRectRadius(5);
}

function TownManager::GetBoundingRectRadius(radius)
{
  local rectangle = AIList();
  local tiles = AITileList();
  local tile1 = null;
  local tile2 = null;
  tile1 = Location + AIMap.GetTileIndex(-radius, -radius);
  tile2 = Location + AIMap.GetTileIndex(radius, radius);
  //AISign.BuildSign(tile1, Name + " 1");
  //AISign.BuildSign(tile2, Name + " 2");
  
  tiles.AddRectangle(tile1, tile2);
  return tiles;
}

function TownManager::GetCirclingRect()
{
  local rectangle = AIList();
  local tiles = AITileList();
  
  local radius = 5;
  local hasjunk = true;
  while(radius < 20 && hasjunk == true)
  {
    local tile1 = Location + AIMap.GetTileIndex(-radius, -radius);
    local tile2 = Location + AIMap.GetTileIndex(radius, radius);
    local tile3 = Location + AIMap.GetTileIndex(-radius + 1, -radius + 1);
    local tile4 = Location + AIMap.GetTileIndex(radius - 1, radius - 1);
  
    tiles.AddRectangle(tile1, tile2);
    tiles.RemoveRectangle(tile3, tile4);
    
    hasjunk = false;
    foreach(tile, v in tiles)
    {
      //AISign.BuildSign(tile, "'");
      if(!(AITile.IsBuildable(tile) || AITile.IsWaterTile(tile) || AIRoad.IsRoadTile(tile) )) {hasjunk = true;}
    }
    radius++;
  }
  

  if(hasjunk == false)
  {
    
    rectangle.AddList(tiles);
    rectangle.Valuate(AITile.GetDistanceManhattanToTile, rectangle.Begin());
    rectangle.Sort(AIAbstractList.SORT_BY_VALUE, true)
    return rectangle;
  }
  return null;
}


function TownManager::BoxInTown()
{
    local rectangle = this.GetCirclingRect();
    local odds = AIList();
    local evens = AIList();
  
    local count = 0;
    foreach(tile, v in rectangle)
    {
      count++;
      if(count % 2 == 0)
      {
        evens.AddItem(tile, count);
      }
      else
      {
        odds.AddItem(tile, count);
      }
    }
    
    BuildRoads(evens);
    BuildRoads(odds);

}

function TownManager::BuildRoads(list)
{
  list.Sort(AIAbstractList.SORT_BY_VALUE, true);
  
  list.Valuate(AITile.IsBuildable);
  list.KeepValue(1);
  local current = list.Begin();
  local next = null;
  while(next = list.Next())
  {
    AIRoad.BuildRoad(current, next);
    current = next;
  }

}
