
// ====================================================== 
//                    FIND RVs TO BUY
// ======================================================  

// Buses, Coaches, Mail and Goods trucks are now unified in this single function (1.9)
function CivilAI::IdentifyBus(silent, intercity, cargo) {

local busid= null;
local vlist= 0;
local blist= 0;
local bcap = 0;
local bdate= 0;
local z = 0;

local fast = BiasFast;
local big = BiasBig;
local cheap = BiasCheap;
local fscore = 0;
local bscore = 0;
local cscore = 0;
local tscore = 0;
local hitea = null;

if (intercity) {
fast = BiasFast + 5; // prefer faster vehicles for intercity
} else {
big = BiasBig + 5; // prefer higher capacity for city
}


// check native vehicles first
vlist = AIEngineList(AIVehicle.VT_ROAD); 	// list of all road vehicles
foreach (rv,z in vlist) { // remove everything that can't carry the cargo
if ((AIEngine.IsBuildable(rv)) 
&& (AIEngine.GetCargoType(rv) == cargo)
&& (AIEngine.GetCapacity(rv) > 9)	
&& (AIEngine.GetRoadType(rv) == AIRoad.ROADTYPE_ROAD)) {

//AILog.Info (AIEngine.GetName(rv) + " is a suitable vehicle.")
} else {
vlist.RemoveItem(rv);
}
}

if (vlist.Count() == 0) { // no native vehicles found - check refittable vehicles
vlist = AIEngineList(AIVehicle.VT_ROAD); 	// list of all road vehicles
foreach (rv,z in vlist) { // remove everything that can't carry the cargo
if ((AIEngine.IsBuildable(rv)) 
&& (AIEngine.CanRefitCargo(rv, cargo))
&& (AIEngine.GetCapacity(rv) > 9)	
&& (AIEngine.GetRoadType(rv) == AIRoad.ROADTYPE_ROAD)) {

//AILog.Info (AIEngine.GetName(rv) + " is a suitable vehicle.")
} else {
vlist.RemoveItem(rv);
}
}
}

if (vlist.Count() == 0) {return null;} else {

 // remove too-slow vehicles
 
 vlist.Valuate(AIEngine.GetMaxSpeed);
 vlist.Sort(AIList.SORT_BY_VALUE,true);
 
 foreach (rv, z in vlist) {
 if (
 ( vlist.Count() > 1) &&
 (AIEngine.GetMaxSpeed(rv) < 40)
 ) {
vlist.RemoveItem(rv);
 }
 }
 
vlist.Valuate(AIBase.RandItem); // shuffle the list so if we have vehicles with the same values (eg different truck graphics) we'll get a random selection

foreach (rv,z in vlist) { // score the vehicles
fscore = AIEngine.GetMaxSpeed(rv) * fast / 4;
bscore = AIEngine.GetCapacity(rv) * big / 2;
cscore = (AIEngine.GetPrice(rv) + AIEngine.GetRunningCost(rv)) * cheap / 800;
tscore = (fscore) + (bscore) - (cscore);

//AILog.Info ("Scored " + AIEngine.GetName(rv) + " at " + tscore + " (" + fscore + "," + bscore + "," + cscore + ").");

if (hitea == null || tscore > hitea) {
busid = rv;
hitea = tscore;
}

}
}
if (!silent) { AILog.Info("I've selected " + AIEngine.GetName(busid)  + " to buy.") }
return (busid);
}

// ====================================================== 
//                    FIND FREIGHT LOCO TO BUY
// ======================================================  

function CivilAI::PickFreightLoco(routelength, climb) {

local loco = null;

local fast = BiasFast;
local big = BiasBig;
local cheap = BiasCheap;
local fscore = 0;
local bscore = 0;
local cscore = 0;
local tscore = 0;
local tbonus = 0;
local hitea = null;
 
local locolist = AIEngineList(AIVehicle.VT_RAIL);

local ft;
if (AIGameSettings.IsValid("vehicle.freight_trains")) {
ft = AIGameSettings.GetValue("vehicle.freight_trains");
} else { ft = 1;}

local minpow = (
350 +
(ft * 50)); // taking freight_trains multiplier into account
local tarpow = (
350 +
(climb * 10 * ft) +
(ft * 50)); // taking freight_trains multiplier into account

// AILog.Info("Freight multiplier is " + ft + ", hilliness of route is " + climb + ", target locomotive power is " + tarpow + "hp.")

 foreach (l, z in locolist) { // remove vehicles which don't meet basic standards
 if (
 AIEngine.GetCapacity(l) > 0
 || AIEngine.GetPower(l) < minpow 
 || AIEngine.GetMaxSpeed(l) < 64 // these are our minimum standards 
 || !AIEngine.CanRunOnRail(l, 0)
 || !AIEngine.HasPowerOnRail(l, 0)
 )
 {locolist.RemoveItem(l)}
 }
 
 locolist.Valuate(AIEngine.GetPower);
 locolist.Sort(AIList.SORT_BY_VALUE,true);
 
 
 foreach (l, z in locolist) { // remove vehicles which don't meet hillclimbing requirement (as long as we keep 1)
 if (
 ( locolist.Count() > 1) &&
 ((AIEngine.GetPower(l) + AIEngine.GetMaxTractiveEffort(l)) < tarpow)
 ) 
 {locolist.RemoveItem(l)}
 }
 
foreach (l, z in locolist) {
// new in 1.9 - we use a scoring method based on our biasing 
fscore = AIEngine.GetMaxSpeed(l) * fast / 4;
bscore = AIEngine.GetMaxTractiveEffort(l) * big / 6;
cscore = (AIEngine.GetPrice(l) + AIEngine.GetRunningCost(l)) * cheap / 1000;
tbonus = (tarpow - AIEngine.GetPower(l)) / 4; // bonus for being close to tarpow
tscore = 500 + (fscore) + (bscore) - (cscore) + tbonus; 

//AILog.Info ("Scored " + AIEngine.GetName(l) + " at " + tscore + " (f " + fscore + ", b " + bscore + "(" + tbonus + "), c " + cscore + ").");

if (hitea == null || tscore > hitea) {
loco = l;
hitea = tscore;
}
}
// if (loco != null) { AILog.Info ("Selected " + AIEngine.GetName(loco) + ".")}
return (loco); 
  
}

// ====================================================== 
//                    FIND HAIRYPLANE TO BUY
// ======================================================  


function CivilAI::PickAircraft(range) {

local acid = null;

local fast = BiasFast;
local big = BiasBig;
local cheap = BiasCheap;
local fscore = 0;
local bscore = 0;
local cscore = 0;
local tscore = 0;
local hitea = null;

local aclist = AIEngineList(AIVehicle.VT_AIR);

foreach (ac, z in aclist) { 
if ((AIEngine.GetPlaneType(ac) != AIAirport.PT_SMALL_PLANE) && (AIEngine.GetPlaneType(ac) != AIAirport.PT_HELICOPTER)) 
{ 
// AILog.Info("Discarding " + AIEngine.GetName(ac) + " because it is not a small aircraft."); 
aclist.RemoveItem(ac)
}

if ((AIEngine.GetMaximumOrderDistance(ac) != 0) && (AIEngine.GetMaximumOrderDistance(ac) < range))
{ 
// AILog.Info("Discarding " + AIEngine.GetName(ac) + " because it has insufficient range."); 
aclist.RemoveItem(ac)
}

if (AIEngine.GetCargoType(ac) != 0)
{ 
// AILog.Info("Discarding " + AIEngine.GetName(ac) + " because it doesn't carry Passengers."); 
aclist.RemoveItem(ac)
}
}

foreach (ac, z in aclist) {
// new in 1.9 - we use a scoring method based on our biasing 
fscore = AIEngine.GetMaxSpeed(ac) * fast / 10;
bscore = AIEngine.GetCapacity(ac) * big / 5;
cscore = (AIEngine.GetPrice(ac) + AIEngine.GetRunningCost(ac)) * cheap / 20000;
tscore = 500 + (fscore) + (bscore) - (cscore); 

//AILog.Info ("Scored " + AIEngine.GetName(ac) + " at " + tscore + " (f " + fscore + ", b " + bscore + ", c " + cscore + ").");

if (hitea == null || tscore > hitea) {
acid = ac;
hitea = tscore;
}
}
//if (acid != null) { AILog.Info ("Selected " + AIEngine.GetName(acid) + ".")}
return (acid); 

}

// ====================================================== 
//                    FIND SHIP TO BUY
// ======================================================  


function CivilAI::PickShip(dist) {

local boatid = null;

local fast = BiasFast;
local big = BiasBig;
local cheap = BiasCheap;
local fscore = 0;
local bscore = 0;
local cscore = 0;
local tscore = 0;
local hitea = null;

local shiplist = AIEngineList(AIVehicle.VT_WATER);

shiplist.Valuate(AIEngine.GetCapacity);
shiplist.Sort(AIList.SORT_BY_VALUE,true);

foreach (boat, z in shiplist) { 
if (AIEngine.GetCargoType(boat) != 0)
{ 
// AILog.Info("Discarding " + AIEngine.GetName(boat) + " because it doesn't carry Passengers."); 
shiplist.RemoveItem(boat)
}

if ( 
(shiplist.Count() > 1) && 
(AIEngine.GetCapacity(boat) < 50))
{ 
//AILog.Info("Discarding " + AIEngine.GetName(boat) + " because it is too small."); 
shiplist.RemoveItem(boat)
}
}

foreach (boat, z in shiplist) {
// new in 1.9 - we use a scoring method based on our biasing 
fscore = AIEngine.GetMaxSpeed(boat) * fast / 5;
bscore = AIEngine.GetCapacity(boat) * big / 5;
cscore = (AIEngine.GetPrice(boat) + AIEngine.GetRunningCost(boat)) * cheap / 5000;
tscore = 500 + (fscore) + (bscore) - (cscore); 

//AILog.Info ("Scored " + AIEngine.GetName(boat) + " at " + tscore + " (f " + fscore + ", b " + bscore + ", c " + cscore + ").");

if ((boatid != null) && ((fscore + bscore) > (dist * 10))) { 
//AILog.Info (AIEngine.GetName(boat) + "is too big for the route length (" + dist + ").")
} else {
if (hitea == null || tscore > hitea) {
boatid = boat;
hitea = tscore;
}
}
}
//if (boatid != null) { AILog.Info ("Selected " + AIEngine.GetName(boatid) + ".")}
return (boatid); 

}



