class CivilAI extends AIInfo {
  function GetAuthor()      { return "David Dallaston"; }
  function GetName()        { return "CivilAI"; }
  function GetDescription() { return "A general-purpose AI which builds out from a starting location. Uses buses, trucks, trains and aircraft and is friendly to children and small animals."; }
  function GetVersion()     { return 19; }
  function MinVersionToLoad () { return 1; }
  function GetDate()        { return "2019-4-1"; }
  function CreateInstance() { return "CivilAI"; }
  function GetShortName()   { return "CIVL"; }
  function GetAPIVersion()  { return "1.9"; }
  function UseAsRandomAI()  { return true }
  function GetSettings() {
    AddSetting({name = "NoRoadNetwork", description = "Disable inter-city road network building", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN|AICONFIG_INGAME});
	AddSetting({name = "NetworkRadius", description = "The maximum radius of the road network this AI will build", easy_value = 512, medium_value = 512, hard_value = 512, custom_value = 512, flags = CONFIG_INGAME, step_size = 64, min_value = 64, max_value = 4096});
	AddSetting({name = "MinPop", description = "The minimum town population required for this AI to build a bus network", easy_value = 1000, medium_value = 1000, hard_value = 1000, custom_value = 1000, flags = CONFIG_INGAME, step_size = 250, min_value = 500, max_value = 5000});
	AddSetting({name = "MaxBus", description = "The maximum number of buses this AI will build", easy_value = 250, medium_value = 250, hard_value = 250, custom_value = 250, flags = CONFIG_INGAME, step_size = 50, min_value = 50, max_value = 5000});
	AddSetting({name = "MaxCar", description = "The maximum number of town cars this AI will build", easy_value = 500, medium_value = 500, hard_value = 500, custom_value = 500, flags = CONFIG_INGAME, step_size = 100, min_value = 0, max_value = 5000});
    AddSetting({name = "TrainRange", description = "The maximum length of train routes this AI will build", easy_value = 128, medium_value = 128, hard_value = 128, custom_value = 128, flags = CONFIG_INGAME, step_size = 16, min_value = 48, max_value = 256}); 
	AddSetting({name = "BrakeYear", description = "Build train brake vans, if available, until this year", easy_value = 1975, medium_value = 1975, hard_value = 1975, custom_value = 1975, flags = CONFIG_INGAME, step_size = 10, min_value = 0, max_value = 10000}); 
	AddSetting({name = "MinAirRange", description = "The minimum length of aircraft routes this AI will build", easy_value = 96, medium_value = 96, hard_value = 96, custom_value = 96, flags = CONFIG_INGAME, step_size = 16, min_value = 48, max_value = 256});
	AddSetting({name = "ShipRange", description = "The maximum length of ship routes this AI will build", easy_value = 256, medium_value = 256, hard_value = 256, custom_value = 256, flags = CONFIG_INGAME, step_size = 16, min_value = 48, max_value = 512});

}  

  
  
}


/* Tell the core we are an AI */


RegisterAI(CivilAI());