
// ====================================================== 
//                    BUILD DEPOT
// ====================================================== 



function CivilAI::BuildDepot(roadtile,town) {
// this is road, check it's joined to the centre of town
local testroad = RoadPF();
local towntile = AITown.GetLocation(town);
local depot = 0;

testroad.cost.no_existing_road = testroad.cost.max_cost; // only check existing roads
testroad.InitializePath([roadtile], [towntile]);

local path = false;
while (path == false) {
path = testroad.FindPath(20);
AIController.Sleep(1);
}

if ((path != null) && (AITile.GetSlope(roadtile) == 0)) { 
// AISign.BuildSign(roadtile, "?");

local builtlink = false; // keep trying if a vehicle is preventing building the road connection
local c = 0;
local roadtilegrid = [AIMap.GetTileX(roadtile),AIMap.GetTileY(roadtile)]
    if (AIRoad.BuildRoadDepot (AIMap.GetTileIndex(roadtilegrid[0]+1,roadtilegrid[1]),roadtile)) {
	depot = AIMap.GetTileIndex(roadtilegrid[0]+1,roadtilegrid[1]);
    while (!builtlink && c < 100) {
	builtlink = AIRoad.BuildRoad (roadtile,depot);
	c++
	AIController.Sleep(5);
	}	
	} else if (AIRoad.BuildRoadDepot (AIMap.GetTileIndex(roadtilegrid[0]-1,roadtilegrid[1]),roadtile)) {
	depot = AIMap.GetTileIndex(roadtilegrid[0]-1,roadtilegrid[1]);
    while (!builtlink && c < 100) {
	builtlink = AIRoad.BuildRoad (roadtile,depot);
	c++
	AIController.Sleep(5);
	}	
	} else if (AIRoad.BuildRoadDepot (AIMap.GetTileIndex(roadtilegrid[0],roadtilegrid[1]+1),roadtile)) {
	depot = AIMap.GetTileIndex(roadtilegrid[0],roadtilegrid[1]+1);	 
    while (!builtlink && c < 100) {
	builtlink = AIRoad.BuildRoad (roadtile,depot);
	c++
	AIController.Sleep(5);
	}	
	} else if (AIRoad.BuildRoadDepot (AIMap.GetTileIndex(roadtilegrid[0],roadtilegrid[1]-1),roadtile)) {
	depot = AIMap.GetTileIndex(roadtilegrid[0],roadtilegrid[1]-1);
    while (!builtlink && c < 100) {
	builtlink = AIRoad.BuildRoad (roadtile,depot);
	c++
	AIController.Sleep(5);
	}	
	}	
}
return depot;
}


//<
// ====================================================== 
// ====================================================== 
//         RRRRR     OOOO      AAAA     DDDD
//         R   RR   O    O    A    A    D  DD
//         RRRRR   OO    OO   AAAAAA    D   DD
//         R   R    O    O    A    A    D  DD
//         R    R    OOOO     A    A    DDDD
// ====================================================== 
// ====================================================== 
//>
// ====================================================== 
//                  CHOOSE ROAD CONNECTION
// ====================================================== 

function CivilAI::MappaMundi() {
AILog.Info("Stand by for road construction...")

local a
local b

//AILog.Info("I'm connecting towns with road.");

// new check: have we built in most of the towns already connected? If not, don't waste money expanding.

local zoop = AIList();
zoop.AddList(Cachedtowns);

zoop.Valuate(AITown.GetPopulation);
zoop.RemoveBelowValue(MinPop); // only buildable towns considered

local yoop = AIDepotList(AITile.TRANSPORT_ROAD); 

//AILog.Info("I currently have " + yoop.Count() + " depots in " + zoop.Count() + " towns.");

if (zoop.Count() < yoop.Count() + 2) {

local hq = AICompany.GetCompanyHQ(Me);
local townlist = AITownList();

townlist.Valuate(AITown.GetPopulation);
townlist.RemoveBelowValue(MinPop); // don't connect to towns we can't build in
townlist.AddItem(AITile.GetClosestTown(hq), 0); // add back the home town, in case it's small
townlist.AddList(IndTownList); // but add back any we want to connect for industrial reasons

 // sort by distance from the hq
townlist.Valuate(AITown.GetDistanceManhattanToTile, hq);


townlist.KeepBelowValue(NetworkRadius); // remove towns which are too far away
townlist.RemoveList(Dudtowns); // remove known unconnectables

townlist.Sort(AIList.SORT_BY_VALUE,true);

// add the home town's home tile to the target list
local hometown = townlist.Begin();
local mapnodes = [AITown.GetLocation(hometown)] 
local nodecount = 1
local target = -1

zoop.AddList(Cachedtowns); //rezoop all-sized towns

foreach (town,z in townlist) {
local towntile = AITown.GetLocation(town);
if (!AITile.HasTransportType(towntile,AITile.TRANSPORT_ROAD) && (AITown.GetRoadReworkDuration(town) == 0)) {
Dudtowns.AddItem(town,0) // add this town to a list of unreachables
AILog.Info(AITown.GetName(town) + " has no central road tile.")
} else {
if (zoop.HasItem(town)) { 			// we are connected already
mapnodes.append(towntile); // add this town to the nodes we can connect to
nodecount ++
//AILog.Info(AITown.GetName(town) + " added as connectable node.")
} else {
target = town;
break;
}
}
}

if (target != -1) {
//new: build halfway first!

local condist = NetworkRadius
local nodedist
local gonode
foreach (node, loc in mapnodes) {
nodedist = AITile.GetDistanceManhattanToTile(AITown.GetLocation(target),loc)
if (nodedist < condist) {
condist = nodedist;
gonode = loc;
}
}

if (gonode != null) {
local halfway = AIMap.GetTileIndex((AIMap.GetTileX(AITown.GetLocation(target)) + AIMap.GetTileX(gonode)) / 2, (AIMap.GetTileY(AITown.GetLocation(target)) + AIMap.GetTileY(gonode)) / 2);
//AISign.BuildSign(halfway, "Ha!")
a = [halfway]
b = [gonode]
BuildARoad(a,b,target,200)
a = [halfway]
b = [AITown.GetLocation(target)]
BuildARoad(a,b,target,200)
}

a = [AITown.GetLocation(target)]
b = mapnodes
BuildARoad(a,b,target,200)

} else {
AILog.Info("I have connected all available towns to the road network.")
}
} // end zoop
else {
AILog.Info("I won't expand my network just yet.")
}

// load the list of known connected towns for the review
local townlist = AIList();
townlist.AddList(Cachedtowns);

local rc = 0;
local ThisMonth = AIDate.GetMonth(AIDate.GetCurrentDate());
local ReviewMonth = AIDate.GetMonth(AIDate.GetCurrentDate());

while ((rc < ((townlist.Count() / 4) + 1)) && (ThisMonth == ReviewMonth)) { 
local revdist = 1000000;
local x = 0
local sstowna
local sstownb

while ((revdist > 128) && (x < 100)) { // was ((NetworkRadius / 2) + 64)
townlist.Valuate(AIBase.RandItem); // shuffle the town list
sstowna = townlist.Begin();
sstownb = townlist.Next();
a = [AITown.GetLocation(sstowna)]
b = [AITown.GetLocation(sstownb)]
revdist = AITile.GetDistanceManhattanToTile(a[0],b[0])
x++
}
BuildARoad(a,b,-1,500)
rc++
ThisMonth = AIDate.GetMonth(AIDate.GetCurrentDate());
}
return;
}

// ====================================================== 
//                  BUILD ROAD CONNECTION
// ====================================================== 

function CivilAI::BuildARoad(a,b,target,bs) {

local buildroad = RoadPF();
buildroad.cost.max_cost 			= 50000000;   //10000000;
buildroad.cost.tile     			= 100;        // 100;
buildroad.cost.no_existing_road		= 300;        //40;
buildroad.cost.turn           		= 200;        //100;
buildroad.cost.slope          		= 800;        //200;
buildroad.cost.bridge_per_tile		= 600;        //150;
buildroad.cost.tunnel_per_tile		= 300;        //120;
buildroad.cost.coast       			= 500;        //20;
buildroad.cost.max_bridge_length	= 60;          //10; !!!!!
buildroad.cost.max_tunnel_length	= 20;          //20;
buildroad.cost.bus_stop				= bs;

if (target != -1) {
// check funds allow for the connection, and a bit left over to maintain the network
// as of 1.6 we only do this check for building new links, because we want to always check eg after building bridges
local condist = NetworkRadius
local nodedist
foreach (node, loc in b) {
nodedist = AITile.GetDistanceManhattanToTile(a[0],loc)
if (nodedist < condist) {
condist = nodedist;
}
}

local dosh = AICompany.GetBankBalance(Me);
if ((dosh) < (AIRoad.GetBuildCost(AIRoad.ROADTYPE_ROAD, AIRoad.BT_ROAD) * 2 * condist)) {
if (target != -1) {
AILog.Info("I can't afford to build a road to " + AITown.GetName(target)  + " right now. Perhaps later.")
}

return;
}	
AILog.Info("I'm connecting " + AITown.GetName(target) + " to the road network (" + condist + ").")
Recache = true;



} else {
//AILog.Info("I'm reviewing the roads between " + AITown.GetName(AITile.GetClosestTown(a[0])) + " and " + AITown.GetName(AITile.GetClosestTown(b[0])) + ".")
}

buildroad.InitializePath(a, b);

local i = 0;
local maxtime = NetworkRadius * 3;
local percount = 0;
local path = false;
while (path == false) {
  path = buildroad.FindPath(50);
  AIController.Sleep(1);
  
i++
if (((i * 10) / maxtime) > percount) {percount++; AILog.Info(percount * 10 + "%");}
   if (i > maxtime) {
   AILog.Info("I couldn't find a path.")
   break;  
}
}

if (path == false) {
if (target != -1) {
Dudtowns.AddItem(target,0) // add this town to a list of unreachables
AILog.Info(AITown.GetName(target) + " seems to be unreachable.")
}
return;
}

local c = 0


while (path != null) {
  local par = path.GetParent();
  if (par != null) {
    local last_node = path.GetTile();
    if (AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) == 1 ) {
      if ((!AIRoad.BuildRoad(path.GetTile(), par.GetTile())) && c < 10) {
			/* An error occured while building a road. TODO: handle it. */
      }
    } else {
      /* Build a bridge or tunnel. */
      if (!AIBridge.IsBridgeTile(path.GetTile()) && !AITunnel.IsTunnelTile(path.GetTile())) {
        /* If it was a road tile, demolish it first. Do this to work around expended roadbits. */
        if (AIRoad.IsRoadTile(path.GetTile())) AITile.DemolishTile(path.GetTile());
        if (AITunnel.GetOtherTunnelEnd(path.GetTile()) == par.GetTile()) {
          if (!AITunnel.BuildTunnel(AIVehicle.VT_ROAD, path.GetTile())) {
            /* An error occured while building a tunnel. TODO: handle it. */
          }
        } else {
          local bridge_list = AIBridgeList_Length(AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) + 1);
          bridge_list.Valuate(AIBridge.GetMaxSpeed);
          bridge_list.Sort(AIList.SORT_BY_VALUE, false);
          if (!AIBridge.BuildBridge(AIVehicle.VT_ROAD, bridge_list.Begin(), path.GetTile(), par.GetTile())) {
            /* An error occured while building a bridge. TODO: handle it. */
          }
        }
      }
    }
  }
  path = par;
}
//AILog.Info("I've finished road building for now.")

return
}

// ====================================================== 
//    FIND LEVEL XINGS TO REPLACE
// ====================================================== 

function CivilAI::XingReplace() {

while (AIEventController.IsEventWaiting()){
local event = AIEventController.GetNextEvent();

if (event.GetEventType() == AIEvent.ET_VEHICLE_CRASHED) {
	local crash = AIEventVehicleCrashed.Convert(event);
		if (crash.GetCrashReason() == AIEventVehicleCrashed.CRASH_RV_LEVEL_CROSSING) {
			local xing = crash.GetCrashSite();
			local xg = [AIMap.GetTileX(xing),AIMap.GetTileY(xing)]			
			AILog.Info("One of our vehicles got squished at " + xg[0] + "," + xg[1] + ". I'll try and remove the crossing..."); 

if (AIRail.GetRailTracks(xing) == AIRail.RAILTRACK_NE_SW) {
XRem(0, xing);
} else {
XRem(1, xing);
}
}
}
}
//AILog.Info("Finished crossing removal.")
}

function CivilAI::XRem(orientation, xing) {
	local xof = 0;
	local yof = 0;
	if (orientation == 0) {yof = 1;} else {xof = 1;}
	local xg = [AIMap.GetTileX(xing),AIMap.GetTileY(xing)]

// find the road tiles either side of the crossing
local tile1 = null;
local tile2 = null;

local c = 0;
local testtile;
while (tile1 == null) {
c++;
testtile = AIMap.GetTileIndex(xg[0] - (xof * c), xg[1] - (yof * c));
//AISign.BuildSign(testtile, "1?");
			if (!AIRail.IsLevelCrossingTile(testtile)) {
				tile1 = testtile;
				xg = [AIMap.GetTileX(tile1),AIMap.GetTileY(tile1)];
			}
}

// check that the tile has road and belongs to us
if (!AIRoad.IsRoadTile(tile1)) {
AILog.Info("but it doesn't seem to be a connected level crossing."); return false;
} else if ((AITile.GetOwner(tile1) != Me) && (AITile.GetOwner(tile1) != AICompany.COMPANY_INVALID)) {
AILog.Info("but it's not my road."); return false;
} else if (AIRoad.AreRoadTilesConnected(tile1, 
										AIMap.GetTileIndex(xg[0] + yof, xg[1] + xof)) ||
		   AIRoad.AreRoadTilesConnected(tile1, 
										AIMap.GetTileIndex(xg[0] - yof, xg[1] - xof))							
		 ) {
AILog.Info("but it's not a straight approach."); return false;
}
// we have our start tile

//AISign.BuildSign(tile1, "1!");


// now, find the tile across the crossing



c = 0;
while (tile2 == null) {
c++;
testtile = AIMap.GetTileIndex(xg[0] + (xof * c), xg[1] + (yof * c));
//AISign.BuildSign(testtile, "2?");
			if (!AIRail.IsLevelCrossingTile(testtile)) {
				tile2 = testtile;
				xg = [AIMap.GetTileX(tile2),AIMap.GetTileY(tile2)];
			}
}
// check that the tile has road and belongs to us
if (!AIRoad.IsRoadTile(tile2)) {
AILog.Info("but it doesn't seem to be a connected level crossing - perhaps I already replaced it."); return false;
} else if ((AITile.GetOwner(tile1) != Me) && (AITile.GetOwner(tile1) != AICompany.COMPANY_INVALID)) {
AILog.Info("but it's not my road."); return false;
} else if (AIRoad.AreRoadTilesConnected(tile2, 
										AIMap.GetTileIndex(xg[0] + yof, xg[1] + xof)) ||
		   AIRoad.AreRoadTilesConnected(tile2, 
										AIMap.GetTileIndex(xg[0] - yof, xg[1] - xof))							
		 ) {
AILog.Info("but it's not a straight approach."); return false;
}
// we have our end tile

//AISign.BuildSign(tile2, "2!");
xg = [AIMap.GetTileX(tile1),AIMap.GetTileY(tile1)];

// check slopes
local tunnel1 = false;
local tunnel2 = false;

if (xof == 1) {
if (AITile.GetSlope(tile1) == AITile.SLOPE_SW) {tunnel1 = true};
if (AITile.GetSlope(tile2) == AITile.SLOPE_NE) {tunnel2 = true};
} else {
if (AITile.GetSlope(tile1) == AITile.SLOPE_SE) {tunnel1 = true};
if (AITile.GetSlope(tile2) == AITile.SLOPE_NW) {tunnel2 = true};
}
if (tunnel1 != tunnel2) {AILog.Info("but the slopes don't match."); return false;}

// all is good - clear the roads.

local d = 0;

while (d < 100) {
//AILog.Info("Clearing tile (" + d + "/100).")
if (AITile.DemolishTile(tile1)) {
break;
}
AIController.Sleep(3);
d++
}

if (d == 100) {AILog.Info("Something went wrong - perhaps the traffic was too heavy to clear the road."); AIRoad.BuildRoadFull(tile1, tile2);AIRoad.BuildRoadFull(tile2, tile1); return;}

xg = [AIMap.GetTileX(tile1),AIMap.GetTileY(tile1)]
local e = 1;
while (e < c + 1) { // c now = how many crossing tiles we have to remove (+1 for the other end). We remove one at a time to avoid stranding vehicles on the crossing.
d = 0;
while (d < 100) {
//AILog.Info("Clearing tile (" + d + "/100).")
//AISign.BuildSign(AIMap.GetTileIndex(xg[0] + (xof * e), xg[1] + (yof * e)), "v");
AIRoad.RemoveRoadFull(tile1, AIMap.GetTileIndex(xg[0] + (xof * e), xg[1] + (yof * e)))
if (!AIRoad.IsRoadTile(AIMap.GetTileIndex(xg[0] + (xof * e), xg[1] + (yof * e)))) {
e++
break;
}
AIController.Sleep(3);
d++
}
if (d == 100) {AILog.Info("Something went wrong - perhaps the traffic was too heavy to clear the road."); AIRoad.BuildRoadFull(tile1, tile2); AIRoad.BuildRoadFull(tile2, tile1);return;}
}

// build a bridge (or tunnel)
AITile.DemolishTile(tile1);
AITile.DemolishTile(tile2);

if (tunnel1) {
if (AITunnel.BuildTunnel(AIVehicle.VT_ROAD, tile1)) {AILog.Info("I replaced it with a tunnel.")} else {AILog.Info("Something went wrong."); AIRoad.BuildRoadFull(tile1, tile2); AIRoad.BuildRoadFull(tile2, tile1);return;}
} else {

local bridgelist = AIBridgeList_Length((AIMap.GetTileX(tile2) - AIMap.GetTileX(tile1)) + (AIMap.GetTileY(tile2) - AIMap.GetTileY(tile1)))
bridgelist.Valuate(AIBridge.GetMaxSpeed);
bridgelist.Sort(AIList.SORT_BY_VALUE, false);
local bridge = bridgelist.Begin();

if (AIBridge.BuildBridge(AIVehicle.VT_ROAD,bridge,tile1,tile2)) {AILog.Info("I replaced it with a bridge.")} else {AILog.Info("Something went wrong."); AIRoad.BuildRoadFull(tile1, tile2); AIRoad.BuildRoadFull(tile2, tile1);return;}
}
}
