
//>
// ====================================================== 
//                       SAVE/LOAD
// ====================================================== 

function CivilAI::Save() {
local Save = {
s0 = [],
s1 = [],
s2 = [],
s3 = [],
s4 = 0,
s5 = [],
slname = null,
sfname = null,
sBiasCheap = null,
sBiasFast = null,
sBiasBig = null
};

Save.s0 = CivilAI.ListToArray(Dudtowns);
Save.s1 = CivilAI.ListToArray(DudTerminus);
Save.s2 = CivilAI.ListToArray(DudIndustries);
Save.s3 = CivilAI.ListToArray(IndTownList);
Save.s4 = DudCounter;
Save.s5 = CivilAI.ListToArray(DudBusNetwork);
Save.slname = lname
Save.sfname = fname
Save.sBiasCheap = BiasCheap
Save.sBiasFast = BiasFast
Save.sBiasBig = BiasBig

AILog.Info("I've made a few notes (" + Dudtowns.Count() + " unreachable towns, " + DudIndustries.Count() + " unreachable industries)...");

return Save;
}  
function CivilAI::Load(version, data) {

if ("s0" in data) Dudtowns = ArrayToList(data.s0);
if ("s1" in data) DudTerminus = ArrayToList(data.s1);
if ("s2" in data) DudIndustries = ArrayToList(data.s2);
if ("s3" in data) IndTownList = ArrayToList(data.s3);
if ("s4" in data) DudCounter = data.s4;
if ("s5" in data) DudBusNetwork = ArrayToList(data.s5);

if ("slname" in data) {lname = data.slname;} else {lname = "Tycoon";}
if ("sfname" in data) {fname = data.sfname;} else {fname = "Transport";}
if ("sBiasCheap" in data) {BiasCheap = data.sBiasCheap;} else {BiasCheap = 10;}
if ("sBiasFast" in data) {BiasFast = data.sBiasFast;} else {BiasFast = 10;}
if ("sBiasBig" in data) {BiasBig = data.sBiasBig;} else {BiasBig = 10;}

AILog.Info(fname + " " + lname + " here - I've found my notes (" + Dudtowns.Count() + " unreachable towns, " + DudIndustries.Count() + " unreachable industries).");

IsLoaded = true;
}  

/**
 * Converts an AIList to an array.
 * @param list The AIList to be converted.
 * @return The converted array.
 * Thanks to Brumi/SimpleAI for this code.
 */
function CivilAI::ListToArray(list)
{
	local array = [];
	local templist = AIList();
	templist.AddList(list);
	while (templist.Count() > 0) {
		local arrayitem = [templist.Begin(), templist.GetValue(templist.Begin())];
		array.append(arrayitem);
		templist.RemoveTop(1);
	}
	return array;
}

/**
 * Converts an array to an AIList.
 * @param The array to be converted.
 * @return The converted AIList.
  * Thanks to Brumi/SimpleAI for this code.
 */
function CivilAI::ArrayToList(array)
{
	local list = AIList();
	local temparray = [];
	temparray.extend(array);
	while (temparray.len() > 0) {
		local arrayitem = temparray.pop();
		list.AddItem(arrayitem[0], arrayitem[1]);
	}
	return list;
}

// ====================================================== 
//                     LOAD PARAMETERS
// ====================================================== 

function CivilAI::LoadParas() {
NetworkRadius = AIController.GetSetting("NetworkRadius");
MinPop = AIController.GetSetting("MinPop");
MaxBus = AIController.GetSetting("MaxBus");
MaxCar = AIController.GetSetting("MaxCar");
BuyCar = 10 // (AIController.GetSetting("BuyCar") / 2);
MinAirRange = (AIController.GetSetting("MinAirRange"));
BuyPlane = 2 // (AIController.GetSetting("BuyPlane"));
TrainRange = (AIController.GetSetting("TrainRange"));
BrakeYear = (AIController.GetSetting("BrakeYear"));
ShipRange = (AIController.GetSetting("ShipRange"));
NoRoadNetwork = (AIController.GetSetting("NoRoadNetwork"));
}
  