
// ====================================================== 
//                   HOME TOWN SET UP
// ====================================================== 

function CivilAI::LocateHomeTown()
{
AILog.Info("Oh, hello...");

// find a town
local bigtown = null;
local townlist = AITownList();
townlist.Valuate(AITown.GetPopulation);
townlist.RemoveBelowValue(MinPop);

// remove unreachables
foreach (town,z in townlist) {
local towntile = AITown.GetLocation(town);
if (!AITile.HasTransportType(towntile,AITile.TRANSPORT_ROAD)) {
AILog.Info(AITown.GetName(town) + " has no central road tile.");
townlist.RemoveItem(town);
} else{
}
}

for(local c = 0; c < 15; c++) {
if ((AICompany.ResolveCompanyID(c) != AICompany.COMPANY_INVALID) && 
    (AICompany.GetCompanyHQ(c) != AIMap.TILE_INVALID)) {
AILog.Info("Hello to " + AICompany.GetPresidentName(c) + " in " + AITown.GetName(AITile.GetClosestTown(AICompany.GetCompanyHQ(c))) + "!");	
townlist.RemoveItem(AITile.GetClosestTown(AICompany.GetCompanyHQ(c))); // don't set up in the same town as other companies
}
}

townlist.Valuate(AIBase.RandItem); // shuffle the list

foreach (town,z in townlist) {
if (!((AITown.GetLastMonthSupplied(town, 0) * 15) > AITown.GetPopulation(town))) {
bigtown = town;
break;
}
}
	
if (bigtown == null) {	
// we'll do our best...
local townlist = AITownList();
townlist.Valuate(AITown.GetPopulation);
bigtown = townlist.Begin();
}	

//AILog.Info("First, I should probably name the company, and myself...");	
SetName(AITown.GetName(bigtown));
AILog.Info("I'll set up my headquarters in " + (AITown.GetName(bigtown)) + ".");	
BuildHQ(bigtown);
return
}

function CivilAI::SetName(HomeTownName)
{
local firstnamem = [0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7]
local firstnamef = [0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7]
local lastname = [0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7]

firstnamem[0] = ("Kenneth");
firstnamem[1] = ("Gordon");
firstnamem[2] = ("Jim");
firstnamem[3] = ("Ronald");
firstnamem[4] = ("Hubert");
firstnamem[5] = ("Alan");
firstnamem[6] = ("Edgar");
firstnamem[7] = ("Tony");
firstnamem[8] = ("Bertie");
firstnamem[9] = ("Rupert");
firstnamem[10] = ("Clive");
firstnamem[11] = ("Chris");
firstnamem[12] = ("Roger");
firstnamem[13] = ("George");
firstnamem[14] = ("Henry");
firstnamem[15] = ("Thomas");

firstnamef[0] = ("Florence");
firstnamef[1] = ("Alice");
firstnamef[2] = ("Sally");
firstnamef[3] = ("Gertrude");
firstnamef[4] = ("Victoria");
firstnamef[5] = ("Madge");
firstnamef[6] = ("Liz");
firstnamef[7] = ("Ronnie");
firstnamef[8] = ("Sharon");
firstnamef[9] = ("Delia");
firstnamef[10] = ("Mavis");
firstnamef[11] = ("Gladys");
firstnamef[12] = ("Sarah");
firstnamef[13] = ("Betty");
firstnamef[14] = ("Anne");
firstnamef[15] = ("Janet");

lastname[0] = ("Wideload");
lastname[1] = ("McBus");
lastname[2] = ("Honker");
lastname[3] = ("Smithe-Jonese");
lastname[4] = ("Bigglesworth");
lastname[5] = ("Speedy");
lastname[6] = ("Diesel");
lastname[7] = ("Mangosteen");

lastname[8] = ("Murphy");
lastname[9] = ("Argyle");
lastname[10] = ("Wheeler");
lastname[11] = ("Fox");
lastname[12] = ("Chutney");
lastname[13] = ("Onslow");
lastname[14] = ("Nock");
lastname[15] = ("Spriggs");

lastname[16] = ("Jinty");
lastname[17] = ("Pepper");
lastname[18] = ("Stevenson");
lastname[19] = ("Copperbottom");
lastname[20] = ("Smellie");
lastname[21] = ("Johnson");
lastname[22] = ("King");
lastname[23] = ("Boggs");

local setn = false;
while (setn == false) {
if (AICompany.GetPresidentGender(Me) == 0) {
fname = firstnamem[AIBase.RandRange(16)];
} else {
fname = firstnamef[AIBase.RandRange(16)];
}
lname = lastname[AIBase.RandRange(24)];

if (AICompany.SetPresidentName(fname + " " + lname)) {
setn = true;
}
}
// set company colour (1.9!) =================================================================
local darkblue = 0;
local palegreen = 1;
local pink = 2;
local yellow = 3;
local red = 4;
local lightblue = 5;
local green = 6;
local darkgreen = 7;
local blue = 8;
local cream = 9;
local mauve = 10;
local purple = 11;
local orange = 12;
local brown = 13;
local grey = 14;
local white = 15;
local ccs = [0, 1, 2, 3, 4, 5, 6, 7]

local dull = grey;
local blank = white;
local pop = orange;
local contrast = red;

// the default company colours are biased, we're going to select one truly randomly (and if it fails, stick with the default selected)
AICompany.SetPrimaryLiveryColour(0, AIBase.RandRange(16))
local cc = AICompany.GetPrimaryLiveryColour(0)

// DARK BLUE
if (cc == darkblue) {
blank = white; dull = grey; pop = orange; contrast = red;

} else if (cc == palegreen) {
blank = white; dull = yellow; pop = red; contrast = blue;

} else if (cc == pink) {
blank = pink; dull = grey; pop = purple; contrast = darkblue;

} else if (cc == yellow) {
blank = white; dull = grey; pop = yellow; contrast = blue;

} else if (cc == red) {
blank = white; dull = grey; pop = orange; contrast = darkblue;

} else if (cc == lightblue) {
blank = white; dull = mauve; pop = brown; contrast = orange;

} else if (cc == green) {
blank = white; dull = lightblue; pop = red; contrast = yellow;

} else if (cc == darkgreen) {
blank = white; dull = lightblue; pop = red; contrast = yellow;

} else if (cc == blue) {
blank = white; dull = cream; pop = yellow; contrast = red;

} else if (cc == cream) {
blank = white; dull = palegreen; pop = orange; contrast = darkblue;

} else if (cc == mauve) {
blank = pink; dull = grey; pop = red; contrast = blue;

} else if (cc == purple) {
blank = white; dull = grey; pop = orange; contrast = darkblue;

} else if (cc == orange) {
blank = white; dull = brown; pop = red; contrast = darkblue;

} else if (cc == brown) {
blank = yellow; dull = brown; pop = yellow; contrast = red;

} else if (cc == grey) {
blank = yellow; dull = green; pop = blue; contrast = red;

} else if (cc == white) {
blank = orange; dull = green; pop = blue; contrast = red;

}

// 2cc
ccs[0] = blank;
ccs[1] = dull;
ccs[2] = pop;
AICompany.SetSecondaryLiveryColour(0, ccs[AIBase.RandRange(3)]);

// locos
ccs[0] = blank;
ccs[1] = dull;
ccs[2] = pop;
ccs[3] = contrast;
ccs[4] = cc;
AICompany.SetSecondaryLiveryColour(1, ccs[AIBase.RandRange(5)]);
AICompany.SetSecondaryLiveryColour(2, ccs[AIBase.RandRange(5)]);
AICompany.SetSecondaryLiveryColour(3, ccs[AIBase.RandRange(5)]);

// freight wagons
ccs[0] = dull;
ccs[1] = cc;
ccs[2] = brown;
ccs[3] = pop;
AICompany.SetPrimaryLiveryColour(13, ccs[AIBase.RandRange(4)]);
AICompany.SetSecondaryLiveryColour(13, ccs[AIBase.RandRange(4)]);

// bus
ccs[0] = blank;
ccs[1] = pop;
ccs[2] = contrast;
ccs[4] = dull;
AICompany.SetSecondaryLiveryColour(14, ccs[AIBase.RandRange(4)]);
AICompany.SetSecondaryLiveryColour(21, ccs[AIBase.RandRange(4)]); // tram

// truck
ccs[0] = brown;
ccs[1] = pop;
ccs[2] = cream;
ccs[4] = dull;
AICompany.SetSecondaryLiveryColour(15, ccs[AIBase.RandRange(4)]);

// ships
AICompany.SetSecondaryLiveryColour(16, contrast);
AICompany.SetSecondaryLiveryColour(17, contrast);

// planes
ccs[0] = dull;
ccs[1] = pop;
ccs[2] = contrast;
ccs[4] = blank;
AICompany.SetSecondaryLiveryColour(18, ccs[AIBase.RandRange(4)]);
AICompany.SetSecondaryLiveryColour(19, ccs[AIBase.RandRange(4)]);
AICompany.SetSecondaryLiveryColour(20, ccs[AIBase.RandRange(4)]);

// coaches and MUs - 1/4 reversed
if (AIBase.RandRange(4) == 1) {
AICompany.SetSecondaryLiveryColour(6, AICompany.GetPrimaryLiveryColour(0));
AICompany.SetSecondaryLiveryColour(7, AICompany.GetPrimaryLiveryColour(0));
AICompany.SetSecondaryLiveryColour(8, AICompany.GetPrimaryLiveryColour(0));
AICompany.SetSecondaryLiveryColour(9, AICompany.GetPrimaryLiveryColour(0));
AICompany.SetSecondaryLiveryColour(10, AICompany.GetPrimaryLiveryColour(0));
AICompany.SetPrimaryLiveryColour(6, AICompany.GetSecondaryLiveryColour(0));
AICompany.SetPrimaryLiveryColour(7, AICompany.GetSecondaryLiveryColour(0));
AICompany.SetPrimaryLiveryColour(8, AICompany.GetSecondaryLiveryColour(0));
AICompany.SetPrimaryLiveryColour(9, AICompany.GetSecondaryLiveryColour(0));
AICompany.SetPrimaryLiveryColour(10, AICompany.GetSecondaryLiveryColour(0));
}

//buses - 1/4 reversed
if (AIBase.RandRange(4) == 1) {
AICompany.SetPrimaryLiveryColour(14, AICompany.GetSecondaryLiveryColour(14));
AICompany.SetSecondaryLiveryColour(14, AICompany.GetPrimaryLiveryColour(0));
}

//planes - 1/2 reversed
if (AIBase.RandRange(2) == 1) {
AICompany.SetPrimaryLiveryColour(19, AICompany.GetSecondaryLiveryColour(19));
AICompany.SetSecondaryLiveryColour(19, AICompany.GetPrimaryLiveryColour(0));
}

// set company name

local companynames = [0,1,2,3,4,5,6,7,8,9,10,11]

companynames[0] = (HomeTownName + " Garages");
companynames[1] = ("Transport for " + HomeTownName);
companynames[2] = (HomeTownName + " Engineering");
companynames[3] = (HomeTownName + " Transport");
companynames[4] = ("Buses by " + fname);
companynames[5] = (fname + "'s Charabanc");
companynames[6] = (HomeTownName + " Express");
companynames[7] = (lname + " & Co.");
companynames[8] = (lname + " Coaches");
companynames[9] = (lname + " Haulage");
companynames[10] = (HomeTownName + " Corporation");
companynames[11] = (lname + "'s");

local set = false;
while (set == false) {
if (AICompany.SetName(companynames[AIBase.RandRange(12)]))
{
set = true;
}
}

// Set biases

  BiasCheap = (1 + AIBase.RandRange(25));
  BiasFast =  (1 + AIBase.RandRange(25));
  BiasBig =   (1 + AIBase.RandRange(25));
AILog.Info ("My vehicle preferences are: Cheap " + BiasCheap + "; Fast " + BiasFast + "; Big " + BiasBig + ".");

return
}

// ====================================================== 
//                     BUILD HQ
// ====================================================== 

function CivilAI::BuildHQ(hometown)
{
// Let's (in)elegantly brute-force the HQ!

  local HomeTownGrid = [0,0];
  local HQ = 0;

local towntile = AITown.GetLocation(hometown);
HomeTownGrid[0] = AIMap.GetTileX(towntile);
HomeTownGrid[1] = AIMap.GetTileY(towntile);

local trytilegrid = [0,0]
local trytile = AIMap.GetTileIndex(trytilegrid[0],trytilegrid[1]);

// this is a cross search!

local i = 0; // iteration
local s = 3; // initial cross length
local j = AIBase.RandRange(2); // toggle x/y
local k = AIBase.RandRange(4); // toggle +/-

while (!AICompany.BuildCompanyHQ(trytile)) {

if (j == 0) {
	trytilegrid[1] = HomeTownGrid[1] + 2;
	if (k < 2) {
	trytilegrid[0] = (HomeTownGrid[0] + s);	
	} else {
    trytilegrid[0] = (HomeTownGrid[0] - s);
	}
} else {
	trytilegrid[0] = HomeTownGrid[0] + 2;
	if (k < 2) {
	trytilegrid[1] = (HomeTownGrid[1] + s);	
	} else {
    trytilegrid[1] = (HomeTownGrid[1] - s);	
	}
}

trytile = AIMap.GetTileIndex(trytilegrid[0],trytilegrid[1]);
// AISign.BuildSign(trytile, "I tried to build an HQ here");

if (j < 1) {
		j = j + 1;
		} else {
		j = 0;
		}
if (k < 3) {
		k = k + 1;
		} else {
		k = 0;
		}
if (i < 3) {
		i = i + 1;
		} else {
		i = 0;
		s = s + 5;
		}		

}
HQ = trytile;
AILog.Info("I've built an HQ at " + trytilegrid[0] + " ," + trytilegrid[1] + ". We're off to a good start!");	


BuildHomeDepot(HQ,hometown);

if (!AIGameSettings.IsDisabledVehicleType(AIVehicle.VT_ROAD)) {
BuildBuses(hometown,HomeDepot);
}

return;

}

// ====================================================== 
//                 PLACE HOME DEPOT
// ====================================================== 

function CivilAI::BuildHomeDepot(hq,hometown)
{
AILog.Info("I'll build my first depot as close to the HQ as possible.")

CashUp(); // take out maximum loan to start

// clockwise spiral out
local trytilegrid = [AIMap.GetTileX(hq),AIMap.GetTileY(hq)]
local trytile;
local x = 1
local y = 1
local i = 0
while ((HomeDepot == 0) && (i < 20)) {
//y--
for (;y >= 0-i;y--) {
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
//AISign.BuildSign(trytile, "?");
//AILog.Info("testing tile at " + x + "," + y);
if (AIRoad.HasRoadType(trytile,AIRoad.ROADTYPE_ROAD) 
&& !AIRoad.IsRoadDepotTile(trytile)
&& !AIRoad.IsRoadStationTile(trytile)
&& !AIRoad.IsDriveThroughRoadStationTile(trytile)
&& !AIBridge.IsBridgeTile(trytile)
&& !HomeDepot)
HomeDepot = BuildDepot(trytile,hometown);
}
//x--;
for (;x >= 0-i;x--) {
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
//AISign.BuildSign(trytile, "?");
//AILog.Info("testing tile at " + x + "," + y);
if (AIRoad.HasRoadType(trytile,AIRoad.ROADTYPE_ROAD) 
&& !AIRoad.IsRoadDepotTile(trytile)
&& !AIRoad.IsRoadStationTile(trytile)
&& !AIRoad.IsDriveThroughRoadStationTile(trytile)
&& !AIBridge.IsBridgeTile(trytile)
&& !HomeDepot)
HomeDepot = BuildDepot(trytile,hometown);
}
//y++;
for (;y <= i;y++) {
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
//AISign.BuildSign(trytile, "?");
//AILog.Info("testing tile at " + x + "," + y);
if (AIRoad.HasRoadType(trytile,AIRoad.ROADTYPE_ROAD)
&& !AIRoad.IsRoadDepotTile(trytile)
&& !AIRoad.IsRoadStationTile(trytile)
&& !AIRoad.IsDriveThroughRoadStationTile(trytile)
&& !AIBridge.IsBridgeTile(trytile)
&& !HomeDepot)
HomeDepot = BuildDepot(trytile,hometown);
}
//x++;
for (;x <= i;x++) {
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
//AISign.BuildSign(trytile, "?");
//AILog.Info("testing tile at " + x + "," + y);
if (AIRoad.HasRoadType(trytile,AIRoad.ROADTYPE_ROAD)
&& !AIRoad.IsRoadDepotTile(trytile)
&& !AIRoad.IsRoadStationTile(trytile)
&& !AIRoad.IsDriveThroughRoadStationTile(trytile)
&& !AIBridge.IsBridgeTile(trytile)
&& !HomeDepot)
HomeDepot = BuildDepot(trytile,hometown);
}
i=i+1
}

if (HomeDepot) {
AILog.Info("I've built my home depot at " + AIMap.GetTileX(HomeDepot) + "," + AIMap.GetTileY(HomeDepot) + "."); 
} else {
AILog.Info("I've failed to build a depot."); 
Failure();
}
return
}

// ====================================================== 
//             FIND HOME DEPOT (after load)
// ====================================================== 


function CivilAI::FindHomeDepot()
{
local hq = AICompany.GetCompanyHQ(Me);
if (hq != -1) {

AILog.Info("I'm looking for my home depot. It should be near my headquarters in " + AITown.GetName(AITile.GetClosestTown(hq)) + ".")

// clockwise spiral out
local trytilegrid = [AIMap.GetTileX(hq),AIMap.GetTileY(hq)]
local trytile;
local x = 1
local y = 1
local i = 0
while ((HomeDepot == 0) && (i < 20)) {
//y--
for (;y >= 0-i;y--) {
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);

if (AIRoad.IsRoadDepotTile(trytile)
	&& AICompany.IsMine(AITile.GetOwner(trytile))
	&& !HomeDepot)
	{
	HomeDepot = trytile;
	}
}
//x--;
for (;x >= 0-i;x--) {
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);


if (AIRoad.IsRoadDepotTile(trytile) 
	&& AICompany.IsMine(AITile.GetOwner(trytile))
	&& !HomeDepot)
	{
	HomeDepot = trytile;
	}
}
//y++;
for (;y <= i;y++) {
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);

if (AIRoad.IsRoadDepotTile(trytile)
	&& AICompany.IsMine(AITile.GetOwner(trytile))
	&& !HomeDepot)
	{
	HomeDepot = trytile;
	}
}
//x++;
for (;x <= i;x++) {
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);

if (AIRoad.IsRoadDepotTile(trytile)  
	&& AICompany.IsMine(AITile.GetOwner(trytile))
	&& !HomeDepot)
	{
	HomeDepot = trytile;
	}
}
i=i+1
}

if (HomeDepot) {
AILog.Info("I've found my home depot at " + AIMap.GetTileX(HomeDepot) + "," + AIMap.GetTileY(HomeDepot) + ".") 

if (AICompany.GetName(Me) == "Failed CivilAI") { SetName(AITown.GetName(AITile.GetClosestTown(hq))) } // resurrect formerly failed AI.

} else {
AILog.Info("I can't find my home depot."); 
Failure();
}
} else {
AILog.Info("I can't find my headquarters."); 
Failure();
}
return
}
// ====================================================== 
//            CHECK HOME DEPOT IS CONNECTED
// ====================================================== 
function CivilAI::HomeConnect() {

AILog.Info("I'm checking my home depot is still connected to the road network.");


// check all our depots are connected to the tile in front of them
local dlist = AIDepotList(AITile.TRANSPORT_ROAD); 	
foreach (depot, z in dlist) {
AIRoad.BuildRoad (AIRoad.GetRoadDepotFrontTile(depot),depot);
//AILog.Info("Checking immediate connection at depot " + depot)
}


local hq = AICompany.GetCompanyHQ(Me);
local a = [AIRoad.GetRoadDepotFrontTile(HomeDepot)]
local b = [AITown.GetLocation(AITile.GetClosestTown(hq))]

local buildroad = RoadPF();
buildroad.cost.max_cost 			= 10000000;   //10000000;
buildroad.cost.tile     			= 100;        // 100;
buildroad.cost.no_existing_road		= 75;         //40;
buildroad.cost.turn           		= 100;        //100;
buildroad.cost.slope          		= 400;        //200;
buildroad.cost.bridge_per_tile		= 500;        //150;
buildroad.cost.tunnel_per_tile		= 900;        //120;
buildroad.cost.coast       			= 100;        //20;
buildroad.cost.max_bridge_length	= 10;          //10;
buildroad.cost.max_tunnel_length	= 20;          //20;

buildroad.InitializePath(a, b);

local path = false;
while (path == false) {
  path = buildroad.FindPath(50);
  AIController.Sleep(1);
}


if (path == null) {
AILog.Info("It isn't.")
Failure();
return
}
while (path != null) {
  local par = path.GetParent();
  if (par != null) {
    local last_node = path.GetTile();
    if (AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) == 1 ) {
      if (!AIRoad.BuildRoad(path.GetTile(), par.GetTile())) {
        /* An error occurred while building a piece of road. TODO: handle it. 
         * Note that this could mean the road was already built. */
      }
    } else {
      /* Build a bridge or tunnel. */
      if (!AIBridge.IsBridgeTile(path.GetTile()) && !AITunnel.IsTunnelTile(path.GetTile())) {
        /* If it was a road tile, demolish it first. Do this to work around expended roadbits. */
        if (AIRoad.IsRoadTile(path.GetTile())) AITile.DemolishTile(path.GetTile());
        if (AITunnel.GetOtherTunnelEnd(path.GetTile()) == par.GetTile()) {
          if (!AITunnel.BuildTunnel(AIVehicle.VT_ROAD, path.GetTile())) {
            /* An error occured while building a tunnel. TODO: handle it. */
          }
        } else {
          local bridge_list = AIBridgeList_Length(AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) + 1);
          bridge_list.Valuate(AIBridge.GetMaxSpeed);
          bridge_list.Sort(AIList.SORT_BY_VALUE, false);
          if (!AIBridge.BuildBridge(AIVehicle.VT_ROAD, bridge_list.Begin(), path.GetTile(), par.GetTile())) {
            /* An error occured while building a bridge. TODO: handle it. */
          }
        }
      }
    }
  }
  path = par;
}
AILog.Info("It's fine.")

}


// ====================================================== 
//            		 Group Management
// ====================================================== 

function CivilAI::MakeGroups() {

Groups[0] = AIGroup.CreateGroup(AIVehicle.VT_ROAD, AIGroup.GROUP_INVALID);
Groups[1] = AIGroup.CreateGroup(AIVehicle.VT_ROAD, AIGroup.GROUP_INVALID);
Groups[2] = AIGroup.CreateGroup(AIVehicle.VT_ROAD, AIGroup.GROUP_INVALID);
Groups[3] = AIGroup.CreateGroup(AIVehicle.VT_ROAD, AIGroup.GROUP_INVALID);

if (AIGroup.SetName(Groups[0], "Buses")) {} else { AIGroup.SetName(Groups[0], "Buses " + Me ) }
if (AIGroup.SetName(Groups[1], "Cars")) {} else { AIGroup.SetName(Groups[1], "Cars " + Me ) }
if (AIGroup.SetName(Groups[2], "Mail")) {} else { AIGroup.SetName(Groups[2], "Mail " + Me ) }
if (AIGroup.SetName(Groups[3], "Goods")) {} else { AIGroup.SetName(Groups[3], "Goods " + Me ) }
}

function CivilAI::LoadGroups() {

local glist = AIGroupList();
foreach (group,z in glist) {

	 if (AIGroup.GetName(group) == "Buses" || AIGroup.GetName(group) == "Buses " + Me) { Groups[0] = group; } 
else if (AIGroup.GetName(group) == "Cars" || AIGroup.GetName(group) == "Cars " + Me) { Groups[1] = group; } 
else if (AIGroup.GetName(group) == "Mail" || AIGroup.GetName(group) == "Mail " + Me) { Groups[2] = group; } 
else if (AIGroup.GetName(group) == "Goods" || AIGroup.GetName(group) == "Goods " + Me) { Groups[3] = group; } 
}
}