// ====================================================== 
// ====================================================== 
// 			  TTTTT RRRR     A    I  N   N
// 			    T   R   R   A A   I  NN  N
// 			    T   R  R   A   A  I  N N N
//  		    T   RRRR   AAAAA  I  N  NN
//  		    T   R   R  A   A  I  N   N
// ===========================================ChooChoo!== 
// ====================================================== 

function CivilAI::ChooChoo() {

if (AIGameSettings.IsDisabledVehicleType(AIVehicle.VT_RAIL)) {
AILog.Info("I'm not allowed to build trains, boo.");
return; // no trains for us
}


AILog.Info("I'm thinking about freight trains...");
// =================================================================
// review existing trains
// =================================================================


local trainlist = AIVehicleList();
foreach (v, z in trainlist) {
if (AIVehicle.GetVehicleType(v) != AIVehicle.VT_RAIL) {
trainlist.RemoveItem(v);
}
}

// trains getting old
foreach (v, z in trainlist) {
if  ((AIVehicle.GetAgeLeft(v) < (365 * 2)) && !(AIOrder.IsGotoDepotOrder(v, 0)) && AIVehicle.IsValidVehicle(v)) {

AILog.Info(AIVehicle.GetName(v) + " is getting old")

// replace the train before sending it to the depot
local dosh = AICompany.GetBankBalance(Me);
local dest = AIStation.GetStationID(AIOrder.GetOrderDestination(v, 1));
local src = AIStation.GetStationID(AIOrder.GetOrderDestination(v, 0));
local cargo = 0;
local clist = AICargoList();
foreach (c, z in clist) {
if (AIVehicle.GetCapacity(v, c) > 0) {
cargo = c;
}
}


local depot;
local dorder = null;
if (AIOrder.IsGotoWaypointOrder(v, 2)) {dorder = AIOrder.GetOrderDestination(v, 2);}

depot = FindTrainDepot(dest);

if (dosh > BuyATrain(dest, src, cargo, depot, 3, true, null) && AIRail.IsRailDepotTile(depot)) {

//AILog.Info(AIBaseStation.GetName(dest) + ", " + AIBaseStation.GetName(src)  + ", " + cargo + ", " + AIMap.GetTileX(depot) + ", " + AIMap.GetTileY(depot) )
BuyATrain(dest, src, cargo, depot, 3, false, dorder);
AIOrder.RemoveOrder(v, 2); // remove gotowaypoint
AIOrder.InsertOrder(v,0,depot,(AIOrder.OF_STOP_IN_DEPOT));
AIOrder.SkipToOrder(v,0);
//AILog.Info("I replaced it.")
} else {
AILog.Info("I can't afford to replace it (or something went wrong).")
}
}
}

// trains losing money
foreach (v, z in trainlist) {

local dest = AIStation.GetStationID(AIOrder.GetOrderDestination(v, 1));
local depot;
depot = FindTrainDepot(dest);

if  ((AIVehicle.GetProfitLastYear(v) < 0) &&
	(AIVehicle.GetProfitThisYear(v) < 0) &&
   !(AIOrder.IsGotoDepotOrder(v, 0)) &&
	(AIVehicle.GetAge(v) > (365)) &&
	 (AIVehicle.GetAgeLeft(v) > (365 * 1))) {
AIOrder.RemoveOrder(v, 2); // remove gotowaypoint
AIOrder.InsertOrder(v,0,depot,(AIOrder.OF_STOP_IN_DEPOT));
AIOrder.SkipToOrder(v,0);
	AILog.Info(AIVehicle.GetName(v) + " is losing money, so I'm sending it to the depot.")	
	}
}

// =================================================================
// BUILD NEW TRAINS :D
// =================================================================

CargoLine();

}


// ==========================================
// Buy a Train! Choo Choo!
// ==========================================
 function CivilAI::BuyATrain(a, b, cargo, depot, tlen, costing, dorder) {
 
if (!AIRail.IsRailDepotTile(depot) && !costing) {return null;} // no depot, oops
 
  // first, pick a loco
  
local routelength;
local climb;
local loco;
local train;
local dosh;

local ft;
if (AIGameSettings.IsValid("vehicle.freight_trains")) {
ft = AIGameSettings.GetValue("vehicle.freight_trains");
} else { ft = 1;}
 
 if (a == 0) { // no route, we're just costing an approximate vehicle
 routelength = TrainRange;
 climb = 20;
 } else {
 routelength = AIMap.DistanceManhattan(AIBaseStation.GetLocation(a), AIBaseStation.GetLocation(b));
 climb = HillClimb;
 }
 
 loco = PickFreightLoco(routelength, climb);
 
 if (loco == null) {return 1000000000;} // couldn't find a loco so return a huge value
else { dosh = AIEngine.GetPrice(loco);}

if (!costing) {
//AILog.Info("I picked " + AIEngine.GetName(loco) + " as my locomotive.");
train = AIVehicle.BuildVehicle(depot, loco);
}

// pick wogans

local woganlist = AIEngineList(AIVehicle.VT_RAIL);
foreach (w, z in woganlist) {
//AILog.Info("Assessing " + AIEngine.GetName(w));
 
 if (
 AIEngine.GetCapacity(w) == 0
 || AIEngine.GetPower(w) > 0 
 || ((AIEngine.GetMaxSpeed(w) < 64) && (AIEngine.GetMaxSpeed(w) != 0)) // these are our minimum standards  
 || !AIEngine.CanRunOnRail(w, 0)
 || !AIEngine.CanRefitCargo(w, cargo)
 )
 {woganlist.RemoveItem(w)} // no locos, unrefits or non-rail vehicles
 }
 if (woganlist.Count() == 0) {
AILog.Info("I couldn't find any suitable wagons.");
dosh = 1000000000;
return (dosh);
} else {

local unit;
local exemplar;
local randomwogans;
local newwogan;
local unitlist = AIList();
unitlist.AddList(woganlist);

 if (
 (AICargo.HasCargoClass(cargo, AICargo.CC_BULK)
 || AICargo.HasCargoClass(cargo, AICargo.CC_LIQUID))
 && !AICargo.HasCargoClass(cargo, AICargo.CC_PIECE_GOODS)
 ) {
  // unit train for bulk, liquid
  
  // prefer native vehicles
 foreach (w, z in unitlist) {
 if (AIEngine.GetCargoType(w) != cargo) {
 unitlist.RemoveItem(w);
 }
 } 
 if (unitlist.Count() > 0) {
  unitlist.Valuate(AIEngine.GetCapacity);
  unitlist.Sort(AIList.SORT_BY_VALUE, false);
  unit = unitlist.Begin();
 } else {
  woganlist.Valuate(AIEngine.GetCapacity);
  woganlist.Sort(AIList.SORT_BY_VALUE, false);
  unit = woganlist.Begin();
  }  
  
  exemplar = unit;  
  
 } else {
 // randomwogans for piece goods
 randomwogans = true;
 
 // find our exemplar wagon (highest capacity)
  // prefer native vehicles
 foreach (w, z in unitlist) {
 if (AIEngine.GetCargoType(w) != cargo) {
 unitlist.RemoveItem(w);
 }
 } 
 if (unitlist.Count() > 0) {
  unitlist.Valuate(AIEngine.GetCapacity);
  unitlist.Sort(AIList.SORT_BY_VALUE, false);
  exemplar = unitlist.Begin();
 } else {
  woganlist.Valuate(AIEngine.GetCapacity);
  woganlist.Sort(AIList.SORT_BY_VALUE, false);
  exemplar = woganlist.Begin();
  }   
 
 // now remove vehicles which aren't up to spec (no more than 10mph slower than the exemplar, or at least as fast as the loco)
 
//AILog.Info("I picked " + AIEngine.GetName(exemplar) + " as my ideal wagon.");
 
 foreach (w, z in woganlist) {
 if ((AIEngine.GetMaxSpeed(w) < (AIEngine.GetMaxSpeed(exemplar) - 16)) && (AIEngine.GetMaxSpeed(w) < AIEngine.GetMaxSpeed(loco))) {
 woganlist.RemoveItem(w);
// AILog.Info("I discarded " + AIEngine.GetName(w) + " as too slow.");
 }
 }
  
  if (costing) { 
  woganlist.Valuate(AIEngine.GetPrice); // choose most expensive for costing
 unit = woganlist.Begin();
 }
 }
 
 
 
			if (costing) { 
				dosh = dosh + (AIEngine.GetPrice(unit) * 6);
				return (dosh);  
			}

// buy a brakevan?

local vanid = null;

if ((AIDate.GetYear(AIDate.GetCurrentDate()) < BrakeYear) && !costing) {
//AILog.Info("It's the year of the Brakevan!");

local woganlist = AIEngineList(AIVehicle.VT_RAIL);
foreach (w, z in woganlist) {
//AILog.Info("Assessing " + AIEngine.GetName(w));
 
 if (
 AIEngine.GetCapacity(w) > 0
 || AIEngine.GetPower(w) > 0 
 || ((AIEngine.GetMaxSpeed(w) < AIEngine.GetMaxSpeed(exemplar)) && (AIEngine.GetMaxSpeed(w) != 0)) // brakevan must be at least as fast as the exemplar
 || !AIEngine.CanRunOnRail(w, 0)
 )
 {woganlist.RemoveItem(w)} // no locos, unrefits or non-rail vehicles
 }
 if (woganlist.Count() > 0) {

 woganlist.Valuate(AIEngine.GetWeight); // choose the lightest, on the grounds that it's probably also the shortest.
 woganlist.Sort(AIList.SORT_BY_VALUE, true);
 vanid = woganlist.Begin(); 


//AILog.Info("Brake Van " + AIEngine.GetName(vanid));
  newwogan = AIVehicle.BuildVehicle(depot, vanid); 
  AIVehicle.MoveWagon(newwogan, 0, train, AIVehicle.GetNumWagons(train)-1);
}			
}			
			
			
			
			
  
 
local maxcargo = (AIEngine.GetPower(loco) / (ft * 2));
//AILog.Info("Maximum cargo weight is " + maxcargo + "t.")  

while (
(AIVehicle.GetLength(train) < (16 * tlen) + 1) &&
(AIVehicle.GetCapacity(train,cargo) < maxcargo + 30)
	) {
if (randomwogans) {
 woganlist.Valuate(AIBase.RandItem); // shuffle the list
 unit = woganlist.Begin();
}


 if (AIEngine.GetPrice(unit) > AICompany.GetBankBalance(Me)) {break;}
 
  
  newwogan = AIVehicle.BuildVehicle(depot, unit);
  AIVehicle.RefitVehicle(newwogan, cargo);  
  AIVehicle.MoveWagon(newwogan, 0, train, AIVehicle.GetNumWagons(train)-1);
}
AIVehicle.SellWagon(train, AIVehicle.GetNumWagons(train)-1) // build overlength and sell the last wagon


if (vanid != null) {
local bvmove = false;
local bvc = 1;
while (!bvmove && (bvc < 5)) {
bvmove = AIVehicle.MoveWagon(train, bvc, train, AIVehicle.GetNumWagons(train)-1); // move the brakevan to the back
bvc++;
}
}

if(!AIVehicle.IsValidVehicle(train)) {return;} // oops, we sold the loco
 
// give the orders and start the train!

AIOrder.AppendOrder(train,AIBaseStation.GetLocation(b),(AIOrder.OF_NON_STOP_INTERMEDIATE + AIOrder.OF_FULL_LOAD_ANY));
AIOrder.AppendOrder(train,AIBaseStation.GetLocation(a),(AIOrder.OF_NON_STOP_INTERMEDIATE + AIOrder.OF_NO_LOAD));
if (dorder != null) { // we have a waypoint
AIOrder.AppendOrder(train,dorder,(AIOrder.OF_NON_STOP_INTERMEDIATE));
}

local darkblue = 0;
local palegreen = 1;
local pink = 2;
local yellow = 3;
local red = 4;
local lightblue = 5;
local green = 6;
local darkgreen = 7;
local blue = 8;
local cream = 9;
local mauve = 10;
local purple = 11;
local orange = 12;
local brown = 13;
local grey = 14;
local white = 15;

local cc = AICompany.GetPrimaryLiveryColour(0); 

local cname = ["Bluebell", "Lightning", "Thomas", "Royal Blue"]
if (cc == pink || cc == cream) { cname = ["Pinky", "Perky", "Salmon", "Eagle"] }
if (cc == yellow) { cname = ["Banana", "Mellow Yellow", "Flying Banana", "Custard"] }
if (cc == red) { cname = ["Scarlet", "Little Red", "Crimson Lake", "Viking"] }
if (cc == green || cc == darkgreen || cc == palegreen) { cname = ["Greengrass", "Percy", "Apple", "Flying Cucumber"] }
if (cc == purple || cc == mauve) { cname = ["Pinky", "Pruplethingz", "Cyclops", "Royal Purple"] }
if (cc == orange) { cname = ["Juicy", "Wildcard", "Naranja", "Big O"] }
if (cc == brown) { cname = ["Bomber", "Bomber", "Richard", "Bull"] }
if (cc == grey || cc == white) { cname = ["Ghost", "Spectre", "Ghost", "Knight"] }

local trainnames = [
"Monty", "Horace", "Apollo", "Mercury", "Vulcan", 
"Cupid", "Sooty", "George", "Comet", "Ajax", 
"Samson", "Giant", "Felix", "Puffer", "Romeo",
AICompany.GetPresidentName(Me), "Hercules", "Amazon", "Atlas", "Rocket", 
cname[0], cname[1], cname[2], cname[3]]

local nx = 0
local name = null
local changename = false
local trainname = trainnames[AIBase.RandRange(24)]

while (!changename && AIVehicle.IsValidVehicle(train)) {
nx++ 
if (nx < 2) {
name = (trainname)
} else {
name = (trainname + " " + nx)
}
changename = AIVehicle.SetName(train,name)
}

AILog.Info("I bought a " + AIEngine.GetName(loco) + " named " + AIVehicle.GetName(train) +".");

AIVehicle.StartStopVehicle(train); // choo choo!
}
}

