//
//CIVIL AI v19
//
//
//AI for OpenTTD
//© 2014-2020 David Dallaston (PikkaBird)
//
//Turn back, before it's too late.
//


import("Pathfinder.CRoad", "RoadPF", 4);
import("Pathfinder.Rail", "RailPF", 1);

class CivilAI extends AIController
{
// vv!
  
  // === global vars
  Groups = [0,0,0,0];
  LCounter = 0;  
  HomeDepot = 0;
  IsLoaded = false;
  Dudtowns = AIList();
  NetworkRadius = null;
  MinPop = null;
  MaxBus = null;
  MaxCar = null;
  BuyCar = null;
  MinAirRange = null;
  BuyPlane = null;
  TrainRange = null;
  BrakeYear = null;
  ShipRange = null;
  
  Cachedtowns = AIList();
  Recache = true;
  
  BackTrackCounter = 0;
  PassingPlace = null;
  HillClimb = 0;
  CycleCount = 0;
  
  fname = null;
  lname = null;
  
  AltMethod = false;
  NoRoadNetwork = false;
  
 // === cargo plan elements
  
  PlanDestination = null;
  PlanSource = null;  
  
  DudIndustries = AIList();
  DudTerminus = AIList();
  IndTownList = AIList();
  DudBusNetwork = AIList();
  DudCounter = 0;
  
  // === Character Biases
  
  BiasCheap = 10;
  BiasFast = 10;
  BiasBig = 10;
  
  Me = (AICompany.ResolveCompanyID(AICompany.COMPANY_SELF));
}


require("setup.nut");
require("saveload.nut");
require("bits.nut");

require("road.nut");
require("rail.nut");
require("rail2.nut");
require("towncars.nut");

require("bus.nut");
require("rv.nut");
require("air.nut");
require("ship.nut");
require("train.nut");
require("train2.nut");

require("buyvehicle.nut")



// ====================================================== 
//                         START
// ====================================================== 
  
function CivilAI::Start()
{

// Startup parameters:
AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_ROAD);
AICompany.SetAutoRenewStatus(false); // we don't do autorenew
AIRail.SetCurrentRailType(0); // let's assume this is standard rail

 
 

LoadParas();
CashUp();

if (!IsLoaded) {
MakeGroups();
LocateHomeTown();
} else {
LoadGroups();
}

MainLoop();

}

// ====================================================== 
//                      MAIN LOOP
// ====================================================== 

function CivilAI::MainLoop() 
{

if (AIGameSettings.IsDisabledVehicleType(AIVehicle.VT_ROAD)) { // use alt mode if no road vehicle construction allowed
AILog.Info("Road vehicle construction is not allowed - using alternative network method.");
AltMethod = true;
}
if (NoRoadNetwork) {AILog.Info("Inter-city road building has been disabled.")}


if (IsLoaded) {
AILog.Info("Welcome back!");
FindHomeDepot();
} else {

AILog.Info("Now that I have introduced myself, I should like to have some idea of what is going on...");
}

local dosh;
while (true) {

LoopCounter();

LoadParas();

dosh = AICompany.GetBankBalance(Me);
if (dosh > (AICompany.GetMaxLoanAmount() * 2)) {
CashDown(); // pay off our loan when we're rich, just for the points.
} else {		
CashUp(); 	// Retake loan, just in case inflation is on
}
	HomeConnect();					// Check Home Depot
	CacheTownList(); 				// Recache town list
	DepotClean();					// Clear Depots
	RailCleanUp();					// Remove unused rail tracks
	
if (!AltMethod) {	
	TruckOps();						// Add some trucks
	BusReview();					// Bus Review
	BigCityDepots();				// build extra depots in large towns
	if (!NoRoadNetwork) {
	InterCity();		}			// Intercity
	CargoPlan();					// Find a goods/food source
	NewNetwork();					// New Bus Network
	Vroom();						// Town Cars
	XingReplace();					// Check for crashes	
	}

	ChooChoo();						// Build freight trains
	ChooChoo2();					// Build passenger trains
	Shipping();						// Build ships
	AirReview();					// Review Aircraft
	Airportz();						// Build Airports
	ManualService();				// Send low-reliability vehicles for servicing
	Statues();						// Build statues in towns
	TreeTime();						// Plant trees around towns which don't like us
	if (!NoRoadNetwork) {	
	MappaMundi();		}			// Roads - this is also when we tend to build up cash, so put the most important things at the top

}
}















