function CivilAI::RailCleanUp() {

// =================================================================
// clear up abandoned tracks
// =================================================================
// clear up unused waypoints

local wplist = AIWaypointList(AIWaypoint.WAYPOINT_RAIL);
foreach (wp, z in wplist) {
if (
AIWaypoint.GetWaypointID(AIMap.GetTileIndex(AIMap.GetTileX(AIBaseStation.GetLocation(wp)) + 1,  AIMap.GetTileY(AIBaseStation.GetLocation(wp)) + 0)) == wp ||
AIWaypoint.GetWaypointID(AIMap.GetTileIndex(AIMap.GetTileX(AIBaseStation.GetLocation(wp)) + 0,  AIMap.GetTileY(AIBaseStation.GetLocation(wp)) + 1)) == wp
){
// this is a trunk junction, so ignore it
} else {
local vls = AIVehicleList_Station(wp);
if (vls.Count() == 0) {

// waypoint (ie passing place) is unused, so remove it.

RemoveTracks(AIMap.GetTileIndex(AIMap.GetTileX(AIBaseStation.GetLocation(wp)) + 0,  AIMap.GetTileY(AIBaseStation.GetLocation(wp)) - 1), 0)
RemoveTracks(AIMap.GetTileIndex(AIMap.GetTileX(AIBaseStation.GetLocation(wp)) - 1,  AIMap.GetTileY(AIBaseStation.GetLocation(wp)) + 0), 1)
RemoveTracks(AIMap.GetTileIndex(AIMap.GetTileX(AIBaseStation.GetLocation(wp)) + 0,  AIMap.GetTileY(AIBaseStation.GetLocation(wp)) + 1), 2)
RemoveTracks(AIMap.GetTileIndex(AIMap.GetTileX(AIBaseStation.GetLocation(wp)) + 1,  AIMap.GetTileY(AIBaseStation.GetLocation(wp)) + 0), 3)
AITile.DemolishTile(AIBaseStation.GetLocation(wp));
}
}
}


// clear up unused stations

local tslist = AIStationList(AIStation.STATION_TRAIN); 
foreach (ts, z in tslist) {
local tlist = AIVehicleList_Station(ts);
if (tlist.Count() == 0) {
if (!AIStation.HasStationType(ts,AIStation.STATION_BUS_STOP)) {
// remove dest, depot and tracks

local depot = FindTrainDepot(ts);
if (AIRail.IsRailDepotTile(depot)) {
local dg = [AIMap.GetTileX(depot),AIMap.GetTileY(depot)]
if (AIRail.GetRailStationDirection(AIBaseStation.GetLocation(ts)) == AIRail.RAILTRACK_NW_SE) {
AITile.DemolishTile(AIMap.GetTileIndex(dg[0] + 1, dg[1] + 1));
AITile.DemolishTile(AIMap.GetTileIndex(dg[0] + 1, dg[1]));
AITile.DemolishTile(AIMap.GetTileIndex(dg[0] + 1, dg[1] - 1));
} else {
AITile.DemolishTile(AIMap.GetTileIndex(dg[0] + 1, dg[1] + 1));
AITile.DemolishTile(AIMap.GetTileIndex(dg[0], dg[1] +1));
AITile.DemolishTile(AIMap.GetTileIndex(dg[0] - 1, dg[1] + 1));
}
AITile.DemolishTile(depot);
AITile.DemolishTile(AIBaseStation.GetLocation(ts));
} else {


// remove supply and track

RemoveTracksFrom(ts);
AITile.DemolishTile(AIBaseStation.GetLocation(ts));
}
} else {
// remove passenger station

//TODO
}
}
}
}

// ===================
// identify industries we want to service

function CivilAI::ServeIndustries() {

local indtypes = AIIndustryTypeList();
local industries = AIIndustryList();
local indlist = AIList();

foreach (ind, z in indtypes) {
local cargos = AIIndustryType.GetProducedCargo(ind);

if (cargos.Count() > 0) {

local good = FindCargo("GOOD");
if (good != null) {
if (cargos.HasItem(good)) {
//AILog.Info (AIIndustryType.GetName(ind) + " is a valid industry (produces Goods).")

	industries = AIIndustryList();
	industries.Valuate(AIIndustry.GetIndustryType);
	industries.KeepValue(ind);
	indlist.AddList(industries);
}
}

local food = FindCargo("FOOD");
if (food != null) {
if (cargos.HasItem(food)) {
//AILog.Info (AIIndustryType.GetName(ind) + " is a valid industry (produces Food).")

	industries = AIIndustryList();
	industries.Valuate(AIIndustry.GetIndustryType);
	industries.KeepValue(ind);
	indlist.AddList(industries);
}
}

} else {
//AILog.Info (AIIndustryType.GetName(ind) + " is a valid industry (no production).")

	industries = AIIndustryList();
	industries.Valuate(AIIndustry.GetIndustryType);
	industries.KeepValue(ind);
	indlist.AddList(industries);

}
}

return indlist;

}


// ===================
// build freight line
function CivilAI::CargoLine() {

local dest = null;
local src = null;
local cargo = null;
local suptile = null;
local go = false;
local secline = false;
local loopline = false;


// find an industry to build a terminus at (or whose terminus we shall reuse)
// first, examine existing termini

local conrail = null;
local contile = null;
local intile = null;
local gotile = null;

local tslist = AIStationList(AIStation.STATION_TRAIN); 
tslist.RemoveList(DudTerminus); // remove known unreachables

foreach (ts, z in tslist) {
local depot = FindTrainDepot(ts);
if (AIRail.IsRailDepotTile(depot) && AITile.GetOwner(depot) == Me) { // we found a depot, so this is a terminus station
local dg = [AIMap.GetTileX(depot),AIMap.GetTileY(depot)]
local doff = [AIMap.GetTileX(depot) - AIMap.GetTileX(AIBaseStation.GetLocation(ts)),AIMap.GetTileY(depot) - AIMap.GetTileY(AIBaseStation.GetLocation(ts))]
//AILog.Info(doff[0] + ", " + doff[1])

local isclear = false;

	if (doff[0] == -2) { // depot northeast
	
contile = AIMap.GetTileIndex(dg[0]-1,dg[1]+1);
conrail = AIRail.RAILTRACK_SW_SE
intile = AIMap.GetTileIndex(dg[0]-1,dg[1]+2);
gotile = AIMap.GetTileIndex(dg[0]-1,dg[1]+3);

	if (AITile.IsBuildableRectangle(intile, 1, 2)) { // && AITile.IsBuildableRectangle(AIMap.GetTileIndex(dg[0]-2,dg[1]+3), 3, 1))
//		AISign.BuildSign(AIMap.GetTileIndex(dg[0]-2,dg[1]+3), "clear")
		isclear = true;
	}
	
	
} else if (doff[1] == -2) { // depot northwest

contile = AIMap.GetTileIndex(dg[0]+1,dg[1]-1);
conrail = AIRail.RAILTRACK_SW_SE
intile = AIMap.GetTileIndex(dg[0]+2,dg[1]-1);
gotile = AIMap.GetTileIndex(dg[0]+3,dg[1]-1);

	if (AITile.IsBuildableRectangle(intile, 1, 2)) { // && AITile.IsBuildableRectangle(AIMap.GetTileIndex(dg[0]+3,dg[1]-2), 3, 1))
//		AISign.BuildSign(AIMap.GetTileIndex(dg[0]+3,dg[1]-2), "clear")
		isclear = true;
	}


} else if (doff[0] == 4) { // depot southwest

contile = AIMap.GetTileIndex(dg[0]+1,dg[1]+1);
conrail = AIRail.RAILTRACK_NE_SE
intile = AIMap.GetTileIndex(dg[0]+1,dg[1]+2);
gotile = AIMap.GetTileIndex(dg[0]+1,dg[1]+3);

	if (AITile.IsBuildableRectangle(intile, 1, 2)) { // && AITile.IsBuildableRectangle(AIMap.GetTileIndex(dg[0],dg[1]+3), 3, 1))
//		AISign.BuildSign(AIMap.GetTileIndex(dg[0],dg[1]+3), "clear")
		isclear = true;
	}


} else { // depot southeast

contile = AIMap.GetTileIndex(dg[0]+1,dg[1]+1);
conrail = AIRail.RAILTRACK_NW_SW
intile = AIMap.GetTileIndex(dg[0]+2,dg[1]+1);
gotile = AIMap.GetTileIndex(dg[0]+3,dg[1]+1);

	if (AITile.IsBuildableRectangle(intile, 1, 2)) { // && AITile.IsBuildableRectangle(AIMap.GetTileIndex(dg[0]+3,dg[1]), 3, 1))
//		AISign.BuildSign(AIMap.GetTileIndex(dg[0]+3,dg[1]), "clear")
		isclear = true;
	}
}


//AISign.BuildSign(contile, "o")
//AISign.BuildSign(intile, "/")
//AISign.BuildSign(gotile, "^")
//AISign.BuildSign(gotile, "^")


if (!isclear) { tslist.RemoveItem(ts); DudTerminus.AddItem(ts, 0); } // no second track space
} else 		  { tslist.RemoveItem(ts); DudTerminus.AddItem(ts, 0); } // not a terminus station
}

if (tslist.Count() > 0 ) {

tslist.Valuate(AIBase.RandItem); // shuffle the list


foreach (ts, z in tslist) {

local supdist = 10000000;
suptile = null;

AILog.Info("Identifying industries which can supply "  + AIBaseStation.GetName(ts) + ".");

	local clist = AICargoList_StationAccepting(ts)
		foreach (c, z in clist) {
		local suplist = AIIndustryList_CargoProducing(c);
		suplist.RemoveList(DudIndustries); // remove known unconnectables
				foreach (s, z in suplist) {
					local d = AIMap.DistanceManhattan((contile),(AIIndustry.GetLocation(s)));
					//AILog.Info("Assessing " + AIIndustry.GetName(s) + " (" + d + " tiles).");
				
					if (d < TrainRange
					&& AIIndustry.GetLastMonthProduction(s, c) > 60
					&& AIIndustry.GetLastMonthTransportedPercentage(s, c) == 0
					&& !AIIndustry.IsBuiltOnWater(s)) {
				
					if (d < supdist) {
					supdist = d; // this is the nearest supplier
					suptile = (AIIndustry.GetLocation(s));
					cargo = c;
					
						// check for industries which don't have a tile in their top left corner (PITA)
						local i = 0;
						while (!AIIndustry.IsValidIndustry(AIIndustry.GetIndustryID(suptile)) && i < 10) {
						suptile = AIMap.GetTileIndex((AIMap.GetTileX(suptile) + 1),(AIMap.GetTileY(suptile) + 1));
						//AILog.Info(AIIndustry.GetName(AIIndustry.GetIndustryID(suptile)))
						i++
					}

			
}
} else {
suplist.RemoveItem(s);
}
}	
if (suptile != null) {dest = ts; break;}
}
if (suptile != null) {dest = ts; break;}
}
}

if (dest != null && suptile != null) { // We found a suitable terminus, so build a line
AILog.Info("I could connect " + AIIndustry.GetName(AIIndustry.GetIndustryID(suptile)) + " to " + AIBaseStation.GetName(dest) + ".");
// check we have dosh

local dosh = AICompany.GetBankBalance(Me);
local cost;
//First, let's check if we want a simple 1-train service, or a two-train loopline.

//AILog.Info("Checking distance: " + AIMap.DistanceManhattan((AIBaseStation.GetLocation(dest)),suptile) + " cargo: " + AIIndustry.GetLastMonthProduction(AIIndustry.GetIndustryID(suptile), cargo))

if (
(AIMap.DistanceManhattan((AIBaseStation.GetLocation(dest)),suptile) > 64) &&
(AIIndustry.GetLastMonthProduction(AIIndustry.GetIndustryID(suptile), cargo) > 80)
) {loopline = true;} // yes

if (loopline) {
// check funds allow for the connection, and a bit left over to maintain the network

cost = (
(AIRail.GetBuildCost(0, AIRail.BT_TRACK) * TrainRange) +
(AITile.GetBuildCost(AITile.BT_CLEAR_FIELDS) * TrainRange) +
(AIRail.GetBuildCost(0, AIRail.BT_STATION) * 6) +
(AIRail.GetBuildCost(0, AIRail.BT_DEPOT)) +
(BuyATrain(0, 0, cargo, 0, 3, true, null) * 2)
)
} else {
// check funds allow for the connection, and a bit left over to maintain the network

cost = (
(AIRail.GetBuildCost(0, AIRail.BT_TRACK) * TrainRange) +
(AITile.GetBuildCost(AITile.BT_CLEAR_FIELDS) * TrainRange) +
(AIRail.GetBuildCost(0, AIRail.BT_STATION) * 3) +
BuyATrain(0, 0, cargo, 0, 3, true, null)
)
}

if (dosh < cost) {
AILog.Info("I can't afford to build a railway right now. Perhaps later.")
return;
}
if (loopline) {
	if (src = TrainPickup2(suptile, AIIndustry.GetIndustryID(suptile), cargo, dest)) {
	go = true;
	secline = true;
	} else { DudIndustries.AddItem(AIIndustry.GetIndustryID(suptile), 0);}
	} else {
	if (src = TrainPickup(suptile, AIIndustry.GetIndustryID(suptile), cargo, dest)) {
	go = true;
	secline = true;
	} else { DudIndustries.AddItem(AIIndustry.GetIndustryID(suptile), 0);}
	}
} else {
//=================================
//We need a new terminus. create a list of goods/food producing industries near our network, with no current production.

local BuildList = ServeIndustries();
local townlist = AIList();
townlist.AddList(Cachedtowns);
BuildList.RemoveList(DudIndustries); // remove known unconnectables


local tslist = AIStationList(AIStation.STATION_TRAIN); 
foreach (i, z in BuildList) {
local catchment = AITileList_IndustryAccepting(i, 4);
foreach (stat, z in tslist) {
if (catchment.HasItem(AIStation.GetLocation(stat))) {
BuildList.RemoveItem(i); // remove industries with existing stations
}
}
}

foreach (i, z in BuildList) {
local tiletown = AITile.GetClosestTown(AIIndustry.GetLocation(i));

if (!(townlist.HasItem(tiletown))) { // remove industries not near our towns
BuildList.RemoveItem(i);
} else if (AIIndustry.IsBuiltOnWater(i)) {
BuildList.RemoveItem(i);
}
}

//Now check for nearby suppliers

foreach (i, z in BuildList) {

//AILog.Info("Contemplating " + AIIndustry.GetName(i) + ".");

// Find the nearest resource supplier
local suplist = AIList();
local cslist = AIList();
cslist = AIIndustryType.GetAcceptedCargo(AIIndustry.GetIndustryType(i));
local supcount = 0;

if (cslist != null) { // added because we crashed here for some reason
foreach (c, z in cslist) {
suplist = AIIndustryList_CargoProducing(c);
suplist.RemoveList(DudIndustries); // remove known unconnectables
foreach (s, z in suplist) {
local d = AIMap.DistanceManhattan((AIIndustry.GetLocation(i)),(AIIndustry.GetLocation(s)));
//AILog.Info("Assessing " + AIIndustry.GetName(s) + " (" + d + " tiles).");

if (d < TrainRange
&& AIIndustry.GetLastMonthProduction(s, c) > 60
&& AIIndustry.GetLastMonthTransportedPercentage(s, c) == 0
&& !AIIndustry.IsBuiltOnWater(s)) {
supcount++ // this is an appropriate supplier
} else {
suplist.RemoveItem(s);
}
}
}
}
if (supcount == 0) {
//AILog.Info("No suppliers found in range.");
BuildList.RemoveItem(i);
} else {
//AILog.Info(supcount + " suppliers found.");
}
}

if (BuildList.Count() > 0) {
BuildList.Valuate(AIBase.RandItem); // shuffle the list
local Ind = BuildList.Begin();

AILog.Info("Contemplating " + AIIndustry.GetName(Ind) + ".");

// now we check again, to get the correct direction for the station
// Find the nearest resource supplier
local suplist = AIList();
local cslist  = AIList();
cslist = AIIndustryType.GetAcceptedCargo(AIIndustry.GetIndustryType(Ind));
local supdist = 10000000;
suptile = null;

foreach (c, z in cslist) {
suplist = AIIndustryList_CargoProducing(c);
suplist.RemoveList(DudIndustries); // remove known unconnectables
foreach (s, z in suplist) {
local d = AIMap.DistanceManhattan((AIIndustry.GetLocation(Ind)),(AIIndustry.GetLocation(s)));
//AILog.Info("Assessing " + AIIndustry.GetName(s) + " (" + d + " tiles).");

if (d < TrainRange
&& AIIndustry.GetLastMonthProduction(s, c) > 60
&& AIIndustry.GetLastMonthTransportedPercentage(s, c) == 0
&& !AIIndustry.IsBuiltOnWater(s)) {

if (d < supdist) {
supdist = d; // this is the nearest supplier
suptile = (AIIndustry.GetLocation(s));

// check for industries which don't have a tile in their top left corner (PITA)
local i = 0;
while (!AIIndustry.IsValidIndustry(AIIndustry.GetIndustryID(suptile)) && i < 10) {
suptile = AIMap.GetTileIndex((AIMap.GetTileX(suptile) + 1),(AIMap.GetTileY(suptile) + 1));
//AILog.Info(AIIndustry.GetName(AIIndustry.GetIndustryID(suptile)))
i++
}

cargo = c;
}
} else {
suplist.RemoveItem(s);
}
}
}

// didn't find a supplier

if (suptile == null) {
AILog.Info("I failed to find a supplier.")
return;
}



//Now pick where to put the station, and in what orientation

local xdist = AIMap.GetTileX(suptile) - AIMap.GetTileX(AIIndustry.GetLocation(Ind));
local ydist = AIMap.GetTileY(suptile) - AIMap.GetTileY(AIIndustry.GetLocation(Ind));
local xabs;
local yabs;
if (xdist < 0) { xabs = 0 - xdist; } else { xabs = xdist; }
if (ydist < 0) { yabs = 0 - ydist; } else { yabs = ydist; }

AILog.Info("Supplier found at " + AIIndustry.GetName(AIIndustry.GetIndustryID(suptile)) + ".");

local s = 0;
local o = 0;

if (xabs > yabs) { 	// supplier is on the x axis
	if (xdist > 0) {
		if (ydist > 0) {
						s = 0;
						o = 0;
		} else {
						s = 2;
						o = 0;
		}
	} else {	
		if (ydist > 0) {
						s = 0;
						o = 1;
		} else {
						s = 2;
						o = 1;
		}	
	}
} else {			// supplier is on the y axis
	if (ydist > 0) { 
		if (xdist > 0) {
						s = 1;
						o = 0;
		} else {
						s = 3;
						o = 0;
		}
	} else {	
		if (xdist > 0) {
						s = 1;
						o = 1;
		} else {
						s = 3;
						o = 1;
		}	
	}

}

// Let's build the route! (if we have the money)

//First, let's check if we want a simple 1-train service, or a two-train loopline.

//AILog.Info("Checking distance: " + AIMap.DistanceManhattan((AIIndustry.GetLocation(Ind)),(AIIndustry.GetLocation(AIIndustry.GetIndustryID(suptile)))) + " cargo: " + AIIndustry.GetLastMonthProduction(AIIndustry.GetIndustryID(suptile), cargo))

local dosh = AICompany.GetBankBalance(Me);
local cost;

if (
(AIMap.DistanceManhattan((AIIndustry.GetLocation(Ind)),(AIIndustry.GetLocation(AIIndustry.GetIndustryID(suptile)))) > 64) &&
(AIIndustry.GetLastMonthProduction(AIIndustry.GetIndustryID(suptile), cargo)		> 80)
) {loopline = true;} // yes

if (loopline) {
// check funds allow for the connection, and a bit left over to maintain the network

cost = (
(AIRail.GetBuildCost(0, AIRail.BT_TRACK) * TrainRange) +
(AITile.GetBuildCost(AITile.BT_CLEAR_FIELDS) * TrainRange) +
(AIRail.GetBuildCost(0, AIRail.BT_STATION) * 6) +
(AIRail.GetBuildCost(0, AIRail.BT_DEPOT)) +
(BuyATrain(0, 0, cargo, 0, 3, true, null) * 2)
)
} else {
// check funds allow for the connection, and a bit left over to maintain the network

cost = (
(AIRail.GetBuildCost(0, AIRail.BT_TRACK) * TrainRange) +
(AITile.GetBuildCost(AITile.BT_CLEAR_FIELDS) * TrainRange) +
(AIRail.GetBuildCost(0, AIRail.BT_STATION) * 6) +
(AIRail.GetBuildCost(0, AIRail.BT_DEPOT)) +
BuyATrain(0, 0, cargo, 0, 3, true, null)
) 
}

if (dosh < cost){
AILog.Info("I can't afford to build a railway right now. Perhaps later.")
return;
}

if (dest = SmallStation(Ind, s, o, cargo)) {
if (loopline) {
	if (src = TrainPickup2(suptile, AIIndustry.GetIndustryID(suptile), cargo, dest)) {
	go = true;
	} else { DudIndustries.AddItem(AIIndustry.GetIndustryID(suptile), 0);}
	} else {
	if (src = TrainPickup(suptile, AIIndustry.GetIndustryID(suptile), cargo, dest)) {
	go = true;
	} else { DudIndustries.AddItem(AIIndustry.GetIndustryID(suptile), 0);}
	}

} else if (dest = SmallStation(Ind, (s + 2) % 4, o, cargo)) {
if (loopline) {
	if (src = TrainPickup2(suptile, AIIndustry.GetIndustryID(suptile), cargo, dest)) {
	go = true;
	} else { DudIndustries.AddItem(AIIndustry.GetIndustryID(suptile), 0);}
	} else {
	if (src = TrainPickup(suptile, AIIndustry.GetIndustryID(suptile), cargo, dest)) {
	go = true;
	} else { DudIndustries.AddItem(AIIndustry.GetIndustryID(suptile), 0);}
	}
}
} else {
AILog.Info("I couldn't find an appropriate industry to serve.");

DudCounter++

if (DudCounter > 3) {
DudIndustries.Valuate(AIBase.RandItem); // shuffle the list
DudIndustries.RemoveTop(1);// remove a random industry from the dud list
DudCounter = 0;
}

// see if we can't find a nearby industry in a smaller town

local xoilist = ServeIndustries();
local hq = AICompany.GetCompanyHQ(Me);
xoilist.Valuate(AIIndustry.GetDistanceManhattanToTile, hq);
xoilist.Sort(AIList.SORT_BY_VALUE,true);
foreach (i, z in xoilist) {

local tiletown = AITile.GetClosestTown(AIIndustry.GetLocation(i));
if (!(townlist.HasItem(tiletown))) {

IndTownList.AddItem(tiletown, 0); // add this town to the list to connect even if it's not big enough
AILog.Info("But " + AIIndustry.GetName(i) + " is intriguing...")
return;
}
}
return;
}
}

if (go) {

HillClimb = 0; // reset global var

// find the target and start tiles
// at source:

local a;
local b;
local adir;
local bdir;
local depot;
local sigtar = [0,0,0]

local rfolo = [AIMap.GetTileX(AIBaseStation.GetLocation(dest)),AIMap.GetTileY(AIBaseStation.GetLocation(dest))]
if (AIStation.GetStationID(AIMap.GetTileIndex(rfolo[0]+1, rfolo[1])) == dest) {
	if (AIRail.GetRailTracks(AIMap.GetTileIndex(rfolo[0]-1, rfolo[1])) == AIRail.RAILTRACK_NE_SW) {	
a = 	AIMap.GetTileIndex(rfolo[0]-4, rfolo[1]);
adir =  AIMap.GetTileIndex(rfolo[0]-3, rfolo[1]);
depot = AIMap.GetTileIndex(rfolo[0]-2, rfolo[1]-1);

	sigtar[0] = AIMap.GetTileIndex(rfolo[0]-5, rfolo[1]);
	sigtar[1] = AIMap.GetTileIndex(rfolo[0]-4, rfolo[1] - 1);
	sigtar[2] = AIMap.GetTileIndex(rfolo[0]-4, rfolo[1] + 1);
	 } else {
a = 	AIMap.GetTileIndex(rfolo[0]+6, rfolo[1]);
adir =  AIMap.GetTileIndex(rfolo[0]+5, rfolo[1]);
depot = AIMap.GetTileIndex(rfolo[0]+4, rfolo[1]-1);

	sigtar[0] = AIMap.GetTileIndex(rfolo[0]+7, rfolo[1]);
	sigtar[1] = AIMap.GetTileIndex(rfolo[0]+6, rfolo[1] - 1);
	sigtar[2] = AIMap.GetTileIndex(rfolo[0]+6, rfolo[1] + 1);
	

}
} else {
	if (AIRail.GetRailTracks(AIMap.GetTileIndex(rfolo[0], rfolo[1]-1)) == AIRail.RAILTRACK_NW_SE) {	
a = 	AIMap.GetTileIndex(rfolo[0], rfolo[1]-4);
adir =  AIMap.GetTileIndex(rfolo[0], rfolo[1]-3);
depot = AIMap.GetTileIndex(rfolo[0]-1, rfolo[1]-2);

	sigtar[0] = AIMap.GetTileIndex(rfolo[0], 	 rfolo[1]-5);
	sigtar[1] = AIMap.GetTileIndex(rfolo[0] - 1, rfolo[1]-4);
	sigtar[2] = AIMap.GetTileIndex(rfolo[0] + 1, rfolo[1]-4);
	 } else {
a = 	AIMap.GetTileIndex(rfolo[0], rfolo[1]+6);
adir =  AIMap.GetTileIndex(rfolo[0], rfolo[1]+5);
depot = AIMap.GetTileIndex(rfolo[0]-1, rfolo[1]+4);

	sigtar[0] = AIMap.GetTileIndex(rfolo[0], 	 rfolo[1] + 7);
	sigtar[1] = AIMap.GetTileIndex(rfolo[0] - 1, rfolo[1] + 6);
	sigtar[2] = AIMap.GetTileIndex(rfolo[0] + 1, rfolo[1] + 6);
}
}


// small source

if (!loopline) {

rfolo = [AIMap.GetTileX(AIBaseStation.GetLocation(src)),AIMap.GetTileY(AIBaseStation.GetLocation(src))]
if (AIStation.GetStationID(AIMap.GetTileIndex(rfolo[0]+1, rfolo[1])) == src) {
	if (AIMap.GetTileX(AIBaseStation.GetLocation(dest)) > rfolo[0]) {
b = 	AIMap.GetTileIndex(rfolo[0]+3, rfolo[1]);
bdir =  AIMap.GetTileIndex(rfolo[0]+2, rfolo[1]);
	} else {
b = 	AIMap.GetTileIndex(rfolo[0]-1, rfolo[1]);
bdir =  AIMap.GetTileIndex(rfolo[0], rfolo[1]);
} 
}else {
	if (AIMap.GetTileY(AIBaseStation.GetLocation(dest)) > rfolo[1]) {
b = 	AIMap.GetTileIndex(rfolo[0], rfolo[1]+3);
bdir =  AIMap.GetTileIndex(rfolo[0], rfolo[1]+2);
	} else {
b = 	AIMap.GetTileIndex(rfolo[0], rfolo[1]-1);
bdir =  AIMap.GetTileIndex(rfolo[0], rfolo[1]);
} 
}

} else {
// loop source

rfolo = [AIMap.GetTileX(AIBaseStation.GetLocation(src)),AIMap.GetTileY(AIBaseStation.GetLocation(src))]
if (AIStation.GetStationID(AIMap.GetTileIndex(rfolo[0]+1, rfolo[1])) == src) {
	if (AIRail.GetSignalType(
	AIMap.GetTileIndex(rfolo[0]-1, rfolo[1]),
	AIMap.GetTileIndex(rfolo[0], rfolo[1])
	) == AIRail.SIGNALTYPE_NONE) {
b = 	AIMap.GetTileIndex(rfolo[0]+7, rfolo[1]);
bdir =  AIMap.GetTileIndex(rfolo[0]+6, rfolo[1]);
	} else {
b = 	AIMap.GetTileIndex(rfolo[0] - 4, rfolo[1]);
bdir =  AIMap.GetTileIndex(rfolo[0] - 3, rfolo[1]);
} 
}else {
	if (AIRail.GetSignalType(
	AIMap.GetTileIndex(rfolo[0], rfolo[1]-1),
	AIMap.GetTileIndex(rfolo[0], rfolo[1])
	) == AIRail.SIGNALTYPE_NONE) {
b = 	AIMap.GetTileIndex(rfolo[0], rfolo[1]+7);
bdir =  AIMap.GetTileIndex(rfolo[0], rfolo[1]+6);
	} else {
b = 	AIMap.GetTileIndex(rfolo[0], rfolo[1] - 4);
bdir =  AIMap.GetTileIndex(rfolo[0], rfolo[1] - 3);
} 
}
}

//AISign.BuildSign(a, "a");
//AISign.BuildSign(adir, "adir");
//AISign.BuildSign(b, "b");
//AISign.BuildSign(bdir, "bdir");

// override a and adir for the second line

if (secline) {
a = gotile;
adir = intile;
}

//build the line

BackTrackCounter = 0;
PassingPlace = null;
if (BuildALine([[a, adir]], [[b, bdir]], loopline, false)) {




// build connecting line and signals

if (secline) {
while ((AIRail.GetRailTracks(contile) & conrail) != conrail) {
AIRail.BuildRailTrack(contile, conrail);
}
AIRail.BuildRail(contile, intile, gotile);
}

// build signals

if (PassingPlace == null) {
if (secline) {
AIRail.BuildSignal(
		intile,
		gotile,
		AIRail.SIGNALTYPE_PBS // how do we build semaphores, precious?
		);
} else {
for(local n = 0; n < 3; n++){
		AIRail.BuildSignal(
		a,
		sigtar[n],
		AIRail.SIGNALTYPE_PBS // how do we build semaphores, precious?
		);
		}
}
}


if (loopline && PassingPlace != null) {
local dorder = PassingPlace;
BuyATrain(dest, src, cargo, depot, 3, false, dorder);
BuyATrain(dest, src, cargo, depot, 3, false, dorder);
} else {
BuyATrain(dest, src, cargo, depot, 3, false, null);
}


} else {
DudIndustries.AddItem(AIIndustry.GetIndustryID(suptile), 0); // don't try the same industry again
}
}
}

//===================================
//build a small station
//===================================

function CivilAI::SmallStation(ind, side, orientation, cargo) {

local xof;
local yof;
local indloc = AIIndustry.GetLocation(ind);


if (side == 0) {
xof = 0 // SE
yof = 4
} else if (side == 1) {
xof = 4 // SW
yof = 0
} else if (side == 2) {
xof = 0 // NW
yof = -3
} else {
xof = -3 // NE
yof = 0
}

// clockwise spiral out
local trytilegrid = [AIMap.GetTileX(indloc) + xof,AIMap.GetTileY(indloc) + yof] // we're making assumptions about industry size here
local trytile;
local x = 0
local y = 0
local i = 0
local s = 4
local NewStat = null;


while ((i < s) && NewStat == null) {
//y--
for (;y >= 0-i;y--) {
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
//AISign.BuildSign(trytile, ".");
if (AITileList_IndustryAccepting(ind, 4).HasItem(trytile)) {
if (NewStat = BuildSmallStation(ind, trytile, side, orientation, cargo)) {
return NewStat;
}
}
} 
//x--;
for (;x >= 0-i;x--) {
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
//AISign.BuildSign(trytile, ".");
if (AITileList_IndustryAccepting(ind, 4).HasItem(trytile)) {
if (NewStat = BuildSmallStation(ind, trytile, side, orientation, cargo)) {
return NewStat;
}
}
} 
//y++;
for (;y <= i;y++) {
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
//AISign.BuildSign(trytile, ".");
if (AITileList_IndustryAccepting(ind, 4).HasItem(trytile)) {
if (NewStat = BuildSmallStation(ind, trytile, side, orientation, cargo)) {
return NewStat;
}
}
} 
//x++;
for (;x <= i;x++) {
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
//AISign.BuildSign(trytile, ".");
if (AITileList_IndustryAccepting(ind, 4).HasItem(trytile)) {
if (NewStat = BuildSmallStation(ind, trytile, side, orientation, cargo)) {
return NewStat;
} 
}
}
i=i+1
}

if (NewStat == null) {DudIndustries.AddItem(ind, 0);}

return NewStat;

}
//======
 function CivilAI::BuildSmallStation(ind, tile, side, orientation, cargo) {
 //=====
 local NewStat = null;
 local indloc = AIIndustry.GetLocation(ind); 
 
 //AISign.BuildSign(tile, side + ", " + orientation);
 
 // flatten land
local tg = [AIMap.GetTileX(tile),AIMap.GetTileY(tile)]

AITile.LevelTiles(indloc,tile);

if (side % 2 == 1) {
if (orientation == 0) {
	if (!(AITile.IsBuildableRectangle(AIMap.GetTileIndex(tg[0]-1,tg[1]), 3, 8))) { return null; }
AITile.LevelTiles(tile,AIMap.GetTileIndex(tg[0]+2,tg[1]+8));
AITile.LevelTiles(tile,AIMap.GetTileIndex(tg[0]-1,tg[1]+8));
} else {
 	if (!(AITile.IsBuildableRectangle(AIMap.GetTileIndex(tg[0]-1,tg[1]-6), 3, 8))) { return null; }
AITile.LevelTiles(tile,AIMap.GetTileIndex(tg[0]+2,tg[1]+3));
AITile.LevelTiles(tile,AIMap.GetTileIndex(tg[0]-1,tg[1]+3));
AITile.LevelTiles(tile,AIMap.GetTileIndex(tg[0]+2,tg[1]-6));
AITile.LevelTiles(tile,AIMap.GetTileIndex(tg[0]-1,tg[1]-6));
}
 } else {
 if (orientation == 0) {
 	if (!(AITile.IsBuildableRectangle(AIMap.GetTileIndex(tg[0],tg[1]-1), 8, 3))) { return null; }
AITile.LevelTiles(tile,AIMap.GetTileIndex(tg[0]+8,tg[1]+2));
AITile.LevelTiles(tile,AIMap.GetTileIndex(tg[0]+8,tg[1]-1));
} else {
 	if (!(AITile.IsBuildableRectangle(AIMap.GetTileIndex(tg[0]-6,tg[1]-1), 8, 3))) { return null; }
AITile.LevelTiles(tile,AIMap.GetTileIndex(tg[0]+3,tg[1]+2));
AITile.LevelTiles(tile,AIMap.GetTileIndex(tg[0]+3,tg[1]-1));
AITile.LevelTiles(tile,AIMap.GetTileIndex(tg[0]-6,tg[1]+2));
AITile.LevelTiles(tile,AIMap.GetTileIndex(tg[0]-6,tg[1]-1));
}
  }
  
if (side % 2 == 0) {
	if (orientation == 0) {
		// 0, 0 SE, S
		if (AIRail.BuildNewGRFRailStation(AIMap.GetTileIndex(tg[0],tg[1]),AIRail.RAILTRACK_NE_SW,1,3,AIStation.STATION_NEW,cargo,AIIndustryType.INDUSTRYTYPE_UNKNOWN, AIIndustry.GetIndustryType(ind), 64, false)) {
//		AILog.Info(cargo + " " + AIIndustry.GetIndustryType(ind));
		NewStat = (AIStation.GetStationID(AIMap.GetTileIndex(tg[0],tg[1])));
		AIRail.BuildRail(
		AIMap.GetTileIndex(tg[0]+2,tg[1]), //init tracks
		AIMap.GetTileIndex(tg[0]+3,tg[1]),
		AIMap.GetTileIndex(tg[0]+6,tg[1])
		);
		local depot = AIMap.GetTileIndex(tg[0]+4,tg[1]-1) //depot
		AIRail.BuildRailDepot(
		depot,
		AIMap.GetTileIndex(tg[0]+4,tg[1])		
		);
if (!AIRail.IsRailDepotTile(depot)) {return null;} // we actually failed to build the depot, probably due to landform.				
		// depot tracks
		AIRail.BuildRailTrack(
		AIMap.GetTileIndex(tg[0]+4,tg[1]),
		AIRail.RAILTRACK_NW_SW);
		AIRail.BuildRailTrack(
		AIMap.GetTileIndex(tg[0]+4,tg[1]),
		AIRail.RAILTRACK_NW_NE);
		// home signal
		AIRail.BuildSignal(
		AIMap.GetTileIndex(tg[0]+3,tg[1]),
		AIMap.GetTileIndex(tg[0]+2,tg[1]),
		AIRail.SIGNALTYPE_PBS // how do we build semaphores, precious?
		);
		return NewStat;
		} else {
		return null;
		}
	} else {
		// 0, 1 SE, N
		if (AIRail.BuildNewGRFRailStation(AIMap.GetTileIndex(tg[0],tg[1]),AIRail.RAILTRACK_NE_SW,1,3,AIStation.STATION_NEW,cargo,AIIndustryType.INDUSTRYTYPE_UNKNOWN, AIIndustry.GetIndustryType(ind), 64, false)) {
//		AILog.Info(cargo + " " + AIIndustry.GetIndustryType(ind));
		NewStat = (AIStation.GetStationID(AIMap.GetTileIndex(tg[0],tg[1])));
		AIRail.BuildRail(
		AIMap.GetTileIndex(tg[0],tg[1]), //init tracks
		AIMap.GetTileIndex(tg[0]-1,tg[1]),
		AIMap.GetTileIndex(tg[0]-4,tg[1])
		);
		local depot = AIMap.GetTileIndex(tg[0]-2,tg[1]-1)
		AIRail.BuildRailDepot(
		depot, //depot
		AIMap.GetTileIndex(tg[0]-2,tg[1])
		);
if (!AIRail.IsRailDepotTile(depot)) {return null;} // we actually failed to build the depot, probably due to landform.			
		// depot tracks
		AIRail.BuildRailTrack(
		AIMap.GetTileIndex(tg[0]-2,tg[1]),
		AIRail.RAILTRACK_NW_SW);
		AIRail.BuildRailTrack(
		AIMap.GetTileIndex(tg[0]-2,tg[1]),
		AIRail.RAILTRACK_NW_NE);
		// home signal
		AIRail.BuildSignal(
		AIMap.GetTileIndex(tg[0]-1,tg[1]),
		AIMap.GetTileIndex(tg[0],tg[1]),
		AIRail.SIGNALTYPE_PBS // how do we build semaphores, precious?
		);
		return NewStat;
		} else {
		return null;
		}
	}  
} else {
	if (orientation == 0) {
		// 1, 0 SW, S
		if (AIRail.BuildNewGRFRailStation(AIMap.GetTileIndex(tg[0],tg[1]),AIRail.RAILTRACK_NW_SE,1,3,AIStation.STATION_NEW,cargo,AIIndustryType.INDUSTRYTYPE_UNKNOWN, AIIndustry.GetIndustryType(ind), 64, false)) {
//		AILog.Info(cargo + " " + AIIndustry.GetIndustryType(ind));
		NewStat = (AIStation.GetStationID(AIMap.GetTileIndex(tg[0],tg[1])));
		AIRail.BuildRail(
		AIMap.GetTileIndex(tg[0],tg[1]+2), //init tracks
		AIMap.GetTileIndex(tg[0],tg[1]+3),
		AIMap.GetTileIndex(tg[0],tg[1]+6)
		);
		local depot = AIMap.GetTileIndex(tg[0]-1,tg[1]+4)
		AIRail.BuildRailDepot(
		depot, //depot
		AIMap.GetTileIndex(tg[0],tg[1]+4)
		);
if (!AIRail.IsRailDepotTile(depot)) {return null;} // we actually failed to build the depot, probably due to landform.			
		// depot tracks
		AIRail.BuildRailTrack(
		AIMap.GetTileIndex(tg[0],tg[1]+4),
		AIRail.RAILTRACK_NE_SE);
		AIRail.BuildRailTrack(
		AIMap.GetTileIndex(tg[0],tg[1]+4),
		AIRail.RAILTRACK_NW_NE);
		// home signal
		AIRail.BuildSignal(
		AIMap.GetTileIndex(tg[0],tg[1]+3),
		AIMap.GetTileIndex(tg[0],tg[1]+2),
		AIRail.SIGNALTYPE_PBS // how do we build semaphores, precious?
		);
		return NewStat;
		} else {
		return null;
		}
	} else {
		// 1, 1, SW, N
		if (AIRail.BuildNewGRFRailStation(AIMap.GetTileIndex(tg[0],tg[1]),AIRail.RAILTRACK_NW_SE,1,3,AIStation.STATION_NEW,cargo,AIIndustryType.INDUSTRYTYPE_UNKNOWN, AIIndustry.GetIndustryType(ind), 64, false)) {
//		AILog.Info(cargo + " " + AIIndustry.GetIndustryType(ind));
		NewStat = (AIStation.GetStationID(AIMap.GetTileIndex(tg[0],tg[1])));
		AIRail.BuildRail(
		AIMap.GetTileIndex(tg[0],tg[1]), //init tracks
		AIMap.GetTileIndex(tg[0],tg[1]-1),
		AIMap.GetTileIndex(tg[0],tg[1]-4)
		);
		local depot = AIMap.GetTileIndex(tg[0]-1,tg[1]-2)
		AIRail.BuildRailDepot(
		depot, //depot
		AIMap.GetTileIndex(tg[0],tg[1]-2)
		);
if (!AIRail.IsRailDepotTile(depot)) {return null;} // we actually failed to build the depot, probably due to landform.			
		// depot tracks
		AIRail.BuildRailTrack(
		AIMap.GetTileIndex(tg[0],tg[1]-2),
		AIRail.RAILTRACK_NE_SE);
		AIRail.BuildRailTrack(
		AIMap.GetTileIndex(tg[0],tg[1]-2),
		AIRail.RAILTRACK_NW_NE);
		// home signal
		AIRail.BuildSignal(
		AIMap.GetTileIndex(tg[0],tg[1]-1),
		AIMap.GetTileIndex(tg[0],tg[1]),
		AIRail.SIGNALTYPE_PBS // how do we build semaphores, precious?
		);
		return NewStat;
		} else {
		return null;
		}
	}  
}
}

//==========
function CivilAI::TrainPickup(source, ind, cargo, dest) {
//===========
// new feature! Check for a second nearby industry, and place the station to cover both if one is found
local ind = AIIndustry.GetIndustryID(source);
local ilist = AIIndustryList();
local ind2 = null;

ilist.RemoveItem(ind);
foreach (i, z in ilist) {
if (AIIndustry.GetIndustryType(i) != AIIndustry.GetIndustryType(ind)) {ilist.RemoveItem(i);}
}
foreach (i, z in ilist) {
if (AIMap.DistanceMax(AIIndustry.GetLocation(ind), AIIndustry.GetLocation(i)) < 8) {ind2 = i;}
}



// clockwise spiral out
local trytilegrid = [AIMap.GetTileX(source),AIMap.GetTileY(source)] // we're making assumptions about industry size here
local trytile;
local x = 0
local y = 0
local i = 0
local s = 8
local NewStat = null;
local gotile;


while ((i < s) && NewStat == null) {
//y--
for (;y >= 0-i;y--) {
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
//AISign.BuildSign(trytile, ".");
if (AITile.IsBuildableRectangle(trytile, 7,2)) {
gotile = AIMap.GetTileIndex(AIMap.GetTileX(trytile)+ 2,AIMap.GetTileY(trytile) );
	if (
	AITileList_IndustryProducing(ind,4).HasItem(gotile) && 
		(ind2 == null || AITileList_IndustryProducing(ind2,4).HasItem(gotile))
	) {
	if (AIRail.BuildNewGRFRailStation(gotile,AIRail.RAILTRACK_NE_SW,1,3,AIStation.STATION_NEW,cargo,AIIndustry.GetIndustryType(ind), AIIndustryType.INDUSTRYTYPE_UNKNOWN, 64, true)) {
				NewStat = (AIStation.GetStationID(gotile));
				
				//AISign.BuildSign(trytile, "T Y-");
				//AISign.BuildSign(gotile, "G");
				
	return NewStat;
}
}
}
} 
//x--;
for (;x >= 0-i;x--) {
//AISign.BuildSign(trytile, ".");
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
if (AITile.IsBuildableRectangle(trytile, 2,7)) {
gotile = AIMap.GetTileIndex(AIMap.GetTileX(trytile) ,AIMap.GetTileY(trytile)+ 2);
	if (
	AITileList_IndustryProducing(ind,4).HasItem(gotile) && 
		(ind2 == null || AITileList_IndustryProducing(ind2,4).HasItem(gotile))
	) {
	if (AIRail.BuildNewGRFRailStation(gotile,AIRail.RAILTRACK_NW_SE,1,3,AIStation.STATION_NEW,cargo,AIIndustry.GetIndustryType(ind), AIIndustryType.INDUSTRYTYPE_UNKNOWN, 64, true)) {
			NewStat = (AIStation.GetStationID(gotile));
			
				//AISign.BuildSign(trytile, "T X-");
				//AISign.BuildSign(gotile, "G");
	return NewStat;
}
}
}
} 
//y++;
for (;y <= i;y++) {
//AISign.BuildSign(trytile, ".");
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
if (AITile.IsBuildableRectangle(trytile, 7,2)) {
gotile = AIMap.GetTileIndex(AIMap.GetTileX(trytile)+ 2,AIMap.GetTileY(trytile) );
	if (
	AITileList_IndustryProducing(ind,4).HasItem(gotile) && 
		(ind2 == null || AITileList_IndustryProducing(ind2,4).HasItem(gotile))
	) {
	if (AIRail.BuildNewGRFRailStation(gotile,AIRail.RAILTRACK_NE_SW,1,3,AIStation.STATION_NEW,cargo,AIIndustry.GetIndustryType(ind), AIIndustryType.INDUSTRYTYPE_UNKNOWN, 64, true)) {
				NewStat = (AIStation.GetStationID(gotile));
				
				//AISign.BuildSign(trytile, "T Y+");
				//AISign.BuildSign(gotile, "G");	
	return NewStat;
}
}
}
} 
//x++;
for (;x <= i;x++) {
//AISign.BuildSign(trytile, ".");
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
if (AITile.IsBuildableRectangle(trytile, 2,7)) {
gotile = AIMap.GetTileIndex(AIMap.GetTileX(trytile) ,AIMap.GetTileY(trytile)+ 2);
	if (
	AITileList_IndustryProducing(ind,4).HasItem(gotile) && 
		(ind2 == null || AITileList_IndustryProducing(ind2,4).HasItem(gotile))
	) {
	if (AIRail.BuildNewGRFRailStation(gotile,AIRail.RAILTRACK_NW_SE,1,3,AIStation.STATION_NEW,cargo,AIIndustry.GetIndustryType(ind), AIIndustryType.INDUSTRYTYPE_UNKNOWN, 64, true)) {
				NewStat = (AIStation.GetStationID(gotile));
				
				//AISign.BuildSign(trytile, "T X+");
				//AISign.BuildSign(gotile, "G");				
	return NewStat;
}
}
}
} 
i=i+1
if ((i == s) && (ind2 != null)) {
// go again without the second industry
x = 0
y = 0
i = 0
ind2 = null;
}
}

return NewStat;
}

//==========
function CivilAI::TrainPickup2(source, ind, cargo, dest) {
//===========
// new feature! Check for a second nearby industry, and place the station to cover both if one is found
local ind = AIIndustry.GetIndustryID(source);
local ilist = AIIndustryList();
local ind2 = null;

ilist.RemoveItem(ind);
foreach (i, z in ilist) {
if (AIIndustry.GetIndustryType(i) != AIIndustry.GetIndustryType(ind)) {ilist.RemoveItem(i);}
}
foreach (i, z in ilist) {
if (AIMap.DistanceMax(AIIndustry.GetLocation(ind), AIIndustry.GetLocation(i)) < 8) {ind2 = i;}
}



// clockwise spiral out
local trytilegrid = [AIMap.GetTileX(source),AIMap.GetTileY(source)] // we're making assumptions about industry size here
local trytile;
local x = 0
local y = 0
local i = 0
local s = 8
local NewStat = null;
local gotile;


while ((i < s) && NewStat == null) {
//y--
for (;y >= 0-i;y--) {
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
//AISign.BuildSign(trytile, ".");
if (AITile.IsBuildableRectangle(trytile, 12,3)) {
gotile = AIMap.GetTileIndex(AIMap.GetTileX(trytile)+ 4,AIMap.GetTileY(trytile) );
	if (
	AITileList_IndustryProducing(ind,4).HasItem(gotile) && 
		(ind2 == null || AITileList_IndustryProducing(ind2,4).HasItem(gotile))
	) {
	if (AIRail.BuildNewGRFRailStation(gotile,AIRail.RAILTRACK_NE_SW,1,4,AIStation.STATION_NEW,cargo,AIIndustry.GetIndustryType(ind), AIIndustryType.INDUSTRYTYPE_UNKNOWN, 64, true)) {
	

				NewStat = (AIStation.GetStationID(gotile));
				AITile.LevelTiles(gotile, AIMap.GetTileIndex(AIMap.GetTileX(gotile) - 2,AIMap.GetTileY(gotile) + 3));				
				AITile.LevelTiles(gotile, AIMap.GetTileIndex(AIMap.GetTileX(gotile) + 8,AIMap.GetTileY(gotile) + 3));				
				break;
}
}
}
} 

if (NewStat != null) {break};

//x--;
for (;x >= 0-i;x--) {
//AISign.BuildSign(trytile, ".");
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
if (AITile.IsBuildableRectangle(trytile, 3,12)) {

gotile = AIMap.GetTileIndex(AIMap.GetTileX(trytile) ,AIMap.GetTileY(trytile)+ 4);
	if (
	AITileList_IndustryProducing(ind,4).HasItem(gotile) && 
		(ind2 == null || AITileList_IndustryProducing(ind2,4).HasItem(gotile))
	) {
	if (AIRail.BuildNewGRFRailStation(gotile,AIRail.RAILTRACK_NW_SE,1,4,AIStation.STATION_NEW,cargo,AIIndustry.GetIndustryType(ind), AIIndustryType.INDUSTRYTYPE_UNKNOWN, 64, true)) {
			
				NewStat = (AIStation.GetStationID(gotile));
				AITile.LevelTiles(gotile, AIMap.GetTileIndex(AIMap.GetTileX(gotile) + 3,AIMap.GetTileY(gotile) - 2));				
				AITile.LevelTiles(gotile, AIMap.GetTileIndex(AIMap.GetTileX(gotile) + 3,AIMap.GetTileY(gotile) + 8));	
				break;
}
}
}
} 

if (NewStat != null) {break};

//y++;
for (;y <= i;y++) {
//AISign.BuildSign(trytile, ".");
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
if (AITile.IsBuildableRectangle(trytile, 12,3)) {

gotile = AIMap.GetTileIndex(AIMap.GetTileX(trytile)+ 4,AIMap.GetTileY(trytile) );
	if (
	AITileList_IndustryProducing(ind,4).HasItem(gotile) && 
		(ind2 == null || AITileList_IndustryProducing(ind2,4).HasItem(gotile))
	) {
	if (AIRail.BuildNewGRFRailStation(gotile,AIRail.RAILTRACK_NE_SW,1,4,AIStation.STATION_NEW,cargo,AIIndustry.GetIndustryType(ind), AIIndustryType.INDUSTRYTYPE_UNKNOWN, 64, true)) {
			
				NewStat = (AIStation.GetStationID(gotile));
				AITile.LevelTiles(gotile, AIMap.GetTileIndex(AIMap.GetTileX(gotile) - 2,AIMap.GetTileY(gotile) + 3));				
				AITile.LevelTiles(gotile, AIMap.GetTileIndex(AIMap.GetTileX(gotile) + 8,AIMap.GetTileY(gotile) + 3));	
				break;
}
}
}
} 

if (NewStat != null) {break};

//x++;
for (;x <= i;x++) {
//AISign.BuildSign(trytile, ".");
trytile = AIMap.GetTileIndex(trytilegrid[0]+x,trytilegrid[1]+y);
if (AITile.IsBuildableRectangle(trytile, 3,12)) {

gotile = AIMap.GetTileIndex(AIMap.GetTileX(trytile) ,AIMap.GetTileY(trytile)+ 4);
	if (
	AITileList_IndustryProducing(ind,4).HasItem(gotile) && 
		(ind2 == null || AITileList_IndustryProducing(ind2,4).HasItem(gotile))
	) {
	if (AIRail.BuildNewGRFRailStation(gotile,AIRail.RAILTRACK_NW_SE,1,4,AIStation.STATION_NEW,cargo,AIIndustry.GetIndustryType(ind), AIIndustryType.INDUSTRYTYPE_UNKNOWN, 64, true)) {
			
				NewStat = (AIStation.GetStationID(gotile));
				AITile.LevelTiles(gotile, AIMap.GetTileIndex(AIMap.GetTileX(gotile) + 3,AIMap.GetTileY(gotile) - 2));				
				AITile.LevelTiles(gotile, AIMap.GetTileIndex(AIMap.GetTileX(gotile) + 3,AIMap.GetTileY(gotile) + 8));				
				break;



}
}
} 
}

if (NewStat != null) {break};
i=i+1
if ((i == s) && (ind2 != null)) {
// go again without the second industry
x = 0
y = 0
i = 0
ind2 = null;
}
}

if (NewStat == null) {return null;} // we didn't manage to build a station

// build the pickup loop
local tgrid = [AIMap.GetTileX(gotile),AIMap.GetTileY(gotile)];


if (AIRail.GetRailStationDirection(gotile) == AIRail.RAILTRACK_NW_SE) {
// xloops
if (AIMap.GetTileY(gotile) < AIMap.GetTileY(AIIndustry.GetLocation(ind))) {

AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] + 4), AIRail.RAILTRACK_NW_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 1, tgrid[1] + 4), AIRail.RAILTRACK_NE_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] + 4), AIRail.RAILTRACK_NW_NE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] + 3), AIRail.RAILTRACK_NW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] + 2), AIRail.RAILTRACK_NW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] + 1), AIRail.RAILTRACK_NW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] + 0), AIRail.RAILTRACK_NW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] - 1), AIRail.RAILTRACK_NE_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 1, tgrid[1] - 1), AIRail.RAILTRACK_NW_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 1, tgrid[1] - 2), AIRail.RAILTRACK_NE_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] - 2), AIRail.RAILTRACK_NW_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] - 2), AIRail.RAILTRACK_NW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] - 1), AIRail.RAILTRACK_NW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] - 3), AIRail.RAILTRACK_NW_SE);

		AIRail.BuildSignal(
		AIMap.GetTileIndex(tgrid[0] + 1, tgrid[1] + 4),
		AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] + 4),
		AIRail.SIGNALTYPE_PBS_ONEWAY // how do we build semaphores, precious?
		);
		
		AIRail.BuildSignal(
		AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] - 1),
		AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] + 0),
		AIRail.SIGNALTYPE_PBS_ONEWAY // how do we build semaphores, precious?
		);		

} else {

AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] - 1), AIRail.RAILTRACK_SW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 1, tgrid[1] - 1), AIRail.RAILTRACK_NE_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] - 1), AIRail.RAILTRACK_NE_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] + 3), AIRail.RAILTRACK_NW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] + 2), AIRail.RAILTRACK_NW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] + 1), AIRail.RAILTRACK_NW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] + 0), AIRail.RAILTRACK_NW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] + 4), AIRail.RAILTRACK_NW_NE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 1, tgrid[1] + 4), AIRail.RAILTRACK_SW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 1, tgrid[1] + 5), AIRail.RAILTRACK_NW_NE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] + 5), AIRail.RAILTRACK_SW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] + 4), AIRail.RAILTRACK_NW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] + 5), AIRail.RAILTRACK_NW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] + 6), AIRail.RAILTRACK_NW_SE);

		AIRail.BuildSignal(
		AIMap.GetTileIndex(tgrid[0] + 1, tgrid[1] - 1),
		AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] - 1),
		AIRail.SIGNALTYPE_PBS_ONEWAY // how do we build semaphores, precious?
		);
		
		AIRail.BuildSignal(
		AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] + 4),
		AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] + 3),
		AIRail.SIGNALTYPE_PBS_ONEWAY // how do we build semaphores, precious?
		);		
}
} else {
// yloops
if (AIMap.GetTileX(gotile) < AIMap.GetTileX(AIIndustry.GetLocation(ind))) {

AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 4, tgrid[1] + 0), AIRail.RAILTRACK_NE_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 4, tgrid[1] + 1), AIRail.RAILTRACK_NW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 4, tgrid[1] + 2), AIRail.RAILTRACK_NW_NE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 3, tgrid[1] + 2), AIRail.RAILTRACK_NE_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] + 2), AIRail.RAILTRACK_NE_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 1, tgrid[1] + 2), AIRail.RAILTRACK_NE_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] + 2), AIRail.RAILTRACK_NE_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] - 1, tgrid[1] + 2), AIRail.RAILTRACK_NW_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] - 1, tgrid[1] + 1), AIRail.RAILTRACK_NE_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] - 2, tgrid[1] + 1), AIRail.RAILTRACK_NW_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] - 2, tgrid[1] + 0), AIRail.RAILTRACK_NE_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] - 2, tgrid[1] + 0), AIRail.RAILTRACK_NE_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] - 1, tgrid[1] + 0), AIRail.RAILTRACK_NE_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] - 3, tgrid[1] + 0), AIRail.RAILTRACK_NE_SW);

		AIRail.BuildSignal(
		AIMap.GetTileIndex(tgrid[0] + 4, tgrid[1] + 1),
		AIMap.GetTileIndex(tgrid[0] + 4, tgrid[1] + 2),
		AIRail.SIGNALTYPE_PBS_ONEWAY // how do we build semaphores, precious?
		);
		
		AIRail.BuildSignal(
		AIMap.GetTileIndex(tgrid[0] - 1, tgrid[1] + 0),
		AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] + 0),
		AIRail.SIGNALTYPE_PBS_ONEWAY // how do we build semaphores, precious?
		);		

} else {

AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] - 1, tgrid[1] + 0), AIRail.RAILTRACK_SW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] - 1, tgrid[1] + 1), AIRail.RAILTRACK_NW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] - 1, tgrid[1] + 2), AIRail.RAILTRACK_NW_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 3, tgrid[1] + 2), AIRail.RAILTRACK_NE_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 2, tgrid[1] + 2), AIRail.RAILTRACK_NE_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 1, tgrid[1] + 2), AIRail.RAILTRACK_NE_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 0, tgrid[1] + 2), AIRail.RAILTRACK_NE_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 4, tgrid[1] + 2), AIRail.RAILTRACK_NW_NE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 4, tgrid[1] + 1), AIRail.RAILTRACK_SW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 5, tgrid[1] + 1), AIRail.RAILTRACK_NW_NE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 5, tgrid[1] + 0), AIRail.RAILTRACK_SW_SE);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 4, tgrid[1] + 0), AIRail.RAILTRACK_NE_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 5, tgrid[1] + 0), AIRail.RAILTRACK_NE_SW);
AIRail.BuildRailTrack(AIMap.GetTileIndex(tgrid[0] + 6, tgrid[1] + 0), AIRail.RAILTRACK_NE_SW);

		AIRail.BuildSignal(
		AIMap.GetTileIndex(tgrid[0] - 1, tgrid[1] + 1),
		AIMap.GetTileIndex(tgrid[0] - 1, tgrid[1] + 2),
		AIRail.SIGNALTYPE_PBS_ONEWAY // how do we build semaphores, precious?
		);
		
		AIRail.BuildSignal(
		AIMap.GetTileIndex(tgrid[0] + 4, tgrid[1] + 0),
		AIMap.GetTileIndex(tgrid[0] + 3, tgrid[1] + 0),
		AIRail.SIGNALTYPE_PBS_ONEWAY // how do we build semaphores, precious?
		);		
}
}


return NewStat;
}


// find the train depot at this station =========
 function CivilAI::FindTrainDepot(station) {
 
local depot = null;
local rfolo = [AIMap.GetTileX(AIBaseStation.GetLocation(station)),AIMap.GetTileY(AIBaseStation.GetLocation(station))]
if (AIStation.GetStationID(AIMap.GetTileIndex(rfolo[0]+1, rfolo[1])) == station) {
	if (AIRail.GetRailTracks(AIMap.GetTileIndex(rfolo[0]-1, rfolo[1])) == AIRail.RAILTRACK_NE_SW) {	
depot = AIMap.GetTileIndex(rfolo[0]-2, rfolo[1]-1);
	 } else {
depot = AIMap.GetTileIndex(rfolo[0]+4, rfolo[1]-1);
}
} else {
	if (AIRail.GetRailTracks(AIMap.GetTileIndex(rfolo[0], rfolo[1]-1)) == AIRail.RAILTRACK_NW_SE) {	
depot = AIMap.GetTileIndex(rfolo[0]-1, rfolo[1]-2);
	 } else {
depot = AIMap.GetTileIndex(rfolo[0]-1, rfolo[1]+4);
}
}

return depot;
}

function CivilAI::RemoveTracksFrom(station){


local rfolo = [AIMap.GetTileX(AIBaseStation.GetLocation(station)),AIMap.GetTileY(AIBaseStation.GetLocation(station))]
local t;
local t2;
local lastdir; // where we came from, not where we're heading

// first, establish station type (either 3-tile with track from one end, or 4-tile with track from both ends)
if (AIRail.GetRailStationDirection(AIBaseStation.GetLocation(station)) == AIRail.RAILTRACK_NE_SW) {

t = AIMap.GetTileIndex(rfolo[0]-1, rfolo[1]);
t2 = AIMap.GetTileIndex(rfolo[0]+3, rfolo[1]);

if (AIStation.GetStationID(t2) == station) {
// it's 4 tiles
//AILog.Info("4-tile station detected.")
RemoveTracks(t, 1);
t2 = AIMap.GetTileIndex(rfolo[0]+4, rfolo[1]);
RemoveTracks(t2, 3);
return;
}

if (
AIRail.GetRailTracks(t) == AIRail.RAILTRACK_NE_SW ||
AIRail.GetRailTracks(t) == AIRail.RAILTRACK_NW_SW ||
AIRail.GetRailTracks(t) == AIRail.RAILTRACK_SW_SE
) {

lastdir = 1;

} else {
lastdir = 3;
t = t2;
}
} else {
t = AIMap.GetTileIndex(rfolo[0], rfolo[1]-1);
t2 = AIMap.GetTileIndex(rfolo[0], rfolo[1]+3);

if (AIStation.GetStationID(t2) == station) {
// it's 4 tiles
//AILog.Info("4-tile station detected.")
RemoveTracks(t, 0);
t2 = AIMap.GetTileIndex(rfolo[0], rfolo[1]+4);
RemoveTracks(t2, 2);
return;
}

if (
AIRail.GetRailTracks(t) == AIRail.RAILTRACK_NW_SE ||
AIRail.GetRailTracks(t) == AIRail.RAILTRACK_NE_SE ||
AIRail.GetRailTracks(t) == AIRail.RAILTRACK_SW_SE
) {
lastdir = 0;
} else {
lastdir = 2;
t = t2;
}
}
RemoveTracks(t, lastdir);
return;
}


// generalised track removal ====================

function CivilAI::RemoveTracks(t, lastdir) {

local rfolo = [AIMap.GetTileX(t),AIMap.GetTileY(t)] // reset rfolo

//AILog.Info(lastdir);

while (true) { // careful now

//AISign.BuildSign(t, "..")

if (AITunnel.IsTunnelTile(t)) { t = AITunnel.GetOtherTunnelEnd(t); rfolo = [AIMap.GetTileX(t),AIMap.GetTileY(t)];} 
else if (AIBridge.IsBridgeTile(t)) {t = AIBridge.GetOtherBridgeEnd(t); rfolo = [AIMap.GetTileX(t),AIMap.GetTileY(t)];} // that was easy enough
else {

if (lastdir == 0) {
	if (AIRail.GetRailTracks(t) == AIRail.RAILTRACK_NW_SE) {lastdir = 0} 
else if (AIRail.GetRailTracks(t) == AIRail.RAILTRACK_NE_SE) {lastdir = 1} 
else if (AIRail.GetRailTracks(t) == AIRail.RAILTRACK_SW_SE) {lastdir = 3} 
else {JunctionTidy(t, lastdir); AILog.Info("Finished removing disused tracks."); return;}
} else if (lastdir == 1) {
	if (AIRail.GetRailTracks(t) == AIRail.RAILTRACK_NE_SW) {lastdir = 1} 
else if (AIRail.GetRailTracks(t) == AIRail.RAILTRACK_NW_SW) {lastdir = 0} 
else if (AIRail.GetRailTracks(t) == AIRail.RAILTRACK_SW_SE) {lastdir = 2} 
else {JunctionTidy(t, lastdir); AILog.Info("Finished removing disused tracks."); return;}
} else if (lastdir == 2) {
	if (AIRail.GetRailTracks(t) == AIRail.RAILTRACK_NW_SE) {lastdir = 2} 
else if (AIRail.GetRailTracks(t) == AIRail.RAILTRACK_NW_NE) {lastdir = 1} 
else if (AIRail.GetRailTracks(t) == AIRail.RAILTRACK_NW_SW) {lastdir = 3} 
else {JunctionTidy(t, lastdir); AILog.Info("Finished removing disused tracks."); return;}
} else {
	if (AIRail.GetRailTracks(t) == AIRail.RAILTRACK_NE_SW) {lastdir = 3} 
else if (AIRail.GetRailTracks(t) == AIRail.RAILTRACK_NW_NE) {lastdir = 0} 
else if (AIRail.GetRailTracks(t) == AIRail.RAILTRACK_NE_SE) {lastdir = 2} 
else {JunctionTidy(t, lastdir); AILog.Info("Finished removing disused tracks."); return;}
}
}

if (AITile.HasTransportType(t, AITile.TRANSPORT_ROAD)) {

AIRail.RemoveRailTrack(t, AIRail.RAILTRACK_NW_SE);
AIRail.RemoveRailTrack(t, AIRail.RAILTRACK_NE_SW);

} else {
AITile.DemolishTile(t);
}

if (lastdir == 0) {rfolo[1]--;}
else if (lastdir == 1) {rfolo[0]--;}
else if (lastdir == 2) {rfolo[1]++;}
else {rfolo[0]++;}

t = AIMap.GetTileIndex(rfolo[0], rfolo[1]);
}
}

function CivilAI::JunctionTidy(t, lastdir) {
// this is the connecting tile, we'll tidy up our spur. Also useful for opening out loops for removal.
if (lastdir == 0) {
	if ((AIRail.GetRailTracks(t) & AIRail.RAILTRACK_NW_SE) == AIRail.RAILTRACK_NW_SE) {AIRail.RemoveRailTrack(t, AIRail.RAILTRACK_NW_SE);} 
	if ((AIRail.GetRailTracks(t) & AIRail.RAILTRACK_NE_SE) == AIRail.RAILTRACK_NE_SE) {AIRail.RemoveRailTrack(t, AIRail.RAILTRACK_NE_SE);} 
	if ((AIRail.GetRailTracks(t) & AIRail.RAILTRACK_SW_SE) == AIRail.RAILTRACK_SW_SE) {AIRail.RemoveRailTrack(t, AIRail.RAILTRACK_SW_SE);}
} else if (lastdir == 1) {                                                                                                   
	if ((AIRail.GetRailTracks(t) & AIRail.RAILTRACK_NE_SW) == AIRail.RAILTRACK_NE_SW) {AIRail.RemoveRailTrack(t, AIRail.RAILTRACK_NE_SW);} 
	if ((AIRail.GetRailTracks(t) & AIRail.RAILTRACK_NW_SW) == AIRail.RAILTRACK_NW_SW) {AIRail.RemoveRailTrack(t, AIRail.RAILTRACK_NW_SW);} 
	if ((AIRail.GetRailTracks(t) & AIRail.RAILTRACK_SW_SE) == AIRail.RAILTRACK_SW_SE) {AIRail.RemoveRailTrack(t, AIRail.RAILTRACK_SW_SE);}
} else if (lastdir == 2) {                                                                                                   
	if ((AIRail.GetRailTracks(t) & AIRail.RAILTRACK_NW_SE) == AIRail.RAILTRACK_NW_SE) {AIRail.RemoveRailTrack(t, AIRail.RAILTRACK_NW_SE);} 
	if ((AIRail.GetRailTracks(t) & AIRail.RAILTRACK_NW_NE) == AIRail.RAILTRACK_NW_NE) {AIRail.RemoveRailTrack(t, AIRail.RAILTRACK_NW_NE);} 
	if ((AIRail.GetRailTracks(t) & AIRail.RAILTRACK_NW_SW) == AIRail.RAILTRACK_NW_SW) {AIRail.RemoveRailTrack(t, AIRail.RAILTRACK_NW_SW);} 
} else {                                                                                                                     
	if ((AIRail.GetRailTracks(t) & AIRail.RAILTRACK_NE_SW) == AIRail.RAILTRACK_NE_SW) {AIRail.RemoveRailTrack(t, AIRail.RAILTRACK_NE_SW);} 
	if ((AIRail.GetRailTracks(t) & AIRail.RAILTRACK_NW_NE) == AIRail.RAILTRACK_NW_NE) {AIRail.RemoveRailTrack(t, AIRail.RAILTRACK_NW_NE);} 
	if ((AIRail.GetRailTracks(t) & AIRail.RAILTRACK_NE_SE) == AIRail.RAILTRACK_NE_SE) {AIRail.RemoveRailTrack(t, AIRail.RAILTRACK_NE_SE);} 
}
return;
}



// ====================================================== 
//                  BUILD RAIL CONNECTIONS
// ====================================================== 

function CivilAI::BuildALine(a,b, pp, pp2) {

AILog.Info("I'm building a rail line!")


local p1 = null;
local p2 = null;
local bx = null;
local by = null;
local p1a = null;
local p2a = null;
local p1s = null;
local p2s = null;
local p2sig = null;
local p2sig2 = null;
local pcount = 0;
local uphill = 0;
local uptick = 10;
local hoick = null;

//AISign.BuildSign(a[0][0], "a")
//AISign.BuildSign(b[0][0], "b " + BackTrackCounter)

local buildrail = RailPF();
buildrail._max_cost = 10000000;
buildrail._cost_tile = 100;
buildrail._cost_diagonal_tile = 100; // 70;
buildrail._cost_turn = 40; // 50;
buildrail._cost_slope = 300; // 100;
buildrail._cost_bridge_per_tile = 300;
buildrail._cost_tunnel_per_tile = 110; // 120;
buildrail._cost_coast = 100; // 20;
buildrail._max_bridge_length = 60; // 6; !!
buildrail._max_tunnel_length = 20; // 6;

buildrail.InitializePath(a, b);

local built = false;
local path = false;
local i = 0;
local maxtime = TrainRange * 15;
local percount = 0;

while (path == false) {
  path = buildrail.FindPath(20);
  AIController.Sleep(1);
//AILog.Info(i)
   i++
   
if (((i * 10) / maxtime) > percount) {percount++; AILog.Info(percount * 10 + "%");}
   if (i > maxtime) {
   AILog.Info("I couldn't find a path.")
   return;  
   }  
}


local prev = null;
local prevprev = null;
local prevprevprev = null;
local p4prev = null; //!
local p5prev = null; //!


while (path != null) {
  if (prevprev != null) {
    if (AIMap.DistanceManhattan(prev, path.GetTile()) > 1) {
      if (AITunnel.GetOtherTunnelEnd(prev) == path.GetTile()) {
        AITunnel.BuildTunnel(AIVehicle.VT_RAIL, prev);
      } else {
        local bridge_list = AIBridgeList_Length(AIMap.DistanceManhattan(path.GetTile(), prev) + 1);
        bridge_list.Valuate(AIBridge.GetMaxSpeed);
        bridge_list.Sort(AIList.SORT_BY_VALUE, false);
        AIBridge.BuildBridge(AIVehicle.VT_RAIL, bridge_list.Begin(), prev, path.GetTile());
      }
      prevprev = prev;
      prev = path.GetTile();
      path = path.GetParent();
    } else {
      if (AIRail.BuildRail(prevprev, prev, path.GetTile())) {
	  
	  built = true; // we actually managed to build something!
	// AILog.Info("All is fine")
	
	// calculate the hillclimb
	if (hoick == null) {hoick = AITile.GetMaxHeight(prev);}
	if ((AITile.GetMaxHeight(prev) > hoick) &&
		((AIRail.GetRailTracks(prev) == AIRail.RAILTRACK_NE_SW) ||
		(AIRail.GetRailTracks(prev) == AIRail.RAILTRACK_NW_SE))
	) {	
			uphill = uphill + uptick + 5;
			uptick = 10;
			hoick = AITile.GetMaxHeight(prev);
	}
	if ((AITile.GetMaxHeight(prev) < hoick) &&
		((AIRail.GetRailTracks(prev) == AIRail.RAILTRACK_NE_SW) ||
		(AIRail.GetRailTracks(prev) == AIRail.RAILTRACK_NW_SE))	
	) {hoick = AITile.GetMaxHeight(prev);}
	if (uptick > 0) {uptick--;} else {uphill = 0;}
	if (uphill > HillClimb) 
			{HillClimb = uphill; 
			//AISign.BuildSign(prev, HillClimb + "");
	}
	
	
		// find and build a passing place
		if (pp && AIMap.DistanceManhattan(prev, a[0][0]) < AIMap.DistanceManhattan(prev, b[0][0])) {
		// we're halfway there
		
bx = AIMap.GetTileIndex(AIMap.GetTileX(prev)-1,AIMap.GetTileY(prev)+1);
by = AIMap.GetTileIndex(AIMap.GetTileX(prev)+1,AIMap.GetTileY(prev)-1);
		
			if (
			p1 == null &&
			(((AIRail.GetRailTracks(prev) == AIRail.RAILTRACK_NE_SW) &&
			(AITile.GetSlope(prev) == AITile.SLOPE_FLAT) &&
			(AITile.IsBuildableRectangle(bx, 3, 1)) && 		
				((AIRail.GetRailTracks(prevprev) == AIRail.RAILTRACK_NE_SW)	||		
				 (AIRail.GetRailTracks(prevprev) == AIRail.RAILTRACK_NW_SW)	||
				 (AIRail.GetRailTracks(prevprev) == AIRail.RAILTRACK_NW_NE))) 
				 ||
			((AIRail.GetRailTracks(prev) == AIRail.RAILTRACK_NW_SE) &&
			(AITile.GetSlope(prev) == AITile.SLOPE_FLAT) &&
			(AITile.IsBuildableRectangle(by, 1, 3)) &&		
				((AIRail.GetRailTracks(prevprev) == AIRail.RAILTRACK_NW_SE)	||		
				 (AIRail.GetRailTracks(prevprev) == AIRail.RAILTRACK_NW_NE)	||
				 (AIRail.GetRailTracks(prevprev) == AIRail.RAILTRACK_NE_SE)))) 				 
			) {
				
			p1 = prev;
			p1s = prevprev;
			if (AIRail.GetRailTracks(p1) == AIRail.RAILTRACK_NE_SW) { p1a =  AIMap.GetTileIndex(AIMap.GetTileX(p1),AIMap.GetTileY(p1)+1);} 
			else { p1a =  AIMap.GetTileIndex(AIMap.GetTileX(p1)+1,AIMap.GetTileY(p1));} 	
			}	
	
		if (p1 != null && p2 == null) {
		pcount++; 
		//AISign.BuildSign(prev, ".." + pcount);
		}
	
bx = AIMap.GetTileIndex(AIMap.GetTileX(prevprev)-1,AIMap.GetTileY(prevprev)+1);
by = AIMap.GetTileIndex(AIMap.GetTileX(prevprev)+1,AIMap.GetTileY(prevprev)-1);
	
			if (
			pcount > 8 &&
			p2 == null &&
			(((AIRail.GetRailTracks(prevprev) == AIRail.RAILTRACK_NE_SW) &&
			(AITile.GetSlope(prevprev) == AITile.SLOPE_FLAT) &&
			(AITile.IsBuildableRectangle(bx, 3, 1)) && 			
				((AIRail.GetRailTracks(prev) == AIRail.RAILTRACK_NE_SW)	||		
				 (AIRail.GetRailTracks(prev) == AIRail.RAILTRACK_NW_SW)	||
				 (AIRail.GetRailTracks(prev) == AIRail.RAILTRACK_NW_NE))) 
				 ||
			((AIRail.GetRailTracks(prevprev) == AIRail.RAILTRACK_NW_SE) &&
			(AITile.GetSlope(prevprev) == AITile.SLOPE_FLAT) &&
			(AITile.IsBuildableRectangle(by, 1, 3)) && 				
				((AIRail.GetRailTracks(prev) == AIRail.RAILTRACK_NW_SE)	||		
				 (AIRail.GetRailTracks(prev) == AIRail.RAILTRACK_NW_NE)	||
				 (AIRail.GetRailTracks(prev) == AIRail.RAILTRACK_NE_SE))))				 
			) {
			p2sig2 = p4prev;
			p2sig = prevprevprev;	
			p2 = prevprev;
			p2s = prev;
			if (AIRail.GetRailTracks(p2) == AIRail.RAILTRACK_NE_SW) { p2a =  AIMap.GetTileIndex(AIMap.GetTileX(p2),AIMap.GetTileY(p2)+1);} 
			else { p2a =  AIMap.GetTileIndex(AIMap.GetTileX(p2)+1,AIMap.GetTileY(p2));} 
			}	
	
		} else if (pp2) {
		
		// building a passing loop
		
		// signal on the first tile
		pcount++;
		if (pcount == 2) {
		AIRail.BuildSignal(
		prevprev,
		prev,
		AIRail.SIGNALTYPE_PBS_ONEWAY // how do we build semaphores, precious?
		);			
		} 
		if (pcount > 1) {
			if (PassingPlace == null) {
				if (AIRail.BuildRailWaypoint(prev)) {
				PassingPlace = prev;
				}
			}		
		}		
		}	
	
	  } else {
			if (AIError.GetLastError() == AIError.ERR_VEHICLE_IN_THE_WAY) {
			AILog.Info("A vehicle was in the way!")
			local c = 0;
			
			while (c < 10) {			
			AIController.Sleep(10);
			AILog.Info("Retrying...")
			c++;
			if (AIRail.BuildRail(prevprev, prev, path.GetTile())) {break;}			
			}
			if (c == 10) {AILog.Info("It's all gone wrong..."); return false;}
			
			} else {
			
			if (AIError.GetLastError() == AIError.ERR_AREA_NOT_CLEAR) {
			AITile.DemolishTile(prev);
			//AISign.BuildSign(prev, "boom");
			}
			
			if ((BackTrackCounter < 5) && (p5prev != null)) {
									BackTrackCounter++;	
									AITile.DemolishTile(prevprev);
									AITile.DemolishTile(prevprevprev);
									AITile.DemolishTile(p4prev);
									
						// abort if we're going to end at bridge or tunnel
							if(AITunnel.IsTunnelTile(p4prev) || AIBridge.IsBridgeTile(p4prev)){
									BackTrackCounter = 0;
									AILog.Info("It's all gone wrong...");
									return false;	
								}
									
									
						local retar;			
						local p4grid = [AIMap.GetTileX(p4prev),AIMap.GetTileY(p4prev)];
						local p5grid = [AIMap.GetTileX(p5prev),AIMap.GetTileY(p5prev)];			
								
						if (p4grid[0] == p5grid[0]) {
								// retrying on the x axis
								AIRail.BuildRailTrack(p4prev, AIRail.RAILTRACK_NW_SE)
								if (p4grid[1] > p5grid[1]) {
								retar = AIMap.GetTileIndex(p4grid[0],p4grid[1] + 1);
								} else {
								retar = AIMap.GetTileIndex(p4grid[0],p4grid[1] - 1);
								}
						} else {
								// retrying on the y axis
								AIRail.BuildRailTrack(p4prev, AIRail.RAILTRACK_NE_SW)
								if (p4grid[0] > p5grid[0]) {
								retar = AIMap.GetTileIndex(p4grid[0] + 1,p4grid[1]);
								} else {                            
								retar = AIMap.GetTileIndex(p4grid[0] - 1,p4grid[1]);
								}
						}		
									
									if (BuildALine(a, [[retar, p4prev]], pp, pp2)) {return true;} else {return false;} // recursive much?
									} else {			
									BackTrackCounter = 0;
									AILog.Info("It's all gone wrong...");
									return false;	
			}
		}	
	  }
	}

  }
  if (path != null) {
	p5prev = p4prev;
  	p4prev = prevprevprev;
	prevprevprev = prevprev;
    prevprev = prev;
    prev = path.GetTile();
    path = path.GetParent();
  }
}

if (pp && p1 != null && p2 != null) {
// build our passing place

AITile.LevelTiles(p1, p1a);	
AITile.LevelTiles(p2, p2a);	

//AISign.BuildSign(p1, "p1");
//AISign.BuildSign(p2, "p2");
//AISign.BuildSign(p1s, "p1s");
//AISign.BuildSign(p1a, "p1a");
//AISign.BuildSign(p2s, "p2s");
//AISign.BuildSign(p2a, "p2a");

if (BuildALine([[p2a, p2]],[[p1a, p1]],false,true)) {

if (PassingPlace != null) {

// build spurs
AIRail.BuildRail(p1s, p1, p1a);
AIRail.BuildRail(p2s, p2, p2a);

// check for kinky connectors 
local sharpturns = AIGameSettings.GetValue("pf.forbid_90_deg");

if ((sharpturns == 1) &&
(
(((AIRail.GetRailTracks(p1) & AIRail.RAILTRACK_NW_SW) == AIRail.RAILTRACK_NW_SW) && (AIRail.GetRailTracks(p1a) == AIRail.RAILTRACK_NW_NE)) ||
(((AIRail.GetRailTracks(p1) & AIRail.RAILTRACK_SW_SE) == AIRail.RAILTRACK_SW_SE) && (AIRail.GetRailTracks(p1a) == AIRail.RAILTRACK_NW_SW)) ||
(((AIRail.GetRailTracks(p1) & AIRail.RAILTRACK_SW_SE) == AIRail.RAILTRACK_SW_SE) && (AIRail.GetRailTracks(p1a) == AIRail.RAILTRACK_NE_SE)) ||
(((AIRail.GetRailTracks(p1) & AIRail.RAILTRACK_NE_SE) == AIRail.RAILTRACK_SW_SE) && (AIRail.GetRailTracks(p1a) == AIRail.RAILTRACK_NW_SW)) ||
(((AIRail.GetRailTracks(p2) & AIRail.RAILTRACK_NW_SW) == AIRail.RAILTRACK_NW_SW) && (AIRail.GetRailTracks(p2a) == AIRail.RAILTRACK_NW_NE)) ||
(((AIRail.GetRailTracks(p2) & AIRail.RAILTRACK_SW_SE) == AIRail.RAILTRACK_SW_SE) && (AIRail.GetRailTracks(p2a) == AIRail.RAILTRACK_NW_SW)) ||
(((AIRail.GetRailTracks(p2) & AIRail.RAILTRACK_SW_SE) == AIRail.RAILTRACK_SW_SE) && (AIRail.GetRailTracks(p2a) == AIRail.RAILTRACK_NE_SE)) ||
(((AIRail.GetRailTracks(p2) & AIRail.RAILTRACK_NE_SE) == AIRail.RAILTRACK_SW_SE) && (AIRail.GetRailTracks(p2a) == AIRail.RAILTRACK_NW_SW))
)
){
//remove the siding
AILog.Info("Kinky passing place detected, removing it.")
RemoveTracks(AIMap.GetTileIndex(AIMap.GetTileX(PassingPlace) + 0,  AIMap.GetTileY(PassingPlace) - 1), 0)
RemoveTracks(AIMap.GetTileIndex(AIMap.GetTileX(PassingPlace) - 1,  AIMap.GetTileY(PassingPlace) + 0), 1)
RemoveTracks(AIMap.GetTileIndex(AIMap.GetTileX(PassingPlace) + 0,  AIMap.GetTileY(PassingPlace) + 1), 2)
RemoveTracks(AIMap.GetTileIndex(AIMap.GetTileX(PassingPlace) + 1,  AIMap.GetTileY(PassingPlace) + 0), 3)
AITile.DemolishTile(PassingPlace);
PassingPlace = null;

} else {
		AIRail.BuildSignal(
		p2sig,
		p2sig2,
		AIRail.SIGNALTYPE_PBS_ONEWAY // how do we build semaphores, precious?
		);	
}
} else {
// we failed to build a waypoint, so remove the passing place tracks
RemoveTracks(p1a, 2);
RemoveTracks(p1a, 3);
}
}
}



//AILog.Info("I've finished rail building for now.")
return built;
}



 // That's all folks.



