// ====================================================== 
// ====================================================== 
// 			  TTTTT RRRR     A    I  N   N  ZZZZZ
// 			    T   R   R   A A   I  NN  N	   Z
// 			    T   R  R   A   A  I  N N N    Z
//  		    T   RRRR   AAAAA  I  N  NN   Z
//  		    T   R   R  A   A  I  N   N  ZZZZZ (for passengers!)
// ===========================================ChooChoo!== 
// ====================================================== 


function CivilAI::ChooChoo2() {

if (AIGameSettings.IsDisabledVehicleType(AIVehicle.VT_RAIL)) {
AILog.Info("I'm not allowed to build trains, boo.");
return; // no trains for us
}

AILog.Info("I'm thinking about passenger trains...");

// extend an existing line?


// build a new line?
//pair cities to find a desirable link

local townlist = AIList();
local bslist = AIList();
local tslist = AIList();
local skip = false;

// make a list of serviced towns (ie with bus stops)
bslist = AIStationList(AIStation.STATION_BUS_STOP);
foreach (stat,z in bslist) {
townlist.AddItem(AIStation.GetNearestTown(stat), 0);
}

local minscore = 75;
local score = 0;
local bestscore = 0;
local best1 = null;
local best2 = null;
local test = null;
local existingstation = null;

while (townlist.Count() > 1) {
test = townlist.Begin();
townlist.RemoveItem(test);

// --- skip towns which already have stations
skip = false;
bslist = AIStationList(AIStation.STATION_BUS_STOP);
foreach (stat,z in bslist) {
if (AIStation.GetNearestTown(stat) == test && AIStation.HasStationType(stat,AIStation.STATION_TRAIN)) { skip = true; break; }
}

if (!skip) {

foreach (town, z in townlist) {
// score the town pairs

// skip towns too close together
if (AITile.GetDistanceManhattanToTile(AITown.GetLocation(test), AITown.GetLocation(town)) > 32) {

score = ((AITown.GetPopulation(test) + AITown.GetPopulation(town)) / AITile.GetDistanceManhattanToTile(AITown.GetLocation(test), AITown.GetLocation(town)))

// add bonus for existing station in town 2
bslist = AIStationList(AIStation.STATION_BUS_STOP); 
bslist.Valuate(AIStation.GetNearestTown);
bslist.KeepValue(town);
foreach (bs, z in bslist) {
if (AIStation.HasStationType(bs,AIStation.STATION_TRAIN)) {
score = score + 50;
existingstation = bs;
break;
} else { existingstation = null; }
}
// AILog.Info ("Scored " + AITown.GetName(test) + " -> " + AITown.GetName(town) + " " + score); 
if ((score > bestscore) && (score > minscore)) { bestscore = score; best1 = test; best2 = town;}
}
}
}
}

if (best1 != null) {
AILog.Info ("Selected " + AITown.GetName(best1) + " -> " + AITown.GetName(best2) + " (" + bestscore + ") to build a passenger line."); 

PaxLine(best1, best2, existingstation);

}

}