//Build functions based on VectorCoordinates and relative positions

//Build piece of rail
function BuildRail(coords, prev, start, to) {
	if (AIRail.BuildRail(VC.GetTile(coords, prev), VC.GetTile(coords, start), VC.GetTile(coords, to)))
		return true
	if (AITile.GetOwner(VC.GetTile(coords, start)) == AICompany.COMPANY_INVALID) {
		//no company, destroy the tile and try again to build the rail!
		if (AITile.DemolishTile(VC.GetTile(coords, start)))
			LogTile("I destroyed whatever was built on ", VC.GetTile(coords, start))
		if (AIRail.BuildRail(VC.GetTile(coords, prev), VC.GetTile(coords, start), VC.GetTile(coords, to)))
			return true
	}
	LogTile("Failed building rail at ", VC.GetTile(coords, start))
	return false
}

//Remove piece of rail
function RemoveRail(coords, prev, start, to) {
	if (AIRail.RemoveRail(VC.GetTile(coords, prev), VC.GetTile(coords, start), VC.GetTile(coords, to)))
		return true
	LogTile("Failed removing rail at ", VC.GetTile(coords, start))
	return false
}

//Build Path Signal
function BuildPSignal(coords, prev, start) {
	if (AIRail.GetSignalType(VC.GetTile(coords, start), VC.GetTile(coords, prev)) != AIRail.SIGNALTYPE_NONE)
		return true
	return AIRail.BuildSignal(VC.GetTile(coords, start), VC.GetTile(coords, prev), AIRail.SIGNALTYPE_PBS);
}

//Build Train Depot
function BuildDepot(coords, prev, start) {
	//Ensure that the depot is actually built, we need it in test mode too
	local execute = AIExecMode()
	local location = VC.GetTile(coords, start)
	if (AIRail.BuildRailDepot(location, VC.GetTile(coords, prev))) {
		ConnectDepot(location)
		return location
	}
	return false
}