﻿function RailwAI::GetCompanyAge() {
	return AIDate.GetYear(AIDate.GetCurrentDate()) - this.yearFounded
}

function RailwAI::SetCompanyName()
{
	//Prefixes, names and suffixes. Length of arrays must be relative prime for randomness
	local company_name_tags = ["Acita", "Advanced", "Allegro", "Arco", "Atlantic", "Babel", "Bimdz", "Bright", "Bonus", "Beta", "Bold",
	"Cantus", "Candide", "Cape", "Capital", "Central", "Civil", "City", "Cloud", "Crossing", "Continental", "Crisp", "Clear", "Cursor", "Circle", "Cruise",
	"DB", "Daily", "Dash", "Driade", "El Paso", "Empire", "Eureka", "Euro", "Ever",
	"Fair", "Fast", "Ferro", "Flakey", "Floss", "Freight", "Fresh", "GW", "Global", "Grand", "Great", "Green",
	"Happy", "Heavy", "Hello", "Hugo", "Husa", "Ice", "Independent", "Interchange", "International", "Italic", "Jaranja",
	"Kale", "Key", "Kingdom", "Light", "Local", "Lux", "Magneta", "Main", "Metropolitan",
	"NADH", "National", "New", "Northwest", "Novel", "Odd", "Open", "Oliveira", "Oak",
	"People", "Pear", "Penta", "Piezo", "Power", "Public", "Quick", "Quark", "Quinoa", "RAI", "Rapid", "Regional", "Rocky", "Rolling", "Royal",
	"Sharp", "Short", "Southern", "Stark", "State", "Strawberry", "Summit", "Super", "Synco",
	"Township", "Turbo", "Triangle", "Union", "United", "Universal", "Vivace", "Vivid", "Wave", "WeGo", "World",
	"XRail", "Yellow", "Your", "Youro", "ZeeZone", "Zebra"] //117
	local company_names = [" Connect", " Avia", " Express", " Logistics", " Pacific", " Network", 
		" Services", " Midnet", " Forward", " Line", " Routes", " Link", " Moves", " Motion", " Metro", 
		" Cargo", "Haul", " Carrier", " Transport",
		" Shipping", " Bus",
		" Rail Force", " Railroad", " Rail", " Train", " Bahn", " Railz",  " Railways"] //28
	local company_name_suffixes = [" AI", " AB", " ApS", " AG", " B.V.", " BVBA", " d.d.", " d.o.o.", " GmbH", " Group", " Inc.", " Ltd.", " plc", " S.A.", " s.p.a.", " S.A.R.L.",  "", "", "", "", "", "", "", "", "", "", "", "", ""] //29
	
	local companyId = AICompany.ResolveCompanyID(AICompany.COMPANY_SELF)
	
	//Requesting a few random numbers before actually doing something has positive influence on the randomness
	local i = AIBase.RandRange(20000000);
	i = AIBase.RandRange(20000000);
	i = AIBase.RandRange(20000000)+companyId;
	local a = company_name_tags.len()
	local b = company_names.len()
	local c = company_name_suffixes.len()
	local nameset = false
	while (!nameset) {
		local name = company_name_tags[i % a] + company_names[i % b] + company_name_suffixes[i % c]
		nameset = AICompany.SetName(name)
		//check if we like this company name, otherwise we can discard it
		if (nameset) {
			for (local j = 0; j < companyId; j++) {
				local theirName = AICompany.GetName(j) + "    "
				if (theirName && name.find(theirName.slice(0,4))) { //names are too similar
					nameset = false
				}
			}
		}
		if (nameset) {
			if (name.find("Cargo") || name.find("Power") || name.find("Carrier") || name.find("Transport") || name.find("Haul")
			 || name.find("Heavy") || name.find("Turbo") || name.find("Freight") || name.find("Magneta") || name.find("Force")) {
				if (RailwAI.GetSetting("use_cargo"))
					this.chances[CARGO] = 9
				else
					nameset = false
			} else if (name.find("Metro") || name.find("Midnet") || name.find("Express") || name.find("Regional") || name.find("Local")
			 || name.find("City") || name.find("Town") || name.find("eople") || name.find("We")) {
				if (RailwAI.GetSetting("use_pass"))
					this.chances[PASS] = 9
				else
					nameset = false
			}
			if (name.find("ail") || name.find("ain") || name.find("Bahn")) {
				if (RailwAI.GetSetting("use_trains"))
					this.chances[RAIL] = 9
				else
					nameset = false
			} else if (name.find("Bus")) {
				if (RailwAI.GetSetting("use_road"))
					this.chances[ROAD] = 9
				else
					nameset = false
			} else if (name.find("Ship") || name.find("Wave")) {
				if (RailwAI.GetSetting("use_ships"))
					this.chances[SHIP] = 9
				else
					nameset = false
			}
			
			
		}
		i = AIBase.RandRange(20000000)+companyId;
	}

}