function GetBankBalance() {
	local me = AICompany.ResolveCompanyID(AICompany.COMPANY_SELF);
	return AICompany.GetBankBalance(me);
}

function MayBuyTrain() {
	return (GetMaximumAmountCash() > 50000)
}
function MayExtendRailway() {
	return (GetMaximumAmountCash() > 30000)
}
function MayCreateNewRailway() {
	return (GetMaximumAmountCash() > 180000)// || (AIVehicleList().Count() < 2)
}
function MayCreateNewBusline() {
	return (GetMaximumAmountCash() > 30000)
}

function MayCreateNewShippingLine() {
	return ((AIVehicleList().Count() > 2 || (!RailwAI.GetSetting("use_road") && !RailwAI.GetSetting("use_trains")) || AICompany.GetMaxLoanAmount() < 200000)
	&& (GetMaximumAmountCash() > 30000))
}

function MayDoExpensiveStuff() {
	return (GetBankBalance() > 200000 && AICompany.GetLoanAmount() < 100000)
}
function MayDoVeryExpensiveStuff() {
	return (GetBankBalance() > 5000000 && AICompany.GetLoanAmount() < 100000)
}

function GetMaximumAmountCash() {
	return GetBankBalance() + AICompany.GetMaxLoanAmount() - AICompany.GetLoanAmount()
}

function GetQuarterlyProfit() {
	//profit = income (positive) + expenses (negative number)
	return AICompany.GetQuarterlyIncome(AICompany.COMPANY_SELF, 1) + AICompany.GetQuarterlyExpenses(AICompany.COMPANY_SELF, 1)
}

function RailwAI::DetermineLoan() {
	local bankBalance = GetBankBalance()
	local maxLoan = AICompany.GetMaxLoanAmount()
	if (bankBalance > maxLoan*2) {
		//Pay back loans
		AICompany.SetMinimumLoanAmount(0)
	} else {
		AICompany.SetLoanAmount(maxLoan)
	}
}

function RailwAI::MonthlyPayBack() {
	local bankBalance = GetBankBalance()
	if (bankBalance < 0) {
		AICompany.SetLoanAmount(AICompany.GetLoanAmount() + AICompany.GetLoanInterval())
	} else {
		AICompany.SetLoanAmount(AICompany.GetLoanAmount() - AICompany.GetLoanInterval())
	}
}

function GetFinancialBuffer() {
	//10.000 + 2 years of interest + 1000/500 per vehicle 
	local numVehicles = AIVehicleList().Count()
	if (numVehicles == 0)
		return AICompany.GetLoanAmount() / 2 //less risk during the begin of the game
	local buffer = 10000 + AICompany.GetLoanAmount()/25
	if (numVehicles > 40)
		buffer += 500 * numVehicles + 500*40
	else
		buffer += 1000 * numVehicles
	return buffer
}
function RailwAI::EnlargeFinancialBuffer() {
	//nothing
}

//maximize loan
function RailwAI::SetMaxLoan() {
	AICompany.SetLoanAmount(AICompany.GetMaxLoanAmount())
}

function IncreaseLoan() {
	if (GetBankBalance() < 8*AICompany.GetLoanInterval())
		AICompany.SetLoanAmount(AICompany.GetLoanAmount() + 4*AICompany.GetLoanInterval())
}

function SetRequiredIdeaLoan(vehicleType) {
	local maxPrice = 0
	local list = AIEngineList(AIVehicle.VT_ROAD)
	for (local engine = list.Begin(); list.HasNext(); engine = list.Next()) {
		local price = AIEngine.GetPrice(engine)
		if (price > maxPrice)
			maxPrice = price
	}
	local requestedLoan = maxPrice + AICompany.GetLoanAmount() - GetBankBalance()
	if (requestedLoan < 0) return
	if (AICompany.GetMaxLoanAmount() > requestedLoan) {
		SetMaxAllowedLoan()
		return
	}
	AICompany.SetMinimumLoanAmount(requestedLoan)
}

function SetMaxAllowedLoan() {
	local real = AIExecMode()
	if (GetBankBalance() > 10*AICompany.GetMaxLoanAmount()) {
		AICompany.SetLoanAmount(0) //I'm 100% sure we don't need the loan.
	} else {
		AICompany.SetLoanAmount(AICompany.GetMaxLoanAmount() - (GetFinancialBuffer() / AICompany.GetLoanInterval()) * AICompany.GetLoanInterval())
		if (GetBankBalance() > 10*AICompany.GetLoanAmount()) {
			AICompany.SetLoanAmount(0) //I'm 100% sure we don't need the loan.
		}
	}
}

function RailwAI::SetMinLoan() {
	while (GetBankBalance() > AICompany.GetLoanInterval() && AICompany.GetLoanAmount() > 0) {
		AICompany.SetLoanAmount(AICompany.GetLoanAmount() - AICompany.GetLoanInterval())
	}
	if (GetBankBalance() < 0) {
		AICompany.SetLoanAmount(AICompany.GetLoanAmount() + AICompany.GetLoanInterval())
	}
}