﻿/**
 * A Land Pathfinder, forked from the default pathfinder
 *  This land pathfinder tries to find a connection with a maximum of n water tiles.
 * this can be used to check whether tow locations are connected by land
 */
 require("aystarw2.nut")
class Land
{
	_estimate_multiplier = 1.6;
	_max_cost = null;              ///< The maximum cost for a route.
	_cost_water = null;            ///< The extra cost for a water tile.
	_pathfinder2 = null;            ///< A reference to the used AyStar object.

	cost = null;                   ///< Used to change the costs.
	_running = null;

	constructor()
	{
		this._estimate_multiplier = 1;
		this._max_cost = 50000; //default: 5 times water is too much
		this._cost_water = 10000;
		this._pathfinder2 = AyStarW2(this, this._Cost, this._Estimate, this._Neighbours);
		this.cost = this.Cost(this);
		this._running = false;
	}

	function InitializePath(source, goal, ignored_tiles = []) {
		this._pathfinder2.InitializePath([source, 0xFF], goal, ignored_tiles);
	}
	
	function FindPath(iterations);
};

class Land.Cost {
	_main = null;

	function _set(idx, val)	{
		if (this._main._running) throw("You are not allowed to change parameters of a running pathfinder.");
		switch (idx) {
			case "multiplier":        this._main._estimate_multiplier = val; break;
			case "max_cost":          this._main._max_cost = val; break;
			case "water":             this._main._cost_water = val; break;
			default: throw("the index '" + idx + "' does not exist");
		}
		return val;
	}

	function _get(idx) {
		switch (idx) {
			case "multiplier":        return this._main._estimate_multiplier;
			case "max_cost":          return this._main._max_cost;
			case "water":             return this._main._cost_water;
			default: throw("the index '" + idx + "' does not exist");
		}
	}
	
	constructor(main) {
		this._main = main;
	}
};

function Land::FindPath(iterations)
{
	local test_mode = AITestMode();
	local ret = this._pathfinder2.FindPath(iterations);
	this._running = (ret == false) ? true : false;
	return ret;
}

function Land::_Cost(self, path, new_tile, new_direction)
{
	if (path == null) return 0; //first node
	// Check if the new tile is a water tile.
	if (IsAWaterTile(new_tile)) {
		return path.GetCost() + self._cost_water;
	}
	return path.GetCost() + 1;
}

function Land::_Estimate(self, cur_tile, cur_direction, goal)
{
	return AIMap.DistanceSquare(cur_tile, goal) * self._estimate_multiplier //manhattan performs way worse
}

function Land::_Neighbours(self, path, cur_node)
{
	/* self._max_cost is the maximum path cost, if we go over it, the path isn't valid. */
	if (path.GetCost() >= self._max_cost) return [];
	return [ [cur_node+dXY(0,1), 1],[cur_node+dXY(1,0), 1],[cur_node+dXY(0,-1), 1],[cur_node+dXY(-1,0), 1] ]
}

