﻿function RailwAI::AdjustInhabitantsPerBusStop(adjustment) {
	this.inhabitantsPerBusStop += adjustment
	if (this.inhabitantsPerBusStop < 200)
		this.inhabitantsPerBusStop = 250
	if (this.inhabitantsPerBusStop > 1000)
		this.inhabitantsPerBusStop = 1000
}
function RailwAI::AdjustMaxDistanceTrainStations(adjustment) {
	this.maxDistanceTrainStations += adjustment
	if (this.maxDistanceTrainStations < 160)
		this.maxDistanceTrainStations = 240
	if (this.maxDistanceTrainStations > 4000)
		this.maxDistanceTrainStations = 4000
	Log ("Maximum distance between train stations is now " + this.maxDistanceTrainStations, "strategy")
}

function AreTrainsFeasible() {
	return RailwAI.GetSetting("use_trains") && GetQuarterlyProfit() > 90000 //maximum 1 year to earn enough money for a train line
	
}

function ShouldCreateNewRailway() {
	if (MayCreateNewRailway())
		return true
	return false
}
function ShouldCreateNewBusline() {
	if (MayCreateNewBusline()) {
		return ShouldUseRoad()
	}
	return false
}
function ShouldUseRoad() {
	if (AreTrainsFeasible() && AIStationList(AIStation.STATION_TRUCK_STOP).Count() + AIStationList(AIStation.STATION_BUS_STOP).Count() > 
		7+AIStationList(AIStation.STATION_TRAIN).Count()*3/2) return false
	return true
}

function ShouldUseCargo() {
	return true //always!
}

function ShouldCreateNewShippingLine() {
	if (MayCreateNewShippingLine()) {
		if (AreTrainsFeasible() && AIStationList(AIStation.STATION_DOCK).Count() > 6+2*AIStationList(AIStation.STATION_TRAIN).Count()) return false
		return true
	}
	return false
}