class TREE extends AIController
{
   constructor()
   {
   } 
}
 
 
function TREE::Start()
{
    AILog.Info("TREE Started.");
    SetCompanyName();
    local tile;
    local starttile;
    while (true)
    {
        local count = 0;
        for (starttile=0;starttile<4096;starttile++)
        {
            for (tile=starttile;tile<=AIMap.GetMapSize();tile+=4096)
            {
                if (
                    AIMap.IsValidTile(tile) &&
                    AITile.IsBuildable(tile) &&
                    !AITile.IsWaterTile(tile) &&
                    !AITile.IsRoughTile(tile) &&
                    !AITile.IsRockTile(tile) &&
                    !AITile.IsFarmTile(tile) &&
                    !AIBase.RandRange(TREE.GetSetting("treechance")) &&
                    !(AITile.GetSlope(tile) && AIBase.RandRange(TREE.GetSetting("slopechance"))) &&
                    !(AITile.IsDesertTile(tile) && AIBase.RandRange(TREE.GetSetting("desertchance")))
                )
                {
                    while (AICompany.GetBankBalance(AICompany.COMPANY_SELF)<100000)
                    {
                        AILog.Info("Waiting a day for more money.");
                        this.Sleep(74);
                    }
                    AITile.PlantTree(tile);
                    count++;
                }
            }
            if (!(starttile%64))
            {
                AILog.Info("Processing ("+starttile/64+"/64) Planted "+count+" trees so far.");
            }
            this.Sleep(TREE.GetSetting("ticksbetweentry"));
        }
        AILog.Info("Whole map processed. Planted "+count+" trees. Sleeping for some time.");
        this.Sleep(1000);
    }
}
 
function TREE::Save()
{
   local table = {};	
   //TODO: Add your save data to the table.
   return table;
}
 
function TREE::Load(version, data)
{
   AILog.Info(" Loaded");
   //TODO: Add your loading routines.
}
 
 
function TREE::SetCompanyName()
{
    if(!AICompany.SetName("TREE")) {
        local i = 2;
        while(!AICompany.SetName("TREE #" + i)) {
            i = i + 1;
            if(i > 255) break;
        }
    }
    AICompany.SetPresidentName("T. R. E. E.");
}

