/* -*- Mode: C++; tab-width: 6 -*- */ 

/*
 *
 * This file is part of Script Communication Protocol (shorten to SCP), which are libraries for OpenTTD NoAI and NoGO
 * Copyright (C) 2012 Krinn <krinn@chez.com> & Zuu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

class _SCPLib_Events extends SCPEventController
{
}

function _SCPLib_Events::NextEvent(event)
// We process an event an instance of (GS/AI)EventController.GetNextEvent()
{
	local eventType = event.GetEventType();
	local needUpdate=(eventType==SCPEvent.ET_COMPANY_NEW || eventType==SCPEvent.ET_COMPANY_BANKRUPT);
	if (needUpdate)	_SCPLib_Client.UpdateCompanyList();
}

function _SCPLib_Events::HandleEvents()
{
	if (_SCPLib_Client.Configuration[5] == 0)	return;
	while (SCPEventController.IsEventWaiting())
		{
		local event=SCPEventController.GetNextEvent(); // force event pop, the handling itself will be done with _SCPLib_Events.NextEvent()
		}
}

