/* 
 *	Copyright 2013 Varen De Meersman
 *  This file is part of MailAI.
 *
 *  MailAI is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MailAI is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with MailAI.  If not, see <http://www.gnu.org/licenses/>.
 */
 
class TownManager {
	constructor() {}
}

function TownManager::GetHalfTileList(town_tile,dir) {
	local SE = 11, SW = 11, NE = -11, NW = -11;//11 is looking distance
	if(!AIMap.IsValidTile(town_tile+AIMap.GetTileIndex(NE,0)))NE=-2;if(!AIMap.IsValidTile(town_tile+AIMap.GetTileIndex(0,NW)))NW=-2;
	if(!AIMap.IsValidTile(town_tile+AIMap.GetTileIndex(SW,0)))SW=2;if(!AIMap.IsValidTile(town_tile+AIMap.GetTileIndex(0,SE)))SE=2;
	switch (dir) {
		case "NE":SW = 0;break;	case "SW":NE = 0;break;
		case "SE":NW = 0;break;	case "NW":SE = 0;break;
	    default: throw("Wrong direction in GetHalfTileList! ")+dir;
	}
	local tl = AITileList();
	tl.AddRectangle(town_tile + AIMap.GetTileIndex(NE, NW), town_tile + AIMap.GetTileIndex(SW, SE));
	return tl;
}

function TownManager::GetQuadrantTileList(town_tile,dir) {
	local SE = 11, SW = 11, NE = -11, NW = -11;//11 is looking distance
	if(!AIMap.IsValidTile(town_tile+AIMap.GetTileIndex(NE,0))){NE=-2;}
	if(!AIMap.IsValidTile(town_tile+AIMap.GetTileIndex(0,NW))){NW=-2;}
	if(!AIMap.IsValidTile(town_tile+AIMap.GetTileIndex(SW,0))){SW=2;}
	if(!AIMap.IsValidTile(town_tile+AIMap.GetTileIndex(0,SE))){SE=2;}
	switch (dir) {
		case "NE":SW = 0;SE = 0;break;
		case "SW":NE = 0;NW = 0;break;
		case "SE":NW = 0;SW = 0;break;
		case "NW":SE = 0;NE = 0;break;
	    default: throw("Wrong direction in GetQuadrantTileList! "+dir);
	}
	local tl = AITileList();
	tl.AddRectangle(town_tile+AIMap.GetTileIndex(NE,NW),town_tile+AIMap.GetTileIndex(SW,SE));
	tl.RemoveRectangle(town_tile+AIMap.GetTileIndex(-2,-2),town_tile+AIMap.GetTileIndex(2,2));
	//if(dir=="SE" || dir=="SW"){foreach(t, _ in tl) {MailAI.BuildSign(t,".");}}
	return tl;
}

function TownManager::xxxxxRAILxFUNCTIONSxxxxx(){}

/**
*	True if existing station in town needs help or no train stations in town
*/
function TownManager::CanBuildNewTrainStation(town_id1, town_id2) {
	local station_list = AIStationList(AIStation.STATION_TRAIN);
	station_list.Valuate(AIStation.GetNearestTown);
	station_list.KeepValue(town_id1);
	if(station_list.IsEmpty()) {return true;}
	foreach(station, _ in station_list) {
		if(AIStation.GetDistanceManhattanToTile(station, AITown.GetLocation(town_id2))
			> AITown.GetDistanceManhattanToTile(town_id1, AITown.GetLocation(town_id2))
		&& AITown.GetPopulation(town_id1) > (station_list.Count() * MailAI.min_long_rail_population) ) {	
			return true;
		}
	}
	return false;	
}

function TownManager::GetExpandingTrainStopConnection(town_id1, town_id2) {
	local station_list = AIStationList(AIStation.STATION_TRAIN);
	station_list.Valuate(AIStation.GetNearestTown); station_list.KeepValue(town_id1);
	foreach(station, _ in station_list) {
		if(!AICompany.IsMine(AITile.GetOwner(AIStation.GetLocation(station)))){continue;}
		if(AIStation.GetDistanceManhattanToTile(station, AITown.GetLocation(town_id2))
		> AITown.GetDistanceManhattanToTile (town_id1, AITown.GetLocation(town_id2))) {return null;}
		if(StationManager.NeedsExtraService(station,AIVehicle.VT_RAIL)) {
			local tile_pair = StationManager.SelectRightTrackOutOfStation(AIStation.GetLocation(station));
			return [tile_pair[0],tile_pair[1],AIStation.GetLocation(station)];			
		}
	}
	return null;
}

function TownManager::GetTrainStationOptions(town_tile,dir,side_dir) {
	local tile_list = TownManager.GetHalfTileList(town_tile,dir);
	if(tile_list==null || side_dir==null){throw("null in gettrainstationoptions");}
	local possibles = [];
	tile_list.Valuate(Valuator.IsGoodForTrainStation); tile_list.RemoveValue(0);
	tile_list.Sort(AIList.SORT_BY_VALUE,false);
	if(tile_list.Count()==0){MailAI.Info(0,"no good coverage tiles");return possibles;}
	local x_start = 0, x_end = 0, y_start = 0, y_end = 0, xs = 0, xe = 0, ys = 0, ye = 0, swx, swy;
	switch (dir) {//5 for check length (6), 2 and 1 for station (is 3*2)
	    case "NE": {x_start = -5; xs = -2; y_start = -1; ys = -1; swx = -3; swy = -1; break;}
	    case "SW": {x_end = 5; xe = 2; y_end = 1; ye = 1; swx = 3; swy = 1; break;}
	    case "SE": {x_start = -1; xs = -1; y_end = 5; ye = 2; swx = -1; swy = 3; break;}
	    case "NW": {x_end = 1; xe = 1; y_start = -5; ys = -2; swx = 1; swy = -3; break;}
	    default: throw("Wrong direction in GetTrainStationOptions!"+dir);
	} 						
	foreach(tile, value in tile_list) {
		local check_list = AITileList();
		check_list.AddRectangle(tile+AIMap.GetTileIndex(x_start,y_start),tile+AIMap.GetTileIndex(x_end,y_end));
		check_list.Valuate(AIRoad.IsRoadTile); check_list.RemoveValue(0);
		if(check_list.Count() > 2) {continue;}
		check_list.AddRectangle(tile+AIMap.GetTileIndex(x_start,y_start),tile+AIMap.GetTileIndex(x_end,y_end));
		check_list.Valuate(AIRoad.IsRoadTile); check_list.RemoveValue(1);//2 roads we can try to demolish later
		check_list.Valuate(AITile.IsBuildable); check_list.RemoveValue(1);//tiles need to be buildable
		if(check_list.Count() > 1) {continue;}
		local start_tile = tile + AIMap.GetTileIndex(xs, ys);//topleft corner of station
		check_list.AddRectangle(start_tile,tile+AIMap.GetTileIndex(xe,ye));//3*2 station		
		check_list.Valuate(Tile.IsAlmostFlat); check_list.RemoveValue(1);
		if(check_list.Count() > 0){continue;}//at least station completely flat
		local switch_tile = tile + AIMap.GetTileIndex(swx, swy);
		//MailAI.BuildSign(start_tile,value+"");
		possibles.append([start_tile,switch_tile,dir,side_dir
			,tile+AIMap.GetTileIndex(xs,ys),tile+AIMap.GetTileIndex(xe,ye)]);							
	}
	return possibles;
}

function TownManager::GetAdjacentRoadStationTiles(train_tile) {
	local tile_list = StationManager.GetSurroundingTiles(train_tile);
	if(tile_list.IsEmpty()){MailAI.Info(0,"surrounding returning null");return null;}
	local return_list = AITileList();
	foreach(station_tile, _ in tile_list) {
		local connect_tiles = Tile.GetAdjacentTiles(station_tile);
		connect_tiles.Valuate(Valuator.CanRoadConnectToAlmostFlatTile,station_tile);
		connect_tiles.KeepValue(1);
		if(connect_tiles.Count() > 0) {return_list.AddTile(station_tile);}
		if(AIRoad.IsRoadTile(station_tile) && Tile.IsAlmostFlat(station_tile)){
			//a flat road tile should be good for drivethrough stations as well
			return_list.AddTile(station_tile);
		}
	}//end foreach tile around station	
	if(return_list.Count() < 4) {//add tiles without road access
		foreach(t, _ in tile_list) {
			if(Tile.IsBuildableAlmostFlatTile(t)) {return_list.AddTile(t);}
		}
	}
	return_list.Valuate(AITile.GetCargoProduction, MailAI.GetMailID(), 1, 1, AIStation.GetCoverageRadius (AIStation.STATION_TRAIN));
	return_list.Sort(AIList.SORT_BY_VALUE,false);
	return return_list;
}

function TownManager::xxxxxROADxFUNCTIONSxxxxx(){}

function TownManager::HasTruckStopPotential(town_id) {
	if(TownManager.GetFirstTruckStopToExpand(town_id) != null) {
		return true;
	}
	if(!TownManager.GetNewTruckStopList(town_id,false).IsEmpty()) {
		return true;
	}
	return false;
}

function TownManager::GetFirstTruckStopToExpand(town) {
	local station_list = AIStationList(AIStation.STATION_TRUCK_STOP);
	station_list.Valuate(AIStation.GetNearestTown);
	station_list.KeepValue(town);
	if(!station_list.IsEmpty()) {
		foreach(station, _ in station_list) {
			if(StationManager.NeedsExtraService(station,AIVehicle.VT_ROAD)) {
				local station_tile = StationManager.SelectTruckStopTile(station);
				return [station_tile,AIRoad.GetRoadStationFrontTile(station_tile)];
			}
		}
	}
	return null;	
}

function TownManager::GetNewTruckStopList(town, articulated) {
	local result_list = AITileList(), tile_list = AITileList();
	local dist = abs(AITown.GetPopulation(town)/400)+3;
	tile_list.AddRectangle(AITown.GetLocation(town) + AIMap.GetTileIndex(-dist,-dist),
							AITown.GetLocation(town) + AIMap.GetTileIndex(dist,dist));		
   	result_list.AddList(tile_list);
	result_list.Valuate(Valuator.IsGoodForTruckStop, articulated);
	result_list.RemoveValue(0); result_list.Sort(AIList.SORT_BY_VALUE,false);
	//foreach(t, v in result_list) {MailAI.BuildSign(t,v);}	
	return result_list;	
}

function TownManager::GetNewFourTruckStopList(town_tile,dir,articulated) {
	local tl = TownManager.GetQuadrantTileList(town_tile,dir);
	if(!articulated) {
		tl.Valuate(AIRoad.IsRoadStationTile); tl.RemoveValue(0);
	} else {
		tl.Valuate(AIRoad.IsDriveThroughRoadStationTile); tl.RemoveValue(0);
	}
	tl.Valuate(Valuator.IsReusableTruckStop);	tl.RemoveValue(0);
	if(tl.Count() > 0) {return tl;}
	local tl = TownManager.GetQuadrantTileList(town_tile,dir);
	tl.Valuate(AIRail.IsRailStationTile); tl.RemoveValue(0);
	tl.Valuate(Valuator.IsReusableTruckStop); tl.RemoveValue(0);
	if(tl.Count() > 0 && StationManager.SelectTruckStopTile(tl.Begin()) != null) {return tl;}
	tl = TownManager.GetQuadrantTileList(town_tile,dir);
	tl.Valuate(Valuator.IsGoodForTruckStop, articulated);
	tl.RemoveValue(0); tl.Sort(AIList.SORT_BY_VALUE,false); 
	//foreach(t, v in tl) {MailAI.BuildSign(t,v);}					
	return tl;
}

/**
*	Checks all (own) depots and returns the one that is in one of the given towns
*	@param townid_a a townID
*	@param townid_b b townID, may be null
*	@return A TileIndex with the (first found) depot in one of the towns
*/
function TownManager::GetRoadDepot(townid_a,townid_b) {
	local depot_list = AIDepotList(AITile.TRANSPORT_ROAD);
	foreach(depot, _ in depot_list) {	
		if(AITile.GetClosestTown(depot) == townid_a || AITile.GetClosestTown(depot) == townid_b) {
			return depot;
		}
	}
	return null;
}