/*
	MogulAI - an artificial intelligence for OpenTTD
	Copyright (C) 2009 - 2010 Kazantsev Lev (Dezmond_snz)

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

class DamnAuthorityManager
{
	damnList = {};
	
	constructor()
	{
		damnList = {};
	}
	
	function AddDamnAuthority(town, rating)
	{
		if (damnList.rawin(town))
		{
			if (damnList.rawget(town).NeededRating < rating)
				damnList.rawget(town).NeededRating = rating;
		}
		else
			damnList.rawset(town, DamnAuthorities(town, rating));
		
		LogWarning("Total count of damned authorities: "+damnList.len());
	}
	
	function ProcessDamnAuthorities()
	{
		if (damnList.len() == 0)
			return;
		
		LogWarning("Processing Damn Authoriries...");
		foreach(idx, inst in damnList)
		{
			if (inst.ProcessTreePlanting(50))
				damnList.rawdelete(idx);
		}
		LogWarning("Processing Damn Authoriries Finished.");
	}
	
	function LogInfo(msg)
	{
		AILog.Info("DamnAuthorityManager: "+msg);
	}
	function LogWarning(msg)
	{
		AILog.Warning("DamnAuthorityManager: "+msg);
	}
	function LogError(msg)
	{
		AILog.Error("DamnAuthorityManager: "+msg);
	}
	
	function LogDebug(msg)
	{
		if (DEBUG)
			AILog.Info("(DBG) DamnAuthorityManager: "+msg);
	}
}

class DamnAuthorities
{
	TownId = -1;
	NeededRating = -1;
	
	_radius = 1;
	_curStep = 0;
	_lastGood = 0;
	
	constructor(town, rating)
	{
		TownId = town;
		NeededRating = rating;
		_radius = 1;
		_curStep = 0;
		_lastGood = 0;
	}
	
	function ProcessTreePlanting(itterations)
	{
		AILog.Warning("Processing tree planting...");
		local i = 0;
		local center = AITown.GetLocation(TownId);
//		AILog.Warning("Town center at "+AIMap.GetTileX(center)+", "+AIMap.GetTileY(center));
		
		while(i < itterations)
		{
			local dx = 0;
			if (_curStep <= _radius*2)
				dx += _curStep - _radius;
			else
				dx += _radius - (_curStep - _radius*2);
			
			local dy = 0;
			if (_curStep <= _radius)
				dy += _curStep;
			else if (_curStep <= _radius*3)
				dy += _radius - (_curStep - _radius);
			else
				dy += (_curStep - _radius*3) - _radius;
			
			local tile = Util.TileAddOffset(center, dx, dy);
			
//			AILog.Warning("i="+i+", radius="+_radius+", curStep="+_curStep+", tile: "+AIMap.GetTileX(tile)+","+AIMap.GetTileY(tile));
			
			if (AIMap.IsValidTile(tile) &&
					AITile.GetClosestTown(tile) == TownId &&
					AIMap.DistanceManhattan(tile, AITown.GetLocation(TownId)) < AIGameSettings.GetValue("economy.dist_local_authority"))
			{
				if (!plantTrees(tile))
					_lastGood++;
				else
				{
					if (AITown.GetRating(TownId, AICompany.ResolveCompanyID(AICompany.COMPANY_SELF)) >= NeededRating)
					{
						AILog.Warning("Needed rating reached.");
						return true;
					}
					_lastGood = 0;
				}
			}
			else
			{
				if (_radius >= AIGameSettings.GetValue("economy.dist_local_authority")/2)
					_lastGood++;
			}
			
			if (_lastGood == _radius*4)
			{
//				AILog.Warning("Cannot find any suitable places for plant tree. I need plan B. ;)");
				return true;
			}
			
			_curStep++;
			if (_curStep == _radius*4)
			{
				_radius++;
				_curStep = 0;
			}
			i++;
		}
		
		AILog.Warning("Needed rating not reached (processed "+itterations+" itterations).");
		return false;
	}
	
	function plantTrees(tile)
	{
		local i = 0;
		while(i < 10)
		{
			if (!FundsManager.CheckMoneyConstruction(5000, true)) return false;
			if (!AITile.PlantTree(tile))
				break;
			i++;
		}
		if (i == 10)
			AILog.Error("Strange overlooping at function plantTrees(tile)! Last Error is "+AIError.GetLastErrorString());
		return true;
	}
}
