
class SCPManager {
	_scp = null;
	_main_ptr = null;
	
   static COMMAND_SET = "NoCarGoal";

	constructor(main_ptr)
	{
		this._scp = null;
		this._main_ptr = main_ptr;
		this.SetupSCP();
	}

}

function SCPManager::SetupSCP()
{
	this._scp = SCPLib();
	this._scp.SCPLogging_Info(false);
	this._scp.SCPLogging_Error(true);

	local self = this;

	// AI -> GS commands:
	this._scp.AddCommand("CurrentGoal", COMMAND_SET, self, SCPManager.ReceivedCurrentGoalCommand);
	this._scp.AddCommand("GSSetting", COMMAND_SET, self, SCPManager.ReceivedGSSettingCommand);

	// GS -> AI commands:
	this._scp.AddCommand("GoalCompleted", COMMAND_SET, self);
}

function SCPManager::Check()
{
	return this._scp.Check();
}

/*****************************************************************
 *                                                               *
 *   Outgoing Commands - commands that we can send to GSes       *
 *                                                               *
 *****************************************************************/

// Call one of these methods to send a command to a GS.

function SCPManager::GetCurrentGoal(company_id, cargo_id)
{
	this._scp.QueryServer("GoalCompleted", COMMAND_SET, [company_id, cargo_id]);
}

/*****************************************************************
 *                                                               *
 *   Incoming Commands - commands that we can get from AIs       *
 *                                                               *
 *****************************************************************/

// These methods are called by the SCP library when we call this._scp.Check() and there is
// a received incoming message.

function SCPManager::ReceivedCurrentGoalCommand(message, self)
{
	// check that the response gives the goal of our company and not some other company
	if (message.GetIntData(0) != null && AICompany.IsMine(message.GetIntData(0))) {

		
		
	}
}
