/*
 * This file is part of SynTrans, which is an AI for OpenTTD
 *
 * SynTrans is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * SynTrans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with SynTrans; If not, see <http://www.gnu.org/licenses/> or
 * write to the Free Software Foundation, Inc., 51 Franklin Street, 
 * Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
 
 class SynTrans extends AIInfo {
	function GetAuthor()      { return "11Runner"; }
	function GetName()        { return "SynTrans"; }
	function GetShortName()   { return "SNTS"; }
	function GetDescription() { return "SynTrans is an AI which its name stands for 'Synaptic Transportation'.  It builds a massive, rapidly expanding road and air networks!"; }
	function GetAPIVersion()  { return "1.2"; }
	function GetVersion()     { return 15; }
	function GetDate()        { return "2011-10-14"; }
	function GetUrl()         { return "http://www.tt-forums.net/viewtopic.php?f=65&t=57136"; }
	function CreateInstance() { return "SynTrans"; }
	
	function MinVersionToLoad() { return 1; }

	function GetSettings() {
		AddSetting({name = "log_level", description = "The amount of AI messages to display in the AI log.  Higher=More messages", easy_value = 2, medium_value = 2, hard_value = 2, custom_value = 2, min_value = 1, max_value = 3, flags = CONFIG_INGAME | CONFIG_DEVELOPER });
		AddSetting({name = "route_distance", description = "The distance of the vehicle routes built by SynTrans", easy_value = 1, medium_value = 1, hard_value = 1, custom_value = 1, min_value = 1, max_value = 3, flags = 0});
		AddLabels("route_distance", {
			_1 = "Short",
			_2 = "Medium",
			_3 = "Long"
		});
	}

}

/* Tell the core we are an AI */
RegisterAI(SynTrans());
