/*
 * This file is part of SynTrans, which is an AI for OpenTTD
 *
 * SynTrans is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * SynTrans is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with SynTrans; If not, see <http://www.gnu.org/licenses/> or
 * write to the Free Software Foundation, Inc., 51 Franklin Street, 
 * Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

// In case this is not clear, this class Builds 2 way rails, and keeps track of them (thats the plan right now at least :)

class RailPath
{
	pathfinder = null;
	path = null;
	constructor
	{
		pathfinder = RailPathFinder();
	}
	function Init(start,end);
	function FindPath();
	function BuildPath();
}

function RailPath::Init(start,end)
{
	local mult = pathfinder.cost.tile;
	pathfinder.cost.diagonal_tile = mult*3;
	pathfinder.cost.turn = mult*2;
	pathfinder.cost.slope = mult*4;
	pathfinder.InitializePath([[start, start + AIMap.GetTileIndex(-1, 0)]], [[end + AIMap.GetTileIndex(-1, 0), end]]);
}

function RailPath::FindPath()
{
	path = pathfinder.FindPath(-1);
}

function RailPath::BuildPath()
{
	local prev = null;
	local prevprev = null;
	while (path != null) {
		if (prevprev != null) {
			if (AIMap.DistanceManhattan(prev, path.GetTile()) > 1) {
				if (AITunnel.GetOtherTunnelEnd(prev) == path.GetTile()) {
					AITunnel.BuildTunnel(AIVehicle.VT_RAIL, prev);
				} else {
					local bridge_list = AIBridgeList_Length(AIMap.DistanceManhattan(path.GetTile(), prev) + 1);
					bridge_list.Valuate(AIBridge.GetMaxSpeed);
					bridge_list.Sort(AIAbstractList.SORT_BY_VALUE, false);
					AIBridge.BuildBridge(AIVehicle.VT_RAIL, bridge_list.Begin(), prev, path.GetTile());
				}
				prevprev = prev;
				prev = path.GetTile();
				path = path.GetParent();
			} else {
				if(!AIRail.BuildRail(prevprev, prev, path.GetTile())) return false; // I recommend restarting pathfinding
			}
		}
		if (path != null) {
			prevprev = prev;
			prev = path.GetTile();
			path = path.GetParent();
		}
	}
	return true;
}
