/*
 * This file is part of FastPTPAI, which is an AI for OpenTTD
 *
 * FastPTPAI is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * FastPTPAI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FastPTPAI; If not, see <http://www.gnu.org/licenses/> or
 * write to the Free Software Foundation, Inc., 51 Franklin Street, 
 * Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

// Derived from SuperLib Tile.FindClosestRoadTile
function GetDistanceFromWater(tile) {
	local r; // radius
	
	local x = AIMap.GetTileX(tile);
	local y = AIMap.GetTileY(tile);
	
	local x1, x2, y1, y2;
	local ix, iy;
	local t;
	
	for(r = 1;r < 20;r++) {
		y1 = y - r;
		y2 = y + r;
		for(ix = x - r;ix < x + r;ix++) {
			t = AIMap.GetTileIndex(ix, y1);
			if(t != null && AITile.IsWaterTile(t)) return AIMap.DistanceManhattan(tile, t);
			t = AIMap.GetTileIndex(ix, y2);
			if(t != null && AITile.IsWaterTile(t)) return AIMap.DistanceManhattan(tile, t);
		}
		x1 = x - r;
		x2 = x + r;
		for(iy = y - r + 1; iy < y + r - 1;iy++) {
			t = AIMap.GetTileIndex(x1, iy);
			if(t != null && AITile.IsWaterTile(t)) return AIMap.DistanceManhattan(tile, t);
			t = AIMap.GetTileIndex(x2, iy);
			if(t != null && AITile.IsWaterTile(t)) return AIMap.DistanceManhattan(tile, t);
		}
	}
	return 21;
}

function IsAlongAnyRail(tile) {
	local tiles = Tile.GetNeighbours8(tile);
	tiles.Valuate(AIRail.IsRailTile);
	tiles.KeepValue(1);
	tiles.Valuate(AIRail.IsRailStationTile);
	tiles.KeepValue(0);
	return !tiles.IsEmpty();
}

function IsAlongRail(tile) {
	local tiles = Tile.GetNeighbours4MainDir(tile);
	tiles.Valuate(AIRail.IsRailTile);
	tiles.KeepValue(1);
	tiles.Valuate(AITile.GetSlope);
	tiles.KeepValue(0);
	tiles.Valuate(AIRail.IsRailStationTile);
	tiles.KeepValue(0);
	tiles.Valuate(AIRail.GetRailTracks);
	foreach(tile, value in tiles) {
		if(value != AIRail.RAILTRACK_NE_SW && value != AIRail.RAILTRACK_NW_SE) tiles.RemoveItem(tile);
	}
	return !tiles.IsEmpty();
}

function IsAlongPath(tile, path) {
	return path.IsAlongPath(tile); // This is stupid, but must comply with OpenTTD standards
}

function GetDistanceFromIndustry(industry, producing, cargo, list) { // list assumes it is a list of "Industry" objects
	local least = 1000000;
	foreach(i in list) {
		if((i.IsProducer() && producing) || (i.IsConsumer() && !producing)) {
			local dist = AIMap.DistanceManhattan(AIIndustry.GetLocation(industry), AIIndustry.GetLocation(i.id));
			if(dist < least) least = dist;
		}
	}
	return least;
}
