
class Engine
{

	static function GetFullSpeedTraveltime(engine, distance);

	static function GetStationToStationAircraftTravelTime(engine, station1_id, station2_id);
}

function Engine::GetFullSpeedTraveltime(engine, distance)
{
	// X km/h => X/27 tiles/day

	/* Multiply by this from start and then remove it at the end in order to 
	 * not lose to much significance in the calculation process. 
	 *
	 * On 100 km/h the tile/day speed becomes 3.7, which would become just
	 * 3 in the integer conversion which would be loosing to much detail.
	 */ 
	local MULTI = 50; 

	local km_h_speed = AIEngine.GetMaxSpeed(engine) * MULTI;
	local tile_speed = km_h_speed / 27;
	if(AIEngine.GetVehicleType(engine) == AIVehicle.VT_AIR)
	{
		local plane_speed = AIGameSettings.GetValue("plane_speed");
		tile_speed = tile_speed / plane_speed;
	}

	local travel_time_days = distance * MULTI / tile_speed;

	return travel_time_days;
}

function Engine::GetStationToStationAircraftTravelTime(engine, station1_id, station2_id)
{
	local ap = [station1_id, station2_id];
	local ap_tiles = [Station.GetAirportTile(station1_id), Station.GetAirportTile(station2_id)];

	local travel_time = 0;

	// Add some time for each airport depending on the airport type
	for(local i = 0; i < ap.len(); i++)
	{
		local ap_type = AIAirport.GetAirportType(ap_tiles[i]);
		switch(ap_type)
		{
			// These values have just been guessed. Some research is needed to find better values. Or at least confirm or reject the guessed values.
			case AIAirport.AT_SMALL:
				travel_time += 10;
				break;
			
			case AIAirport.AT_COMMUTER:
				travel_time += 5;
				break;

			case AIAirport.AT_LARGE:
				travel_time += 10;
				break;

			case AIAirport.AT_METROPOLITAN:
				travel_time += 8;
				break;

			case AIAirport.AT_INTERNATIONAL:
				travel_time += 7;
				break;

			case AIAirport.AT_INTERCON:
				travel_time += 7;
				break;

			default:
				// Unknown airport type -> crash the AI
				KABOOOOOM_unknown_airport_type();
		}
	}

	// Add the time it takes to fly between the airports
	travel_time += Engine.GetFullSpeedTraveltime(engine, AIMap.DistanceManhattan(ap_tiles[0], ap_tiles[1]));

	return travel_time;
}
