/*
 * This file is part of StreetTraffic, which is an AI for OpenTTD
 * Copyright (C) 2009  Frank Jüdes with parts written by Leif Linse
 *
 * StreetTraffic is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * StreetTraffic is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with StreetTraffic; If not, see <http://www.gnu.org/licenses/> or
 * write to the Free Software Foundation, Inc., 51 Franklin Street, 
 * Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

// min OpenTTD nightly: 2009-01-18

class StreetTraffic extends AIInfo {
  function GetAuthor()      { return "Zuu, modified by fjuedes"; }
  function GetName()        { return "StreetTraffic"; }
  function GetShortName()   { return "STTR"; }
  function GetDescription() { return "Builds random cars on your streets if you have a GRF with cars."; }
  function GetVersion()     { return 1; }
  function GetDate()        { return "2009-04-06"; }
  function CreateInstance() { return "StreetTraffic"; }
	
  // There is no saved state, but by setting <= this version, users
  // will not use an older version that might not handle the vehicles
  // as good as the one that was used to make the save game
  function CanLoadFromVersion(version) { return version <= GetVersion(); }

  function GetSettings() {
    AddSetting({name = "num_towns_max", description = "Maximum number of towns where cars will be build", easy_value = 10, medium_value = 20, hard_value = 50, custom_value = 15, flags = 0, min_value = 1, max_value = 80});
    AddSetting({name = "num_cars_total", description = "Maximum total number of cars to build", easy_value = 500, medium_value = 500, hard_value = 500, custom_value = 500, flags = 0, min_value = 1, max_value = 1000000});
    AddSetting({name = "num_cars_per_town", description = "Number of cars per 100 inhabitants per town", easy_value = 1, medium_value = 2, hard_value = 3, custom_value = 2, flags = 0, min_value = 1, max_value = 20});
    AddSetting({name = "car_sleep_time", description = "Ticks to sleep after creating a single car", easy_value = 40, medium_value = 20, hard_value = 10, custom_value = 20, flags = 0, min_value = 1, max_value = 300});
    AddSetting({name = "town_sleep_time", description = "Ticks to sleep after creating cars in one town", easy_value = 200, medium_value = 100, hard_value = 50, custom_value = 200, flags = 0, min_value = 10, max_value = 3000});
    AddSetting({name = "eol_sleep_time", description = "Ticks to sleep after finishing the list of towns", easy_value = 600, medium_value = 450, hard_value = 300, custom_value = 600, flags = 0, min_value = 10, max_value = 3000});
    AddSetting({name = "build_only_zero_price_rvs", description = "Only build zero price RVs", easy_value = 1, medium_value = 1, hard_value = 1, custom_value = 1, flags = AICONFIG_BOOLEAN});
    AddSetting({name = "build_only_zero_running_cost_rvs", description = "Only build zero running cost RVs", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN});
    AddSetting({name = "build_only_zero_capacity_rvs", description = "Only build zero capacity RVs", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN});
    AddSetting({name = "build_only_if_cargo_type_is_pax", description = "Only build RVs that carry PAX", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN});
    AddSetting({name = "debug_signs", description = "Enable building debug signs", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN});
  } // GetSettings

} // StreetTraffic

RegisterAI(StreetTraffic()); // Tell the core we are an AI
