/*
 * This file is part of FastPTPAI, which is an AI for OpenTTD
 *
 * FastPTPAI is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * FastPTPAI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FastPTPAI; If not, see <http://www.gnu.org/licenses/> or
 * write to the Free Software Foundation, Inc., 51 Franklin Street, 
 * Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

function ConvertDirectionToRail(dir) {
	switch(dir) {
		case Direction.DIR_N:
			return AIRail.RAILTRACK_NW_NE;
		case Direction.DIR_NE:
		case Direction.DIR_SW:
			return AIRail.RAILTRACK_NE_SW;
		case Direction.DIR_E:
			return AIRail.RAILTRACK_NE_SE;
		case Direction.DIR_NW:
		case Direction.DIR_SE:
			return AIRail.RAILTRACK_NW_SE;
		case Direction.DIR_S:
			return AIRail.RAILTRACK_SW_SE;
		case Direction.DIR_W:
			return AIRail.RAILTRACK_NW_SW;
		default:
			return AIRail.RAILTRACK_INVALID;
	}
}

function GetTrainCargo(v) {
	local wagon = AIVehicle.GetWagonEngineType(v,1);
	return AIEngine.GetCargoType(wagon);
}

function WaitForMoney(amount, max_sleep = 1000) {
	local start = AIController.GetTick();
	if(amount > Money.GetMaxSpendingAmount()) Log.Info("Waiting for " + amount + " for as long as " + max_sleep + " ticks.", Log.LVL_SUB_DECISIONS);
	while(amount > Money.GetMaxSpendingAmount()) {
		AIController.Sleep(5);
		if(start + max_sleep < AIController.GetTick() && max_sleep > 0) return false;
	}
	Money.MakeSureToHaveAmount(amount);
	return true;
}
