/*
 * This file is part of RoadAI, which is an AI for OpenTTD
 *
 * RoadAI is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License
 *
 * RoadAI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with RoadAI; If not, see <http://www.gnu.org/licenses/> or
 * write to the Free Software Foundation, Inc., 51 Franklin Street,
 * Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
// Add all the files for libraries here
import("util.superlib","SuperLib",40);
// Add all your files here
require("network.nut");
require("town.nut");

Result <- SuperLib.Result;
Log <- SuperLib.Log;
Helper <- SuperLib.Helper;
ScoreList <- SuperLib.ScoreList;
Money <- SuperLib.Money;
Tile <- SuperLib.Tile;
Direction <- SuperLib.Direction;
Engine <- SuperLib.Engine;
Vehicle <- SuperLib.Vehicle;
Station <- SuperLib.Station;
Airport <- SuperLib.Airport;
Industry <- SuperLib.Industry;
//Town <- SuperLib.Town;
Order <- SuperLib.Order;
OrderList <- SuperLib.OrderList;
Road <- SuperLib.Road;
RoadBuilder <- SuperLib.RoadBuilder;

aiInstance <- null;

 // Add all the files for the entire project here
 // ex. require("globals.nut");

 class RoadAI extends AIController {
	networks = null;
	function Start();
	constructor() {
		networks = [];
	}
}

function RoadAI::Start() {
	this.Sleep(10);
	aiInstance=this;
	Log.Info("RoadAI Started");
	AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_ROAD);
	if(Vehicle.IsVehicleTypeDisabledByAISettings(AIVehicle.VT_ROAD)) {
		Log.Error("This is a vehicle only AI.  Please enable AI vehicle building in Advanced settings!");
	}
	/*local rb=RoadBuilder();
	local pathfinder = RoadPathFinder();
	AILog.Warning(AIRoad.GetCurrentRoadType());
	AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_ROAD);
	local list=AITownList();
	local town=list.Begin();
	local newStation=Road.BuildNextToRoad(AITown.GetLocation(town), "BUS_STOP", -1, -1, 50, 150);
	local newDepot=Road.BuildNextToRoad(AITown.GetLocation(town),"DEPOT",-1,-1,50,155);
	local town2=list.Next();
	local newStation2=Road.BuildNextToRoad(AITown.GetLocation(town2), "BUS_STOP",-1,-1,50,150);
	local newDepot2=Road.BuildNextToRoad(AITown.GetLocation(town2), "DEPOT",-1,-1,50,155);
	rb.Init(newStation,newStation2);
	rb.ConnectTiles();
	local myEngine=Engine.GetEngine_PAXLink(10, AIVehicle.VT_ROAD);
	local myne=AIVehicle.BuildVehicle(newDepot,myEngine);
	local ol=OrderList();
	ol.AddStop(AIStation.GetStationID(newStation), AIOrder.AIOF_NONE);
	ol.AddStop(AIStation.GetStationID(newStation2), AIOrder.AIOF_NONE);
	ol.ApplyToVehicle(myne);
	AIVehicle.StartStopVehicle(myne);*/
	// Name the company
	if(!AICompany.SetName("On Your Way Transport")) {
		if(!AICompany.SetName("MEGA Transport Inc.")) {
			local i=2;
			while(!AICompany.SetName("On Your Way Transport Division #" + i)) i++;
		}
	}
	// Make initial network
	local newNet=Network();
	networks.append(newNet);
	local townlist;
	local networkStart;
	while(true)
	{
		foreach(network in networks) network.ManageNetwork();
		// Should we build a new network?
		if(AIController.GetSetting("max_networks")>networks.len()) {
			if(AICompany.GetBankBalance(AICompany.COMPANY_SELF)>500000) {
				Log.Info("==========BUILDING NEW NETWORK!!!==========");
				townlist=AITownList();
				// take out the cities we already own
				foreach(network in networks) {
					foreach(town in network.towns) {
						townlist.RemoveItem(town.id);
					}
				}
				// now find the biggest city
				townlist.Valuate(AITown.GetPopulation)
				townlist.Sort(AIList.SORT_BY_VALUE, false);
				networkStart=townlist.Begin();
				newNet=Network(networkStart);
				networks.append(newNet);
			}
		}
		Log.Info("Waiting...");
		this.Sleep(500/networks.len());
	}
}
