/*
 *	Copyright  2008 George Weller
 *	
 *	This file is part of PathZilla.
 *	
 *	PathZilla is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 2 of the License, or
 *	(at your option) any later version.
 *	
 *	PathZilla is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with PathZilla.  If not, see <http://www.gnu.org/licenses/>.
 *
 * info.nut
 * 
 * The basic descriptor for the PathZilla AI.
 * 
 * Author:  George Weller (Zutty)
 * Created: 27/05/2008
 * Version: 1.1
 */

///The original authorship of this code still belongs to George Weller. If you want to thank him for this great AI, you can send him as much money as you want or have. If you have problems with this AI you can make your own AI, download another AI, cry, or you can write suggestions to me on http://www.tt-forums.net.  Stefan Brunner (Steffl) 24/4/2010

class PathZilla extends AIInfo {
	function GetAuthor()      { return "Steffl"; }
	function GetName()        { return "RoadRunner"; }
	function GetDescription() { return "This AI is an improved and updated version of PathZilla, originally written by George Weller. It transports all kinds of cargo, but only uses road vehicles."; }
	function GetVersion()     { return 12; }
	function GetDate()        { return "2016-11-01"; }
	function CreateInstance() { return "PathZilla"; }
	function GetShortName()   { return "RRUN"; }
	function GetSettings() {
		AddSetting({name = "latency", description = "Planning speed of AI", min_value = 0, max_value = 5, easy_value = 3, medium_value = 5, hard_value = 5, custom_value = 5, flags = 0|AICONFIG_INGAME});
		AddLabels("latency", {_0="Very Slow", _1="Slow", _2="Medium", _3="Fast", _4="Very Fast", _5="Fastest"});
		AddSetting({name = "aggressive", description = "Prefer aggressive competition with other players over already served targets", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN|AICONFIG_INGAME});
		AddSetting({name = "percent", description = "Max. transported percentage for new routes ('0'=only consider unserved targets)", min_value = 0, max_value = 100, easy_value = 70, medium_value = 70, hard_value = 70, custom_value = 70, flags = 0|AICONFIG_INGAME});
		AddSetting({name = "traffic", description = "Level of traffic the AI should generate", min_value = 1, max_value = 4, easy_value = 3, medium_value = 3, hard_value = 3, custom_value = 3, flags = 0|AICONFIG_INGAME});
		AddLabels("traffic", {_1="Light", _2="Normal", _3="Heavy", _4="Very Heavy"});
		AddSetting({name = "cargo", description = "Transport more cargo from industries (0-4) or from towns (6-10)", min_value = 0, max_value = 10, easy_value = 5, medium_value = 5, hard_value = 5, custom_value = 5, flags = 0|AICONFIG_INGAME});
		AddLabels("cargo", {_0="only from industries", _1="1", _2="2", _3="3", _4="4", _5="5", _6="6", _7="7", _8="8", _9="9",_10="only from towns"});
		AddSetting({name = "rt_cargo_towns", description = "Route all cargo through towns", easy_value = 1, medium_value = 1, hard_value = 1, custom_value = 1, flags = AICONFIG_BOOLEAN|AICONFIG_INGAME});
		AddSetting({name = "country_lanes", description = "Build windy country lanes in rural towns", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = AICONFIG_BOOLEAN|AICONFIG_INGAME});
		AddSetting({name = "fullLoad", description = "Use full load orders", min_value = 1, max_value = 5, easy_value = 1, medium_value = 1, hard_value = 1, custom_value = 1, flags = 0|AICONFIG_INGAME});
		AddLabels("fullLoad", {_1="Always", _2="Not for passengers", _3="Not for passengers & mail", _4="Not for passengers, mail & valuables", _5="Never"});
		AddSetting({name = "pathfinding", description = "Pathfinding (lower=more accurate, higher=faster)", min_value = 1, max_value = 1000, easy_value = 50, medium_value = 100, hard_value = 100, custom_value = 100, flags = 0|AICONFIG_INGAME});
		AddSetting({name = "targets", description = "Number of targets for route calculation (--> set lower if AI crashes while saving)", min_value = 2, max_value = 300, easy_value = 9, medium_value = 9, hard_value = 9, custom_value = 9, flags = 0|AICONFIG_INGAME});
		AddSetting({name = "language", description = "Language for debug output", min_value = 0, max_value = 2, easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = 0|AICONFIG_INGAME});
		AddLabels("language", {_0="Automatic", _1="English", _2="Deutsch"});

		AddSetting({name = "hq", description = "(This don't affect gameplay): I will", min_value = 0, max_value = 1, easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = 0|AICONFIG_INGAME});
		AddLabels("hq", {_0=" play some little pranks to other companies :-)", _1=" concentrate on the hard work I have to do :-|"});
	

}
	function CanLoadFromVersion(version) {
		return (version == 5);
	}
}

RegisterAI(PathZilla());
