/*
 *	Copyright  2008 George Weller
 *	
 *	This file is part of PathZilla.
 *	
 *	PathZilla is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 2 of the License, or
 *	(at your option) any later version.
 *	
 *	PathZilla is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with PathZilla.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ServiceManager.nut
 * 
 * Handles all service related functions and maintains service lists.
 * 
 * Author:  George Weller (Zutty)
 * Created: 27/07/2008
 * Version: 1.1
 */

class ServiceManager {
	// Serialization constants
	CLASS_NAME = "ServiceManager";
	SRLZ_SERVICE_LIST = 0;
	SRLZ_TARGETS_UPDATED = 1;
	SRLZ_POTENTIAL_SERVICES = 2;
	SRLZ_TARGETS_CONSIDERED = 3;
	
	// Member variables
	potentialServices = null;
	targetsConsidered = null;
	serviceList = null;
	targetsUpdated = null;

	constructor() {
		this.targetsConsidered = AIList();
		this.targetsUpdated = Map();

		this.serviceList = SortedSet();		
		this.potentialServices = SortedSet();

	}
}

/*
 * Get a list of services currently in operation.
 */
function ServiceManager::GetServices() {
	return this.serviceList;
}

function ServiceManager::TargetClosed(target) {
	this.targetsConsidered.AddItem(target.GetId(),0);
	return;
}

function ServiceManager::DeleteService(svc) {
local helplist=this.serviceList;
this.serviceList=null;
this.serviceList=SortedSet();
	foreach(service in helplist) {
if (service.GetCargo()!=svc.GetCargo()||service.GetTargets()[0]!=svc.GetTargets()[0]||service.GetTargets()[1]!=svc.GetTargets()[1]){
this.serviceList.Insert(service);
}
}
	return;
}

/*
 * Maintians the operating services. This function ensures that all towns have
 * enough stations to cover them, and that all the vehciles in each service are
 * distributed adequately.
 */
function ServiceManager::MaintainServices(rek=0) {


	local targetsTried = SortedSet();

	local build=(AIDate.GetCurrentDate()%(11+(::vc/55).tointeger()))==1&&::vc>0;
::pz.HandleEvents();

if((AIDate.GetCurrentDate()%2==1||build)){
				local staList=AIStationList(AIStation.STATION_BUS_STOP);
				staList.AddList(AIStationList(AIStation.STATION_TRUCK_STOP));
local vhhs=AIList();
				foreach (stdt,_ in staList){
				local vhz=0;
				local ves=-1;
local avke =AIVehicleList_Station(stdt);
local avkc=avke.Count();		
vhhs.Clear();
		foreach (vh,_ in avke){
if (AIOrder.GetOrderCount(vh)>0&&AIOrder.IsGotoDepotOrder(vh,0)&&::vehiclesToSell.GetValue(vh)!=1){
AIOrder.UnshareOrders(vh);
AIOrder.RemoveOrder(vh,0);
}
if (AIOrder.GetOrderCount(vh)>0&&AIOrder.IsGotoDepotOrder(vh,0)&&!::vehiclesToSell.HasItem(vh)){
AIOrder.UnshareOrders(vh);
AIOrder.RemoveOrder(vh,0);
}
if(AIVehicle.GetState(vh)==AIVehicle.VS_IN_DEPOT&&!::vehiclesToSell.HasItem(vh))AIVehicle.StartStopVehicle(vh);
if(AIVehicle.GetState(vh)==AIVehicle.VS_STOPPED&&!::vehiclesToSell.HasItem(vh))AIVehicle.StartStopVehicle(vh);
				for(local orv=0;orv<AIOrder.GetOrderCount(vh);orv++)if (AIOrder.IsGotoStationOrder(vh,orv)&&AIOrder.GetOrderDestination(vh,orv)==AIStation.GetLocation(stdt)&&(AIOrder.GetOrderFlags(vh,orv)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)||AIOrder.GetOrderFlags(vh,orv)==AIOrder.AIOF_FULL_LOAD_ANY))ves=vh;
				if(AIMap.DistanceManhattan(AIStation.GetLocation(stdt),AIVehicle.GetLocation(vh))<5&&AIVehicle.GetCurrentSpeed(vh)*2<AIEngine.GetMaxSpeed(AIVehicle.GetEngineType(vh))){
				vhz++;

				if (ves>-1&&AIOrder.GetOrderFlags(ves,AIOrder.ORDER_CURRENT)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)&&AIVehicle.GetCurrentSpeed(ves)<5){
if(vhz<=3+avkc/18){
vhhs.AddItem(ves,0);
}else{
if (!vhhs.IsEmpty()){
foreach(vfz,_ in vhhs){
if(!AIVehicle.IsInDepot(vfz)){
AIVehicle.ReverseVehicle(vfz);
if (AIOrder.GetOrderFlags(vfz,AIOrder.ORDER_CURRENT)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)){
AIVehicle.SendVehicleToDepotForServicing(vfz);
}}}
vhhs.Clear();
}
if(!AIVehicle.IsInDepot(ves)&&AIOrder.GetOrderFlags(ves,AIOrder.ORDER_CURRENT)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)){
					AIVehicle.ReverseVehicle(ves);
AIVehicle.SendVehicleToDepotForServicing(ves);
}
if(AIVehicle.GetAge(ves)>284&&!::stmsg.HasItem(stdt)){
::stmsg.AddItem(stdt,AIDate.GetCurrentDate());
					(::german)?AILog.Info(  "   Fahrzeugueberwachung meldet: Stau bei "+AIStation.GetName(stdt)):AILog.Info("   Vehicles are jamming at "+AIStation.GetName(stdt));
}
if(AIVehicle.GetAge(ves)>284){
foreach(c,_ in ::c){
if (AIVehicle.GetCapacity(ves,c)>0){
if (AIStation.GetCargoWaiting(stdt,c)==0&&(AICargo.HasCargoClass(c,AICargo.CC_PASSENGERS)||AICargo.HasCargoClass(c,AICargo.CC_MAIL)||AICargo.GetCargoLabel(c)=="VALU"||AIVehicle.GetCargoLoad(ves,c)*3<AIVehicle.GetCapacity(ves,c)*2)){
if (AIOrder.GetOrderFlags(ves,AIOrder.ORDER_CURRENT)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)&&((AIOrder.GetOrderCount(ves)==0||(!AIOrder.IsGotoDepotOrder(ves,0)))&&AIVehicle.GetCargoLoad(ves,c)*5<AIVehicle.GetCapacity(ves,c)*3)){

		AIVehicle.SendVehicleToDepot(ves);	
}	
				if(!::vehiclesToSell.HasItem(ves))::vehiclesToSell.AddItem(ves, 0);
					this.LockThis(ves);

}
break;
}
}

}else{
foreach(c,_ in ::c){
if (AIVehicle.GetCapacity(ves,c)>0){
if (AIStation.GetCargoWaiting(stdt,c)==0&&AIVehicle.GetCargoLoad(ves,c)*2<AIVehicle.GetCapacity(ves,c)){
if (AIOrder.GetOrderFlags(ves,AIOrder.ORDER_CURRENT)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)&&((AIOrder.GetOrderCount(ves)==0||(!AIOrder.IsGotoDepotOrder(ves,0)))&&AIVehicle.GetCargoLoad(ves,c)*5<AIVehicle.GetCapacity(ves,c)*3)){
		AIVehicle.SendVehicleToDepotForServicing(ves);	
}	
								if(!::vehiclesToSell.HasItem(ves))::vehiclesToSell.AddItem(ves, 0);
					this.LockThis(ves);

}
break;
}}
}

}}}}}}


		
local bb=false;
local mz=0;

if(this.serviceList==null)return;
local svcl=(this.serviceList.Len()/((::vc+100)/80)).tointeger()+1;
local dad=(AIDate.GetDayOfMonth(AIDate.GetCurrentDate())*3);
local llx=dad;
foreach (service in this.serviceList){
if (llx++%svcl>0||service.GetActualFleetSize()<dad)continue;
if (!service.IsValid()||service.GetActualFleetSize()==0){
this.DeleteService(service);
continue;
}
mz++;
//		PathZilla.Sleep(1);
		
		// Update fleet size
RoadManager.MaintainInfrastructure(service, targetsTried, this.targetsUpdated);
//local needUpdate = false;
if(rek==0){
		this.CreateFleet(service, true,0,0);
}else{
::pz.CloneVehicles(true);
}}
		//foreach(target in service.GetTargets()) {
//			needUpdate = needUpdate && this.targetsUpdated.Contains(target);

	//	if(needUpdate) {
//(::german)?AILog.Info("  Ueberpruefe: " + service):AILog.Info("  Updating service - " + service);
	//		this.UpdateOrders(service);
	
	

	this.targetsUpdated = Map();

}

/*
 * Gets a list of potential services as service descriptors. At present this
 * searchs through a matrix of all towns in the map, checks which would turn a
 * profit, and ranks them by their profitability.
 */
function ServiceManager::FindNewServices(tre=0) {
this.potentialServices.SortBy(profit);
if (this.potentialServices.Len()*3>PathZilla.MAX_POTENTIAL_SERVICES&&(this.potentialServices.Len()>=PathZilla.MAX_POTENTIAL_SERVICES||(this.potentialServices[5]).GetRawIncome()>43000)){
::tt2=0;
 return;
}

if (::tt1>30000&&AIDate.GetCurrentDate()%333==1)this.targetsConsidered.Clear();

if(PathZilla.GetSetting("latency")>4){
local otre=tre;
local psz=0;
for (local schema = ::pz.GetNextSchema();;schema = ::pz.GetNextSchema()){
if (psz++>=::pz.schemas.len())return;
local targets=schema.GetTargets();
if (targets.len()<2)continue;
local pcc=(schema.GetCargos()).Count();
local cargo=schema.GetNextCargo();
if(cargo>-1){
local pcz=schema.cid%pcc;
if (::vc>5||(targets[0].IsTown()||AIIndustry.GetLastMonthProduction((targets[0]).GetId(),cargo)>35)){
local subType=schema.GetSubType();
local transportType=schema.GetTransportType();

local engine = this.SelectEngine([], cargo, transportType, subType, false);
if (engine==null)continue;
(::german)?0:AILog.Info("  Looking for potential " + AICargo.GetCargoLabel(cargo) + " services...");
if (subType==AIRoad.ROADTYPE_TRAM){
local eg=0;
local en=null;

foreach(e,_ in AIEngineList(AIVehicle.VT_ROAD)){
if (AIEngine.GetCargoType(e)==cargo){
if (AIEngine.GetMaxSpeed(e)>eg){
en=e;
eg=AIEngine.GetMaxSpeed(e);
}
}
}
if (en==null) continue;
if (AIEngine.GetRoadType(en)==AIRoad.ROADTYPE_ROAD)subType=AIRoad.ROADTYPE_ROAD;
}
local tgSort=AIList();
tgSort.Clear();
local sub=-1;
local sbz=1;
foreach(subsidy,_ in AISubsidyList()){
if (AISubsidy.IsAwarded(subsidy)||!AISubsidy.DestinationIsTown(subsidy))continue;
if (pcz>sbz++)continue;
sub=AITown.GetLocation(AISubsidy.GetDestination(subsidy));
}
if (sub==-1)sub=AITown.GetLocation(::pz.homeTown);
local map=(max(AIMap.GetMapSizeX(),AIMap.GetMapSizeY())/2).tointeger();
local tpx=-1;
foreach(target in targets){
tpx++;
if (this.targetsConsidered.HasItem(target.GetId()))continue;
tgSort.AddItem(tpx,sortTargets(target,sub,cargo,map));
}
tgSort.Sort(AIAbstractList.SORT_BY_VALUE, false);
if(tgSort.Count()<otre)tre=-10+tgSort.Count();
foreach(tpw,_ in tgSort){
local aTarget=targets[tpw];
if(tre< (-9)){
otre=tre+min(otre+2,8);
break;
}
if (tre==1){
return;
}else{tre--;}
if((!(aTarget.ProducesCargo(cargo)))||aTarget.GetTransportation(-1,cargo)*(PathZilla.GetSetting("aggressive")+1)>PathZilla.GetSetting("percent"))continue;
(::german)?AILog.Info("    Suche moegliche Ziele fuer "+AICargo.GetCargoLabel(cargo)+" von " + aTarget.GetName() + "..."):AILog.Info("    Looking for potential services from " + aTarget.GetName() + "...");
local aTile=aTarget.GetLocation();
local acp=aTarget.AcceptsCargo(cargo);
local netDist = schema.GetPlanGraph().GetShortestDistances(aTarget.GetVertex());
if (pcc==1||pcz==0)this.targetsConsidered.AddItem(aTarget.GetId(),0);
local bz=0;
local tggSort=AIList();
tggSort.Clear();
local tpx=0;
foreach(target in targets){
tggSort.AddItem(tpx++,nearTargets(target,aTile));
}
tggSort.Sort(AIAbstractList.SORT_BY_VALUE, true);
foreach(tlw,_ in tggSort){
local bTarget=targets[tlw];
local bTile=bTarget.GetLocation();
local distance=AIMap.DistanceManhattan(aTile,bTile);
if (bz++>9||distance>::spd+min(80,::vc))break;
if(!(bTarget.AcceptsCargo(cargo))||distance<33||(acp&&bTarget.ProducesCargo(cargo)&&this.targetsConsidered.HasItem(bTarget.GetId())&&AIDate.GetCurrentDate()%24<23))continue;
local targetIds=[aTarget.GetId(), bTarget.GetId()];

if (!(bTile in netDist)||netDist[bTile]*3>distance*5||netDist[bTile]<3||this.ProvidesService(targetIds, cargo, transportType, subType))continue;

local coverageLimit = PathZilla.MAX_TARGET_COVERAGE;
					local year = AIDate.GetYear(AIDate.GetCurrentDate());
					if(year < 1950) {
						year = max(year, 1920);
						coverageLimit = (((year - 1900) * 16 / 10)*PathZilla.MAX_TARGET_COVERAGE/80).tointeger();
					}
	
					// Decide on the coverage level itself
					// TODO: Move this code into the schema and make it more general
					local maxCoverage = PathZilla.MAX_TARGET_COVERAGE;
					local coverageTarget = maxCoverage;
					//if(subType == AIRoad.ROADTYPE_TRAM) coverageTarget = maxCoverage / 2; // Penalise trams to prevent sprawl
					if(AICargo.HasCargoClass(cargo, AICargo.CC_MAIL)) (coverageTarget = maxCoverage *3/ 4).tointeger(); // Penalise mail to prevent over-servicing
					
					// Ensure the target does not exceed the limit
					coverageTarget = min(coverageTarget, coverageLimit);
					local travelTime=((netDist[bTile]*30)/(1+(sqrt(AIEngine.GetMaxSpeed(engine)+1)*4*((netDist[bTile]+15)/(netDist[bTile]+1)))).tointeger()); // in days
					// Get the base income for one trip				

					local rawIncome = AICargo.GetCargoIncome(cargo, distance, travelTime)*AIEngine.GetCapacity(engine);
					local production = (aTarget.IsTown()?(AITown.GetMaxProduction(aTarget.GetId()-1000000,cargo)/((aTarget.GetTransportation(-1,cargo)+49)/50+1).tointeger())*(100-aTarget.GetTransportation(-1,cargo)+1)/100:(AIIndustry.GetLastMonthProduction(aTarget.GetId(),cargo)/((aTarget.GetTransportation(-1,cargo)+49)/50+1).tointeger())*(100-aTarget.GetTransportation(-1,cargo)+1)/100).tointeger();
if (Service(schema.GetId(), targetIds, cargo, transportType, subType, engine, distance, rawIncome, coverageTarget).IsTwoWayService()){
local productionb = (((bTarget.IsTown()?(AITown.GetMaxProduction(bTarget.GetId()-1000000,cargo)/((bTarget.GetTransportation(-1,cargo)+69)/70+1).tointeger())*(100-bTarget.GetTransportation(-1,cargo)+1)/100:(AIIndustry.GetLastMonthProduction(bTarget.GetId(),cargo)/((bTarget.GetTransportation(-1,cargo)+69)/70+1).tointeger())*(100-bTarget.GetTransportation(-1,cargo)+1)/100))).tointeger();
production=(max(10,sqrt(((production+productionb-max(productionb-production,production-productionb)*4/3)*500))-100)/(((bTarget.ProducesCargo(cargo))&&this.targetsConsidered.HasItem(bTarget.GetId()))?2:1)).tointeger();
}					// Project revenue and costs

					local annualProfit = ::lastvehicle+(((rawIncome-((travelTime+15)*AIEngine.GetRunningCost(engine)/90))*production*365/(travelTime+15))*(aTarget.IsTown()?PathZilla.GetSetting("cargo")/5:(10-PathZilla.GetSetting("cargo"))/5)).tointeger();
//AILog.Warning(aTarget.GetName()+production+"|"+rawIncome+"|"+annualProfit);

if ((annualProfit>0||this.potentialServices.Len()<99)&&((PathZilla.GetSetting("cargo")<10||aTarget.IsTown())&&(PathZilla.GetSetting("cargo")>0||!aTarget.IsTown()))){

local water=50;
local stpo=max(abs(AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation())),abs(AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation())));
local wz=1;
for (local i=2;i<=stpo&&wz<=10000000;i++){
local wx=(AIMap.GetTileX(aTarget.GetLocation())-(AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation()))*i/stpo).tointeger();
local wy=(AIMap.GetTileY(aTarget.GetLocation())-(AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation()))*i/stpo).tointeger();
//if (i%10==0)AILog.Info(wx+"/"+wy+"|"+wz);
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
water=abs(water+wz);
wz=0;
}
}
water=abs(water+wz);
wz=0;
local wa=50;
local wz=1;
for (local i=1;i<=AIMap.DistanceManhattan(aTarget.GetLocation(),bTarget.GetLocation())&&wz<=10000000;i++){
local wx=(AIMap.GetTileX(aTarget.GetLocation())-((AIMap.GetTileX(aTarget.GetLocation())>AIMap.GetTileX(bTarget.GetLocation()))?min((AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation())),i):max((AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation())),0-i)));
local wy=(AIMap.GetTileY(aTarget.GetLocation())-((AIMap.GetTileY(aTarget.GetLocation())>AIMap.GetTileY(bTarget.GetLocation()))?min((AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation())),max(0,i-abs(AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation())))):max((AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation())),0-max(0,i-abs(AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation()))))));
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
wa=abs(wa+wz);
wz=0;
}
}
wa=abs(wa+wz);
wz=0;
water=min(water,wa);
wa=50;
wz=1;
//AILog.Info(water);
for (local i=1;i<=AIMap.DistanceManhattan(aTarget.GetLocation(),bTarget.GetLocation())&&wz<=10000000;i++){
local wy=(AIMap.GetTileY(aTarget.GetLocation())-((AIMap.GetTileY(aTarget.GetLocation())>AIMap.GetTileY(bTarget.GetLocation()))?min((AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation())),i):max((AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation())),0-i)));
local wx=(AIMap.GetTileX(aTarget.GetLocation())-((AIMap.GetTileX(aTarget.GetLocation())>AIMap.GetTileX(bTarget.GetLocation()))?min((AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation())),max(0,i-abs(AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation())))):max((AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation())),0-max(0,i-abs(AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation()))))));
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
wa=abs(wa+wz);
wz=0;
}
}
wa=abs(wa+wz);
wz=0;
water=min(water,wa);

if (!aTarget.IsTown())annualProfit=annualProfit/max(1,(AIIndustry.GetAmountOfStationsAround(aTarget.GetId())-RoadManager.GetStations(aTarget, cargo, subType).Count()));
annualProfit=(50000+(annualProfit-abs(water*70))).tointeger();
//AILog.Info(aTarget.GetName()+"-"+bTarget.GetName()+distance+"dist."+travelTime+"days"+annualProfit+"$"+water);

						local svc = Service(schema.GetId(), targetIds, cargo, transportType, subType, engine, distance, (annualProfit/20).tointeger(), coverageTarget);
if ((annualProfit>min(0,50000-AICompany.GetMaxLoanAmount()/10)-::tt2&&(distance<max(90,::vc)*2&&(annualProfit+::tt1>5000-::tt2||(this.potentialServices.Len()<20||(this.potentialServices[0]).GetRawIncome()/2<=annualProfit+500+::tt1))))){
this.potentialServices.Insert(svc);
/*
local svs=this.potentialServices;
for (local pi=0;pi<svs.Len();pi++){
local sv=this.potentialServices[pi];
AILog.Warning(sv+"|"+sv.rawIncome);
}
*/

::tt1=tt1/2;
::tt2+=3333;

if(AICargo.HasCargoClass(cargo, AICargo.CC_MAIL)) {
foreach(cgc,_ in AICargoList()){
if (AICargo.HasCargoClass(cgc, AICargo.CC_PASSENGERS)){

this.potentialServices.Insert(Service(schema.GetId(), targetIds, cgc, transportType, subType, this.SelectEngine(svc.GetTargets(), cgc, transportType, subType, false), distance, (annualProfit/20).tointeger(), coverageTarget));

break;
}}}

//if (this.potentialServices.Len()<20||(this.potentialServices.Begin()).GetRawIncome()<annualProfit/19)this.potentialServices.SortBy(profit);
annualProfit=0;					
}}

}}}}}
}else{
local psz=0;
for (local schema = ::pz.GetNextSchema();psz++<::pz.schemas.len();schema = ::pz.GetNextSchema()){
if (schema.GetTargets().len()<2)continue;
if (::vc>5||(schema.GetTargets()[0].IsTown()||AIIndustry.GetLastMonthProduction((schema.GetTargets()[0]).GetId(),schema.GetCargos().Begin())>35)){

//	local schema = ::pz.GetSchema(0);
	local transportType = schema.GetTransportType();
	local subType = schema.GetSubType();
	// If there are no targets then just move on

	// Discard the targets that
/*local svs=this.potentialServices;
for (local pi=0;pi<svs.Len();pi++){
local sv=this.potentialServices[pi];
AILog.Warning(sv+"|"+sv.rawIncome);
}
*/
local tlist=AIList();
foreach(t in schema.GetTargets()){
if (!t.IsTown()||AITown.GetPopulation(t.GetId()-1000000)>500)tlist.AddItem(t.GetId(),0);
}
if (((AICompany.GetBankBalance(AICompany.COMPANY_SELF)/10000).tointeger())%50==15){
this.targetsConsidered.Clear();
}

	// If all targets have already been considered then just move on
	if(tlist.IsEmpty()){
if (AICompany.GetBankBalance(AICompany.COMPANY_SELF)%10==7)this.targetsConsidered.Clear();
return;
}	// Look for possible services for each cargo type in the current schema
local lcar=0;
foreach(cargo, _ in schema.GetCargos()) {
lcar++;
}
local lzz=0
local cargs=schema.GetCargos();
	for(local cargo=cargs.Begin();hasnext(cargs);cargo=cargs.Next()){
lzz++;
(::german)?0:AILog.Info("  Looking for potential " + AICargo.GetCargoLabel(cargo) + " services...");
if (subType==AIRoad.ROADTYPE_TRAM){
local eg=0;
local en=null;
foreach(e,_ in AIEngineList(AIVehicle.VT_ROAD)){
if (AIEngine.GetCargoType(e)==cargo){
if (AIEngine.GetMaxSpeed(e)>eg){
en=e;
eg=AIEngine.GetMaxSpeed(e);
}
}
}
if (en==null) continue;
if (AIEngine.GetRoadType(en)==AIRoad.ROADTYPE_ROAD)subType=AIRoad.ROADTYPE_ROAD;
}
		// Discard those targets that don't produce this cargo
if(AIDate.GetMonth(AIDate.GetCurrentDate())<9&&AICargo.HasCargoClass(cargo,AICargo.CC_MAIL)){
foreach(cpass,_ in AICargoList()){
if (AICargo.HasCargoClass(cpass, AICargo.CC_PASSENGERS)){
cargo =cpass;
break;
}
}
}
local engine = this.SelectEngine([], cargo, transportType, subType, false);
		if(engine != null) {
		local targets = [];

foreach (tk in schema.GetTargets()){
if (tk.IsValid()&&tk.ProducesCargo(cargo)&&!this.targetsConsidered.HasItem(tk.GetId())){
local insert=0;
foreach(tgt, _ in targets){
if (tgt==tk.GetId())insert=1;
}
if (insert==0)targets.append(tk);
}
}		
local ite=0;
if (targets.len()<2) continue;
local aold="";
for (local it=0;ite==0&&it<targets.len();it++){
if (it>2&&(FinanceManager.GetAvailableFunds()>PathZilla.FLOAT*2||AICompany.GetMaxLoanAmount()-AICompany.GetLoanAmount()>80000))ite=1;
			local aTarget=targets[((it+(AIDate.GetCurrentDate()/2).tointeger()+AICompany.GetLoanAmount())%557*10)%(targets.len()-1)];
if (tre==1){
return;
}else{tre--;}
if (aold==aTarget.GetName())break;
aold=aTarget.GetName();
if (lcar==lzz) this.targetsConsidered.AddItem(aTarget.GetId(),0);
(::german)?AILog.Info("    Suche moegliche Ziele fuer "+AICargo.GetCargoLabel(cargo)+" von " + aTarget.GetName() + "..."):AILog.Info("    Looking for potential services from " + aTarget.GetName() + "...");
				// Get the shortest distances accross the network
			local netDist = schema.GetPlanGraph().GetShortestDistances(aTarget.GetVertex());
			// Iterate over each town to test each possible connection
			local steps = 0;
			local blist= tlist;
 			blist.Valuate(function(b,a,c){return abs(AIMap.DistanceManhattan(((b>1000000)?AITown.GetLocation(b-1000000):AIIndustry.GetLocation(b)),a)-c)},aTarget.GetLocation(),::spd);
			blist.Sort(AIAbstractList.SORT_BY_VALUE, true);
			foreach(b,_ in blist) {
local bTarget=((b>1000000)?Target(Target.TYPE_TOWN, b):Target(Target.TYPE_INDUSTRY, b));
				if(aTarget.GetTransportation(-1,cargo)*(PathZilla.GetSetting("aggressive")+1)<=PathZilla.GetSetting("percent")&&bTarget.AcceptsCargo(cargo)&&(bTarget.GetTransportation(-1,cargo)*(PathZilla.GetSetting("aggressive")+1)<=PathZilla.GetSetting("percent")||RoadManager.GetStations(bTarget, cargo, subType).Count()>=1)){


					// Build a list of targets

				local targetIds = [aTarget.GetId(), bTarget.GetId()];
				local targetList = [aTarget, bTarget];

				// Ensure that its possible to connect to the town, and that we 
				// don't already provide this service
				if(bTarget.GetName() == aTarget.GetName() || this.ProvidesService(targetIds, cargo, transportType, subType)) continue;
{
					local bTile = bTarget.GetLocation();
	
					// Select an engine
					local crowDist = AITile.GetDistanceManhattanToTile(aTarget.GetLocation(), bTile);
					if(crowDist>=max(160,::vc)*2) continue;
					if (bTile in netDist){
					if(crowDist<AIEngine.GetMaxSpeed(engine)*5&&(crowDist>20&&netDist[bTile]*3<crowDist*5&& netDist[bTile] > 0)) {
					
					// Decide on a limit for the target coverage level
					local coverageLimit = PathZilla.MAX_TARGET_COVERAGE;
					local year = AIDate.GetYear(AIDate.GetCurrentDate());
					if(year < 1950) {
						year = max(year, 1920);
						coverageLimit = (((year - 1900) * 16 / 10)*PathZilla.MAX_TARGET_COVERAGE/80).tointeger();
					}
	
					// Decide on the coverage level itself
					// TODO: Move this code into the schema and make it more general
					local maxCoverage = PathZilla.MAX_TARGET_COVERAGE;
					local coverageTarget = maxCoverage;
					//if(subType == AIRoad.ROADTYPE_TRAM) coverageTarget = maxCoverage / 2; // Penalise trams to prevent sprawl
					if(AICargo.HasCargoClass(cargo, AICargo.CC_MAIL)) (coverageTarget = maxCoverage *3/ 4).tointeger(); // Penalise mail to prevent over-servicing
					
					// Ensure the target does not exceed the limit
					coverageTarget = min(coverageTarget, coverageLimit);
					
					// Only consider the service if it is more profitable than it is costly
					local travelTime=((netDist[bTile]*30)/(1+(sqrt(AIEngine.GetMaxSpeed(engine)+1)*4*((netDist[bTile]+15)/(netDist[bTile]+1)))).tointeger()); // in days
					// Get the base income for one trip				

					local rawIncome = AICargo.GetCargoIncome(cargo, crowDist, travelTime)*AIEngine.GetCapacity(engine);
					local production = (aTarget.IsTown()?(AITown.GetMaxProduction(aTarget.GetId()-1000000,cargo)/((aTarget.GetTransportation(-1,cargo)+49)/50+1).tointeger())*(100-aTarget.GetTransportation(-1,cargo)+1)/100:(AIIndustry.GetLastMonthProduction(aTarget.GetId(),cargo)/((aTarget.GetTransportation(-1,cargo)+49)/50+1).tointeger())*(100-aTarget.GetTransportation(-1,cargo)+1)/100).tointeger();
if (Service(schema.GetId(), targetIds, cargo, transportType, subType, engine, crowDist, rawIncome, coverageTarget).IsTwoWayService()){
local productionb = (((bTarget.IsTown()?(AITown.GetMaxProduction(bTarget.GetId()-1000000,cargo)/((bTarget.GetTransportation(-1,cargo)+69)/70+1).tointeger())*(100-bTarget.GetTransportation(-1,cargo)+1)/100:(AIIndustry.GetLastMonthProduction(bTarget.GetId(),cargo)/((bTarget.GetTransportation(-1,cargo)+69)/70+1).tointeger())*(100-bTarget.GetTransportation(-1,cargo)+1)/100))).tointeger();
production=(max(10,sqrt(((production+productionb-max(productionb-production,production-productionb)*4/3)*500))-100)/((bTarget.ProducesCargo(cargo)&&this.targetsConsidered.HasItem(bTarget.GetId()))?2:1)).tointeger();
}					// Project revenue and costs

					local annualProfit = ::lastvehicle+(((rawIncome-((travelTime+15)*AIEngine.GetRunningCost(engine)/90))*production*365/(travelTime+15))*(aTarget.IsTown()?PathZilla.GetSetting("cargo")/5:(10-PathZilla.GetSetting("cargo"))/5)).tointeger();
//AILog.Warning(aTarget.GetName()+production+"|"+rawIncome+"|"+annualProfit);
if ((annualProfit>0||this.potentialServices.Len()<10)&&((PathZilla.GetSetting("cargo")<10||aTarget.IsTown())&&(PathZilla.GetSetting("cargo")>0||!aTarget.IsTown()))){
local water=50;
local stpo=max(abs(AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation())),abs(AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation())));
local wz=1;
for (local i=2;i<=stpo&&wz<=10000000;i++){
local wx=(AIMap.GetTileX(aTarget.GetLocation())-(AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation()))*i/stpo).tointeger();
local wy=(AIMap.GetTileY(aTarget.GetLocation())-(AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation()))*i/stpo).tointeger();
//if (i%10==0)AILog.Info(wx+"/"+wy+"|"+wz);
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
water=abs(water+wz);
wz=0;
}
}
water=abs(water+wz);
wz=0;
local wa=50;
local wz=1;
for (local i=1;i<=AIMap.DistanceManhattan(aTarget.GetLocation(),bTarget.GetLocation())&&wz<=10000000;i++){
local wx=(AIMap.GetTileX(aTarget.GetLocation())-((AIMap.GetTileX(aTarget.GetLocation())>AIMap.GetTileX(bTarget.GetLocation()))?min((AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation())),i):max((AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation())),0-i)));
local wy=(AIMap.GetTileY(aTarget.GetLocation())-((AIMap.GetTileY(aTarget.GetLocation())>AIMap.GetTileY(bTarget.GetLocation()))?min((AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation())),max(0,i-abs(AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation())))):max((AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation())),0-max(0,i-abs(AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation()))))));
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
wa=abs(wa+wz);
wz=0;
}
}
wa=abs(wa+wz);
wz=0;
water=min(water,wa);
wa=50;
wz=1;
//AILog.Info(water);
for (local i=1;i<=AIMap.DistanceManhattan(aTarget.GetLocation(),bTarget.GetLocation())&&wz<=10000000;i++){
local wy=(AIMap.GetTileY(aTarget.GetLocation())-((AIMap.GetTileY(aTarget.GetLocation())>AIMap.GetTileY(bTarget.GetLocation()))?min((AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation())),i):max((AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation())),0-i)));
local wx=(AIMap.GetTileX(aTarget.GetLocation())-((AIMap.GetTileX(aTarget.GetLocation())>AIMap.GetTileX(bTarget.GetLocation()))?min((AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation())),max(0,i-abs(AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation())))):max((AIMap.GetTileX(aTarget.GetLocation())-AIMap.GetTileX(bTarget.GetLocation())),0-max(0,i-abs(AIMap.GetTileY(aTarget.GetLocation())-AIMap.GetTileY(bTarget.GetLocation()))))));
if (AITile.IsWaterTile(AIMap.GetTileIndex(wx,wy))){
wz+=min(9999,wz+1+(sqrt(wz*8)));
}else{
wa=abs(wa+wz);
wz=0;
}
}
wa=abs(wa+wz);
wz=0;
water=min(water,wa);
if (!aTarget.IsTown())annualProfit=annualProfit/max(1,(AIIndustry.GetAmountOfStationsAround(aTarget.GetId())-RoadManager.GetStations(aTarget, cargo, subType).Count()));
annualProfit=(50000+(annualProfit-abs(water*70))).tointeger();
//AILog.Info(aTarget.GetName()+"-"+bTarget.GetName()+crowDist+"dist."+travelTime+"days"+annualProfit+"$"+water);

						local svc = Service(schema.GetId(), targetIds, cargo, transportType, subType, engine, crowDist, (annualProfit/20).tointeger(), coverageTarget);
if ((annualProfit>min(0,50000-AICompany.GetMaxLoanAmount()/10)-::tt2&&(crowDist<max(90,::vc)*2&&(annualProfit+::tt1>5000-::tt2||(this.potentialServices.Len()<20||(this.potentialServices[0]).GetRawIncome()/2<=annualProfit+500+::tt1))))){
this.potentialServices.Insert(svc);
::tt1=tt1/2;
::tt2+=3333;
if(AICargo.HasCargoClass(cargo, AICargo.CC_MAIL)) {
foreach(cargo,_ in AICargoList()){
if (AICargo.HasCargoClass(cargo, AICargo.CC_PASSENGERS)){

this.potentialServices.Insert(Service(schema.GetId(), targetIds, cargo, transportType, subType, this.SelectEngine(svc.GetTargets(), cargo, transportType, subType, false), crowDist, (annualProfit/20).tointeger(), coverageTarget));
break;
}}}
//if (this.potentialServices.Len()<20||(this.potentialServices.Begin()).GetRawIncome()<annualProfit/19)this.potentialServices.SortBy(profit);
annualProfit=0;					
}}					
					}else{	
//	AILog.Error("    There is no possible path between " + aTarget.GetName() + " and " + bTarget.GetName());
					}
					}
					}
					}
					}
					}
					
		}

	}
}
}}
}

function ServiceManager::LockThis(v) {
local g=AIVehicle.GetGroupID(v);
	foreach(service in this.serviceList) {
		if (!(service.GetVehicles()).IsEmpty()&&AIVehicle.GetGroupID(service.GetVehicles().Begin())==g){
		service.Lock(2000/(service.GetActualFleetSize()+9)+50);
			return true;
		}
	}
	
	return false;
}

/*
 * Checks to see if the company provides a service from a to b for the
 * specified cargo and road type.
 */

function ServiceManager::ProvidesService(targetIds, cargo, transportType, subType) {
	foreach(service in this.serviceList) {
		if(service.GetCargo() == cargo && service.GoesToAll(targetIds)&&service.GetSubType() == subType) {
			return true;
		}
	}
	
	return false;
}

function ServiceManager::TargetsConnected(svc,c=-1) {
local targetIds=svc.GetTargets();
local cargo=((c==-1)?svc.GetCargo():c);
	foreach(service in this.serviceList) {
		if(service.GetCargo() == cargo && ((service.GetTargets()[0].GetName()==svc.GetTargets()[0].GetName()&&service.GetTargets()[1].GetName()==svc.GetTargets()[1].GetName())||(service.GetTargets()[0].GetName()==svc.GetTargets()[1].GetName()&&service.GetTargets()[1].GetName()==svc.GetTargets()[0].GetName()))) {
			return true;
		}
	}
	
	return false;
}

/*
 * Checks to see if the company already provides the specified service.
 */
function ServiceManager::ProvidesThisService(svc) {
	return this.ProvidesService(svc.GetTargetIds(), svc.GetCargo(), svc.GetTransportType(), svc.GetSubType());
}


/*
 * Choose the next best service descriptor from pententialServices to be 
 * implemented in the game world. This function ensures that roads are built to
 * connect the towns in the service to the network (described by actualGraph),
 * builds preliminary stations at the town, and then creates the vehciles that
 * will operate the service.
 */
function ServiceManager::ImplementService() {
	this.potentialServices.SortBy(profit);
	// Check whether or not we can build any more vehicles


	if(::vc >= AIGameSettings.GetValue("vehicle.max_roadveh")) return true;
	
	// Implement the service at the top of the list

	local bestService = null;
for (local pi=0;pi<this.potentialServices.Len();pi++){
bestService=this.potentialServices[pi];
if (!bestService.IsValid()||TargetsConnected(bestService)){
			this.potentialServices.Remove(bestService);
this.potentialServices.SortBy(profit);
continue;
}
local cont=0;
	// Check that we don't already provide this service
for(local tw=0;(tw<1||(bestService.GetTargets()[0]).IsTown())&&tw<2;tw++){
cont=0;
if (tw>0&&(bestService.GetTargets()[0]).IsTown()){
if (bestService.GetCargo()!=0&&!TargetsConnected(bestService,0)){
local engine = this.SelectEngine(bestService.GetTargets(), 0, bestService.GetTransportType(), bestService.GetSubType(), false);
if (engine==null) continue;
bestService=Service(bestService.GetSchemaId(),bestService.GetTargetIds(),0,bestService.GetTransportType(),bestService.GetSubType(),engine,bestService.GetDistance(),bestService.GetRawIncome(),bestService.GetCoverageTarget());
}
}
local ll=0;
		// If we already provide it then move on to the next one
if (((bestService.GetTargets()[0]).GetTransportation(-1,bestService.GetCargo())*(PathZilla.GetSetting("aggressive")+1)<=PathZilla.GetSetting("percent")&&((bestService.GetTargets()[1]).GetTransportation(-1,bestService.GetCargo())*(PathZilla.GetSetting("aggressive")+1)<=PathZilla.GetSetting("percent")||RoadManager.GetStations(bestService.GetTargets()[1], bestService.GetCargo(), bestService.GetSubType()).Count()>=1))&&(!this.TargetsConnected(bestService)&&bestService.WasTransported()*2>=(bestService.GetTargets()[0]).GetTransportation(-1,bestService.GetCargo())/((bestService.GetTargets()[0].IsTown())?1:max(1,(AIIndustry.GetAmountOfStationsAround(bestService.GetTargetIds()[0])-RoadManager.GetStations(bestService.GetTargets()[0], bestService.GetCargo(), bestService.GetSubType()).Count()))))){
foreach(serv in this.serviceList) {
if (serv.GetDistance()>1&&bestService.GetCargo()==serv.GetCargo()&&((serv.GetTargets())[0]).GetName()==((bestService.GetTargets())[0]).GetName()){
ll=1;
break;
}
//AILog.Warning(serv.GetDistance()+"|"+ll+"|"+bestService.GetCargo()+"="+serv.GetCargo()+"|"+((serv.GetTargets())[0]).GetName()+"="+((bestService.GetTargets())[0]).GetName());	
}
}else{ ll=1;
}
if (ll==1) {
cont=1;
break
}
	
	// Only proceed if there are any services left to implement
if ((bestService.GetTargets()[0]==bestService.GetTargets()[1]||((!(bestService.GetTargets()[0]).IsTown()&&AIIndustry.GetLastMonthProduction((bestService.GetTargets()[0]).GetId(),bestService.GetCargo())<max(0,80-::vc/10))||((bestService.GetTargets()[0]).IsTown()&&AITown.GetLastMonthProduction((bestService.GetTargets()[0]).GetId()-1000000,bestService.GetCargo())<max(0,80-::vc/10)))&&AIDate.GetYear(AIDate.GetCurrentDate())-5<=AIGameSettings.GetValue("game_creation.starting_year"))||(!(bestService.GetTargets()[0]).IsTown()&&AIIndustry.GetLastMonthProduction((bestService.GetTargets()[0]).GetId(),bestService.GetCargo())<5)){
			this.potentialServices.Remove(bestService);
this.potentialServices.SortBy(profit);
return false;
}
	if(bestService != null) {
		local success = false;
		local schema = ::pz.GetSchema(bestService.GetSchemaId());
		
(::german)?AILog.Info("Beste Verbindung liefert " + bestService+"."):AILog.Info("Best service takes " + bestService);
		
		// Build infrastructure for the service
		if(bestService.GetTransportType() == AITile.TRANSPORT_ROAD) {
			success = RoadManager.BuildInfrastructure(bestService, schema, this.targetsUpdated);
		}
		
		// If the service implementation failed then move it from the top 
		// position in the list to allow other services to be implemented
		if(!success) {
(::german)?AILog.Warning("  Verwerfe geplante Route..."):AILog.Warning("  Demoting service...");
			(bestService.GetTargets()[1].GetId()>=1000000)?this.targetsConsidered.AddItem(bestService.GetTargets()[1].GetId()-1000000,0):this.targetsConsidered.AddItem(bestService.GetTargets()[1].GetId(),0);
			this.potentialServices.Remove(bestService);
this.potentialServices.SortBy(profit);
			cont=1;
			break;
		}

		// Create a fleet of vehicles to operate this service
if (cont==0){
		bestService.Create();
		this.CreateFleet(bestService);
}
		// Finally, add the service to the list	
if (bestService.GetActualFleetSize()<1){
(::german)?AILog.Warning("  Keine Fahrzeuge vorhanden..."):AILog.Warning("  No fleet created...");
			this.potentialServices.Remove(bestService);
this.potentialServices.SortBy(profit);
			cont=1;
			break;
		}
		this.serviceList.Insert(bestService);
local cargoList=AIList();
local cargo=bestService.GetCargo();
local targets=bestService.GetTargets();
cargoList.AddItem(cargo,0);
if (::german){
AILog.Warning("Service Nr:     "+bestService.GetSchemaId()+"-"+((max(1,(((9*bestService.GetDistance())/::spd)*((((targets.len()==0||!((targets[0])).IsValid())?100:(((targets[0]).IsTown())?max(((targets.len()<2||!((targets[1])).IsValid())?0:(AITown.GetLastMonthProduction((targets[1]).GetId()-1000000,cargo)/2+AITown.GetLastMonthProduction((targets[1]).GetId()-1000000,cargo)-AITown.GetLastMonthTransported((targets[1]).GetId()-1000000,cargo))),(AITown.GetLastMonthProduction((targets[0]).GetId()-1000000,cargo)/2+AITown.GetLastMonthProduction((targets[0]).GetId()-1000000,cargo)-AITown.GetLastMonthTransported((targets[0]).GetId()-1000000,cargo))):(AIIndustry.GetLastMonthProduction((targets[0]).GetId(),cargo)/2+AIIndustry.GetLastMonthProduction((targets[0]).GetId(),cargo)-AIIndustry.GetLastMonthTransported((targets[0]).GetId(),cargo))))+5)/2).tointeger())/max(3,(9*bestService.GetDistance())/::spd))).tointeger()));
AILog.Warning("Fracht:            "+AICargo.GetCargoLabel(cargo));
AILog.Warning("Von:                    "+(targets[0]).GetName());
AILog.Warning("Nach:                "+(targets[1]).GetName());
AILog.Warning("Entfernung: "+bestService.GetDistance());
AILog.Warning("Einkommen: "+((bestService.GetRawIncome())));
}else{
AILog.Warning("Service Nr:     "+bestService.GetSchemaId()+"-"+((max(1,(((9*bestService.GetDistance())/::spd)*((((targets.len()==0||!((targets[0])).IsValid())?100:(((targets[0]).IsTown())?max(((targets.len()<2||!((targets[1])).IsValid())?0:(AITown.GetLastMonthProduction((targets[1]).GetId()-1000000,cargo)/2+AITown.GetLastMonthProduction((targets[1]).GetId()-1000000,cargo)-AITown.GetLastMonthTransported((targets[1]).GetId()-1000000,cargo))),(AITown.GetLastMonthProduction((targets[0]).GetId()-1000000,cargo)/2+AITown.GetLastMonthProduction((targets[0]).GetId()-1000000,cargo)-AITown.GetLastMonthTransported((targets[0]).GetId()-1000000,cargo))):(AIIndustry.GetLastMonthProduction((targets[0]).GetId(),cargo)/2+AIIndustry.GetLastMonthProduction((targets[0]).GetId(),cargo)-AIIndustry.GetLastMonthTransported((targets[0]).GetId(),cargo))))+5)/2).tointeger())/max(3,(9*bestService.GetDistance())/::spd))).tointeger()));
AILog.Warning("Cargo:              "+AICargo.GetCargoLabel(cargo));
AILog.Warning("From:                  "+(targets[0]).GetName());
AILog.Warning("To:                       "+(targets[1]).GetName());
AILog.Warning("Distance:        "+bestService.GetDistance());
AILog.Warning("Raw Income:"+((bestService.GetRawIncome())));
}
if (!(bestService.GetTargets()[0]).IsTown()&&!(bestService.GetTargets()[1]).IsTown()&&bestService.IsValid()){
		foreach (prodcargo , _ in AIIndustryType.GetProducedCargo(AIIndustry.GetIndustryType((bestService.GetTargets()[0]).GetId()))){
		foreach (acceptcargo , _ in AIIndustryType.GetAcceptedCargo(AIIndustry.GetIndustryType((bestService.GetTargets()[1]).GetId()))){
		if ((!cargoList.HasItem(prodcargo)&&prodcargo==acceptcargo&&AICargo.GetTownEffect(prodcargo)!=AICargo.TE_PASSENGERS&&AICargo.GetTownEffect(prodcargo)!=AICargo.TE_MAIL)&&(bestService.GetTargets()[0]).GetTransportation(-1,prodcargo)*(PathZilla.GetSetting("aggressive")+1)<=PathZilla.GetSetting("percent")) {
local engine = this.SelectEngine(bestService.GetTargets(), prodcargo, bestService.GetTransportType(), bestService.GetSubType(), false);
if (engine!=null){
local farmService=Service(bestService.GetSchemaId(),bestService.GetTargetIds(),prodcargo,bestService.GetTransportType(),bestService.GetSubType(),engine,bestService.GetDistance(),bestService.GetRawIncome(),bestService.GetCoverageTarget());
local schema = ::pz.GetSchema(farmService.GetSchemaId());
		farmService.Create();
		this.CreateFleet(farmService);
                this.serviceList.Insert(farmService);
if (::german){
AILog.Warning("Service Nr:     "+bestService.GetSchemaId()+"-"+((max(1,(((9*bestService.GetDistance())/::spd)*((((targets.len()==0||!((targets[0])).IsValid())?100:(((targets[0]).IsTown())?max(((targets.len()<2||!((targets[1])).IsValid())?0:(AITown.GetLastMonthProduction((targets[1]).GetId()-1000000,prodcargo)/2+AITown.GetLastMonthProduction((targets[1]).GetId()-1000000,prodcargo)-AITown.GetLastMonthTransported((targets[1]).GetId()-1000000,prodcargo))),(AITown.GetLastMonthProduction((targets[0]).GetId()-1000000,prodcargo)/2+AITown.GetLastMonthProduction((targets[0]).GetId()-1000000,prodcargo)-AITown.GetLastMonthTransported((targets[0]).GetId()-1000000,prodcargo))):(AIIndustry.GetLastMonthProduction((targets[0]).GetId(),prodcargo)/2+AIIndustry.GetLastMonthProduction((targets[0]).GetId(),prodcargo)-AIIndustry.GetLastMonthTransported((targets[0]).GetId(),prodcargo))))+5)/2).tointeger())/max(3,(9*bestService.GetDistance())/::spd))).tointeger()));
AILog.Warning("Fracht:            "+AICargo.GetCargoLabel(prodcargo));
AILog.Warning("Von:                    "+(targets[0]).GetName());
AILog.Warning("Nach:                "+(targets[1]).GetName());
AILog.Warning("Entfernung: "+bestService.GetDistance());
AILog.Warning("Einkommen: "+((bestService.GetRawIncome())));
}else{
AILog.Warning("Service Nr:     "+bestService.GetSchemaId()+"-"+((max(1,(((9*bestService.GetDistance())/::spd)*((((targets.len()==0||!((targets[0])).IsValid())?100:(((targets[0]).IsTown())?max(((targets.len()<2||!((targets[1])).IsValid())?0:(AITown.GetLastMonthProduction((targets[1]).GetId()-1000000,prodcargo)/2+AITown.GetLastMonthProduction((targets[1]).GetId()-1000000,prodcargo)-AITown.GetLastMonthTransported((targets[1]).GetId()-1000000,prodcargo))),(AITown.GetLastMonthProduction((targets[0]).GetId()-1000000,prodcargo)/2+AITown.GetLastMonthProduction((targets[0]).GetId()-1000000,prodcargo)-AITown.GetLastMonthTransported((targets[0]).GetId()-1000000,prodcargo))):(AIIndustry.GetLastMonthProduction((targets[0]).GetId(),prodcargo)/2+AIIndustry.GetLastMonthProduction((targets[0]).GetId(),prodcargo)-AIIndustry.GetLastMonthTransported((targets[0]).GetId(),prodcargo))))+5)/2).tointeger())/max(3,(9*bestService.GetDistance())/::spd))).tointeger()));
AILog.Warning("Cargo:              "+AICargo.GetCargoLabel(prodcargo));
AILog.Warning("From:                  "+(targets[0]).GetName());
AILog.Warning("To:                       "+(targets[1]).GetName());
AILog.Warning("Distance:        "+bestService.GetDistance());
AILog.Warning("Raw Income:"+((bestService.GetRawIncome())));
}
cargoList.AddItem(prodcargo,0);
}
}
}
}}
}else cont=1;
if (cont==1) {
			this.targetsConsidered.RemoveItem((best.Service.GetTargets()[0]).GetId());
continue;
}
(::german)?AILog.Info("Verbindung erfolgreich fertiggestellt."):AILog.Info("Done implementing service.");
::pz.HandleEvents();
::lastservice=AIDate.GetCurrentDate();
this.MaintainServices();
	}

	// Don't remove it until we are finished
			this.potentialServices.Remove(bestService);
this.potentialServices.SortBy(profit);
if (cont==1&&FinanceManager.GetAvailableFunds() >= (AICompany.GetMaxLoanAmount() / 5)) continue;
		return true;
}
}

/*
 * Choose an engine to run between two specified towns, and carry the specified
 * cargo. This method is compatible with NewGRF sets that require vehciles to 
 * be refitted.
 */
function ServiceManager::SelectEngine(targets, cargo, transportType, subType, checkStations,best=false) {
	local availableFunds = FinanceManager.GetAvailableFunds();
	// Calculate the total distance
	local distance = 0;
	local prev = 0;
local cc=1

	for(local next = 1; next < targets.len(); next++) {
		distance += AITile.GetDistanceManhattanToTile(targets[prev].GetTile(), targets[next].GetTile());
	}
	local prod=((((targets.len()==0||!((targets[0])).IsValid())?100:(((targets[0]).IsTown())?max(((targets.len()<2||!((targets[1])).IsValid())?0:(AITown.GetLastMonthProduction((targets[1]).GetId()-1000000,cargo)/2+AITown.GetLastMonthProduction((targets[1]).GetId()-1000000,cargo)-AITown.GetLastMonthTransported((targets[1]).GetId()-1000000,cargo))),(AITown.GetLastMonthProduction((targets[0]).GetId()-1000000,cargo)/2+AITown.GetLastMonthProduction((targets[0]).GetId()-1000000,cargo)-AITown.GetLastMonthTransported((targets[0]).GetId()-1000000,cargo))):(AIIndustry.GetLastMonthProduction((targets[0]).GetId(),cargo)/2+AIIndustry.GetLastMonthProduction((targets[0]).GetId(),cargo)-AIIndustry.GetLastMonthTransported((targets[0]).GetId(),cargo))))+5)/2).tointeger();
if (distance==0)distance=::spd;
	local nc=(max(1,(((9*distance)/::spd)*prod)/max(4,(9*distance)/::spd))).tointeger();
	local vtTypeMap = {};
	vtTypeMap[AITile.TRANSPORT_ROAD] <- AIVehicle.VT_ROAD;
	local cpm=0;
	local engineList = AIEngineList(vtTypeMap[transportType]);
	foreach(engine, _ in engineList) {
		
		local ok = true; 
		if(transportType == AITile.TRANSPORT_ROAD) {
			if(AIEngine.GetRoadType(engine) != subType) ok = false;
		}
		if(!(AIEngine.GetCargoType(engine) == cargo || AIEngine.CanRefitCargo(engine, cargo))) ok = false;
		if(AIEngine.GetPrice(engine) == 0) ok = false;
cc=AIEngine.GetCapacity(engine);		
if(cc <= 0) ok = false;
if (ok)cpm=max(((nc*((cc/nc)*(cc/nc))+min(nc,cc)+max(0,cc-nc)*((nc-max(0,cc-nc))/nc))/(((cc/nc)*(cc/nc))+1)).tointeger(),cpm);

//		if(AIEngine.GetPrice(engine) > availableFunds) ok = false;
local fz=0;
for (;AIEngine.GetPrice(engine)>=FinanceManager.GetAvailableFunds()&&ok==true;){
if (fz%10==9){
SaveMoney();
}
if(AICompany.GetBankBalance(AICompany.COMPANY_SELF)<88888)		PathZilla.Sleep(1);
::pz.HandleEvents();
FinanceManager.EnsureFundsAvailable(AIEngine.GetPrice(engine)+1111);
fz++;
}
		engineList.SetValue(engine, (ok) ? 1 : 0);
	}
	
	// Discount vehicles that are invalid or that can't be built
	engineList.RemoveValue(0);

	// If none are left, then return with nothing	
	if(engineList.Count() == 0) {
		return null;
	}
	// Build a function to compute the profit making potential of each vehicle
	local profitValuator = function (engine, cargo, distance,nc) {
		local travelTime = (179 * distance) / (10 * AIEngine.GetMaxSpeed(engine)); // AIEngine.GetReliability(engine) / 100
		travelTime = max(1, travelTime); // Compensate for ultra-fast vehicles
		local unitIncome = AICargo.GetCargoIncome(cargo, distance, travelTime);
		local period = 12; // years
		local tco = AIEngine.GetPrice(engine) + (AIEngine.GetRunningCost(engine) * period);
		local cc=AIEngine.GetCapacity(engine);		
		local income = unitIncome * ((nc*((cc/nc)*(cc/nc))+min(nc,cc)+max(0,cc-nc)*((nc-max(0,cc-nc))/nc))/(((cc/nc)*(cc/nc))+1)) * ((364 * period) / travelTime); 
		local profit = ((income*AIEngine.GetReliability(engine)/90).tointeger())-tco+AICompany.GetMaxLoanAmount()/10;
		return profit;

	}
	
	// Find the highest profit level
	engineList.Valuate(profitValuator, cargo, distance,nc);
	engineList.Sort(AIAbstractList.SORT_BY_VALUE, false);
	local maxProfit = engineList.GetValue(engineList.Begin());
	engineList.RemoveBelowValue((maxProfit/2).tointeger());

	// Findthe highest capacity
	engineList.Valuate(AIEngine.GetCapacity);
	engineList.Sort(AIAbstractList.SORT_BY_VALUE, false);
	local maxCapactiy = engineList.GetValue(engineList.Begin());
	engineList.RemoveBelowValue((min(maxCapactiy/2,cpm/3)).tointeger());

	// Get the minimum acceptance for the service
	local minAcceptance = -1;
	
	if(checkStations) { 
		// Get coverage radius of stations the vechies will stop at
		local truckStation = !AICargo.HasCargoClass(cargo, AICargo.CC_PASSENGERS);
		local stationType = (truckStation) ? AIStation.STATION_TRUCK_STOP : AIStation.STATION_BUS_STOP;
		local radius = AIStation.GetCoverageRadius(stationType);

		// Create a valuator function to rank stations based on acceptance
		local accValuator = function(station, cargo, radius) {
			return AITile.GetCargoAcceptance(AIStation.GetLocation(station), cargo, 1, 1, radius) + 1;
		}

		// Get the minimum level of acceptance for each target		
		minAcceptance = 10000000;
		foreach(target in targets) {
			local stations = RoadManager.GetStations(target, cargo, subType);
			stations.Valuate(accValuator, cargo, radius);
			minAcceptance = min(minAcceptance, ListSum(stations));
		}
	}
	
	// Rank the remaining engines by their score
if (engineList.IsEmpty())return null;	
	foreach(engine, _ in engineList) {

/*		local profitTerm = (max(0, profitValuator(engine, cargo, distance)) * 100);
		local reliabilityTerm = AIEngine.GetReliability(engine);
		local normCapacity = (AIEngine.GetCapacity(engine) * 100) / maxCapactiy;
		local accUpper = 100;
		local overkillTerm = 100 - abs(normCapacity - (min(minAcceptance, accUpper) * 100 / accUpper));
		*/
cc=AIEngine.GetCapacity(engine);
		local score = ((((nc*((cc/nc)*(cc/nc))+min(nc,cc)+max(0,cc-nc)*((nc-max(0,cc-nc))/nc))/(((cc/nc)*(cc/nc))+1))*200+AIEngine.GetMaxSpeed(engine)*6*(90+AIEngine.GetReliability(engine))-AIEngine.GetRunningCost(engine))*2222/(200+(min(30000,AIEngine.GetPrice(engine)*((AIEngine.GetPrice(engine)*100)/FinanceManager.GetAvailableFunds()+1).tointeger()))))+1;

		//(profitTerm + reliabilityTerm + overkillTerm) / 3);
		engineList.SetValue(engine, score);

	}
	engineList.Sort(AIAbstractList.SORT_BY_VALUE, false);
if (best)return engineList.Begin();
	local mmq=engineList.GetValue(engineList.Begin());
	// If the engines are good enough then choose randomly from the best ones 
	if(mmq >= PathZilla.ENGINE_SCORE_THRESHOLD) {
		engineList.RemoveBelowValue((mmq*2/3).tointeger());
 	foreach(engine, _ in engineList) {
local ab=engineList.GetValue(engine)%AIDate.GetMonth(AIDate.GetCurrentDate());
engineList.SetValue(engine,ab);
	}
engineList.Sort(AIAbstractList.SORT_BY_VALUE, false);
	
}

if (engineList.IsEmpty())return null;	
	// Return the selected engine

	return engineList.Begin();


}

/*
 * Create a fleet of vehicles for the specified service. This method assumes 
 * that the towns that the service run between are already on the network and  
 * have stations built. The function finds the nearest depot, then estimates a 
 * suitable fleet size, then builds the vehicles with randomly distributed 
 * orders between the stations in both towns.
 */
function ServiceManager::CreateFleet(service, update = false,pnum=0,rek=0) {
	// Initialise
	local vnum=((::vc)/100+1).tointeger();
        local cargo = service.GetCargo();	
        local isIndustry = false;
	// Get the stations
	local stations = {};
	local depots = {};
	// Get type of station the vechies will stop at
	local truckStation = !AICargo.HasCargoClass(cargo, AICargo.CC_PASSENGERS);
	local stationType = (truckStation) ? AIStation.STATION_TRUCK_STOP : AIStation.STATION_BUS_STOP;
	local radius = AIStation.GetCoverageRadius(stationType);
	local waitingCargo = 0;
	local bt=0;
		
	

// Select an engine type


local funds = min(2500000,max(0, FinanceManager.GetAvailableFunds() - (PathZilla.FLOAT/10)*vnum));
	local engine = null;
local price=PathZilla.FLOAT;
local fz=0;
	if(update) {
if (service.IsLocked())return false;
for (;funds-price<0;funds=FinanceManager.GetAvailableFunds() - (PathZilla.FLOAT/10)*vnum){
if (fz%10==9){
SaveMoney();
}
//PathZilla.Sleep(1);
fz++;
::pz.HandleEvents();
FinanceManager.EnsureFundsAvailable(price+5000,false);
		engine = this.SelectEngine(service.GetTargets(), cargo, service.GetTransportType(), service.GetSubType(), true);;
if (engine!=null){
price = AIEngine.GetPrice(engine);
}else{
price=20000;
}	
}
if (engine == null){
engine=service.GetEngine();
if (engine == null){
(::german)?AILog.Warning("  Geplante Verbindung wird verworfen..."):AILog.Warning("  Demoting service...");
SellVehicles(service,service.GetActualFleetSize());
			service.CloseService();
			return false;
}
}
} else {
for (;funds-price<0;funds=FinanceManager.GetAvailableFunds() - (PathZilla.FLOAT/10)*vnum,fz==1){
if (fz%10==9){
SaveMoney();
}
if(AICompany.GetBankBalance(AICompany.COMPANY_SELF)<88888)		PathZilla.Sleep(1);
::pz.HandleEvents();
fz++;
FinanceManager.EnsureFundsAvailable(PathZilla.FLOAT+5000,fz==1);
engine = this.SelectEngine(service.GetTargets(), cargo, service.GetTransportType(), service.GetSubType(), true);
if (engine!=null){
price = AIEngine.GetPrice(engine);
}else{
price=20000;
}
}
if (engine == null)engine = this.SelectEngine(service.GetTargets(), cargo, service.GetTransportType(), service.GetSubType(), true);
if (engine == null){
engine=service.GetEngine();
if (engine == null){
(::german)?AILog.Warning("  Geplante Verbindung wird verworfen..."):AILog.Warning("  Demoting service...");
			this.potentialServices.Remove(service);
			return false;
}
}
		service.SetEngine(engine);
	}	
	

// Get a few basic details

local capacity = AIEngine.GetCapacity(engine)+1;
local refcap = capacity;
	
	local speed = AIEngine.GetMaxSpeed(engine);
	local distance = 0;
	local prev = 0;
	local fz=0;
	for(local next = 1; next < service.GetTargets().len(); next++) {
		distance += AITile.GetDistanceManhattanToTile(service.GetTargets()[prev].GetLocation(), service.GetTargets()[next].GetLocation());
	}


	// Calculate the required fleet size
	local fleetSize = 0;
	local updateSize=0;
	local jam=0;
	// If we are updating the service, base the decision on waiting cargo
foreach(target in service.GetTargets()) {
		if (!service.IsValid()||!target.IsValid()) return;
		stations[target.GetId()] <- RoadManager.GetStations(target, cargo, service.GetSubType());
		if(!target.IsTown()) isIndustry = true;

		// If the target has no stations then there is no point in building a 
		// fleet - defer until stations have been built
		if(stations[target.GetId()].Count() == 0) {
//			AILog.Warning("No stations at " + target.GetName());
			return;
		}
	}
	if(update) {


		// Get the total waiting cargo for all targets
		local rating=10;
		local vv=0;
		// Prime the station lists with waiting cargo values
		foreach(target in service.GetTargets()) {
			if (!target.IsValid())continue;
			local rr=85;

			foreach(station, _ in stations[target.GetId()]) {


				local waiting = AIStation.GetCargoWaiting(station, cargo)+max(0,(60-AIStation.GetCargoRating(station,cargo)));
//				local cap = PathZilla.PAX_SERVICE_CAP_BASE * PathZilla.GetSetting("traffic");
				stations[target.GetId()].SetValue(station, waiting);
				if (fz==0){
				rr=min(AIStation.GetCargoRating(station,cargo),rr);
				jam+=service.VehiclesWaiting(station,AIStation.GetCargoRating(station,cargo)<1);
				if (AIVehicleList_Station(station).IsEmpty()&&service.GetDistance()>1)vv++;
				if (!AITown.HasStatue(AIStation.GetNearestTown(station))&&AICompany.GetLoanAmount()<9&&(AICompany.GetBankBalance(AICompany.COMPANY_SELF)>PathZilla.FLOAT*15||(rating==69&&waiting<1))&&AIVehicleList_Station(station).HasItem(service.GetVehicles().Begin())){
				TownManager.BuildStatue(AIStation.GetNearestTown(station));
			

				return false;
				}
				}
			}
			if (fz==0)rating=max(rating,rr);
			if (service.IsTwoWayService()){ fz=0;
}else{ fz++;}
			waitingCargo += ListSum(stations[target.GetId()]);
		}

		// Estimate the number of additional vechiles required based on waiting cargo
jam=(jam*2/3).tointeger();
if(AICargo.GetTownEffect(cargo)==AICargo.TE_MAIL)waitingCargo=waitingCargo/2;
if (waitingCargo==0&&!((service.GetTargets()[0]).IsTown())){
if (!AIIndustryType.IsRawIndustry(AIIndustry.GetIndustryType((service.GetTargets()[0]).GetId())))service.VehiclesWaiting((stations[(service.GetTargets()[0]).GetId()]).Begin(),true);
}
if (waitingCargo<capacity/2&&(rating>65||service.IsTwoWayService())){
if (jam-min(4,((service.GetActualFleetSize()+1)/(AIVehicleList_Station((stations[(service.GetTargets()[0]).GetId()]).Begin()).Count()+1)*service.GetActualFleetSize()))-(service.GetActualFleetSize()/8).tointeger()>0){
		updateSize = service.GetActualFleetSize()-min((service.GetActualFleetSize()/3+1).tointeger(),(jam-min(4,((service.GetActualFleetSize()+1)/(AIVehicleList_Station((stations[(service.GetTargets()[0]).GetId()]).Begin()).Count()+1)*service.GetActualFleetSize()))-(service.GetActualFleetSize()/12).tointeger()));
}else{
updateSize = service.GetActualFleetSize()+(1-min(max(0,jam-(service.GetActualFleetSize()/25).tointeger()),1))*(55-max(54,min(rating,55)))*min(1,service.GetDistance()-1)*(1-min(1,service.IsProfitable(true)))*((service.IsLocked())?0:1)+vv;
}
}else{
		updateSize = (service.GetActualFleetSize()+((sqrt(waitingCargo/((capacity+1)*10))).tointeger()+(55-max(54,min(rating,55))))*(1-min(max(0,jam-(service.GetActualFleetSize()/25).tointeger()),1)*(70-max(69,min(rating,70))))*min(1,service.GetDistance()-1)*(1-min(1,service.IsProfitable(true))))*((service.IsLocked())?0:1)+vv;
}
	}
if (service.IsTwoWayService()) jam=(jam/max(3,service.GetActualFleetSize()/10)).tointeger();

if (jam>1&&waitingCargo<capacity/2){
foreach (zk,_ in service.GetVehicles()){
if(AIVehicle.GetCargoLoad(zk,cargo)==0&&AIVehicle.GetCurrentSpeed(zk)<30&&AIStation.IsValidStation(AIStationList_Vehicle(zk).Begin())&&AIMap.DistanceManhattan(AIVehicle.GetLocation(zk),AIStation.GetLocation(AIStationList_Vehicle(zk).Begin()))<8){
if (AIOrder.GetOrderFlags(zk,AIOrder.ORDER_CURRENT)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)){
	AIVehicle.SendVehicleToDepotForServicing(zk);
}
	AIVehicle.ReverseVehicle(zk);
}}}
	// Find the minimum acceptance level
	local minAcceptance = 1000000;
	local accSum = {};
local prod=0;
local zz=0;
local tt=0;
local big=0;
local stc=0;
	local kas=(((service.GetTargets()[0]).IsTown())?1:((sqrt(AIIndustry.GetAmountOfStationsAround((service.GetTargets()[0]).GetId())))).tointeger());
	foreach(target in service.GetTargets()) {
	foreach(station, _ in stations[target.GetId()]) {
	
local tgpp=target.GetProduction(station,cargo);
local tgtt=target.GetTransportation(station,cargo);
		

			local acceptance = (AITile.GetCargoAcceptance(AIStation.GetLocation(station), cargo, 1, 1, radius) + 1)*(100-tgtt)/100;

if (zz==0){
stations[target.GetId()].SetValue(station, 100-AIStation.GetCargoRating(station,cargo));
}else{
			stations[target.GetId()].SetValue(station, acceptance*1000/(AIVehicleList_Station(station).Count()+1));
}
if (zz==0||(service.IsTwoWayService()&&prod*tt<tgpp*(100-max(35,tgtt)))){
bt=zz;
big=AITile.GetClosestTown(target.GetLocation());
prod=target.GetProduction(station,cargo);
if (tgtt>45)kas=1;
tt=100-max(35,tgtt);
stc=(stations[target.GetId()]).Count();
}
		}
zz++
	// Get the minimum acceptance of all targets
	accSum[target.GetId()] <- ListSum(stations[target.GetId()]);
if(target.AcceptsCargo(cargo)) {
	minAcceptance = min(minAcceptance, accSum[target.GetId()]);
}
		}
	if (minAcceptance==1000000) minAcceptance=0;


	// Estimate the amount that will be waiting and other details that will 
	// influence our decision on fleet size.
		// Estimate how many vehicles will be needed to cover the route
	if(isIndustry) {
fleetSize = ((((((PathZilla.GetSetting("traffic") * prod* (distance+5-(((distance*distance)/2060).tointeger()))*tt) / (((capacity+5+min(capacity/3,(capacity*capacity)/500).tointeger()*2))).tointeger()) /max(1,kas)/ speed)/188)*PathZilla.INDUSTRY_FLEET_MULTI/2)/(max(1,AIGameSettings.GetValue("economy.day_length_factor")))+0.6).tointeger();
}else{
fleetSize = (((((((PathZilla.GetSetting("traffic") * prod* (distance+5-(((distance*distance)/2240).tointeger()))*tt) / (((capacity+5+min(capacity/3,(capacity*capacity)/500).tointeger()*2))).tointeger()) /max(1,kas)/ speed)/195))/stc)/(max(1,AIGameSettings.GetValue("economy.day_length_factor")))+0.6).tointeger();
}			

//AILog.Warning(PathZilla.GetSetting("traffic")*prod/2+ "*"+tt+"% /" + capacity +"*"+(distance+3-(((distance*distance)/2000).tointeger())) +"/"+speed+"="+fleetSize+"|"+kas);

	// Adjust the fleet size for early routes
	// TODO: Make this more generic
//	local year = AIDate.GetYear(AIDate.GetCurrentDate());
//	if(year < 1950) {
//		year = max(year, 1905);
//		fleetSize = (fleetSize * (year - 1900)) / 50;
//	}

	// Ensure the fleet is not too small, there is at least one vehicle per station
	local minFleetSize = 0;
	foreach(target in service.GetTargets()) {
		minFleetSize += stations[target.GetId()].Count();
	}
	fleetSize = max(minFleetSize, fleetSize);

	if(update) {
if (waitingCargo<capacity/2&&min((service.GetActualFleetSize()/3+1).tointeger(),jam-(min(3,((service.GetActualFleetSize()+1)/(AIVehicleList_Station((stations[(service.GetTargets()[0]).GetId()]).Begin()).Count()+1)*service.GetActualFleetSize()))+(service.GetActualFleetSize()/10).tointeger()))>0&&(fleetSize<service.GetActualFleetSize()||service.IsTwoWayService())) {
SellVehicles(service,min((service.GetActualFleetSize()/2+1).tointeger(),(jam/3).tointeger()),true);
return;
}
if ((((!(service.GetTargets()[0]).IsTown())&&jam-(service.GetActualFleetSize()/20).tointeger()>0)||jam-(service.GetActualFleetSize()/20).tointeger()>0)){
fleetSize = min(max(updateSize,service.GetActualFleetSize()),((fleetSize*3)/2).tointeger());
}else{
fleetSize = min(max(updateSize,service.GetActualFleetSize()),max(((fleetSize*3)/2).tointeger(),service.GetActualFleetSize()+1))
}
}

	
	// Ensure we have no more than the maximum number of vehicles
	fleetSize = min(fleetSize, PathZilla.MAX_VEHICLES_PER_SVC);
	
	// If were updating, account for vehicles already built
	if(update) {
		updateSize = fleetSize - service.GetActualFleetSize();
		local zz=service.WithProfit();
		if(zz==0) {
local ee = (jam-(min(3,((service.GetActualFleetSize()+1)/(AIVehicleList_Station((stations[(service.GetTargets()[0]).GetId()]).Begin()).Count()+1)*service.GetActualFleetSize()))+(service.GetActualFleetSize()/10).tointeger()))<1||RoadManager.BuildInfrastructure(service, ::pz.GetSchema(service.GetSchemaId()), this.targetsUpdated);
if (ee==false){
(::german)?AILog.Warning("Transport von " + service + " erbringt keinen Profit."):AILog.Warning("Service for " + service + " did not turn a profit last year");
SellVehicles(service,service.GetVehicles().Count());
(::german)?AILog.Warning("  Verbindung wird geschlossen..."):AILog.Warning("  Demoting service...");
service.CloseService();
return;	
}else{		
//SellVehicles(service,max(zz,1))
			return;
}		
} else {
			fleetSize = max(0, updateSize);
		}
	}else{
if (service.IsTwoWayService()){
fleetSize=fleetSize/((isIndustry)?max(stations[(service.GetTargets()[0]).GetId()].Count(),stations[(service.GetTargets()[1]).GetId()].Count()):max(max(30,AITown.GetHouseCount((service.GetTargets()[0]).GetId()-1000000))/30,max(30,AITown.GetHouseCount((service.GetTargets()[1]).GetId()-1000000))/30)).tointeger();
}else{
fleetSize=fleetSize/(((isIndustry)?stations[(service.GetTargets()[0]).GetId()].Count():max(30,AITown.GetHouseCount(target.GetId()-1000000))/30)).tointeger();
}
fleetSize=max(1,fleetSize);
}
	// Do not attempt to build more than we can actually afford

while(FinanceManager.GetAvailableFunds()<AIEngine.GetPrice(engine)+500){
this.FindNewServices(3);
::pz.HandleEvents();
FinanceManager.EnsureFundsAvailable(AIEngine.GetPrice(engine)+1111);
}
	local maxFleetSize = funds / AIEngine.GetPrice(engine);
	fleetSize = min(maxFleetSize, ((pnum<1)?fleetSize:pnum));

	// If there is no fleet to build then just return now
	if(fleetSize <= 0) return;
local nodep=false;
local bhff={};
local stz=0;
		foreach(target in service.GetTargets()) {
stz++;
RoadManager.BuildIndustryStation(target, service.GetCargo(), service.GetSubType(),fleetSize);
stations[target.GetId()]<-RoadManager.GetStations(target, cargo, service.GetSubType());
local conmax=0;
local cons=stations[target.GetId()].Begin();
foreach(stdd,_ in RoadManager.GetStations(target, cargo, service.GetSubType())){
local elist=AIVehicleList_Station(stdd);
local empty=true;
foreach(v,_ in elist){
if (AIEngine.GetCargoType(AIVehicle.GetEngineType(v))==AIEngine.GetCargoType(engine)){
empty=false;
break;
}
}
if (empty&&(stz==1||service.IsTwoWayService())){
conmax=100000000;
cons=stdd;
break;
if(!target.IsValid())return false;
}else if (200-AIStation.GetCargoRating(stdd,cargo)+(AIStation.GetCargoWaiting(stdd,cargo)/AIEngine.GetCapacity(engine))/3-AIVehicleList_Station(stdd).Count()*3/2>conmax&&(stz==1||service.IsTwoWayService())){
conmax=200-AIStation.GetCargoRating(stdd,cargo)+(AIStation.GetCargoWaiting(stdd,cargo)/AIEngine.GetCapacity(engine))/3-AIVehicleList_Station(stdd).Count()*3/2;
cons=stdd;
}else if (AIStation.GetConstructionDate(stdd)>conmax&&stz==2&&!service.IsTwoWayService()){
conmax=AIStation.GetConstructionDate(stdd);
cons=stdd;
}
stations[target.GetId()].SetValue(stdd, 0)
}
stations[target.GetId()].SetValue(cons, accSum[target.GetId()]);
bhff[target.GetId()]<-RandomItemByWeight(stations[target.GetId()], accSum[target.GetId()]);
	local depotList = AIDepotList(AITile.TRANSPORT_ROAD);
	depotList.Valuate(AIRoad.HasRoadType, service.GetSubType());
	depotList.KeepValue(1);
	depotList.Valuate(AITile.GetDistanceManhattanToTile, AIStation.GetLocation(bhff[target.GetId()]));
	depotList.Sort(AIAbstractList.SORT_BY_VALUE, false);
	depotList.KeepBottom(1);
	depots[target.GetId()] <- depotList.Begin();
(AITile.GetDistanceManhattanToTile(AIStation.GetLocation(bhff[target.GetId()]),depots[target.GetId()])>10)?nodep=true:nodep=false;
}
local adi=(service.GetTargets()[0]).GetId();
local bdi=(service.GetTargets()[1]).GetId();
local newSt=(bhff.len()<2)||(AIVehicleList_Station(bhff[(service.GetTargets()[0]).GetId()]).IsEmpty());
	local engineName = AIEngine.GetName(engine);
if (!service.IsValid()||(service.GetTargets()[0]).GetId()==(service.GetTargets()[1]).GetId())return false;
	this.targetsConsidered.AddItem((service.GetTargets()[0]).GetId(),0);
	
if (update)service.Lock(2000/(waitingCargo+100)+1);	
	// Check if the vehicles will need to be refitted
	local needRefit = (AIEngine.GetCargoType(engine) != service.GetCargo());


	// Clone a fleet from the prototype vehicle
local zz=0;
local ee=0;
local dep=0;
if (nodep||distance<60) {
dep=0;
}else{
dep=1;
}
local vcc=0;
local eqc=0;	
local bhf=0;
	// Borrow enough to buy the whole fleet of vehicles
	FinanceManager.EnsureFundsAvailable(AIEngine.GetPrice(engine) * (fleetSize + 1));
	for(local i = 0; i < fleetSize; i++) {
		// Alternate between targets if they are towns 
		local idx = 0; 
		if(service.IsTwoWayService()) idx = (i+bt) % service.GetTargets().len();
if (idx>0 && service.GetTargets()[idx]==service.GetTargets()[idx-1]){
(::german)?AILog.Warning("  Kann Ziele nicht finden..."):AILog.Warning("  Demoting service...");
			this.potentialServices.Remove(service);
			return false;
}
	local depot = depots[(service.GetTargets()[idx]).GetId()];
		// Build a new vehicle at the nearest depot
	local v =-1;
	// Choose stations and assign orders
		local j = 0;
local jj=0;		
local bz=0;
zz=zz*ee+1;
local ee=1;


foreach(target in service.GetTargets()) {
bhf=bhff[target.GetId()];
if ((bz==0&&i>0&&!AIIndustryType.IsRawIndustry(AIIndustry.GetIndustryType(target.GetId()))&&!service.IsTwoWayService()&&AIStation.GetCargoWaiting(bhf, cargo)<AIEngine.GetCapacity(engine)*zz)||(!newSt&&!((service.GetTargets()[0]).IsTown())&&bz==0&&i>0&&AIStation.GetCargoWaiting(bhf, cargo)<AIEngine.GetCapacity(engine)*zz)){
for (local ww=AIDate.GetCurrentDate();ww+((service.GetDistance())/(rek+1))/(AIEngine.GetMaxSpeed(engine)+20)>AIDate.GetCurrentDate()&&AIStation.GetCargoWaiting(bhf, cargo)<AIEngine.GetCapacity(engine)*zz;){
if (ww%5==2){
if (AIVehicle.IsValidVehicle(service.GetVehicles().Begin())){
if (i>4&&eqc==0&&AIVehicle.GetCargoLoad(service.GetVehicles().Begin(),cargo)<1){
 vcc=1;
fleetSize=((fleetSize-i)/2).tointeger()+i+1
eqc=1;
}}
service.VehiclesWaiting(bhf,true);
if (ww%3==2||FinanceManager.GetAvailableFunds()<PathZilla.FLOAT)SaveMoney();
if (ww%9==5&&this.potentialServices.Len()<30)this.FindNewServices(2);
}
if (rek<88)this.MaintainServices(rek+1);else{ 
i=fleetSize-1;
break;
}
if (this.potentialServices.Len()<10)this.FindNewServices(3);
ee=0;
if (i>0&&!update){
foreach (v,_ in AIVehicleList()){
					if (AIVehicle.IsValidVehicle(v)){
					if (AIVehicle.GetState(v)==AIVehicle.VS_STOPPED&&!AIVehicle.IsStoppedInDepot(v)){		
					AIVehicle.StartStopVehicle(v);
					continue;					
					}}}}

if (vcc==1)break;
}
}

if (bz==0){
v= AIVehicle.BuildVehicle(depot, engine);
(!update)?::lastvehicle=AIDate.GetCurrentDate():0;
		// Wait some time to spread the vechiles out a bit.
if(AIDate.GetYear(AIDate.GetCurrentDate())-AIGameSettings.GetValue("game_creation.starting_year")<33)PathZilla.Sleep(PathZilla.NEW_VEHICLE_SPREAD_DELAY+(5-PathZilla.GetSetting("latency"))*(5-PathZilla.GetSetting("latency"))*100);
if (i==0){
//AILog.Info(((((((((fleetSize*refcap)/AIVehicle.GetRefitCapacity(v,cargo)).tointeger())))*((AIVehicle.GetRefitCapacity(v,cargo)*5)+25)/6).tointeger()/(((refcap*5)+25)/6))).tointeger());
if (refcap!=AIVehicle.GetRefitCapacity(v,cargo)&&AIVehicle.GetRefitCapacity(v,cargo)>2)fleetSize=(((fleetSize*((((refcap*5)+25)/6))).tointeger())/(((AIVehicle.GetRefitCapacity(v,cargo)*5)+25)/6).tointeger())+1;
if(::german){
local rq=engineName.len()-1;
if(rq>2&&engineName[rq]=='s'&&engineName[rq-1]=='u'&&(engineName[rq-2]=='b'||engineName[rq-2]=='B')&&fleetSize>1)engineName=engineName+"se";
}
(::german)?AILog.Info(((update) ? "   Aufstockung um " : "  Kaufe ") + (fleetSize) + " " + engineName + "..."):AILog.Info(((update) ? "  Updating a fleet with " : "  Building a fleet of ") + (fleetSize)+ " "  + ((fleetSize==1)?engineName+"...":engineName+"s..."));
FinanceManager.EnsureFundsAvailable(AIEngine.GetPrice(engine) * (fleetSize+ 1));
}}
bz++;
			local tile = AIStation.GetLocation(bhf);
local flags = AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY;
local fl=PathZilla.GetSetting("fullLoad");
if (fl==5||(((AIStation.GetCargoWaiting(bhf, cargo)>AIEngine.GetCapacity(engine)*2&&AIStation.GetCargoRating(bhf,cargo)>54)||(((AIVehicleList_Station(bhf).Count()+fleetSize-(i/2))*100)/distance>8&&(AIStation.GetCargoRating(bhf,cargo)>58||(i!=1&&i%3!=2))))&&service.IsTwoWayService())||(fl>1&&AICargo.HasCargoClass(cargo,AICargo.CC_PASSENGERS))||(fl>2&&AICargo.HasCargoClass(cargo,AICargo.CC_MAIL))||(fl>3&&AICargo.GetCargoLabel(cargo)=="VALU")){
flags = AIOrder.AIOF_NON_STOP_INTERMEDIATE;
}			
//			if(!target.IsTown() && target.ProducesCargo(cargo)) flags = flags | AIOrder.AIOF_FULL_LOAD;

if (adi!=(service.GetTargets()[0]).GetId()||bdi!=(service.GetTargets()[1]).GetId())return;
if (service.IsTwoWayService()){
if (big==AITile.GetClosestTown(tile)) {
AIOrder.AppendOrder(v, tile, flags);
if (dep==1&&AIMap.IsValidTile(depots[service.GetTargets()[bz%service.GetTargets().len()].GetId()])&&AIRoad.IsRoadDepotTile(depots[service.GetTargets()[bz%service.GetTargets().len()].GetId()])){
AIOrder.AppendOrder(v, depots[service.GetTargets()[bz%service.GetTargets().len()].GetId()], AIOrder.AIOF_NON_STOP_INTERMEDIATE);
}else if (dep==1){
AIOrder.AppendOrder(v, depots[service.GetTargets()[(bz+1)%service.GetTargets().len()].GetId()], AIOrder.AIOF_NON_STOP_INTERMEDIATE);
}
}else {
AIOrder.AppendOrder(v, tile, AIOrder.AIOF_NON_STOP_INTERMEDIATE);
if (dep==1&&AIMap.IsValidTile(depots[service.GetTargets()[bz%service.GetTargets().len()].GetId()])&&AIRoad.IsRoadDepotTile(depots[service.GetTargets()[bz%service.GetTargets().len()].GetId()])){
AIOrder.AppendOrder(v, depots[service.GetTargets()[bz%service.GetTargets().len()].GetId()], AIOrder.AIOF_NON_STOP_INTERMEDIATE);
}else if (dep==1){
AIOrder.AppendOrder(v, depots[service.GetTargets()[(bz+1)%service.GetTargets().len()].GetId()], AIOrder.AIOF_NON_STOP_INTERMEDIATE);
}
}
}else {
if (jj==0){
 AIOrder.AppendOrder(v, tile, flags);
}else{
 AIOrder.AppendOrder(v, tile, AIOrder.AIOF_NON_STOP_INTERMEDIATE + AIOrder.AIOF_NO_LOAD + AIOrder.AIOF_UNLOAD);
}
if (dep==1&&AIMap.IsValidTile(depots[service.GetTargets()[bz%service.GetTargets().len()].GetId()])&&AIRoad.IsRoadDepotTile(depots[service.GetTargets()[bz%service.GetTargets().len()].GetId()])){
AIOrder.AppendOrder(v, depots[service.GetTargets()[bz%service.GetTargets().len()].GetId()], AIOrder.AIOF_SERVICE_IF_NEEDED | AIOrder.AIOF_NON_STOP_INTERMEDIATE);
}else if (dep==1){
AIOrder.AppendOrder(v, depots[service.GetTargets()[(bz+1)%service.GetTargets().len()].GetId()], AIOrder.AIOF_SERVICE_IF_NEEDED |AIOrder.AIOF_NON_STOP_INTERMEDIATE);
}
/* AIOrder.AppendOrder(v, tile, AIOrder.AIOF_NON_STOP_INTERMEDIATE + AIOrder.AIOF_NO_LOAD + AIOrder.AIOF_UNLOAD);
if (dep==1&&AIMap.IsValidTile(depots[service.GetTargets()[bz%service.GetTargets().len()].GetId()])&&AIRoad.IsRoadDepotTile(depots[service.GetTargets()[bz%service.GetTargets().len()].GetId()])){
AIOrder.AppendOrder(v, depots[service.GetTargets()[bz%service.GetTargets().len()].GetId()], AIOrder.AIOF_NON_STOP_INTERMEDIATE );
}else if (dep==1){
AIOrder.AppendOrder(v, depots[service.GetTargets()[(bz+1)%service.GetTargets().len()].GetId()], AIOrder.AIOF_NON_STOP_INTERMEDIATE);
}
 AIOrder.InsertConditionalOrder(v, jj,jj+1+dep);                        
 AIOrder.SetOrderCondition(v, jj, AIOrder.OC_LOAD_PERCENTAGE);
 AIOrder.SetOrderCompareFunction(v, jj, AIOrder.CF_EQUALS);
 AIOrder.SetOrderCompareValue(v, jj, 100);
*/
if (jj>0) { 
//AIOrder.InsertConditionalOrder(v, jj-1-dep,jj);                        
// AIOrder.SetOrderCondition(v, jj-1-dep, AIOrder.OC_UNCONDITIONALLY);
jj++;
}
		jj=jj+3+dep*2;	
		}
}
if (jj>0 && !service.IsTwoWayService()) { 
//AIOrder.InsertConditionalOrder(v, jj-1-dep,0);                        
// AIOrder.SetOrderCondition(v, jj-1-dep, AIOrder.OC_UNCONDITIONALLY);
}		
		// Refit the vehicle if necessary
		if(needRefit) {
			AIVehicle.RefitVehicle(v, service.GetCargo());
		}
		
		// Share orders if possible
		local vll=AIVehicleList_Station(bhf);
		vll.Valuate(AIOrder.GetOrderCount);
		vll.KeepValue(AIOrder.GetOrderCount(v));
		vll.Valuate(AIVehicle.GetUnitNumber);
		vll.RemoveValue(AIVehicle.GetUnitNumber(v));
if (vll.Count()>0){
		vll.Valuate(AIVehicle.GetAge);
		vll.Sort(AIAbstractList.SORT_BY_VALUE, false);				
		local srf=0;
foreach(vhl, _ in vll) {
		srf=0;
		for(local orv=0;orv<AIOrder.GetOrderCount(vhl);orv++){
			if (AIOrder.GetOrderDestination(v,orv)!=AIOrder.GetOrderDestination(vhl,orv)||AIOrder.GetOrderFlags(v,orv)!=AIOrder.GetOrderFlags(vhl,orv)){
				srf=1;
				break;
			}
		}
if (srf==0){
AIOrder.ShareOrders(v,vhl);
break;
}}}


		// Send the vehicle to the destination nearest the depot we built it at
		AIVehicle.SkipToVehicleOrder(v, idx);
		
		// Add the vehicle to the service
		service.AddVehicle(v);

		// Start the vehicle
		AIVehicle.StartStopVehicle(v);
	if (vcc==1)return;
	}

}

function ServiceManager::SaveMoney() {

foreach(service in this.serviceList) {
if (!service.IsValid())continue;
local zfz=0;
(AIDate.GetMonth(AIDate.GetCurrentDate())<8)?zfz=service.IsProfitable():zfz=service.IsProfitable(true);
if (zfz>0){
SellVehicles(service,(zfz/3).tointeger()+1);
//PathZilla.Sleep(1);
}else{
local smjam=0;
local sfz=0;
local smcargo=service.GetCargo();
local smstations={}
local smwaitingCargo=0;
foreach(smtarget in service.GetTargets()) {
	smstations[smtarget.GetId()] <- RoadManager.GetStations(smtarget, smcargo, service.GetSubType());
if ((smstations[smtarget.GetId()]).Begin()!=null){
	foreach(smstation, _ in smstations[smtarget.GetId()]) {
		local smwaiting = AIStation.GetCargoWaiting(smstation, smcargo)+max(0,(50-AIStation.GetCargoRating(smstation,smcargo)));
		smstations[smtarget.GetId()].SetValue(smstation, smwaiting);
		if (sfz==0){
		smjam+=service.VehiclesWaiting(smstation);
		sfz++
		}
	}
	if (service.IsTwoWayService()) sfz=0;
	smwaitingCargo = ListSum(smstations[smtarget.GetId()]);
}
if (service.IsTwoWayService()) smjam=smjam/2;
if (service.GetActualFleetSize()<1||(smstations[(service.GetTargets()[0]).GetId()]).Count()==0||AIVehicleList_Station((smstations[(service.GetTargets()[0]).GetId()]).Begin()).IsEmpty()) continue;
if (smwaitingCargo<AIEngine.GetCapacity(AIVehicle.GetEngineType(service.GetVehicles().Begin()))/2&&min((service.GetActualFleetSize()/2+1).tointeger(),smjam-(((min(4,((service.GetActualFleetSize()+1)/(AIVehicleList_Station((smstations[(service.GetTargets()[0]).GetId()]).Begin()).Count()+1)*service.GetActualFleetSize()))+(service.GetActualFleetSize()/8).tointeger())*2)/3).tointeger())>0){
service.VehiclesWaiting((smstations[smtarget.GetId()]).Begin(),true);
SellVehicles(service,min((service.GetActualFleetSize()/2+1).tointeger(),(smjam/3).tointeger()),true);
}
smjam=0;
}
}
}
local sz=0;
for (;AICompany.GetBankBalance(AICompany.COMPANY_SELF)*3+1000<PathZilla.FLOAT*2;){

for (;AICompany.GetBankBalance(AICompany.COMPANY_SELF)<0;){
sz++;
local minprofit=10000000;
local sell=null;
if (::vehiclesToSell.Count()==0||sz%100==99){
foreach(service in this.serviceList) {
foreach (v,_ in service.GetVehicles()){
if (AIVehicle.IsValidVehicle(v)){
if (AIVehicle.GetAge(v)>400&&AIVehicle.GetProfitLastYear(v)<minprofit){
minprofit=AIVehicle.GetProfitLastYear(v);
sell=service;
}
}
}
}
}
if (minprofit<0){
SellVehicles(sell,1);
}
if(AICompany.GetBankBalance(AICompany.COMPANY_SELF)<88888)		PathZilla.Sleep(1);
::pz.HandleEvents();
FinanceManager.EnsureFundsAvailable(PathZilla.FLOAT*2);
}
if(AICompany.GetBankBalance(AICompany.COMPANY_SELF)<88888)		PathZilla.Sleep(1);
::pz.HandleEvents();
FinanceManager.EnsureFundsAvailable(PathZilla.FLOAT*2);
}
return;

}

/*
 * Sell the specified number of vehicles from the specified service, selected 
 * at random. This will permanently reduce the service's fleet size.
 */
function ServiceManager::SellVehicles(service, number,jam=false,update=false) {
if (service.GetActualFleetSize()>0){
if (!update){
service.Lock(number*1000/(service.GetActualFleetSize()+9)+number*20);
local gid=AIVehicle.GetGroupID(service.GetVehicles().Begin());
foreach (v,_ in ::vehiclesToSell){
if (!AIVehicle.IsValidVehicle(v)) continue;
if (AIVehicle.GetGroupID(v)==gid)number--;
}
}
}else return;
number=number-max(0,::vehiclesToSell.Count()-(::vc/30).tointeger());
if (number <1) return;
local cargo=service.GetCargo();
if (number >2&&number+1<service.GetActualFleetSize()) number=(number/3).tointeger();
if (jam)((::german)?AILog.Warning("Stau beim Transport von "+service+ "."):AILog.Warning("Service for "+service+ ": vehicles are jamming"));
	local vlist = service.GetVehicles();
	vlist.Valuate(AIVehicle.GetAge);
	vlist.Sort(AIAbstractList.SORT_BY_VALUE, false);
	foreach(vehicle, _ in vlist) {
		local empty = (AIVehicle.GetCargoLoad(vehicle, cargo) == 0);
		if (!empty) vlist.SetValue(vehicle, vlist.GetValue(vehicle)*10*AIVehicle.GetCargoLoad(vehicle, cargo));
	}
	vlist.Sort(AIAbstractList.SORT_BY_VALUE, false);
	
	local i = 1;
local fzz=0;
	for(local vehicle = vlist.Begin(); hasnext(vlist) && ++i <= number+1; vehicle = vlist.Next()) {

		// Turn the vehcile around (to help clear jams) and send it to a depot
if (((service.GetTargets()[0]).IsValid()&&(service.GetTargets()[1]).IsValid())||AIVehicle.GetAge(vehicle)>330&&(!(service.GetTargets()[0]).IsValid()||!(service.GetTargets()[1]).IsValid())&&AIVehicle.GetProfitLastYear(vehicle)<=0&&AIVehicle.GetProfitThisYear(vehicle)<=0){
AIVehicle.ReverseVehicle(vehicle);
if (AIVehicle.GetCargoLoad(vehicle,cargo)*3<AIVehicle.GetCapacity(vehicle,cargo)*2){
if (AIOrder.GetOrderFlags(vehicle,AIOrder.ORDER_CURRENT)==(AIOrder.AIOF_NON_STOP_INTERMEDIATE | AIOrder.AIOF_FULL_LOAD_ANY)&&((AIOrder.GetOrderCount(vehicle)==0||(!AIOrder.IsGotoDepotOrder(vehicle,0)))&&AIVehicle.GetCargoLoad(vehicle,cargo)*5<AIVehicle.GetCapacity(vehicle,cargo)*3)){
		AIVehicle.SendVehicleToDepot(vehicle);	
}}


		fzz++
		// Remember to sell the vehcile when it stops in a depot
						if(!::vehiclesToSell.HasItem(vehicle))::vehiclesToSell.AddItem(vehicle, 0);
}else{i--;}
}
if (fzz>0)(::german)?AILog.Info("  Verkaufe " + fzz + " Fahrzeug" +((fzz>1)?"e":"")+"..."):AILog.Info("  Selling " + fzz + " vehicle" +((fzz>1)?"s":"")+"...");
//this.FindNewServices(3);
}

/*
 * Update orders for all the vehicles in a service to ensure that vechicles are
 * distributed correctly between the available stations. 
 */

function ServiceManager::UpdateOrders(service) {
	// Get the stations
if (service.GetDistance()==1) return;
	local stations = {};
	foreach(target in service.GetTargets()) {
		stations[target.GetId()] <- RoadManager.GetStations(target, cargo, service.GetSubType());

		// If the engine type is articulated, forbid the vehicle from visiting regular stations
		if(AIEngine.IsArticulated(engine)) {
			foreach(station, _ in stations[target.GetId()]) {
				local driveThru = AIRoad.IsDriveThroughRoadStationTile(AIStation.GetLocation(station));
				stations[target.GetId()].SetValue(station, (driveThru) ? 1 : 0);
			}
			stations[target.GetId()].RemoveValue(0);
		}

		// If the target has no stations then there is no point in building a 
		// fleet - defer until stations have been built
		if(stations[target.GetId()].Count() == 0) {
(::german)?AILog.Warning("Keine Haltestelle in " + target.GetName()):AILog.Warning("No stations at " + target.GetName());
			return;
		}
	}

	// Get the coverage radius of the stations	
	local truckStation = !AICargo.HasCargoClass(service.GetCargo(), AICargo.CC_PASSENGERS);
	local stationType = (truckStation) ? AIStation.STATION_TRUCK_STOP : AIStation.STATION_BUS_STOP;
	local radius = AIStation.GetCoverageRadius(stationType);

	// Find the acceptance list sums
	local accSum = {};
	
	foreach(target in service.GetTargets()) {
		foreach(station, _ in stations[target.GetId()]) {
			local acceptance = AITile.GetCargoAcceptance(AIStation.GetLocation(station), cargo, 1, 1, radius) + 1;
			stations[target.GetId()].SetValue(station, acceptance);
		}

		// Get the minimum acceptance of all targets
		accSum[target.GetId()] <- ListSum(stations[target.GetId()]);
	}

	// Shuffle the vehicle orders between the stations
	foreach(v, _ in service.GetVehicles()) {
		local currentOrder = AIOrder.ResolveOrderPosition(v, AIOrder.ORDER_CURRENT);

		// Clear the order list 
		local ocount = AIOrder.GetOrderCount(v);
AIOrder.UnshareOrders(v);
		for(local i = 0; i < ocount; i++) {
			AIOrder.RemoveOrder(v, i);
		}

		// Set the new orders
		foreach(target in service.GetTargets()) {
			local tile = AIStation.GetLocation(RandomItemByWeight(stations[target.GetId()], accSum[target.GetId()]));
			local flags = AIOrder.AIOF_NON_STOP_INTERMEDIATE;
			if(!target.IsTown() && target.ProducesCargo(cargo)) flags = flags & AIOrder.AIOF_FULL_LOAD;
			AIOrder.AppendOrder(v, tile, flags);
		}

		// Ensure the vehicle is still heading to the same town it was before
		AIVehicle.SkipToVehicleOrder(v, currentOrder);
	}
}

function ServiceManager::sortTargets(a=0,b=-1,c=0,d=256){
local dst=d*2-((b<0)?0:AIMap.DistanceManhattan(a.GetLocation(),b));
return((a.IsTown())?AITown.GetLastMonthProduction(a.GetId()-1000000,c)-AITown.GetLastMonthTransported(a.GetId()-1000000,c):AIIndustry.GetLastMonthProduction(a.GetId(),c)-AIIndustry.GetLastMonthTransported(a.GetId(),c))*dst;
}

function ServiceManager::nearTargets(b=0,a=0){
return abs(AIMap.DistanceManhattan(b.GetLocation(),a)-(::spd/2+50).tointeger());
}


function ServiceManager::profit(a=null,b=null){
if (a==null||b==null) return 0;
if (a.rawIncome==b.rawIncome)return 0;
if (a.rawIncome<b.rawIncome)return 1;
return-1;
}

/*
 * Saves data to a table.
 */
function ServiceManager::Serialize() {
	local data = {};
	local t=AIList()
	if(this.targetsUpdated != null){
	foreach (target in this.targetsUpdated.GetData()){
	t.AddItem(target.GetId(),0)
	}
	}
	data[SRLZ_TARGETS_UPDATED] <- ListToArray(t);
	data[SRLZ_TARGETS_CONSIDERED] <- ListToArray(this.targetsConsidered); 
if (this.potentialServices.Len()>0){
	data[SRLZ_POTENTIAL_SERVICES] <- this.potentialServices.Serialize();
}else{	data[SRLZ_POTENTIAL_SERVICES] <- SortedSet().Serialize()}
if (this.serviceList.Len()>0){
	data[SRLZ_SERVICE_LIST] <- this.serviceList.Serialize();
}else{	data[SRLZ_SERVICE_LIST] <- SortedSet().Serialize()}	
	return data;
}

/*
 * Loads data from a table.
 */
function ServiceManager::Unserialize(data) {
	this.targetsUpdated = Map();
	local t=AIList();		
	t.AddList(ArrayToList(data[SRLZ_TARGETS_UPDATED]));
	foreach (target,_ in t){
	this.targetsUpdated.Insert(Target(((target<1000000)?Target.TYPE_INDUSTRY:Target.TYPE_TOWN),target));
	}

	this.targetsConsidered = AIList();
	this.targetsConsidered.AddList(ArrayToList(data[SRLZ_TARGETS_CONSIDERED]));
	
	this.potentialServices = SortedSet();
	this.potentialServices.Unserialize(data[SRLZ_POTENTIAL_SERVICES]);

	this.serviceList = SortedSet();
	this.serviceList.Unserialize(data[SRLZ_SERVICE_LIST]);

}

/*
 * This call should be made after data has been loaded and the game has 
 * started, to load vehicles into the service list.
 */
function ServiceManager::PostLoad() {
	foreach(service in this.serviceList) {
		local vehicles = AIVehicleList();
		vehicles.Valuate(AIVehicle.GetGroupID);
		vehicles.KeepValue(service.group);
		if(vehicles.Count() > 0) service.vehicles.AddList(vehicles);
	}
}
