import("pathfinder.road", "RoadPathFinder", 4);
require("money.nut");
class Util {
    roadpathfinder=RoadPathFinder();
	unbuiltConnections = [];
	tileBlacklist = [];
	
	function GetRoadConnections(tile);
    function BuildRoute(sourcetiles, destinationtiles);
    function FindFreeTileNear(tileID);
    function FilterBuildableTiles();
    static function GetDirectlyAdjacentTiles(tile);
	function IsAreaClear(tile);
	function IsClearableTile(tile);
    static function IndustryTotalCargo(industryID);
	static function StationWaitingCargo(stationID);
	static function hasAnyCargoRaiting(stationID);
	static function ConstValue(unused, value);
    function ArrayFind(arr, item);
	function FindRoadVehicle(cargoID);
	static function IsStraightRoadTile(tile);
	static function GetRandomizedPopulation(townID);
	function IsCargoPickedUp(industryID, cargoID);
	function TryBuildRoad(loc1, loc2);
	function BuildUnbuiltRoads();
	static function CapLength(str);
	static function getTileListRadius(tile, radius);
	static function GetYear();
	
	function Save();
	function Load(data);
	
    constructor()
    {
        AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_ROAD);
        roadpathfinder.cost.max_cost=500;
		roadpathfinder.cost.tile=2;
		roadpathfinder.cost.turn=1;
		roadpathfinder.cost.no_existing_road=2;
		roadpathfinder.cost.slope=2;
		roadpathfinder.cost.bridge_per_tile=3;
		roadpathfinder.cost.coast=1;
		roadpathfinder.cost.tunnel_per_tile=3;
        
    }
}

function Util::GetRoadConnections(tile) {
	local total = 0;
	if (AIBridge.IsBridgeTile(tile) || AITunnel.IsTunnelTile(tile)){
		total+=1;
	}
	
	foreach (tile2 in Util.GetDirectlyAdjacentTiles(tile)){
		if (AIRoad.AreRoadTilesConnected(tile, tile2)){
			total+=1;
		}
	}
	return total;
}

function Util::BuildRoute(sourcetile, destinationtile){
	foreach(tile in tileBlacklist){
		if (tile[0]==sourcetile && tile[1]==destinationtile){
			AILog.Info("tile combination in blacklist");
			return false;
		}
	}
	roadpathfinder.InitializePath([sourcetile],[destinationtile]);
	local path = false;
	AILog.Info("Pathfinding...")
	local loan = AICompany.GetLoanAmount();
	if (AICompany.GetBankBalance(AICompany.COMPANY_SELF)>loan){
		AICompany.SetLoanAmount(0);
	}
	else {
		AICompany.SetMinimumLoanAmount(loan - AICompany.GetBankBalance(AICompany.COMPANY_SELF))
	}
	
	while (path == false) {
		path = roadpathfinder.FindPath(100);
		AIController.Sleep(1);
	}
	//building route
	local distance=0;
	if (path==null) {
        AILog.Info("No Path Found");
		tileBlacklist.push([sourcetile,destinationtile]);
		return false;
	}
    else {
		AILog.Info("Completed, building route");
    }
	AICompany.SetLoanAmount(loan);
	
	while (path != null) {
		local par = path.GetParent();
		if (par != null) {
			local last_node = path.GetTile();
			if (AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) == 1 ) {
				if (AIRoad.AreRoadTilesConnected(path.GetTile(), par.GetTile())){
					//A road already exists
				}
				else if (!TryBuildRoad(path.GetTile(), par.GetTile())) {
                    AILog.Warning("failed to build path: "+AIError.GetLastErrorString());
					if (AIError.GetLastError() == AIError.ERR_OWNED_BY_ANOTHER_COMPANY){
						//Some new building built since building started
						//recursively try to build new route
						return BuildRoute(path.GetTile(), sourcetile);
					}
					/* An error occurred while building a piece of road. TODO: handle it. 
					* Note that this could mean the road was already built. */
				}
				distance+=1;
			}
			else {
			/* Build a bridge or tunnel. */
				if (!AIBridge.IsBridgeTile(path.GetTile()) && !AITunnel.IsTunnelTile(path.GetTile())) {
					/* If it was a road tile, demolish it first. Do this to work around expended roadbits. */
					if (AIRoad.IsRoadTile(path.GetTile())) AITile.DemolishTile(path.GetTile());
						if (AITunnel.GetOtherTunnelEnd(path.GetTile()) == par.GetTile()) {
							if (!AITunnel.BuildTunnel(AIVehicle.VT_ROAD, path.GetTile())) {
								AILog.Warning("failed to build tunnel: "+AIError.GetLastErrorString());
							/* An error occured while building a tunnel. TODO: handle it. */
							}
						} else {
							local distance = AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) + 1;
							local bridge_list = AIBridgeList_Length(distance);
							bridge_list.Valuate(AIBridge.GetPrice, distance);
							bridge_list.KeepBelowValue(AICompany.GetBankBalance(AICompany.COMPANY_SELF)/2);
							bridge_list.Valuate(AIBridge.GetMaxSpeed);
							bridge_list.Sort(AIList.SORT_BY_VALUE, false);
							if (bridge_list.IsEmpty()){
								AILog.Warning("cannot afford bridge");
								return false;
							}
							else if (!AIBridge.BuildBridge(AIVehicle.VT_ROAD, bridge_list.Begin(), path.GetTile(), par.GetTile())) {
								AILog.Warning("failed to build bridge: "+AIError.GetLastErrorString());
								/* An error occured while building a bridge. TODO: handle it. */
							}
						}
				}
			}
		}
		path = par;
	}
    return true;
}

function Util::TryBuildRoad(tile1, tile2){
	if (Money.ReserveMoney(AIRoad.GetBuildCost(AIRoad.ROADTYPE_ROAD, AIRoad.BT_ROAD)*2)){ //times 2 just to be safe
		if (AIRoad.BuildRoad(tile1, tile2)){
			return true;
		}
		else {
			local error = AIError.GetLastError();
			switch (error) {
				case AIError.ERR_VEHICLE_IN_THE_WAY:
				case AIError.ERR_NOT_ENOUGH_CASH:
				case AIError.ERR_LOCAL_AUTHORITY_REFUSES:
					unbuiltConnections.push([tile1, tile2, AIError.GetLastErrorString()]);
					return true;
					break;
				case AIError.ERR_AREA_NOT_CLEAR:
					if (AITile.DemolishTile(tile2)){
						return TryBuildRoad(tile1, tile2);
					}
					else {
						return false;
					}
					break;
				default:
					return false;
			}
		}
	}
	else {
		unbuiltConnections.push([tile1, tile2, "NOT_ENOUGH_MONEY"]);
	}
}

function Util::BuildUnbuiltRoads(){
	local unbuild = unbuiltConnections;
	unbuiltConnections = []
	foreach (connection in unbuild){
		AILog.Info("fixing unbuilt road ("+connection[2]+")");
		//AISign.BuildSign(connection[0], "unbuilt fix");
		if (!TryBuildRoad(connection[0], connection[1])){
			AILog.Info("Success");
		};
	}
}

function Util::IsStraightRoadTile(tile) {
	return AIRoad.IsRoadTile(tile) && AIRoad.GetNeighbourRoadCount(tile)==2 &&
			((AIRoad.AreRoadTilesConnected(tile, tile + AIMap.GetTileIndex(-1,0)) &&
			  AIRoad.AreRoadTilesConnected(tile, tile + AIMap.GetTileIndex(1, 0))) ||
			 (AIRoad.AreRoadTilesConnected(tile, tile + AIMap.GetTileIndex(0,-1)) &&
			  AIRoad.AreRoadTilesConnected(tile, tile + AIMap.GetTileIndex(0, 1))))
}

function Util::GetRandomizedPopulation(townID) {
	return AITown.GetPopulation(townID)*(80+AIBase.RandRange(40))/100;
}

function Util::IsClearableTile(tile, allowRoad = false) {
	return AITile.IsBuildable(tile) || AITile.IsFarmTile(tile) || AITile.HasTreeOnTile(tile) ||
		   AITile.IsRockTile(tile) || AITile.IsRoughTile(tile) ||
	       (allowRoad && Util.IsStraightRoadTile(tile))
}

function Util::GetDirectlyAdjacentTiles(tile){
    return [tile + AIMap.GetTileIndex(-1,0),
            tile + AIMap.GetTileIndex(1 ,0),
            tile + AIMap.GetTileIndex(0,-1),
            tile + AIMap.GetTileIndex(0, 1)]
}

function Util::IsAreaClear(tile, ut, checkFlat) {
	//ut.GetDirectlyAdjacentTiles(tile);
	foreach (tile2 in Util.GetDirectlyAdjacentTiles(tile)) {
		if (!ut.IsClearableTile(tile2,true) && !AIRoad.IsRoadTile(tile2)){
			return false;
		}
		if (checkFlat && AITile.GetSlope(tile2)!=AITile.SLOPE_FLAT){
			return false;
		}
	}
	return true;
}

function Util::ConstValue(unused, value){
	return value;
}

function Util::FilterBuildableTiles(tiles, allowRoad = false){
    tiles.Valuate(IsClearableTile, allowRoad);
    tiles.KeepValue(1);
    tiles.Valuate(AITile.GetSlope);
    tiles.KeepValue(AITile.SLOPE_FLAT);
	tiles.Valuate(IsAreaClear, this, true);
	tiles.KeepValue(1);
    return tiles
}

function Util::FindFreeTileNear(tileID)
{
    local tiles = AITileList();
    tiles.AddRectangle(tileID - AIMap.GetTileIndex(9, 9),
		tileID + AIMap.GetTileIndex(9, 9));
    tiles = FilterBuildableTiles(tiles);
    tiles.Valuate(AITile.GetDistanceManhattanToTile, tileID);
    tiles.Sort(AIList.SORT_BY_VALUE, true);
    local firstTile = tiles.Begin();
    return firstTile;
}

function Util::IndustryTotalCargo(industryID)
{
    local cargoList = AICargoList();
    local max=0;
    foreach (cargo, prod in cargoList) {
        local diff = AIIndustry.GetLastMonthProduction(industryID, cargo) - AIIndustry.GetLastMonthTransported(industryID, cargo);
		if (diff > 0){
			diff = diff * (80 + AIBase.RandRange(40)) / 100;
			
			local elist = AIEngineList(AIVehicle.VT_ROAD);
			elist.Valuate(AIEngine.CanRefitCargo, cargo);
			elist.KeepValue(1);
			
			if (!elist.IsEmpty()){
				if (diff > max){
					max = diff;
				}
			}
		}
    }
    return max;
}

function Util::StationWaitingCargo(stationID){
	local cargoList = AICargoList();
	local sum=0;
	foreach (cargo, prod in cargoList){
		sum+=AIStation.GetCargoWaiting(stationID, cargo);
	}
	return sum;

}

function Util::hasAnyCargoRaiting(stationID){
	local cargoList = AICargoList();
	foreach (cargo, prod in cargoList){
		if (AIStation.HasCargoRating(stationID, cargo)){
			return true;
		}
	}
	return false;	
}

function Util::CarriesCargo(vehicle, cargoID){
	return AIVehicle.GetCapacity(vehicle, cargoID)>5;
}

function Util::FindRoadVehicle(CargoID){
		local engineList=AIEngineList(AIVehicle.VT_ROAD);
		engineList.Valuate(AIEngine.CanRefitCargo,CargoID);
		engineList.KeepValue(1);
		engineList.Valuate(AIEngine.GetCapacity);
		engineList.KeepAboveValue(10);
		engineList.Valuate(AIEngine.GetMaxSpeed);
		engineList.Sort(AIList.SORT_BY_VALUE, false);
		engineList.Valuate(AIEngine.GetRoadType);
		engineList.KeepValue(AIRoad.GetCurrentRoadType());
		return engineList.Begin();
}

function Util::IsCargoPickedUp(industryID, cargoID){
	if (AIIndustry.GetAmountOfStationsAround(industryID)==0){
		return true;
	}
	else if (AIIndustry.GetLastMonthTransported(industryID, cargoID)>5){
		return false;
	}
	else {
		local stationType = AICargo.HasCargoClass(cargoID, AICargo.CC_PASSENGERS)?AIStation.STATION_BUS_STOP:AIStation.STATION_TRUCK_STOP;
		local tiles = AITileList_IndustryProducing(industryID, AIStation.GetCoverageRadius(stationType));
		tiles.Valuate(AIStation.GetStationID);
		foreach(tile, stationID in tiles){
			if (AIStation.IsValidStation(stationID)){
				//AILog.Info("checking station "+AIBaseStation.GetName(stationID));
				if (AIStation.HasStationType(stationID, stationType)){
					local vehicles = AIVehicleList_Station(stationID);
					foreach(vehicle, itm2 in vehicles){
						//AILog.Info("Checking vehicle "+AIVehicle.GetName(vehicle));
						if (AIVehicle.GetCapacity(vehicle, cargoID)>1){
							return false;
						}
					}
				}
			}
		}
	}
	return true;
}
	
function Util::FindRoadVehicleCapacity(CargoID, ut){
	local vehicle = ut.FindRoadVehicle(CargoID);
}

function Util::ArrayFind(array, item)
{
    foreach (element in array) {
        if (element == item){
            return true;
        }
    }
    return false;
}

function Util::CapLength(string, length)
{
	if (string == null) {
		return "NULL"
	}
	else if (string.len() > length){
		return string.slice(0, length);
	}
	else {
		return string;
	}
}

function Util::GetTileListRadius(tile, radius){
	local tiles = AITileList();
	local x = AIMap.GetTileX(tile);
	local y = AIMap.GetTileY(tile);
	local topLeft = AIMap.GetTileIndex(max(1, x-radius), max(1, y-radius));
	local bottomRight = AIMap.GetTileIndex(min(AIMap.GetMapSizeX() - 1, x+radius), min(AIMap.GetMapSizeY() - 1, y+radius));
	if (!AIMap.IsValidTile(topLeft) || !AIMap.IsValidTile(bottomRight)){
		AILog.Error("GetTileListRadius returned invalid value: ["+AIMap.GetTileX(topLeft)+", "+AIMap.GetTileY(topLeft)+"], ["+
																	AIMap.GetTileX(bottomRight)+", "+AIMap.GetTileY(bottomRight)+"]");
	}
	tiles.AddRectangle(topLeft, bottomRight);
	return tiles;
}

function Util::GetYear() {
	return AIDate.GetYear(AIDate.GetCurrentDate());
}

function Util::Save() {
	return {
		unbuiltConnections = unbuiltConnections,
		tileBlacklist = tileBlacklist
	};
}

function Util::Load(data){
	if ("unbuiltConnections" in data){
		unbuiltConnections = data.unbuiltConnections;
	}
	else {
		AILog.Warning("UtilLoad: Missing field util.unbuiltConnections");
	}
	
	if ("tileBlacklist" in data){
		tileBlacklist = data.tileBlacklist;
	}
	else {
		AILog.Warning("UtilLoad: Missing field util.tileBlacklist");
	}
}