/*
 * This file is part of FastPTPAI, which is an AI for OpenTTD
 *
 * FastPTPAI is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * FastPTPAI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FastPTPAI; If not, see <http://www.gnu.org/licenses/> or
 * write to the Free Software Foundation, Inc., 51 Franklin Street, 
 * Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
 
 class FastPTPAI extends AIInfo {
	function GetAuthor()      { return "11Runner"; }
	function GetName()        { return "FastPTPAI"; }
	function GetShortName()   { return "FPTP"; }
	function GetDescription() { return "FastPTPAI is an AI designed to be FastPTPAI for trains!"; }
	function GetAPIVersion()  { return "1.2"; }
	function GetVersion()     { return 4; }
	function GetDate()        { return "2013-04-09"; }
	function GetUrl()         { return "http://www.tt-forums.net/viewtopic.php?f=65&t=66958"; }
	function CreateInstance() { return "FastPTPAI"; }
	
	function MinVersionToLoad() { return 1; }

	function GetSettings() {
		AddSetting({name = "log_level", description = "The amount of AI messages to display in the AI log.  Higher=More messages", easy_value = 2, medium_value = 2, hard_value = 2, custom_value = 2, min_value = 1, max_value = 3, flags = CONFIG_INGAME | CONFIG_DEVELOPER });
	}

}

/* Tell the core we are an AI */
RegisterAI(FastPTPAI());
