/* 
 *	Copyright 2013 Varen De Meersman
 *  This file is part of MailAI.
 *
 *  MailAI is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MailAI is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with MailAI.  If not, see <http://www.gnu.org/licenses/>.
 */
class Route {
	station_list = AITileList();
	sorted_towns = [];
	replaced_towns = [];
	depot = null;
	engine = null;
	travel_distance = 0;
	
	constructor(town_array,stat_list,depot_tile,distance,engine,replaced_towns) {
		this.sorted_towns = town_array;
		this.station_list = stat_list;
		this.depot = depot_tile;
		this.travel_distance = distance;
		this.engine = engine;
		this.replaced_towns = replaced_towns;
		this.PopulateRoute();
	}
}

function Route::PopulateRoute() {
	local counter = 0;
	if(AIEngine.GetVehicleType(this.engine) == AIVehicle.VT_ROAD) {
		if(this.station_list.Count() < 3) {
			if(this.travel_distance < 25) {
				this.NewVehicle(2);//1 should be the train station
			} else {
				this.NewVehicle(1);this.NewVehicle(2);//normal truck route
			}
		}
		if(this.station_list.Count() == 3) {
			this.NewVehicle(2);this.NewVehicle(3);//1 should be the train station
		}
		if(this.station_list.Count() == 4) {
			this.NewVehicle(2);this.NewVehicle(3);this.NewVehicle(4);//1 should be the train station
		}
		if(this.station_list.Count() > 4) {//relocated train station in high density neighbourhood
			this.NewVehicle(666);this.NewVehicle(666);this.NewVehicle(666);this.NewVehicle(666);
		}
	} else if(AIEngine.GetVehicleType(this.engine) == AIVehicle.VT_RAIL) {
		this.NewVehicle(1);this.NewVehicle(2);
	} else {
		throw("Wrong vehicletype in populateroute");	
	}
}

function Route::NewVehicle(full_load_number) {
	if(this.engine==null) {throw("No Engine for Route.NewVehicle!");}
	local new_veh;
	if(AIEngine.GetVehicleType(engine) == AIVehicle.VT_ROAD) {
		new_veh= BankManager.BuildVehicle(this.depot, this.engine);
		if(new_veh == null){
			MailAI.Info(2,"Failed building vehicle.");
			return null;
		}
		if(!AIVehicle.RefitVehicle(new_veh,AICargo.CC_MAIL)) {
			MailAI.Info(2,"Couldn't refit truck: "+AIError.GetLastErrorString());
		}
	} else if(AIEngine.GetVehicleType(engine) == AIVehicle.VT_RAIL) {	
		new_veh = BankManager.BuildVehicle(this.depot, this.engine);
		if(new_veh == null){
			MailAI.Info(2,"Failed building vehicle.");
			return null;
		}
		if(!AIVehicle.RefitVehicle(new_veh,AICargo.CC_MAIL)) {
			if(AIError.GetLastErrorString() == "ERR_NOT_ENOUGH_CASH") {
				BankManager.LoanOne();
			}
			if(!AIVehicle.RefitVehicle(new_veh,AICargo.CC_MAIL)) {
				MailAI.Info(2,"Couldn't refit truck: "+AIError.GetLastErrorString());
			}
		}
		EngineMaster.AddWagons(new_veh,this.travel_distance);
	} else {throw("Wrong vehicletype in newvehicle");}
	//first two orders must be stations!
	local counter = 0;
	foreach(station, _ in this.station_list) {
		if(AIEngine.GetVehicleType(this.engine) == AIVehicle.VT_ROAD
		&& StationManager.SelectTrainStationTile(station) != null) {
			counter++;
			if(!AIOrder.AppendOrder(new_veh,station,AIOrder.OF_NON_STOP_INTERMEDIATE)) {
				MailAI.Info(3,"Couldn't append order!! "+AIError.GetLastErrorString());
				MailAI.BuildSign(station,"station");
			}
			break;
		}	
	}
	foreach(station, _ in this.station_list) {
		if(AIEngine.GetVehicleType(this.engine) == AIVehicle.VT_ROAD
		&& StationManager.SelectTrainStationTile(station) != null) {
			//station added as first
		} else {
			counter++;
			if(counter == full_load_number) {
				if(!AIOrder.AppendOrder(new_veh,station,AIOrder.OF_NON_STOP_INTERMEDIATE | AIOrder.OF_FULL_LOAD)) {
					MailAI.Info(3,"Couldn't append order!! "+AIError.GetLastErrorString());
					MailAI.BuildSign(station,"station");
				}
			} else if(!AIOrder.AppendOrder(new_veh,station,AIOrder.OF_NON_STOP_INTERMEDIATE)) {
				MailAI.Info(3,"Couldn't append order!! "+AIError.GetLastErrorString());	
				MailAI.BuildSign(station,"station");
			}
		}
	}
	AIVehicle.StartStopVehicle(new_veh);
	return new_veh;
}

function Route::GetRouteArray() {return [this.sorted_towns,this.station_list,this.engine];}

function Route::GetVehicleType(){return AIEngine.GetVehicleType(this.engine);}
function Route::GetTravelDistance(){return this.travel_distance;}
function Route::GetEngine(){return this.engine;}
function Route::GetStationList(){return this.station_list;}
function Route::GetSortedTowns(){return this.sorted_towns;}
function Route::GetReplacedTowns(){return this.replaced_towns;}
