/* 
 *	Copyright 2013 Varen De Meersman
 *  This file is part of MailAI.
 *
 *  MailAI is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MailAI is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with MailAI.  If not, see <http://www.gnu.org/licenses/>.
 */
 
 class StationManager {
	constructor() {}
}

function StationManager::GetSurroundingTiles(train_tile) {
	return Tile.GetSurroundingTiles(StationManager.GetStationTiles(train_tile),null);
}
	
function StationManager::GetStationTiles(train_tile) {
	local tl = AITileList(); local ld = 4;
	tl.AddRectangle(train_tile + AIMap.GetTileIndex(-ld, -ld),
		 train_tile + AIMap.GetTileIndex(ld, ld));		
	tl.Valuate(AIStation.GetStationID);
	tl.KeepValue(AIStation.GetStationID(train_tile));
	return tl;
}

function StationManager::SelectTruckStopTile(station) {
	if(station == null) {return null;}	
	local around_list = AITileList();
	around_list.AddRectangle(AIStation.GetLocation(station) + AIMap.GetTileIndex(-5, -5)
		, AIStation.GetLocation(station) + AIMap.GetTileIndex(5, 5));
	foreach(t, _ in around_list) {	
		if(AIRoad.IsRoadStationTile(t) || AIRoad.IsDriveThroughRoadStationTile(t)
			&& AICompany.IsMine(AITile.GetOwner(t))) {
			return t;
		}
	}
	MailAI.Info(0,"didn't find truck stop tile");
	return null;
}

function StationManager::SelectTrainStationTile(station) {
	if(station == null) {return null;}	
	local around_list = AITileList();
	around_list.AddRectangle(station + AIMap.GetTileIndex(-5, -5),station + AIMap.GetTileIndex(5, 5));
	foreach(t, _ in around_list) {	
		if(AIRail.IsRailStationTile(t) && AICompany.IsMine(AITile.GetOwner(t))) {
			return t;
		}
	}
	return null;
}

function StationManager::SelectRightTrackOutOfStation(station_tile) {
	if(station_tile == null) {MailAI.Info(0,"null tile in SelectRightTrackOutOfStation"); return null;}	
	local around_list = AITileList();
	around_list.AddRectangle(station_tile + AIMap.GetTileIndex(-5, -5),station_tile + AIMap.GetTileIndex(5, 5));
	around_list.Valuate(AIRail.IsRailStationTile);around_list.KeepValue(1);	
	//foreach(t, _ in around_list) {MailAI.BuildSign(t,"s");}
	local front_list = Tile.GetSurroundingTiles(around_list,null);
	front_list.Valuate(AIRail.IsRailTile);front_list.KeepValue(1);
	local station_tile = null, switch_tile = null;
	foreach(t, _ in front_list) {
		if(AICompany.IsMine(AITile.GetOwner(t))){
			local around_track = Tile.GetAdjacentTiles(t);
			foreach(check, _ in around_track) {
				if(AITile.IsStationTile(check)) {
					station_tile = check; switch_tile = t;
					break;
				}
			}
		}
	}
	local dir = Tile.GetDirectionFromTo(station_tile,switch_tile);
	local station_tile2 = Tile.GetRightTile(station_tile,dir);
	local switch_tile2 = Tile.GetRightTile(switch_tile,dir);
	if(AITile.IsStationTile(station_tile2) && AIRail.IsRailTile(switch_tile2)
	&& AICompany.IsMine(AITile.GetOwner(station_tile2))
	&& AICompany.IsMine(AITile.GetOwner(switch_tile2))) {
		return [station_tile2,switch_tile2];
	}
	return [station_tile,switch_tile];
}

/**
*	Valuator used in RoutePlanner that checks to see if provided
*	station could use extra service or not.
*	@param station The station to check cargo rating and waiting.
*	@param type Decide to check for trucks or trains.
*	@return 
*/
function StationManager::NeedsExtraService(stat, type) {
	local cargo_waiting = AIStation.GetCargoWaiting(stat,AICargo.CC_MAIL);
	local cargo_rating = AIStation.GetCargoRating(stat,AICargo.CC_MAIL);
	if(type = AIVehicle.VT_RAIL && AIStation.HasStationType(stat,AIStation.STATION_TRAIN)
	&& cargo_rating < MailAI.max_train_cargo_rating) {
		local val = MailAI.min_train_cargo_waiting - (10*AIController.GetSetting("level_of_easiness"));
		if(cargo_waiting > val) {
			return true;	
		} else {
			MailAI.Sleep(200);
			if(cargo_waiting > val) {return true;}
		}
	}
	if(type = AIVehicle.VT_ROAD && AIStation.HasStationType(stat,AIStation.STATION_TRUCK_STOP)){
		if(cargo_waiting > MailAI.min_truck_cargo_waiting && cargo_rating < MailAI.max_truck_cargo_rating) {	
			return true;
		}
	}
	return false;
}

function StationManager::TruckStopNeedsTrainService(station) {
	if(AIStation.HasStationType(station,AIStation.STATION_TRAIN)){return false;}
	if(cargo_waiting > MailAI.min_train_cargo_waiting && cargo_rating < MailAI.max_train_cargo_rating) {	
		return true;
	}
}