/* 
 *	Copyright 2013 Varen De Meersman
 *  This file is part of MailAI.
 *
 *  MailAI is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MailAI is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with MailAI.  If not, see <http://www.gnu.org/licenses/>.
 */ 

class MailAI extends AIInfo { 	
	function GetAuthor()		{ return "Hephi"; }
	function GetName()			{ return "MailAI"; }
	function GetDescription()	{ return "Transports mail."; }
	function GetVersion()		{ return 21; }//2.1
  	function MinVersionToLoad() { return 2; } 
  	function GetAPIVersion ()   { return "1.3"; }
	function GetDate()			{ return "2013-10-06"; }
	function CreateInstance()	{ return "MailAI"; }
	function GetShortName()		{ return "Mail"; }
	function GetURL()			{ return "http://www.tt-forums.net/viewtopic.php?t=52478";}
   
	function GetSettings() {
		AddSetting({
			name = "show_debug",
			description = "Show debug lines.", 
			easy_value = 0, 
			medium_value = 0, 
			hard_value = 1, 
			custom_value = 0, 
			flags = CONFIG_BOOLEAN});
			
		AddSetting({
			name = "use_trucks",
			description = "Use trucks", 
			easy_value = 1, 
			medium_value = 1, 
			hard_value = 1, 
			custom_value = 1, 
			flags = CONFIG_BOOLEAN});
			
		AddSetting({
			name = "use_art_trucks",
			description = "Allow articulated trucks", 
			easy_value = 0, 
			medium_value = 1, 
			hard_value = 1, 
			custom_value = 1, 
			flags = CONFIG_BOOLEAN});
                
		AddSetting({
			name = "use_trains",
			description = "Use trains",
			easy_value = 1,
			medium_value = 1,
			hard_value = 1,
			custom_value = 1,
			flags = CONFIG_BOOLEAN});            
       
		AddSetting({name = "use_ISR", 
            description = "Try to build ISR stations (GRF)", 
            easy_value = 1, 
            medium_value = 1, 
            hard_value = 1, 
            custom_value = 1, 
            flags = CONFIG_BOOLEAN});
            		
        AddSetting({
			name = "level_of_easiness",
			description = "Level of easiness", 
			easy_value = 0, 
			medium_value = 2, 
			hard_value = 3, 
			custom_value = 1, 
			flags = CONFIG_INGAME,
			min_value = 0, 
            max_value = 5});
            
		AddLabels("level_of_easiness", {
				_0 = "Chieftain",
				_1 = "I'm a Chew Toy",
				_2 = "Elves Just Want To Have Fun",
				_3 = "Smooth Sailin'",
				_4 = "I'm Too Young To Die",
				_5 = "Sith Apprentice"});  
	}
}
 
/* Tell the core we are an AI */
 RegisterAI(MailAI());